/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileChooser.impl;

import com.intellij.ide.util.treeView.AbstractTreeBuilder;
import com.intellij.ide.util.treeView.AbstractTreeStructure;
import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileElement;
import com.intellij.openapi.fileChooser.ex.RootFileElement;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.util.StatusBarProgress;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileEvent;
import com.intellij.openapi.vfs.VirtualFileListener;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFileMoveEvent;
import com.intellij.openapi.vfs.VirtualFilePropertyEvent;
import java.util.Comparator;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeModel;
import org.jetbrains.annotations.NotNull;

public class FileTreeBuilder
extends AbstractTreeBuilder {
    private final FileChooserDescriptor myChooserDescriptor;

    public FileTreeBuilder(JTree tree, DefaultTreeModel treeModel, AbstractTreeStructure treeStructure, Comparator<NodeDescriptor> comparator2, FileChooserDescriptor chooserDescriptor, Runnable onInitialized) {
        super(tree, treeModel, treeStructure, comparator2, false);
        this.myChooserDescriptor = chooserDescriptor;
        this.initRootNode();
        VirtualFileManager.getInstance().addVirtualFileListener(new VirtualFileListener(){

            public void propertyChanged(@NotNull VirtualFilePropertyEvent event) {
                this.doUpdate();
            }

            public void fileCreated(@NotNull VirtualFileEvent event) {
                this.doUpdate();
            }

            public void fileDeleted(@NotNull VirtualFileEvent event) {
                this.doUpdate();
            }

            public void fileMoved(@NotNull VirtualFileMoveEvent event) {
                this.doUpdate();
            }

            private void doUpdate() {
                FileTreeBuilder.this.queueUpdateFrom(FileTreeBuilder.this.getRootNode(), false);
            }
        }, (Disposable)this);
    }

    protected boolean isAlwaysShowPlus(NodeDescriptor nodeDescriptor) {
        FileElement descriptor;
        VirtualFile file2;
        Object element = nodeDescriptor.getElement();
        if (element != null && (file2 = (descriptor = (FileElement)element).getFile()) != null) {
            if (this.myChooserDescriptor.isChooseJarContents() && FileElement.isArchive((VirtualFile)file2)) {
                return true;
            }
            return file2.isDirectory();
        }
        return true;
    }

    protected boolean isAutoExpandNode(NodeDescriptor nodeDescriptor) {
        if (nodeDescriptor.getElement() instanceof RootFileElement) {
            return true;
        }
        if (!SystemInfo.isWindows) {
            NodeDescriptor parent = nodeDescriptor.getParentDescriptor();
            return parent != null && parent.getElement() instanceof RootFileElement;
        }
        return false;
    }

    protected ProgressIndicator createProgressIndicator() {
        return new StatusBarProgress();
    }
}

