/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileChooser.impl;

import com.intellij.ide.util.treeView.AbstractTreeStructure;
import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileElement;
import com.intellij.openapi.fileChooser.ex.FileNodeDescriptor;
import com.intellij.openapi.fileChooser.ex.RootFileElement;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ArrayUtil;
import java.util.Collection;
import java.util.HashSet;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FileTreeStructure
extends AbstractTreeStructure {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.chooser.FileTreeStructure");
    private final RootFileElement myRootElement;
    private final FileChooserDescriptor myChooserDescriptor;
    private boolean myShowHidden;
    private final Project myProject;

    public FileTreeStructure(Project project, FileChooserDescriptor chooserDescriptor) {
        this.myProject = project;
        VirtualFile[] rootFiles = VfsUtilCore.toVirtualFileArray((Collection)chooserDescriptor.getRoots());
        String name = rootFiles.length == 1 && rootFiles[0] != null ? rootFiles[0].getPresentableUrl() : chooserDescriptor.getTitle();
        this.myRootElement = new RootFileElement(rootFiles, name, chooserDescriptor.isShowFileSystemRoots());
        this.myChooserDescriptor = chooserDescriptor;
        this.myShowHidden = this.myChooserDescriptor.isShowHiddenFiles();
    }

    public boolean isToBuildChildrenInBackground(@NotNull Object element) {
        return true;
    }

    public final boolean areHiddensShown() {
        return this.myShowHidden;
    }

    public final void showHiddens(boolean showHidden) {
        this.myShowHidden = showHidden;
    }

    @NotNull
    public final Object getRootElement() {
        return this.myRootElement;
    }

    @NotNull
    public Object[] getChildElements(@NotNull Object nodeElement) {
        if (!(nodeElement instanceof FileElement)) {
            return ArrayUtil.EMPTY_OBJECT_ARRAY;
        }
        FileElement element = (FileElement)nodeElement;
        VirtualFile file2 = element.getFile();
        if (file2 == null || !file2.isValid()) {
            if (element == this.myRootElement) {
                return this.myRootElement.getChildren();
            }
            return ArrayUtil.EMPTY_OBJECT_ARRAY;
        }
        VirtualFile[] children2 = null;
        if (element.isArchive() && this.myChooserDescriptor.isChooseJarContents()) {
            String path = file2.getPath();
            if (!(file2.getFileSystem() instanceof JarFileSystem)) {
                file2 = JarFileSystem.getInstance().findFileByPath(path + "!/");
            }
            if (file2 != null) {
                children2 = file2.getChildren();
            }
        } else {
            children2 = file2.getChildren();
        }
        if (children2 == null) {
            return ArrayUtil.EMPTY_OBJECT_ARRAY;
        }
        HashSet<FileElement> childrenSet = new HashSet<FileElement>();
        for (VirtualFile child2 : children2) {
            if (!this.myChooserDescriptor.isFileVisible(child2, this.myShowHidden)) continue;
            FileElement childElement = new FileElement(child2, child2.getName());
            childElement.setParent(element);
            childrenSet.add(childElement);
        }
        return ArrayUtil.toObjectArray(childrenSet);
    }

    @Nullable
    public Object getParentElement(@NotNull Object element) {
        if (element instanceof FileElement) {
            VirtualFile parentFile;
            FileElement fileElement = (FileElement)element;
            VirtualFile elementFile = FileTreeStructure.getValidFile(fileElement);
            VirtualFile rootElementFile = this.myRootElement.getFile();
            if (rootElementFile != null && rootElementFile.equals(elementFile)) {
                return null;
            }
            VirtualFile parentElementFile = FileTreeStructure.getValidFile(fileElement.getParent());
            if (elementFile != null && parentElementFile != null && parentElementFile.equals(parentFile = elementFile.getParent())) {
                return fileElement.getParent();
            }
            VirtualFile file2 = fileElement.getFile();
            if (file2 == null) {
                return null;
            }
            VirtualFile parent = file2.getParent();
            if (parent != null && parent.getFileSystem() instanceof JarFileSystem && parent.getParent() == null) {
                String localPath = parent.getPath().substring(0, parent.getPath().length() - "!/".length());
                parent = LocalFileSystem.getInstance().findFileByPath(localPath);
            }
            if (parent != null && parent.isValid() && parent.equals(rootElementFile)) {
                return this.myRootElement;
            }
            if (parent == null) {
                return this.myRootElement;
            }
            return new FileElement(parent, parent.getName());
        }
        return null;
    }

    @Nullable
    private static VirtualFile getValidFile(FileElement element) {
        if (element == null) {
            return null;
        }
        VirtualFile file2 = element.getFile();
        return file2 != null && file2.isValid() ? file2 : null;
    }

    public final void commit() {
    }

    public final boolean hasSomethingToCommit() {
        return false;
    }

    @NotNull
    public NodeDescriptor createDescriptor(@NotNull Object element, NodeDescriptor parentDescriptor) {
        LOG.assertTrue(element instanceof FileElement, (Object)element.getClass().getName());
        VirtualFile file2 = ((FileElement)element).getFile();
        Icon closedIcon = file2 == null ? null : this.myChooserDescriptor.getIcon(file2);
        String name = file2 == null ? null : this.myChooserDescriptor.getName(file2);
        String comment = file2 == null ? null : this.myChooserDescriptor.getComment(file2);
        return new FileNodeDescriptor(this.myProject, (FileElement)element, parentDescriptor, closedIcon, name, comment);
    }
}

