/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileEditor.impl;

import com.intellij.icons.AllIcons;
import com.intellij.ide.GeneralSettings;
import com.intellij.ide.IdeEventQueue;
import com.intellij.ide.actions.CloseAction;
import com.intellij.ide.actions.ShowFilePathAction;
import com.intellij.ide.ui.UISettings;
import com.intellij.ide.ui.UISettingsListener;
import com.intellij.ide.ui.customization.CustomActionsSchema;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.ex.FileEditorManagerEx;
import com.intellij.openapi.fileEditor.ex.IdeDocumentHistory;
import com.intellij.openapi.fileEditor.impl.DockableEditorTabbedContainer;
import com.intellij.openapi.fileEditor.impl.EditorTabPresentationUtil;
import com.intellij.openapi.fileEditor.impl.EditorWindow;
import com.intellij.openapi.fileEditor.impl.FileEditorManagerImpl;
import com.intellij.openapi.fileEditor.impl.IdeDocumentHistoryImpl;
import com.intellij.openapi.fileEditor.impl.text.FileDropHandler;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Queryable;
import com.intellij.openapi.ui.ShadowAction;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowAnchor;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.openapi.wm.ToolWindowType;
import com.intellij.openapi.wm.ex.ToolWindowManagerEx;
import com.intellij.openapi.wm.ex.ToolWindowManagerListener;
import com.intellij.ui.InplaceButton;
import com.intellij.ui.docking.DockContainer;
import com.intellij.ui.docking.DockManager;
import com.intellij.ui.docking.DockableContent;
import com.intellij.ui.docking.DragSession;
import com.intellij.ui.tabs.JBTabs;
import com.intellij.ui.tabs.JBTabsPosition;
import com.intellij.ui.tabs.TabInfo;
import com.intellij.ui.tabs.TabsListener;
import com.intellij.ui.tabs.UiDecorator;
import com.intellij.ui.tabs.impl.JBEditorTabs;
import com.intellij.ui.tabs.impl.JBTabsImpl;
import com.intellij.util.BitUtil;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.TimedDeadzone;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.event.FocusEvent;
import java.awt.event.InputEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.TransferHandler;
import javax.swing.border.Border;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class EditorTabbedContainer
implements Disposable,
CloseAction.CloseTarget {
    private final EditorWindow myWindow;
    private final Project myProject;
    private final JBEditorTabs myTabs;
    @NonNls
    public static final String HELP_ID = "ideaInterface.editor";
    private final TabInfo.DragOutDelegate myDragOutDelegate = new MyDragOutDelegate();

    EditorTabbedContainer(EditorWindow window, Project project) {
        this.myWindow = window;
        this.myProject = project;
        ActionManager actionManager = ActionManager.getInstance();
        this.myTabs = new JBEditorTabs(project, actionManager, IdeFocusManager.getInstance((Project)project), this){
            {
                if (this.hasUnderlineSelection()) {
                    IdeEventQueue.getInstance().addDispatcher(this.createFocusDispatcher(), (Disposable)this);
                }
            }

            private IdeEventQueue.EventDispatcher createFocusDispatcher() {
                return e -> {
                    if (e instanceof FocusEvent) {
                        Component from = ((FocusEvent)e).getOppositeComponent();
                        Component to = ((FocusEvent)e).getComponent();
                        if (this.isChild(from) || this.isChild(to)) {
                            EditorTabbedContainer.this.myTabs.repaint();
                        }
                    }
                    return false;
                };
            }

            private boolean isChild(@Nullable Component c) {
                if (c == null) {
                    return false;
                }
                if (c == this) {
                    return true;
                }
                return this.isChild(c.getParent());
            }

            public boolean hasUnderlineSelection() {
                return UIUtil.isUnderDarcula() && Registry.is((String)"ide.new.editor.tabs.selection");
            }

            @Nullable
            public TabInfo getToSelectOnRemoveOf(TabInfo info) {
                int indexToSelect;
                VirtualFile file2;
                int index = this.getIndexOf(info);
                if (index != -1 && (file2 = EditorTabbedContainer.this.myWindow.getFileAt(index)) != null && (indexToSelect = EditorTabbedContainer.this.myWindow.calcIndexToSelect(file2, index)) >= 0 && indexToSelect < this.getTabs().size()) {
                    return this.getTabAt(indexToSelect);
                }
                return super.getToSelectOnRemoveOf(info);
            }
        };
        this.myTabs.setBorder((Border)new MyShadowBorder(this.myTabs));
        this.myTabs.setTransferHandler((TransferHandler)new MyTransferHandler());
        this.myTabs.setDataProvider((DataProvider)new MyDataProvider()).setPopupGroup(() -> (ActionGroup)CustomActionsSchema.getInstance().getCorrectedAction("EditorTabPopupMenu"), "EditorTabPopup", false).addTabMouseListener((MouseListener)new TabMouseListener()).getPresentation().setTabDraggingEnabled(true).setUiDecorator(() -> new UiDecorator.UiDecoration(null, (Insets)JBUI.insets((int)2, (int)8))).setTabLabelActionsMouseDeadzone(TimedDeadzone.NULL).setGhostsAlwaysVisible(true).setTabLabelActionsAutoHide(false).setActiveTabFillIn(EditorColorsManager.getInstance().getGlobalScheme().getDefaultBackground()).setPaintFocus(false).getJBTabs().addListener(new TabsListener(){

            public void selectionChanged(TabInfo oldSelection, TabInfo newSelection) {
                VirtualFile newFile;
                FileEditor newEditor;
                FileEditor oldEditor;
                FileEditorManager editorManager = FileEditorManager.getInstance((Project)EditorTabbedContainer.this.myProject);
                FileEditor fileEditor = oldEditor = oldSelection != null ? editorManager.getSelectedEditor((VirtualFile)oldSelection.getObject()) : null;
                if (oldEditor != null) {
                    oldEditor.deselectNotify();
                }
                if ((newEditor = editorManager.getSelectedEditor(newFile = (VirtualFile)newSelection.getObject())) != null) {
                    newEditor.selectNotify();
                }
                if (GeneralSettings.getInstance().isSyncOnFrameActivation()) {
                    VfsUtil.markDirtyAndRefresh((boolean)true, (boolean)false, (boolean)false, (VirtualFile[])new VirtualFile[]{newFile});
                }
            }
        }).setSelectionChangeHandler((info, requestFocus, doChangeSelection) -> {
            ActionCallback result2 = new ActionCallback();
            CommandProcessor.getInstance().executeCommand(this.myProject, () -> {
                ((IdeDocumentHistoryImpl)IdeDocumentHistory.getInstance(this.myProject)).onSelectionChanged();
                result2.notify(doChangeSelection.run());
            }, "EditorChange", null);
            return result2;
        });
        this.myTabs.getPresentation().setRequestFocusOnLastFocusedComponent(true);
        this.myTabs.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (EditorTabbedContainer.this.myTabs.findInfo(e) != null || EditorTabbedContainer.this.isFloating()) {
                    return;
                }
                if (!e.isPopupTrigger() && SwingUtilities.isLeftMouseButton(e) && e.getClickCount() == 2) {
                    EditorTabbedContainer.this.doHideAll(e);
                }
            }
        });
        this.setTabPlacement(UISettings.getInstance().getEditorTabPlacement());
        this.updateTabBorder();
        MessageBusConnection busConnection = project.getMessageBus().connect();
        busConnection.subscribe(ToolWindowManagerListener.TOPIC, (Object)new ToolWindowManagerListener(){

            @Override
            public void stateChanged() {
                EditorTabbedContainer.this.updateTabBorder();
            }

            @Override
            public void toolWindowRegistered(@NotNull String id) {
                EditorTabbedContainer.this.updateTabBorder();
            }
        });
        busConnection.subscribe(UISettingsListener.TOPIC, uiSettings -> this.updateTabBorder());
        Disposer.register((Disposable)project, (Disposable)this);
    }

    public int getTabCount() {
        return this.myTabs.getTabCount();
    }

    @NotNull
    public ActionCallback setSelectedIndex(int indexToSelect) {
        return this.setSelectedIndex(indexToSelect, true);
    }

    @NotNull
    public ActionCallback setSelectedIndex(int indexToSelect, boolean focusEditor) {
        if (indexToSelect >= this.myTabs.getTabCount()) {
            return ActionCallback.REJECTED;
        }
        return this.myTabs.select(this.myTabs.getTabAt(indexToSelect), focusEditor);
    }

    @NotNull
    public static DockableEditor createDockableEditor(Project project, Image image, VirtualFile file2, Presentation presentation, EditorWindow window) {
        return new DockableEditor(project, image, file2, presentation, window.getSize(), window.isFilePinned(file2));
    }

    private void updateTabBorder() {
        if (!this.myProject.isOpen()) {
            return;
        }
        ToolWindowManagerEx mgr = (ToolWindowManagerEx)ToolWindowManager.getInstance((Project)this.myProject);
        String[] ids = mgr.getToolWindowIds();
        JBInsets border = JBUI.emptyInsets();
        UISettings uiSettings = UISettings.getInstance();
        List<String> topIds = mgr.getIdsOn(ToolWindowAnchor.TOP);
        List<String> bottom = mgr.getIdsOn(ToolWindowAnchor.BOTTOM);
        List<String> rightIds = mgr.getIdsOn(ToolWindowAnchor.RIGHT);
        List<String> leftIds = mgr.getIdsOn(ToolWindowAnchor.LEFT);
        if (!uiSettings.getHideToolStripes() && !uiSettings.getPresentationMode()) {
            border.top = !topIds.isEmpty() ? 1 : 0;
            border.bottom = !bottom.isEmpty() ? 1 : 0;
            border.left = !leftIds.isEmpty() ? 1 : 0;
            border.right = !rightIds.isEmpty() ? 1 : 0;
        }
        for (String each : ids) {
            ToolWindow eachWnd = mgr.getToolWindow(each);
            if (eachWnd == null || !eachWnd.isAvailable() || !eachWnd.isVisible() || eachWnd.getType() != ToolWindowType.DOCKED) continue;
            ToolWindowAnchor eachAnchor = eachWnd.getAnchor();
            if (eachAnchor == ToolWindowAnchor.TOP) {
                border.top = 0;
                continue;
            }
            if (eachAnchor == ToolWindowAnchor.BOTTOM) {
                border.bottom = 0;
                continue;
            }
            if (eachAnchor == ToolWindowAnchor.LEFT) {
                border.left = 0;
                continue;
            }
            if (eachAnchor != ToolWindowAnchor.RIGHT) continue;
            border.right = 0;
        }
        this.myTabs.getPresentation().setPaintBorder(border.top, border.left, border.right, border.bottom).setTabSidePaintBorder(5);
    }

    @NotNull
    public JComponent getComponent() {
        return this.myTabs.getComponent();
    }

    public ActionCallback removeTabAt(int componentIndex, int indexToSelect, boolean transferFocus) {
        TabInfo toSelect2 = indexToSelect >= 0 && indexToSelect < this.myTabs.getTabCount() ? this.myTabs.getTabAt(indexToSelect) : null;
        TabInfo info = this.myTabs.getTabAt(componentIndex);
        if (info.isHidden() || !this.myProject.isOpen()) {
            toSelect2 = null;
        }
        ActionCallback callback2 = this.myTabs.removeTab(info, toSelect2, transferFocus);
        return this.myProject.isOpen() ? callback2 : ActionCallback.DONE;
    }

    public ActionCallback removeTabAt(int componentIndex, int indexToSelect) {
        return this.removeTabAt(componentIndex, indexToSelect, true);
    }

    public int getSelectedIndex() {
        return this.myTabs.getIndexOf(this.myTabs.getSelectedInfo());
    }

    void setForegroundAt(int index, Color color) {
        this.myTabs.getTabAt(index).setDefaultForeground(color);
    }

    void setWaveColor(int index, @Nullable Color color) {
        TabInfo tab = this.myTabs.getTabAt(index);
        tab.setDefaultStyle(color == null ? 0 : 8);
        tab.setDefaultWaveColor(color);
    }

    void setIconAt(int index, Icon icon) {
        this.myTabs.getTabAt(index).setIcon(icon);
    }

    public void setTitleAt(int index, String text) {
        this.myTabs.getTabAt(index).setText(text);
    }

    void setToolTipTextAt(int index, String text) {
        this.myTabs.getTabAt(index).setTooltipText(text);
    }

    void setBackgroundColorAt(int index, Color color) {
        this.myTabs.getTabAt(index).setTabColor(color);
    }

    void setTabLayoutPolicy(int policy) {
        switch (policy) {
            case 1: {
                this.myTabs.getPresentation().setSingleRow(true);
                break;
            }
            case 0: {
                this.myTabs.getPresentation().setSingleRow(false);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported tab layout policy: " + policy);
            }
        }
    }

    public void setTabPlacement(int tabPlacement) {
        switch (tabPlacement) {
            case 1: {
                this.myTabs.getPresentation().setTabsPosition(JBTabsPosition.top);
                break;
            }
            case 3: {
                this.myTabs.getPresentation().setTabsPosition(JBTabsPosition.bottom);
                break;
            }
            case 2: {
                this.myTabs.getPresentation().setTabsPosition(JBTabsPosition.left);
                break;
            }
            case 4: {
                this.myTabs.getPresentation().setTabsPosition(JBTabsPosition.right);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown tab placement code=" + tabPlacement);
            }
        }
    }

    @Nullable
    public Object getSelectedComponent(boolean ignorePopup) {
        TabInfo info = ignorePopup ? this.myTabs.getSelectedInfo() : this.myTabs.getTargetInfo();
        return info != null ? info.getComponent() : null;
    }

    public void insertTab(@NotNull VirtualFile file2, Icon icon, @NotNull JComponent component, @Nullable String tooltip, int indexToInsert, @NotNull Disposable parentDisposable) {
        TabInfo tab = this.myTabs.findInfo((Object)file2);
        if (tab != null) {
            return;
        }
        tab = new TabInfo(component).setText(EditorTabPresentationUtil.getEditorTabTitle(this.myProject, file2, this.myWindow)).setTabColor(EditorTabPresentationUtil.getEditorTabBackgroundColor(this.myProject, file2, this.myWindow)).setIcon(icon).setTooltipText(tooltip).setObject((Object)file2).setDragOutDelegate(this.myDragOutDelegate);
        tab.setTestableUi((Queryable)new MyQueryable(tab));
        DefaultActionGroup tabActions = new DefaultActionGroup();
        tabActions.add((AnAction)new CloseTab(component, file2, parentDisposable));
        tab.setTabLabelActions((ActionGroup)tabActions, "EditorTab");
        this.myTabs.addTabSilently(tab, indexToInsert);
    }

    boolean isEmptyVisible() {
        return this.myTabs.isEmptyVisible();
    }

    public JBTabs getTabs() {
        return this.myTabs;
    }

    public void requestFocus(boolean forced) {
        if (this.myTabs != null) {
            IdeFocusManager.getInstance((Project)this.myProject).requestFocus((Component)this.myTabs.getComponent(), forced);
        }
    }

    void setPaintBlocked(boolean blocked) {
        this.myTabs.setPaintBlocked(blocked, true);
    }

    @Deprecated
    @NotNull
    public static String calcTabTitle(@NotNull Project project, @NotNull VirtualFile file2) {
        return EditorTabPresentationUtil.getEditorTabTitle(project, file2, null);
    }

    @Deprecated
    @NotNull
    public static String calcFileName(@NotNull Project project, @NotNull VirtualFile file2) {
        return EditorTabPresentationUtil.getUniqueEditorTabTitle(project, file2, null);
    }

    @Deprecated
    @Nullable
    public static Color calcTabColor(@NotNull Project project, @NotNull VirtualFile file2) {
        return EditorTabPresentationUtil.getEditorTabBackgroundColor(project, file2, null);
    }

    public Component getComponentAt(int i) {
        TabInfo tab = this.myTabs.getTabAt(i);
        return tab.getComponent();
    }

    public void dispose() {
    }

    @Override
    public void close() {
        TabInfo selected = this.myTabs.getTargetInfo();
        if (selected == null) {
            return;
        }
        FileEditorManagerEx.getInstanceEx(this.myProject).closeFile((VirtualFile)selected.getObject(), this.myWindow);
    }

    private boolean isFloating() {
        return this.myWindow.getOwner().isFloating();
    }

    public void doHideAll(MouseEvent e) {
        if (!Registry.is((String)"editor.maximize.on.double.click")) {
            return;
        }
        ActionManager mgr = ActionManager.getInstance();
        mgr.tryToExecute(mgr.getAction("HideAllWindows"), (InputEvent)e, null, "unknown", true);
    }

    private static class MyShadowBorder
    implements Border {
        private final JBEditorTabs myTabs;

        MyShadowBorder(JBEditorTabs tabs2) {
            this.myTabs = tabs2;
        }

        @Override
        public void paintBorder(Component component, Graphics g, int x, int y, int w, int h) {
            Rectangle selectedBounds = this.myTabs.getSelectedBounds();
            if (selectedBounds != null && selectedBounds.y > 0) {
                selectedBounds = null;
            }
            Rectangle bounds2 = new Rectangle(x, y, w, h);
            g.setColor(UIUtil.CONTRAST_BORDER_COLOR);
            MyShadowBorder.drawLine(bounds2, selectedBounds, g, 0);
            if (!UIUtil.isUnderDarcula()) {
                // empty if block
            }
        }

        private static void drawLine(Rectangle bounds2, @Nullable Rectangle selectedBounds, Graphics g, int yShift) {
            if (selectedBounds != null) {
                if (selectedBounds.x > 0) {
                    UIUtil.drawLine((Graphics)g, (int)bounds2.x, (int)(bounds2.y + yShift), (int)(selectedBounds.x - 2), (int)(bounds2.y + yShift));
                }
                UIUtil.drawLine((Graphics)g, (int)(selectedBounds.x + selectedBounds.width + 1), (int)(bounds2.y + yShift), (int)(bounds2.x + bounds2.width), (int)(bounds2.y + yShift));
            } else {
                UIUtil.drawLine((Graphics)g, (int)bounds2.x, (int)(bounds2.y + yShift), (int)(bounds2.x + bounds2.width), (int)(bounds2.y + yShift));
            }
        }

        @Override
        public Insets getBorderInsets(Component component) {
            return JBUI.emptyInsets();
        }

        @Override
        public boolean isBorderOpaque() {
            return false;
        }
    }

    private final class MyTransferHandler
    extends TransferHandler {
        private final FileDropHandler myFileDropHandler = new FileDropHandler(null);

        private MyTransferHandler() {
        }

        @Override
        public boolean importData(JComponent comp, Transferable t) {
            if (this.myFileDropHandler.canHandleDrop(t.getTransferDataFlavors())) {
                this.myFileDropHandler.handleDrop(t, EditorTabbedContainer.this.myProject, EditorTabbedContainer.this.myWindow);
                return true;
            }
            return false;
        }

        @Override
        public boolean canImport(JComponent comp, DataFlavor[] transferFlavors) {
            return this.myFileDropHandler.canHandleDrop(transferFlavors);
        }
    }

    public static class DockableEditor
    implements DockableContent<VirtualFile> {
        final Image myImg;
        private final DockableEditorTabbedContainer myContainer;
        private final Presentation myPresentation;
        private final Dimension myPreferredSize;
        private final boolean myPinned;
        private final VirtualFile myFile;

        public DockableEditor(Project project, Image img, VirtualFile file2, Presentation presentation, Dimension preferredSize, boolean isFilePinned) {
            this.myImg = img;
            this.myFile = file2;
            this.myPresentation = presentation;
            this.myContainer = new DockableEditorTabbedContainer(project);
            this.myPreferredSize = preferredSize;
            this.myPinned = isFilePinned;
        }

        @NotNull
        public VirtualFile getKey() {
            return this.myFile;
        }

        public Image getPreviewImage() {
            return this.myImg;
        }

        public Dimension getPreferredSize() {
            return this.myPreferredSize;
        }

        public String getDockContainerType() {
            return "file-editors";
        }

        public Presentation getPresentation() {
            return this.myPresentation;
        }

        public void close() {
            this.myContainer.close(this.myFile);
        }

        public VirtualFile getFile() {
            return this.myFile;
        }

        public boolean isPinned() {
            return this.myPinned;
        }
    }

    class MyDragOutDelegate
    implements TabInfo.DragOutDelegate {
        private VirtualFile myFile;
        private DragSession mySession;

        MyDragOutDelegate() {
        }

        public void dragOutStarted(@NotNull MouseEvent mouseEvent, @NotNull TabInfo info) {
            TabInfo previousSelection = info.getPreviousSelection();
            Image img = JBTabsImpl.getComponentImage((TabInfo)info);
            if (previousSelection == null) {
                previousSelection = EditorTabbedContainer.this.myTabs.getToSelectOnRemoveOf(info);
            }
            info.setHidden(true);
            if (previousSelection != null) {
                EditorTabbedContainer.this.myTabs.select(previousSelection, true);
            }
            this.myFile = (VirtualFile)info.getObject();
            Presentation presentation = new Presentation(info.getText());
            presentation.setIcon(info.getIcon());
            this.mySession = this.getDockManager().createDragSession(mouseEvent, (DockableContent)EditorTabbedContainer.createDockableEditor(EditorTabbedContainer.this.myProject, img, this.myFile, presentation, EditorTabbedContainer.this.myWindow));
        }

        private DockManager getDockManager() {
            return DockManager.getInstance((Project)EditorTabbedContainer.this.myProject);
        }

        public void processDragOut(@NotNull MouseEvent event, @NotNull TabInfo source) {
            this.mySession.process(event);
        }

        public void dragOutFinished(@NotNull MouseEvent event, TabInfo source) {
            boolean copy;
            boolean bl = copy = UIUtil.isControlKeyDown((MouseEvent)event) || this.mySession.getResponse(event) == DockContainer.ContentResponse.ACCEPT_COPY;
            if (!copy) {
                this.myFile.putUserData(FileEditorManagerImpl.CLOSING_TO_REOPEN, (Object)Boolean.TRUE);
                FileEditorManagerEx.getInstanceEx(EditorTabbedContainer.this.myProject).closeFile(this.myFile, EditorTabbedContainer.this.myWindow);
            } else {
                source.setHidden(false);
            }
            this.mySession.process(event);
            if (!copy) {
                this.myFile.putUserData(FileEditorManagerImpl.CLOSING_TO_REOPEN, null);
            }
            this.myFile = null;
            this.mySession = null;
        }

        public void dragOutCancelled(TabInfo source) {
            source.setHidden(false);
            if (this.mySession != null) {
                this.mySession.cancel();
            }
            this.myFile = null;
            this.mySession = null;
        }
    }

    private class TabMouseListener
    extends MouseAdapter {
        private int myActionClickCount;

        private TabMouseListener() {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            TabInfo info;
            if (UIUtil.isCloseClick((MouseEvent)e, (int)502) && (info = EditorTabbedContainer.this.myTabs.findInfo(e)) != null) {
                IdeEventQueue.getInstance().blockNextEvents(e);
                if (e.isAltDown() && e.getButton() == 1) {
                    List allTabInfos = EditorTabbedContainer.this.myTabs.getTabs();
                    for (TabInfo tabInfo : allTabInfos) {
                        if (tabInfo == info) continue;
                        FileEditorManagerEx.getInstanceEx(EditorTabbedContainer.this.myProject).closeFile((VirtualFile)tabInfo.getObject(), EditorTabbedContainer.this.myWindow);
                    }
                } else {
                    FileEditorManagerEx.getInstanceEx(EditorTabbedContainer.this.myProject).closeFile((VirtualFile)info.getObject(), EditorTabbedContainer.this.myWindow);
                }
            }
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (UIUtil.isActionClick((MouseEvent)e)) {
                Component deepestComponent;
                if (e.getClickCount() == 1) {
                    this.myActionClickCount = 0;
                }
                if (!((deepestComponent = SwingUtilities.getDeepestComponentAt(e.getComponent(), e.getX(), e.getY())) instanceof InplaceButton)) {
                    ++this.myActionClickCount;
                }
                if (this.myActionClickCount > 1 && !EditorTabbedContainer.this.isFloating()) {
                    EditorTabbedContainer.this.doHideAll(e);
                }
            }
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (UIUtil.isActionClick((MouseEvent)e, (int)500) && (e.isMetaDown() || !SystemInfo.isMac && e.isControlDown())) {
                Object o;
                TabInfo info = EditorTabbedContainer.this.myTabs.findInfo(e);
                Object object = o = info == null ? null : info.getObject();
                if (o instanceof VirtualFile) {
                    ShowFilePathAction.show((VirtualFile)o, e);
                }
            }
        }
    }

    private final class MyDataProvider
    implements DataProvider {
        private MyDataProvider() {
        }

        public Object getData(@NotNull @NonNls String dataId) {
            TabInfo selected;
            if (CommonDataKeys.PROJECT.is(dataId)) {
                return EditorTabbedContainer.this.myProject;
            }
            if (CommonDataKeys.VIRTUAL_FILE.is(dataId)) {
                VirtualFile selectedFile = EditorTabbedContainer.this.myWindow.getSelectedFile();
                return selectedFile != null && selectedFile.isValid() ? selectedFile : null;
            }
            if (EditorWindow.DATA_KEY.is(dataId)) {
                return EditorTabbedContainer.this.myWindow;
            }
            if (PlatformDataKeys.HELP_ID.is(dataId)) {
                return EditorTabbedContainer.HELP_ID;
            }
            if (CloseAction.CloseTarget.KEY.is(dataId) && (selected = EditorTabbedContainer.this.myTabs.getSelectedInfo()) != null) {
                return EditorTabbedContainer.this;
            }
            if (EditorWindow.DATA_KEY.is(dataId)) {
                return EditorTabbedContainer.this.myWindow;
            }
            return null;
        }
    }

    public final class CloseTab
    extends AnAction
    implements DumbAware {
        private final VirtualFile myFile;

        CloseTab(@NotNull JComponent c, @NotNull VirtualFile file2, Disposable parentDisposable) {
            this.myFile = file2;
            new ShadowAction((AnAction)this, ActionManager.getInstance().getAction("CloseContent"), c, parentDisposable);
        }

        public void update(@NotNull AnActionEvent e) {
            e.getPresentation().setIcon(AllIcons.Actions.Close);
            e.getPresentation().setHoveredIcon(AllIcons.Actions.CloseHovered);
            e.getPresentation().setVisible(UISettings.getInstance().getShowCloseButton());
            e.getPresentation().setText("Close. Alt-click to close others.");
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            FileEditorManagerEx mgr = FileEditorManagerEx.getInstanceEx(EditorTabbedContainer.this.myProject);
            EditorWindow window = "EditorTab".equals(e.getPlace()) ? EditorTabbedContainer.this.myWindow : mgr.getCurrentWindow();
            if (window != null) {
                if (BitUtil.isSet((int)e.getModifiers(), (int)8)) {
                    window.closeAllExcept(this.myFile);
                } else if (window.findFileComposite(this.myFile) != null) {
                    mgr.closeFile(this.myFile, window);
                }
            }
        }
    }

    private static class MyQueryable
    implements Queryable {
        private final TabInfo myTab;

        MyQueryable(TabInfo tab) {
            this.myTab = tab;
        }

        public void putInfo(@NotNull Map<String, String> info) {
            info.put("editorTab", this.myTab.getText());
        }
    }
}

