/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileEditor.impl;

import com.intellij.ProjectTopics;
import com.intellij.featureStatistics.fusCollectors.LifecycleUsageTriggerCollector;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.IdeEventQueue;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.ide.ui.UISettings;
import com.intellij.ide.ui.UISettingsListener;
import com.intellij.injected.editor.VirtualFileWindow;
import com.intellij.notebook.editor.BackedVirtualFile;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.application.TransactionGuard;
import com.intellij.openapi.application.TransactionGuardImpl;
import com.intellij.openapi.application.ex.ApplicationManagerEx;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.fileEditor.AsyncFileEditorProvider;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.FileEditorManagerEvent;
import com.intellij.openapi.fileEditor.FileEditorManagerListener;
import com.intellij.openapi.fileEditor.FileEditorProvider;
import com.intellij.openapi.fileEditor.FileEditorState;
import com.intellij.openapi.fileEditor.NavigatableFileEditor;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.fileEditor.ex.FileEditorManagerEx;
import com.intellij.openapi.fileEditor.ex.FileEditorProviderManager;
import com.intellij.openapi.fileEditor.ex.FileEditorWithProvider;
import com.intellij.openapi.fileEditor.ex.IdeDocumentHistory;
import com.intellij.openapi.fileEditor.impl.DockableEditorContainerFactory;
import com.intellij.openapi.fileEditor.impl.DockableEditorTabbedContainer;
import com.intellij.openapi.fileEditor.impl.EditorComposite;
import com.intellij.openapi.fileEditor.impl.EditorFileSwapper;
import com.intellij.openapi.fileEditor.impl.EditorHistoryManager;
import com.intellij.openapi.fileEditor.impl.EditorTabTitleProvider;
import com.intellij.openapi.fileEditor.impl.EditorWindow;
import com.intellij.openapi.fileEditor.impl.EditorWindowHolder;
import com.intellij.openapi.fileEditor.impl.EditorWithProviderComposite;
import com.intellij.openapi.fileEditor.impl.EditorsSplitters;
import com.intellij.openapi.fileEditor.impl.FileEditorAssociateFinder;
import com.intellij.openapi.fileEditor.impl.FileEditorManagerChange;
import com.intellij.openapi.fileEditor.impl.FileEditorProviderManagerImpl;
import com.intellij.openapi.fileEditor.impl.FilePreviewPanelProvider;
import com.intellij.openapi.fileEditor.impl.HistoryEntry;
import com.intellij.openapi.fileEditor.impl.IdeDocumentHistoryImpl;
import com.intellij.openapi.fileEditor.impl.text.TextEditorImpl;
import com.intellij.openapi.fileEditor.impl.text.TextEditorProvider;
import com.intellij.openapi.fileTypes.FileTypeEvent;
import com.intellij.openapi.fileTypes.FileTypeListener;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.keymap.Keymap;
import com.intellij.openapi.keymap.KeymapManager;
import com.intellij.openapi.preview.PreviewManager;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.DumbAwareRunnable;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.PossiblyDumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.ProjectManagerListener;
import com.intellij.openapi.project.impl.ProjectImpl;
import com.intellij.openapi.roots.ModuleRootEvent;
import com.intellij.openapi.roots.ModuleRootListener;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.ActiveRunnable;
import com.intellij.openapi.util.BusyObject;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.ExpirableRunnable;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.Trinity;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.FileStatusListener;
import com.intellij.openapi.vcs.FileStatusManager;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileEvent;
import com.intellij.openapi.vfs.VirtualFileListener;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFileMoveEvent;
import com.intellij.openapi.vfs.VirtualFilePropertyEvent;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.openapi.wm.ex.StatusBarEx;
import com.intellij.pom.Navigatable;
import com.intellij.reference.SoftReference;
import com.intellij.ui.docking.DockContainer;
import com.intellij.ui.docking.DockContainerFactory;
import com.intellij.ui.docking.DockManager;
import com.intellij.ui.docking.impl.DockManagerImpl;
import com.intellij.ui.tabs.impl.JBTabsImpl;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SmartList;
import com.intellij.util.concurrency.SequentialTaskExecutor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.impl.MessageListenerList;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import gnu.trove.THashSet;
import java.awt.AWTEvent;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.Window;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicInteger;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import one.util.streamex.StreamEx;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.CancellablePromise;
import org.jetbrains.concurrency.Promise;

@State(name="FileEditorManager", storages={@Storage(value="$WORKSPACE_FILE$")})
public class FileEditorManagerImpl
extends FileEditorManagerEx
implements PersistentStateComponent<Element> {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.fileEditor.impl.FileEditorManagerImpl");
    private static final Key<Boolean> DUMB_AWARE = Key.create((String)"DUMB_AWARE");
    private static final FileEditor[] EMPTY_EDITOR_ARRAY = new FileEditor[0];
    private static final FileEditorProvider[] EMPTY_PROVIDER_ARRAY = new FileEditorProvider[0];
    public static final Key<Boolean> CLOSING_TO_REOPEN = Key.create((String)"CLOSING_TO_REOPEN");
    public static final String FILE_EDITOR_MANAGER = "FileEditorManager";
    private static final ExecutorService ourSwapperExecutor = SequentialTaskExecutor.createSequentialApplicationPoolExecutor((String)"EditorFileSwapper");
    private volatile JPanel myPanels;
    private EditorsSplitters mySplitters;
    private final Project myProject;
    private final List<Pair<VirtualFile, EditorWindow>> mySelectionHistory = new ArrayList<Pair<VirtualFile, EditorWindow>>();
    private Reference<EditorComposite> myLastSelectedComposite = new WeakReference<Object>(null);
    private final MergingUpdateQueue myQueue = new MergingUpdateQueue("FileEditorManagerUpdateQueue", 50, true, MergingUpdateQueue.ANY_COMPONENT);
    private final BusyObject.Impl.Simple myBusyObject = new BusyObject.Impl.Simple();
    private final PropertyChangeListener myEditorPropertyChangeListener = new MyEditorPropertyChangeListener();
    private final DockManager myDockManager;
    private DockableEditorContainerFactory myContentFactory;
    private static final AtomicInteger ourOpenFilesSetModificationCount = new AtomicInteger();
    static final ModificationTracker OPEN_FILE_SET_MODIFICATION_COUNT = ourOpenFilesSetModificationCount::get;
    private final Object myInitLock = new Object();
    private final MessageListenerList<FileEditorManagerListener> myListenerList;

    public FileEditorManagerImpl(@NotNull Project project, DockManager dockManager) {
        this.myProject = project;
        this.myDockManager = dockManager;
        this.myListenerList = new MessageListenerList(this.myProject.getMessageBus(), FileEditorManagerListener.FILE_EDITOR_MANAGER);
        if (!FileEditorAssociateFinder.EP_NAME.getExtensionList().isEmpty()) {
            this.myListenerList.add((Object)new FileEditorManagerListener(){

                public void selectionChanged(@NotNull FileEditorManagerEvent event) {
                    EditorsSplitters splitters = FileEditorManagerImpl.this.getSplitters();
                    FileEditorManagerImpl.this.openAssociatedFile(event.getNewFile(), splitters.getCurrentWindow(), splitters);
                }
            });
        }
        this.myQueue.setTrackUiActivity(true);
        final MessageBusConnection connection = project.getMessageBus().connect();
        connection.subscribe(DumbService.DUMB_MODE, (Object)new DumbService.DumbModeListener(){

            public void exitDumbMode() {
                ApplicationManager.getApplication().invokeLater(() -> {
                    if (!FileEditorManagerImpl.this.myProject.isDisposed()) {
                        FileEditorManagerImpl.this.dumbModeFinished(FileEditorManagerImpl.this.myProject);
                    }
                });
            }
        });
        connection.subscribe(ProjectManager.TOPIC, (Object)new ProjectManagerListener(){

            public void projectOpened(@NotNull Project project) {
                if (project == FileEditorManagerImpl.this.myProject) {
                    FileEditorManagerImpl.this.projectOpened(connection);
                }
            }

            public void projectClosed(@NotNull Project project) {
                if (project == FileEditorManagerImpl.this.myProject) {
                    FileEditorManagerImpl.this.closeAllFiles();
                }
            }
        });
    }

    private void dumbModeFinished(Project project) {
        VirtualFile[] files2;
        for (VirtualFile file2 : files2 = this.getOpenFiles()) {
            HashSet providers = new HashSet();
            List<EditorWithProviderComposite> composites = this.getEditorComposites(file2);
            for (EditorWithProviderComposite composite : composites) {
                ContainerUtil.addAll(providers, (Object[])composite.getProviders());
            }
            FileEditorProvider[] newProviders = FileEditorProviderManager.getInstance().getProviders(project, file2);
            if (newProviders.length <= providers.size()) continue;
            ArrayList<FileEditorProvider> toOpen = new ArrayList<FileEditorProvider>(Arrays.asList(newProviders));
            toOpen.removeAll(providers);
            for (EditorWithProviderComposite composite : composites) {
                for (FileEditorProvider provider : toOpen) {
                    FileEditor editor = provider.createEditor(this.myProject, file2);
                    composite.addEditor(editor, provider);
                }
            }
        }
    }

    public void initDockableContentFactory() {
        if (this.myContentFactory != null) {
            return;
        }
        this.myContentFactory = new DockableEditorContainerFactory(this.myProject, this, this.myDockManager);
        this.myDockManager.register("file-editors", (DockContainerFactory)this.myContentFactory);
        Disposer.register((Disposable)this.myProject, (Disposable)this.myContentFactory);
    }

    public static boolean isDumbAware(@NotNull FileEditor editor) {
        return Boolean.TRUE.equals(editor.getUserData(DUMB_AWARE)) && (!(editor instanceof PossiblyDumbAware) || ((PossiblyDumbAware)editor).isDumbAware());
    }

    @Override
    public JComponent getComponent() {
        this.initUI();
        return this.myPanels;
    }

    @NotNull
    public EditorsSplitters getMainSplitters() {
        this.initUI();
        return this.mySplitters;
    }

    @NotNull
    public Set<EditorsSplitters> getAllSplitters() {
        LinkedHashSet<EditorsSplitters> all = new LinkedHashSet<EditorsSplitters>();
        all.add(this.getMainSplitters());
        Set dockContainers = this.myDockManager.getContainers();
        for (DockContainer each : dockContainers) {
            if (!(each instanceof DockableEditorTabbedContainer)) continue;
            all.add(((DockableEditorTabbedContainer)each).getSplitters());
        }
        return Collections.unmodifiableSet(all);
    }

    @NotNull
    private Promise<EditorsSplitters> getActiveSplittersAsync() {
        AsyncPromise result2 = new AsyncPromise();
        IdeFocusManager fm = IdeFocusManager.getInstance((Project)this.myProject);
        TransactionGuard.getInstance().assertWriteSafeContext(ModalityState.defaultModalityState());
        fm.doWhenFocusSettlesDown(() -> {
            if (this.myProject.isDisposed()) {
                result2.cancel();
                return;
            }
            Component focusOwner = fm.getFocusOwner();
            DockContainer container = this.myDockManager.getContainerFor(focusOwner);
            if (container instanceof DockableEditorTabbedContainer) {
                result2.setResult((Object)((DockableEditorTabbedContainer)container).getSplitters());
            } else {
                result2.setResult((Object)this.getMainSplitters());
            }
        }, ModalityState.defaultModalityState());
        return result2;
    }

    private EditorsSplitters getActiveSplittersSync() {
        DockContainer container;
        FileEditorManagerImpl.assertDispatchThread();
        IdeFocusManager fm = IdeFocusManager.getInstance((Project)this.myProject);
        Component focusOwner = fm.getFocusOwner();
        if (focusOwner == null) {
            focusOwner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
        }
        if (focusOwner == null) {
            focusOwner = fm.getLastFocusedFor(fm.getLastFocusedFrame());
        }
        if ((container = this.myDockManager.getContainerFor(focusOwner)) == null) {
            focusOwner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getActiveWindow();
            container = this.myDockManager.getContainerFor(focusOwner);
        }
        if (container instanceof DockableEditorTabbedContainer) {
            return ((DockableEditorTabbedContainer)container).getSplitters();
        }
        return this.getMainSplitters();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initUI() {
        if (this.myPanels == null) {
            Object object = this.myInitLock;
            synchronized (object) {
                if (this.myPanels == null) {
                    JPanel panel2 = new JPanel(new BorderLayout());
                    panel2.setOpaque(false);
                    panel2.setBorder(new MyBorder());
                    this.mySplitters = new EditorsSplitters(this, this.myDockManager, true);
                    Disposer.register((Disposable)this.myProject, (Disposable)this.mySplitters);
                    panel2.add((Component)((Object)this.mySplitters), "Center");
                    this.myPanels = panel2;
                }
            }
        }
    }

    @Override
    public JComponent getPreferredFocusedComponent() {
        EditorWithProviderComposite editor;
        FileEditorManagerImpl.assertReadAccess();
        EditorWindow window = this.getSplitters().getCurrentWindow();
        if (window != null && (editor = window.getSelectedEditor()) != null) {
            return editor.getPreferredFocusedComponent();
        }
        return null;
    }

    public Color getFileColor(@NotNull VirtualFile file2) {
        Color statusColor;
        FileStatusManager fileStatusManager = FileStatusManager.getInstance((Project)this.myProject);
        Color color = statusColor = fileStatusManager != null ? fileStatusManager.getStatus(file2).getColor() : UIUtil.getLabelForeground();
        if (statusColor == null) {
            statusColor = UIUtil.getLabelForeground();
        }
        return statusColor;
    }

    public boolean isProblem(@NotNull VirtualFile file2) {
        return false;
    }

    @NotNull
    public String getFileTooltipText(@NotNull VirtualFile file2) {
        List availableProviders = DumbService.getDumbAwareExtensions((Project)this.myProject, EditorTabTitleProvider.EP_NAME);
        for (EditorTabTitleProvider provider : availableProviders) {
            String text = provider.getEditorTabTooltipText(this.myProject, file2);
            if (text == null) continue;
            return text;
        }
        return FileUtil.getLocationRelativeToUserHome((String)file2.getPresentableUrl());
    }

    @Override
    public void updateFilePresentation(@NotNull VirtualFile file2) {
        if (!this.isFileOpen(file2)) {
            return;
        }
        this.updateFileColor(file2);
        this.updateFileIcon(file2);
        this.updateFileName(file2);
        this.updateFileBackgroundColor(file2);
    }

    private void updateFileColor(@NotNull VirtualFile file2) {
        Set<EditorsSplitters> all = this.getAllSplitters();
        for (EditorsSplitters each : all) {
            each.updateFileColor(file2);
        }
    }

    private void updateFileBackgroundColor(@NotNull VirtualFile file2) {
        Set<EditorsSplitters> all = this.getAllSplitters();
        for (EditorsSplitters each : all) {
            each.updateFileBackgroundColor(file2);
        }
    }

    protected void updateFileIcon(@NotNull VirtualFile file2) {
        Set<EditorsSplitters> all = this.getAllSplitters();
        for (EditorsSplitters each : all) {
            each.updateFileIcon(file2);
        }
    }

    void updateFileName(final @Nullable VirtualFile file2) {
        this.myQueue.queue(new Update("UpdateFileName " + (file2 == null ? "" : file2.getPath())){

            public boolean isExpired() {
                return FileEditorManagerImpl.this.myProject.isDisposed() || !FileEditorManagerImpl.this.myProject.isOpen() || (file2 == null ? super.isExpired() : !file2.isValid());
            }

            public void run() {
                Set<EditorsSplitters> all = FileEditorManagerImpl.this.getAllSplitters();
                for (EditorsSplitters each : all) {
                    each.updateFileName(file2);
                }
            }
        });
    }

    @Override
    public VirtualFile getFile(@NotNull FileEditor editor) {
        EditorWithProviderComposite editorComposite = this.getEditorComposite(editor);
        if (editorComposite != null) {
            return editorComposite.getFile();
        }
        return null;
    }

    @Override
    public void unsplitWindow() {
        EditorWindow currentWindow = this.getActiveSplittersSync().getCurrentWindow();
        if (currentWindow != null) {
            currentWindow.unsplit(true);
        }
    }

    @Override
    public void unsplitAllWindow() {
        EditorWindow currentWindow = this.getActiveSplittersSync().getCurrentWindow();
        if (currentWindow != null) {
            currentWindow.unsplitAll();
        }
    }

    @Override
    public int getWindowSplitCount() {
        return this.getActiveSplittersSync().getSplitCount();
    }

    @Override
    public boolean hasSplitOrUndockedWindows() {
        Set<EditorsSplitters> splitters = this.getAllSplitters();
        if (splitters.size() > 1) {
            return true;
        }
        return this.getWindowSplitCount() > 1;
    }

    @Override
    @NotNull
    public EditorWindow[] getWindows() {
        ArrayList windows = new ArrayList();
        Set<EditorsSplitters> all = this.getAllSplitters();
        for (EditorsSplitters each : all) {
            Object[] eachList = each.getWindows();
            ContainerUtil.addAll(windows, (Object[])eachList);
        }
        return windows.toArray(new EditorWindow[0]);
    }

    @Override
    public EditorWindow getNextWindow(@NotNull EditorWindow window) {
        EditorWindow[] windows = this.getSplitters().getOrderedWindows();
        for (int i = 0; i != windows.length; ++i) {
            if (!windows[i].equals(window)) continue;
            return windows[(i + 1) % windows.length];
        }
        LOG.error("Not window found");
        return null;
    }

    @Override
    public EditorWindow getPrevWindow(@NotNull EditorWindow window) {
        EditorWindow[] windows = this.getSplitters().getOrderedWindows();
        for (int i = 0; i != windows.length; ++i) {
            if (!windows[i].equals(window)) continue;
            return windows[(i + windows.length - 1) % windows.length];
        }
        LOG.error("Not window found");
        return null;
    }

    @Override
    public void createSplitter(int orientation, @Nullable EditorWindow window) {
        if (window != null) {
            window.split(orientation, true, null, false);
        } else {
            EditorWindow currentWindow = this.getSplitters().getCurrentWindow();
            if (currentWindow != null) {
                currentWindow.split(orientation, true, null, false);
            }
        }
    }

    @Override
    public void changeSplitterOrientation() {
        EditorWindow currentWindow = this.getSplitters().getCurrentWindow();
        if (currentWindow != null) {
            currentWindow.changeOrientation();
        }
    }

    @Override
    public void flipTabs() {
        this.myPanels.revalidate();
    }

    @Override
    public boolean tabsMode() {
        return false;
    }

    private void setTabsMode(boolean mode) {
        if (this.tabsMode() != mode) {
            this.flipTabs();
        }
    }

    @Override
    public boolean isInSplitter() {
        EditorWindow currentWindow = this.getSplitters().getCurrentWindow();
        return currentWindow != null && currentWindow.inSplitter();
    }

    @Override
    public boolean hasOpenedFile() {
        EditorWindow currentWindow = this.getSplitters().getCurrentWindow();
        return currentWindow != null && currentWindow.getSelectedEditor() != null;
    }

    @Override
    public VirtualFile getCurrentFile() {
        return this.getActiveSplittersSync().getCurrentFile();
    }

    @Override
    @NotNull
    public Promise<EditorWindow> getActiveWindow() {
        return this.getActiveSplittersAsync().then(EditorsSplitters::getCurrentWindow);
    }

    @Override
    public EditorWindow getCurrentWindow() {
        if (!ApplicationManager.getApplication().isDispatchThread()) {
            return null;
        }
        EditorsSplitters splitters = this.getActiveSplittersSync();
        return splitters == null ? null : splitters.getCurrentWindow();
    }

    @Override
    public void setCurrentWindow(EditorWindow window) {
        this.getActiveSplittersSync().setCurrentWindow(window, true);
    }

    public void closeFile(@NotNull VirtualFile file2, @NotNull EditorWindow window, boolean transferFocus) {
        FileEditorManagerImpl.assertDispatchThread();
        ourOpenFilesSetModificationCount.incrementAndGet();
        CommandProcessor.getInstance().executeCommand(this.myProject, () -> {
            if (window.isFileOpen(file2)) {
                window.closeFile(file2, true, transferFocus);
            }
        }, IdeBundle.message((String)"command.close.active.editor", (Object[])new Object[0]), null);
        this.removeSelectionRecord(file2, window);
    }

    @Override
    public void closeFile(@NotNull VirtualFile file2, @NotNull EditorWindow window) {
        this.closeFile(file2, window, true);
    }

    public void closeFile(@NotNull VirtualFile file2) {
        this.closeFile(file2, true, false);
    }

    public void closeFile(@NotNull VirtualFile file2, boolean moveFocus, boolean closeAllCopies) {
        FileEditorManagerImpl.assertDispatchThread();
        CommandProcessor.getInstance().executeCommand(this.myProject, () -> this.closeFileImpl(file2, moveFocus, closeAllCopies), "", null);
    }

    private void closeFileImpl(@NotNull VirtualFile file2, boolean moveFocus, boolean closeAllCopies) {
        FileEditorManagerImpl.assertDispatchThread();
        ourOpenFilesSetModificationCount.incrementAndGet();
        this.runChange(splitters -> splitters.closeFile(file2, moveFocus), closeAllCopies ? null : this.getActiveSplittersSync());
    }

    @Override
    @NotNull
    public Pair<FileEditor[], FileEditorProvider[]> openFileWithProviders(@NotNull VirtualFile file2, boolean focusEditor, boolean searchForSplitter) {
        Pair<FileEditor[], FileEditorProvider[]> previewResult;
        if (!file2.isValid()) {
            throw new IllegalArgumentException("file is not valid: " + file2);
        }
        FileEditorManagerImpl.assertDispatchThread();
        if (FileEditorManagerImpl.isOpenInNewWindow()) {
            return this.openFileInNewWindow(file2);
        }
        EditorWindow wndToOpenIn = null;
        if (searchForSplitter) {
            Set<EditorsSplitters> all = this.getAllSplitters();
            EditorsSplitters active = this.getActiveSplittersSync();
            if (active.getCurrentWindow() != null && active.getCurrentWindow().isFileOpen(file2)) {
                wndToOpenIn = active.getCurrentWindow();
            } else {
                for (EditorsSplitters splitters : all) {
                    EditorWindow window = splitters.getCurrentWindow();
                    if (window == null || !window.isFileOpen(file2)) continue;
                    wndToOpenIn = window;
                    break;
                }
            }
        } else {
            wndToOpenIn = this.getSplitters().getCurrentWindow();
        }
        if (!(wndToOpenIn != null && wndToOpenIn.isFileOpen(file2) || (previewResult = PreviewManager.SERVICE.preview(this.myProject, FilePreviewPanelProvider.ID, file2, focusEditor)) == null)) {
            return previewResult;
        }
        EditorsSplitters splitters = this.getSplitters();
        if (wndToOpenIn == null) {
            wndToOpenIn = splitters.getOrCreateCurrentWindow(file2);
        }
        this.openAssociatedFile(file2, wndToOpenIn, splitters);
        return this.openFileImpl2(wndToOpenIn, file2, focusEditor);
    }

    public Pair<FileEditor[], FileEditorProvider[]> openFileInNewWindow(@NotNull VirtualFile file2) {
        return ((DockManagerImpl)DockManager.getInstance((Project)this.getProject())).createNewDockContainerFor(file2, this);
    }

    private static boolean isOpenInNewWindow() {
        AWTEvent event = IdeEventQueue.getInstance().getTrueCurrentEvent();
        if (event instanceof MouseEvent && ((MouseEvent)event).getModifiersEx() == 64 && (event.getID() == 500 || event.getID() == 501 || event.getID() == 502)) {
            return true;
        }
        if (event instanceof KeyEvent) {
            KeyEvent ke = (KeyEvent)event;
            Keymap keymap = KeymapManager.getInstance().getActiveKeymap();
            String[] ids = keymap.getActionIds(KeyStroke.getKeyStroke(ke.getKeyCode(), ke.getModifiers()));
            return Arrays.asList(ids).contains("OpenElementInNewWindow");
        }
        return false;
    }

    private void openAssociatedFile(VirtualFile file2, EditorWindow wndToOpenIn, @NotNull EditorsSplitters splitters) {
        EditorWindow[] windows = splitters.getWindows();
        if (file2 != null && windows.length == 2) {
            for (FileEditorAssociateFinder finder : FileEditorAssociateFinder.EP_NAME.getExtensionList()) {
                VirtualFile associatedFile = finder.getAssociatedFileToOpen(this.myProject, file2);
                if (associatedFile == null) continue;
                EditorWindow currentWindow = splitters.getCurrentWindow();
                int idx = windows[0] == wndToOpenIn ? 1 : 0;
                this.openFileImpl2(windows[idx], associatedFile, false);
                if (currentWindow == null) break;
                splitters.setCurrentWindow(currentWindow, false);
                break;
            }
        }
    }

    @Override
    @NotNull
    public Pair<FileEditor[], FileEditorProvider[]> openFileWithProviders(@NotNull VirtualFile file2, boolean focusEditor, @NotNull EditorWindow window) {
        if (!file2.isValid()) {
            throw new IllegalArgumentException("file is not valid: " + file2);
        }
        FileEditorManagerImpl.assertDispatchThread();
        return this.openFileImpl2(window, file2, focusEditor);
    }

    @NotNull
    public Pair<FileEditor[], FileEditorProvider[]> openFileImpl2(@NotNull EditorWindow window, @NotNull VirtualFile file2, boolean focusEditor) {
        Ref result2 = new Ref();
        CommandProcessor.getInstance().executeCommand(this.myProject, () -> result2.set(this.openFileImpl3(window, file2, focusEditor, null, true)), "", null);
        return (Pair)result2.get();
    }

    @NotNull
    Pair<FileEditor[], FileEditorProvider[]> openFileImpl3(@NotNull EditorWindow window, @NotNull VirtualFile file2, boolean focusEditor, @Nullable HistoryEntry entry, boolean current) {
        return this.openFileImpl4(window, file2, entry, current, focusEditor, null, -1, false);
    }

    @NotNull
    Pair<FileEditor[], FileEditorProvider[]> openFileImpl4(@NotNull EditorWindow window, @NotNull VirtualFile file2, @Nullable HistoryEntry entry, boolean current, boolean focusEditor, Boolean pin, int index, boolean exactState) {
        AsyncFileEditorProvider.Builder[] builders;
        FileEditorProvider[] newProviders;
        assert (ApplicationManager.getApplication().isDispatchThread() || !ApplicationManager.getApplication().isReadAccessAllowed()) : "must not open files under read action since we are doing a lot of invokeAndWaits here";
        Ref compositeRef = new Ref();
        UIUtil.invokeAndWaitIfNeeded(() -> compositeRef.set((Object)window.findFileComposite(file2)));
        if (compositeRef.isNull()) {
            newProviders = FileEditorProviderManager.getInstance().getProviders(this.myProject, file2);
            if (newProviders.length == 0) {
                return Pair.create((Object)EMPTY_EDITOR_ARRAY, (Object)EMPTY_PROVIDER_ARRAY);
            }
            builders = new AsyncFileEditorProvider.Builder[newProviders.length];
            for (int i = 0; i < newProviders.length; ++i) {
                try {
                    FileEditorProvider provider = newProviders[i];
                    LOG.assertTrue(provider != null, (Object)("Provider for file " + file2 + " is null. All providers: " + Arrays.asList(newProviders)));
                    builders[i] = (AsyncFileEditorProvider.Builder)ReadAction.compute(() -> {
                        if (this.myProject.isDisposed() || !file2.isValid()) {
                            return null;
                        }
                        LOG.assertTrue(provider.accept(this.myProject, file2), (Object)("Provider " + provider + " doesn't accept file " + file2));
                        return provider instanceof AsyncFileEditorProvider ? ((AsyncFileEditorProvider)provider).createEditorAsync(this.myProject, file2) : null;
                    });
                    continue;
                }
                catch (ProcessCanceledException e) {
                    throw e;
                }
                catch (AssertionError | Exception e) {
                    LOG.error((Throwable)e);
                }
            }
        } else {
            newProviders = null;
            builders = null;
        }
        Runnable runnable2 = () -> {
            if (this.myProject.isDisposed() || !file2.isValid()) {
                return;
            }
            ((TransactionGuardImpl)TransactionGuard.getInstance()).assertWriteActionAllowed();
            compositeRef.set((Object)window.findFileComposite(file2));
            boolean newEditor = compositeRef.isNull();
            if (newEditor) {
                FileEditorManagerImpl.clearWindowIfNeeded(window);
                ((FileEditorManagerListener.Before)this.getProject().getMessageBus().syncPublisher(FileEditorManagerListener.Before.FILE_EDITOR_MANAGER)).beforeFileOpened((FileEditorManager)this, file2);
                FileEditor[] newEditors = new FileEditor[newProviders.length];
                for (int i = 0; i < newProviders.length; ++i) {
                    try {
                        FileEditorProvider provider = newProviders[i];
                        FileEditor editor = builders[i] == null ? provider.createEditor(this.myProject, file2) : builders[i].build();
                        LOG.assertTrue(editor.isValid(), (Object)("Invalid editor created by provider " + (provider == null ? null : provider.getClass().getName())));
                        newEditors[i] = editor;
                        editor.addPropertyChangeListener(this.myEditorPropertyChangeListener);
                        editor.putUserData(DUMB_AWARE, (Object)DumbService.isDumbAware((Object)provider));
                        continue;
                    }
                    catch (ProcessCanceledException e) {
                        throw e;
                    }
                    catch (AssertionError | Exception e) {
                        LOG.error((Throwable)e);
                    }
                }
                EditorWithProviderComposite composite = this.createComposite(file2, newEditors, newProviders);
                if (composite == null) {
                    return;
                }
                if (index >= 0) {
                    composite.getFile().putUserData(EditorWindow.INITIAL_INDEX_KEY, (Object)index);
                }
                compositeRef.set((Object)composite);
            }
            EditorWithProviderComposite composite = (EditorWithProviderComposite)compositeRef.get();
            FileEditor[] editors = composite.getEditors();
            FileEditorProvider[] providers = composite.getProviders();
            window.setEditor(composite, current, focusEditor);
            for (int i = 0; i < editors.length; ++i) {
                this.restoreEditorState(file2, providers[i], editors[i], entry, newEditor, exactState);
            }
            FileEditorProvider selectedProvider = entry == null ? ((FileEditorProviderManagerImpl)FileEditorProviderManager.getInstance()).getSelectedFileEditorProvider(EditorHistoryManager.getInstance(this.myProject), file2, providers) : entry.getSelectedProvider();
            if (selectedProvider != null) {
                for (int i = editors.length - 1; i >= 0; --i) {
                    FileEditorProvider provider = providers[i];
                    if (!provider.equals(selectedProvider)) continue;
                    composite.setSelectedEditor(i);
                    break;
                }
            }
            window.getOwner().setCurrentWindow(window, focusEditor);
            window.getOwner().afterFileOpen(file2);
            this.addSelectionRecord(file2, window);
            composite.getSelectedEditor().selectNotify();
            if (!ApplicationManagerEx.getApplicationEx().isUnitTestMode() && focusEditor) {
                window.setAsCurrentWindow(true);
                Window windowAncestor = SwingUtilities.getWindowAncestor(window.myPanel);
                if (windowAncestor != null && windowAncestor.equals(KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusedWindow())) {
                    ToolWindowManager.getInstance((Project)this.myProject).activateEditorComponent();
                    IdeFocusManager.getInstance((Project)this.myProject).toFront((JComponent)((Object)window.getOwner()));
                }
            }
            if (newEditor) {
                ourOpenFilesSetModificationCount.incrementAndGet();
            }
            ((IdeDocumentHistoryImpl)IdeDocumentHistory.getInstance(this.myProject)).onSelectionChanged();
            this.updateFileName(file2);
            IdeDocumentHistory.getInstance(this.myProject).includeCurrentCommandAsNavigation();
            if (pin != null) {
                window.setFilePinned(file2, pin);
            }
            if (newEditor) {
                ((FileEditorManagerListener)this.getProject().getMessageBus().syncPublisher(FileEditorManagerListener.FILE_EDITOR_MANAGER)).fileOpenedSync((FileEditorManager)this, file2, Pair.pair((Object)editors, (Object)providers));
                this.notifyPublisher(() -> {
                    if (this.isFileOpen(file2)) {
                        ((FileEditorManagerListener)this.getProject().getMessageBus().syncPublisher(FileEditorManagerListener.FILE_EDITOR_MANAGER)).fileOpened((FileEditorManager)this, file2);
                    }
                });
            }
        };
        ApplicationManager.getApplication().invokeAndWait(runnable2);
        EditorWithProviderComposite composite = (EditorWithProviderComposite)compositeRef.get();
        return Pair.create((Object)(composite == null ? EMPTY_EDITOR_ARRAY : composite.getEditors()), (Object)(composite == null ? EMPTY_PROVIDER_ARRAY : composite.getProviders()));
    }

    @Nullable
    private EditorWithProviderComposite createComposite(@NotNull VirtualFile file2, @NotNull FileEditor[] editors, @NotNull FileEditorProvider[] providers) {
        if (ArrayUtil.contains(null, (Object[])editors) || ArrayUtil.contains(null, (Object[])providers)) {
            ArrayList<FileEditor> editorList = new ArrayList<FileEditor>(editors.length);
            ArrayList<FileEditorProvider> providerList = new ArrayList<FileEditorProvider>(providers.length);
            for (int i = 0; i < editors.length; ++i) {
                FileEditor editor = editors[i];
                FileEditorProvider provider = providers[i];
                if (editor == null || provider == null) continue;
                editorList.add(editor);
                providerList.add(provider);
            }
            if (editorList.isEmpty()) {
                return null;
            }
            editors = editorList.toArray(new FileEditor[0]);
            providers = providerList.toArray(new FileEditorProvider[0]);
        }
        return new EditorWithProviderComposite(file2, editors, providers, this);
    }

    private static void clearWindowIfNeeded(@NotNull EditorWindow window) {
        if (UISettings.getInstance().getEditorTabPlacement() == 0 || UISettings.getInstance().getPresentationMode()) {
            window.clear();
        }
    }

    private void restoreEditorState(@NotNull VirtualFile file2, @NotNull FileEditorProvider provider, @NotNull FileEditor editor, HistoryEntry entry, boolean newEditor, boolean exactState) {
        FileEditorState state = null;
        if (entry != null) {
            state = entry.getState(provider);
        }
        if (state == null && newEditor) {
            state = EditorHistoryManager.getInstance(this.myProject).getState(file2, provider);
        }
        if (state != null) {
            if (!FileEditorManagerImpl.isDumbAware(editor)) {
                FileEditorState finalState = state;
                DumbService.getInstance((Project)this.getProject()).runWhenSmart(() -> editor.setState(finalState, exactState));
            } else {
                editor.setState(state, exactState);
            }
        }
    }

    @Override
    @NotNull
    public ActionCallback notifyPublisher(final @NotNull Runnable runnable2) {
        final IdeFocusManager focusManager = IdeFocusManager.getInstance((Project)this.myProject);
        final ActionCallback done = new ActionCallback();
        return this.myBusyObject.execute(new ActiveRunnable(){

            @NotNull
            public ActionCallback run() {
                focusManager.doWhenFocusSettlesDown((Runnable)new ExpirableRunnable.ForProject(FileEditorManagerImpl.this.myProject){

                    public void run() {
                        runnable2.run();
                        done.setDone();
                    }
                }, ModalityState.current());
                return done;
            }
        });
    }

    public void setSelectedEditor(@NotNull VirtualFile file2, @NotNull String fileEditorProviderId) {
        EditorWithProviderComposite composite = this.getCurrentEditorWithProviderComposite(file2);
        if (composite == null) {
            List<EditorWithProviderComposite> composites = this.getEditorComposites(file2);
            if (composites.isEmpty()) {
                return;
            }
            composite = composites.get(0);
        }
        FileEditorProvider[] editorProviders = composite.getProviders();
        FileEditorProvider selectedProvider = (FileEditorProvider)composite.getSelectedEditorWithProvider().getSecond();
        for (int i = 0; i < editorProviders.length; ++i) {
            if (!editorProviders[i].getEditorTypeId().equals(fileEditorProviderId) || selectedProvider.equals(editorProviders[i])) continue;
            composite.setSelectedEditor(i);
            composite.getSelectedEditor().selectNotify();
        }
    }

    @Nullable
    EditorWithProviderComposite newEditorComposite(VirtualFile file2) {
        if (file2 == null) {
            return null;
        }
        FileEditorProviderManager editorProviderManager = FileEditorProviderManager.getInstance();
        FileEditorProvider[] providers = editorProviderManager.getProviders(this.myProject, file2);
        if (providers.length == 0) {
            return null;
        }
        FileEditor[] editors = new FileEditor[providers.length];
        for (int i = 0; i < providers.length; ++i) {
            FileEditor editor;
            FileEditorProvider provider = providers[i];
            LOG.assertTrue(provider != null);
            LOG.assertTrue(provider.accept(this.myProject, file2));
            editors[i] = editor = provider.createEditor(this.myProject, file2);
            LOG.assertTrue(editor.isValid());
            editor.addPropertyChangeListener(this.myEditorPropertyChangeListener);
        }
        EditorWithProviderComposite newComposite = new EditorWithProviderComposite(file2, editors, providers, this);
        EditorHistoryManager editorHistoryManager = EditorHistoryManager.getInstance(this.myProject);
        for (int i = 0; i < editors.length; ++i) {
            FileEditor editor = editors[i];
            FileEditorProvider provider = providers[i];
            FileEditorState state = editorHistoryManager.getState(file2, provider);
            if (state == null) continue;
            editor.setState(state);
        }
        return newComposite;
    }

    @NotNull
    public List<FileEditor> openEditor(@NotNull OpenFileDescriptor descriptor, boolean focusEditor) {
        OpenFileDescriptor realDescriptor;
        FileEditorManagerImpl.assertDispatchThread();
        if (descriptor.getFile() instanceof VirtualFileWindow) {
            VirtualFileWindow delegate = (VirtualFileWindow)descriptor.getFile();
            int hostOffset = delegate.getDocumentWindow().injectedToHost(descriptor.getOffset());
            realDescriptor = new OpenFileDescriptor(descriptor.getProject(), delegate.getDelegate(), hostOffset);
            realDescriptor.setUseCurrentWindow(descriptor.isUseCurrentWindow());
        } else {
            realDescriptor = descriptor;
        }
        SmartList result2 = new SmartList();
        CommandProcessor.getInstance().executeCommand(this.myProject, () -> this.lambda$openEditor$10(realDescriptor, focusEditor, (List)result2), "", null);
        return result2;
    }

    private boolean navigateAndSelectEditor(@NotNull NavigatableFileEditor editor, @NotNull OpenFileDescriptor descriptor) {
        if (editor.canNavigateTo((Navigatable)descriptor)) {
            this.setSelectedEditor((FileEditor)editor);
            editor.navigateTo((Navigatable)descriptor);
            return true;
        }
        return false;
    }

    private void setSelectedEditor(@NotNull FileEditor editor) {
        EditorWithProviderComposite composite = this.getEditorComposite(editor);
        if (composite == null) {
            return;
        }
        FileEditor[] editors = composite.getEditors();
        for (int i = 0; i < editors.length; ++i) {
            FileEditor each = editors[i];
            if (editor != each) continue;
            composite.setSelectedEditor(i);
            composite.getSelectedEditor().selectNotify();
            break;
        }
    }

    @NotNull
    public Project getProject() {
        return this.myProject;
    }

    @Nullable
    public Editor openTextEditor(@NotNull OpenFileDescriptor descriptor, boolean focusEditor) {
        TextEditor textEditor = this.doOpenTextEditor(descriptor, focusEditor);
        return textEditor == null ? null : this.getOpenedEditor(textEditor.getEditor(), focusEditor);
    }

    protected Editor getOpenedEditor(@NotNull Editor editor, boolean focusEditor) {
        return editor;
    }

    public void navigateToTextEditor(@NotNull OpenFileDescriptor descriptor, boolean focusEditor) {
        this.doOpenTextEditor(descriptor, focusEditor);
    }

    @Nullable
    private TextEditor doOpenTextEditor(@NotNull OpenFileDescriptor descriptor, boolean focusEditor) {
        List<FileEditor> fileEditors = this.openEditor(descriptor, focusEditor);
        if (fileEditors.isEmpty()) {
            return null;
        }
        if (fileEditors.size() == 1) {
            return (TextEditor)ObjectUtils.tryCast((Object)ContainerUtil.getFirstItem(fileEditors), TextEditor.class);
        }
        List textEditors = ContainerUtil.mapNotNull(fileEditors, e -> (TextEditor)ObjectUtils.tryCast((Object)e, TextEditor.class));
        if (textEditors.isEmpty()) {
            return null;
        }
        TextEditor target2 = (TextEditor)textEditors.get(0);
        if (textEditors.size() > 1) {
            EditorWithProviderComposite composite = this.getEditorComposite((FileEditor)target2);
            assert (composite != null);
            FileEditor[] editors = composite.getEditors();
            FileEditorProvider[] providers = composite.getProviders();
            String textProviderId = TextEditorProvider.getInstance().getEditorTypeId();
            for (int i = 0; i < editors.length; ++i) {
                FileEditor editor = editors[i];
                if (!(editor instanceof TextEditor) || !providers[i].getEditorTypeId().equals(textProviderId)) continue;
                target2 = (TextEditor)editor;
                break;
            }
        }
        this.setSelectedEditor((FileEditor)target2);
        return target2;
    }

    public Editor getSelectedTextEditor() {
        return this.getSelectedTextEditor(false);
    }

    public Editor getSelectedTextEditor(boolean lockfree) {
        EditorWithProviderComposite selectedEditor;
        EditorWindow currentWindow;
        if (!lockfree) {
            FileEditorManagerImpl.assertDispatchThread();
        }
        EditorWindow editorWindow = currentWindow = lockfree ? this.getMainSplitters().getCurrentWindow() : this.getSplitters().getCurrentWindow();
        if (currentWindow != null && (selectedEditor = currentWindow.getSelectedEditor()) != null && selectedEditor.getSelectedEditor() instanceof TextEditor) {
            return ((TextEditor)selectedEditor.getSelectedEditor()).getEditor();
        }
        return null;
    }

    public boolean isFileOpen(@NotNull VirtualFile file2) {
        return !this.getEditorComposites(file2).isEmpty();
    }

    @NotNull
    public VirtualFile[] getOpenFiles() {
        THashSet openFiles = new THashSet();
        for (EditorsSplitters each : this.getAllSplitters()) {
            ContainerUtil.addAll((Collection)openFiles, (Object[])each.getOpenFiles());
        }
        return VfsUtilCore.toVirtualFileArray((Collection)openFiles);
    }

    @NotNull
    public VirtualFile[] getSelectedFiles() {
        LinkedHashSet selectedFiles = new LinkedHashSet();
        EditorsSplitters activeSplitters = this.getSplitters();
        ContainerUtil.addAll(selectedFiles, (Object[])activeSplitters.getSelectedFiles());
        for (EditorsSplitters each : this.getAllSplitters()) {
            if (each == activeSplitters) continue;
            ContainerUtil.addAll(selectedFiles, (Object[])each.getSelectedFiles());
        }
        return VfsUtilCore.toVirtualFileArray(selectedFiles);
    }

    @NotNull
    public FileEditor[] getSelectedEditors() {
        LinkedHashSet selectedEditors = new LinkedHashSet();
        for (EditorsSplitters each : this.getAllSplitters()) {
            ContainerUtil.addAll(selectedEditors, (Object[])each.getSelectedEditors());
        }
        return selectedEditors.toArray(new FileEditor[0]);
    }

    @Override
    @NotNull
    public EditorsSplitters getSplitters() {
        EditorsSplitters active = null;
        if (ApplicationManager.getApplication().isDispatchThread()) {
            active = this.getActiveSplittersSync();
        }
        return active == null ? this.getMainSplitters() : active;
    }

    @Nullable
    public FileEditor getSelectedEditor() {
        EditorWithProviderComposite selected;
        EditorWindow window = this.getSplitters().getCurrentWindow();
        if (window != null && (selected = window.getSelectedEditor()) != null) {
            return selected.getSelectedEditor();
        }
        return super.getSelectedEditor();
    }

    @Nullable
    public FileEditor getSelectedEditor(@NotNull VirtualFile file2) {
        FileEditorWithProvider editorWithProvider = this.getSelectedEditorWithProvider(file2);
        return editorWithProvider == null ? null : editorWithProvider.getFileEditor();
    }

    @Override
    @Nullable
    public FileEditorWithProvider getSelectedEditorWithProvider(@NotNull VirtualFile file2) {
        EditorWithProviderComposite composite;
        if (file2 instanceof VirtualFileWindow) {
            file2 = ((VirtualFileWindow)file2).getDelegate();
        }
        if ((composite = this.getCurrentEditorWithProviderComposite(file2)) != null) {
            return composite.getSelectedWithProvider();
        }
        List<EditorWithProviderComposite> composites = this.getEditorComposites(file2);
        return composites.isEmpty() ? null : composites.get(0).getSelectedWithProvider();
    }

    @Override
    @NotNull
    public Pair<FileEditor[], FileEditorProvider[]> getEditorsWithProviders(@NotNull VirtualFile file2) {
        FileEditorManagerImpl.assertReadAccess();
        EditorWithProviderComposite composite = this.getCurrentEditorWithProviderComposite(file2);
        if (composite != null) {
            return Pair.create((Object)composite.getEditors(), (Object)composite.getProviders());
        }
        List<EditorWithProviderComposite> composites = this.getEditorComposites(file2);
        if (!composites.isEmpty()) {
            return Pair.create((Object)composites.get(0).getEditors(), (Object)composites.get(0).getProviders());
        }
        return Pair.create((Object)EMPTY_EDITOR_ARRAY, (Object)EMPTY_PROVIDER_ARRAY);
    }

    @NotNull
    public FileEditor[] getEditors(@NotNull VirtualFile file2) {
        EditorWithProviderComposite composite;
        FileEditorManagerImpl.assertReadAccess();
        if (file2 instanceof VirtualFileWindow) {
            file2 = ((VirtualFileWindow)file2).getDelegate();
        }
        if (file2 instanceof BackedVirtualFile) {
            file2 = ((BackedVirtualFile)file2).getOriginFile();
        }
        if ((composite = this.getCurrentEditorWithProviderComposite(file2)) != null) {
            return composite.getEditors();
        }
        List<EditorWithProviderComposite> composites = this.getEditorComposites(file2);
        if (!composites.isEmpty()) {
            return composites.get(0).getEditors();
        }
        return EMPTY_EDITOR_ARRAY;
    }

    @NotNull
    public FileEditor[] getAllEditors(@NotNull VirtualFile file2) {
        List<EditorWithProviderComposite> editorComposites = this.getEditorComposites(file2);
        if (editorComposites.isEmpty()) {
            return EMPTY_EDITOR_ARRAY;
        }
        ArrayList editors = new ArrayList();
        for (EditorWithProviderComposite composite : editorComposites) {
            ContainerUtil.addAll(editors, (Object[])composite.getEditors());
        }
        return editors.toArray(new FileEditor[0]);
    }

    @Nullable
    private EditorWithProviderComposite getCurrentEditorWithProviderComposite(@NotNull VirtualFile virtualFile) {
        EditorWindow editorWindow = this.getSplitters().getCurrentWindow();
        if (editorWindow != null) {
            return editorWindow.findFileComposite(virtualFile);
        }
        return null;
    }

    @NotNull
    private List<EditorWithProviderComposite> getEditorComposites(@NotNull VirtualFile file2) {
        ArrayList<EditorWithProviderComposite> result2 = new ArrayList<EditorWithProviderComposite>();
        Set<EditorsSplitters> all = this.getAllSplitters();
        for (EditorsSplitters each : all) {
            result2.addAll(each.findEditorComposites(file2));
        }
        return result2;
    }

    @NotNull
    public FileEditor[] getAllEditors() {
        FileEditorManagerImpl.assertReadAccess();
        ArrayList result2 = new ArrayList();
        Set<EditorsSplitters> allSplitters = this.getAllSplitters();
        for (EditorsSplitters splitter : allSplitters) {
            EditorWithProviderComposite[] editorsComposites;
            for (EditorWithProviderComposite editorsComposite : editorsComposites = splitter.getEditorsComposites()) {
                Object[] editors = editorsComposite.getEditors();
                ContainerUtil.addAll(result2, (Object[])editors);
            }
        }
        return result2.toArray(new FileEditor[0]);
    }

    @NotNull
    public List<JComponent> getTopComponents(@NotNull FileEditor editor) {
        EditorWithProviderComposite composite = this.getEditorComposite(editor);
        return composite != null ? composite.getTopComponents(editor) : Collections.emptyList();
    }

    public void addTopComponent(@NotNull FileEditor editor, @NotNull JComponent component) {
        EditorWithProviderComposite composite = this.getEditorComposite(editor);
        if (composite != null) {
            composite.addTopComponent(editor, component);
        }
    }

    public void removeTopComponent(@NotNull FileEditor editor, @NotNull JComponent component) {
        EditorWithProviderComposite composite = this.getEditorComposite(editor);
        if (composite != null) {
            composite.removeTopComponent(editor, component);
        }
    }

    public void addBottomComponent(@NotNull FileEditor editor, @NotNull JComponent component) {
        EditorWithProviderComposite composite = this.getEditorComposite(editor);
        if (composite != null) {
            composite.addBottomComponent(editor, component);
        }
    }

    public void removeBottomComponent(@NotNull FileEditor editor, @NotNull JComponent component) {
        EditorWithProviderComposite composite = this.getEditorComposite(editor);
        if (composite != null) {
            composite.removeBottomComponent(editor, component);
        }
    }

    public void addFileEditorManagerListener(@NotNull FileEditorManagerListener listener2) {
        this.myListenerList.add((Object)listener2);
    }

    public void addFileEditorManagerListener(@NotNull FileEditorManagerListener listener2, @NotNull Disposable parentDisposable) {
        this.myListenerList.add((Object)listener2, parentDisposable);
    }

    public void removeFileEditorManagerListener(@NotNull FileEditorManagerListener listener2) {
        this.myListenerList.remove((Object)listener2);
    }

    protected void projectOpened(@NotNull MessageBusConnection connection) {
        this.getMainSplitters().startListeningFocus();
        FileStatusManager fileStatusManager = FileStatusManager.getInstance((Project)this.myProject);
        if (fileStatusManager != null) {
            MyFileStatusListener myFileStatusListener = new MyFileStatusListener();
            fileStatusManager.addFileStatusListener((FileStatusListener)myFileStatusListener, (Disposable)this.myProject);
        }
        connection.subscribe(FileTypeManager.TOPIC, (Object)new MyFileTypeListener());
        connection.subscribe(ProjectTopics.PROJECT_ROOTS, (Object)new MyRootsListener());
        MyVirtualFileListener myVirtualFileListener = new MyVirtualFileListener();
        VirtualFileManager.getInstance().addVirtualFileListener((VirtualFileListener)myVirtualFileListener, (Disposable)this.myProject);
        connection.subscribe(UISettingsListener.TOPIC, (Object)new MyUISettingsListener());
        StartupManager.getInstance((Project)this.myProject).registerPostStartupActivity((Runnable)((DumbAwareRunnable)() -> {
            if (this.myProject.isDisposed()) {
                return;
            }
            this.setTabsMode(UISettings.getInstance().getEditorTabPlacement() != 0);
            ToolWindowManager.getInstance((Project)this.myProject).invokeLater(() -> {
                if (!this.myProject.isDisposed()) {
                    CommandProcessor.getInstance().executeCommand(this.myProject, () -> ApplicationManager.getApplication().invokeLater(() -> {
                        long currentTime = System.nanoTime();
                        Long startTime = (Long)this.myProject.getUserData(ProjectImpl.CREATION_TIME);
                        if (startTime != null) {
                            long time = (currentTime - startTime) / 1000000L;
                            LifecycleUsageTriggerCollector.onProjectOpenFinished(this.myProject, time);
                            LOG.info("Project opening took " + time + " ms");
                            PluginManagerCore.dumpPluginClassStatistics();
                        }
                    }, this.myProject.getDisposed()), "", null);
                }
            });
        }));
    }

    @Nullable
    public Element getState() {
        if (this.mySplitters == null) {
            return null;
        }
        Element state = new Element("state");
        this.getMainSplitters().writeExternal(state);
        return state;
    }

    public void loadState(@NotNull Element state) {
        this.getMainSplitters().readExternal(state);
    }

    @Nullable
    private EditorWithProviderComposite getEditorComposite(@NotNull FileEditor editor) {
        for (EditorsSplitters splitters : this.getAllSplitters()) {
            EditorWithProviderComposite[] editorsComposites = splitters.getEditorsComposites();
            for (int i = editorsComposites.length - 1; i >= 0; --i) {
                EditorWithProviderComposite composite = editorsComposites[i];
                FileEditor[] editors = composite.getEditors();
                for (int j = editors.length - 1; j >= 0; --j) {
                    FileEditor _editor = editors[j];
                    LOG.assertTrue(_editor != null);
                    if (!editor.equals(_editor)) continue;
                    return composite;
                }
            }
        }
        return null;
    }

    private static void assertDispatchThread() {
        ApplicationManager.getApplication().assertIsDispatchThread();
    }

    private static void assertReadAccess() {
        ApplicationManager.getApplication().assertReadAccessAllowed();
    }

    public void fireSelectionChanged(EditorComposite newSelectedComposite) {
        boolean editorsEqual;
        boolean filesEqual;
        Trinity<VirtualFile, FileEditor, FileEditorProvider> oldData = FileEditorManagerImpl.extract((EditorComposite)SoftReference.dereference(this.myLastSelectedComposite));
        Trinity<VirtualFile, FileEditor, FileEditorProvider> newData = FileEditorManagerImpl.extract(newSelectedComposite);
        WeakReference<EditorComposite> weakReference = this.myLastSelectedComposite = newSelectedComposite == null ? null : new WeakReference<EditorComposite>(newSelectedComposite);
        boolean bl = oldData.first == null ? newData.first == null : (filesEqual = ((VirtualFile)oldData.first).equals(newData.first));
        boolean bl2 = oldData.second == null ? newData.second == null : (editorsEqual = ((FileEditor)oldData.second).equals(newData.second));
        if (!filesEqual || !editorsEqual) {
            JComponent component;
            EditorWindowHolder holder;
            if (oldData.first != null && newData.first != null) {
                for (FileEditorAssociateFinder finder : FileEditorAssociateFinder.EP_NAME.getExtensionList()) {
                    VirtualFile associatedFile = finder.getAssociatedFileToOpen(this.myProject, (VirtualFile)oldData.first);
                    if (!Comparing.equal((Object)associatedFile, (Object)newData.first)) continue;
                    return;
                }
            }
            FileEditorManagerEvent event = new FileEditorManagerEvent((FileEditorManager)this, (VirtualFile)oldData.first, (FileEditor)oldData.second, (FileEditorProvider)oldData.third, (VirtualFile)newData.first, (FileEditor)newData.second, (FileEditorProvider)newData.third);
            FileEditorManagerListener publisher = (FileEditorManagerListener)this.getProject().getMessageBus().syncPublisher(FileEditorManagerListener.FILE_EDITOR_MANAGER);
            if (newData.first != null && (holder = (EditorWindowHolder)UIUtil.getParentOfType(EditorWindowHolder.class, (Component)(component = ((FileEditor)newData.second).getComponent()))) != null) {
                this.addSelectionRecord((VirtualFile)newData.first, holder.getEditorWindow());
            }
            this.notifyPublisher(() -> publisher.selectionChanged(event));
        }
    }

    @NotNull
    private static Trinity<VirtualFile, FileEditor, FileEditorProvider> extract(@Nullable EditorComposite composite) {
        FileEditorProvider provider;
        FileEditor editor;
        VirtualFile file2;
        if (composite == null || composite.isDisposed()) {
            file2 = null;
            editor = null;
            provider = null;
        } else {
            file2 = composite.getFile();
            FileEditorWithProvider pair = composite.getSelectedWithProvider();
            editor = pair.getFileEditor();
            provider = pair.getProvider();
        }
        return new Trinity((Object)file2, (Object)editor, provider);
    }

    @Override
    public boolean isChanged(@NotNull EditorComposite editor) {
        FileStatusManager fileStatusManager = FileStatusManager.getInstance((Project)this.myProject);
        if (fileStatusManager == null) {
            return false;
        }
        FileStatus status = fileStatusManager.getStatus(editor.getFile());
        return status != FileStatus.UNKNOWN && status != FileStatus.NOT_CHANGED;
    }

    void disposeComposite(@NotNull EditorWithProviderComposite editor) {
        if (this.getAllEditors().length == 0) {
            this.setCurrentWindow(null);
        }
        if (editor.equals(this.getLastSelected())) {
            editor.getSelectedEditor().deselectNotify();
            this.getSplitters().setCurrentWindow(null, false);
        }
        FileEditor[] editors = editor.getEditors();
        FileEditorProvider[] providers = editor.getProviders();
        FileEditor selectedEditor = editor.getSelectedEditor();
        for (int i = editors.length - 1; i >= 0; --i) {
            FileEditor editor1 = editors[i];
            FileEditorProvider provider = providers[i];
            if (!editor.equals(selectedEditor) && selectedEditor.equals(editor1)) {
                editor1.deselectNotify();
            }
            editor1.removePropertyChangeListener(this.myEditorPropertyChangeListener);
            provider.disposeEditor(editor1);
        }
        Disposer.dispose((Disposable)editor);
    }

    @Nullable
    private EditorComposite getLastSelected() {
        EditorWindow currentWindow = this.getActiveSplittersSync().getCurrentWindow();
        if (currentWindow != null) {
            return currentWindow.getSelectedEditor();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void runChange(@NotNull FileEditorManagerChange change, @Nullable EditorsSplitters splitters) {
        HashSet<EditorsSplitters> target2 = new HashSet<EditorsSplitters>();
        if (splitters == null) {
            target2.addAll(this.getAllSplitters());
        } else {
            target2.add(splitters);
        }
        for (EditorsSplitters each : target2) {
            ++each.myInsideChange;
            try {
                change.run(each);
            }
            finally {
                --each.myInsideChange;
            }
        }
    }

    @Override
    public boolean isInsideChange() {
        return this.getSplitters().isInsideChange();
    }

    @Override
    public void closeAllFiles() {
        VirtualFile[] openFiles;
        for (VirtualFile openFile2 : openFiles = this.getSplitters().getOpenFiles()) {
            this.closeFile(openFile2);
        }
    }

    @Override
    @NotNull
    public VirtualFile[] getSiblings(@NotNull VirtualFile file2) {
        return this.getOpenFiles();
    }

    void queueUpdateFile(final @NotNull VirtualFile file2) {
        this.myQueue.queue(new Update(file2){

            public void run() {
                if (FileEditorManagerImpl.this.isFileOpen(file2)) {
                    FileEditorManagerImpl.this.updateFileIcon(file2);
                    FileEditorManagerImpl.this.updateFileColor(file2);
                    FileEditorManagerImpl.this.updateFileBackgroundColor(file2);
                }
            }
        });
    }

    @Override
    public EditorsSplitters getSplittersFor(Component c) {
        EditorsSplitters splitters = null;
        DockContainer dockContainer = this.myDockManager.getContainerFor(c);
        if (dockContainer instanceof DockableEditorTabbedContainer) {
            splitters = ((DockableEditorTabbedContainer)dockContainer).getSplitters();
        }
        if (splitters == null) {
            splitters = this.getMainSplitters();
        }
        return splitters;
    }

    @NotNull
    public List<Pair<VirtualFile, EditorWindow>> getSelectionHistory() {
        ArrayList<Object> copy = new ArrayList<Object>();
        for (Pair<VirtualFile, EditorWindow> pair : this.mySelectionHistory) {
            if (((EditorWindow)pair.second).getFiles().length == 0) {
                Pair p;
                EditorWindow[] windows = ((EditorWindow)pair.second).getOwner().getWindows();
                if (windows.length <= 0 || windows[0] == null || windows[0].getFiles().length <= 0 || copy.contains(p = Pair.create((Object)pair.first, (Object)windows[0]))) continue;
                copy.add(p);
                continue;
            }
            if (copy.contains(pair)) continue;
            copy.add(pair);
        }
        this.mySelectionHistory.clear();
        this.mySelectionHistory.addAll(copy);
        return this.mySelectionHistory;
    }

    public void addSelectionRecord(@NotNull VirtualFile file2, @NotNull EditorWindow window) {
        Pair record = Pair.create((Object)file2, (Object)window);
        this.mySelectionHistory.remove(record);
        this.mySelectionHistory.add(0, (Pair<VirtualFile, EditorWindow>)record);
    }

    void removeSelectionRecord(@NotNull VirtualFile file2, @NotNull EditorWindow window) {
        this.mySelectionHistory.remove(Pair.create((Object)file2, (Object)window));
        this.updateFileName(file2);
    }

    @NotNull
    public ActionCallback getReady(@NotNull Object requestor) {
        return this.myBusyObject.getReady(requestor);
    }

    private /* synthetic */ void lambda$openEditor$10(OpenFileDescriptor realDescriptor, boolean focusEditor, List result2) {
        Object editor;
        int n;
        VirtualFile file2 = realDescriptor.getFile();
        Object[] editors = this.openFile(file2, focusEditor, !realDescriptor.isUseCurrentWindow());
        ContainerUtil.addAll((Collection)result2, (Object[])editors);
        boolean navigated = false;
        Object[] objectArray = editors;
        int n2 = objectArray.length;
        for (n = 0; !(n >= n2 || (editor = objectArray[n]) instanceof NavigatableFileEditor && this.getSelectedEditor(realDescriptor.getFile()) == editor && (navigated = this.navigateAndSelectEditor((NavigatableFileEditor)editor, realDescriptor))); ++n) {
        }
        if (!navigated) {
            objectArray = editors;
            n2 = objectArray.length;
            for (n = 0; !(n >= n2 || (editor = objectArray[n]) instanceof NavigatableFileEditor && this.getSelectedEditor(realDescriptor.getFile()) != editor && this.navigateAndSelectEditor((NavigatableFileEditor)editor, realDescriptor)); ++n) {
            }
        }
    }

    private final class MyUISettingsListener
    implements UISettingsListener {
        private MyUISettingsListener() {
        }

        public void uiSettingsChanged(UISettings uiSettings) {
            FileEditorManagerImpl.assertDispatchThread();
            TransactionGuard.submitTransaction((Disposable)FileEditorManagerImpl.this.myProject, () -> this.handleUiSettingChange(uiSettings));
        }

        private void handleUiSettingChange(UISettings uiSettings) {
            FileEditorManagerImpl.this.setTabsMode(uiSettings.getEditorTabPlacement() != 0 && !uiSettings.getPresentationMode());
            for (EditorsSplitters each : FileEditorManagerImpl.this.getAllSplitters()) {
                each.setTabsPlacement(uiSettings.getEditorTabPlacement());
                each.trimToSize(uiSettings.getEditorTabLimit());
                if (uiSettings.getScrollTabLayoutInEditor()) {
                    each.setTabLayoutPolicy(1);
                    continue;
                }
                each.setTabLayoutPolicy(0);
            }
            VirtualFile[] openFiles = FileEditorManagerImpl.this.getOpenFiles();
            for (int i = openFiles.length - 1; i >= 0; --i) {
                VirtualFile file2 = openFiles[i];
                FileEditorManagerImpl.this.updateFileIcon(file2);
                FileEditorManagerImpl.this.updateFileName(file2);
                FileEditorManagerImpl.this.updateFileBackgroundColor(file2);
            }
        }
    }

    private class MyRootsListener
    implements ModuleRootListener {
        private CancellablePromise<?> prevTask;

        private MyRootsListener() {
        }

        public void rootsChanged(@NotNull ModuleRootEvent event) {
            if (this.prevTask != null) {
                this.prevTask.cancel();
            }
            List allEditors = StreamEx.of((Object[])FileEditorManagerImpl.this.getWindows()).flatArray(EditorWindow::getEditors).toList();
            this.prevTask = ReadAction.nonBlocking(() -> this.calcEditorReplacements(allEditors)).inSmartMode(FileEditorManagerImpl.this.myProject).finishOnUiThread(ModalityState.defaultModalityState(), this::replaceEditors).submit((Executor)ourSwapperExecutor);
            this.prevTask.onProcessed(__ -> {
                this.prevTask = null;
            });
        }

        private Map<EditorWithProviderComposite, Pair<VirtualFile, Integer>> calcEditorReplacements(List<EditorWithProviderComposite> allEditors) {
            List swappers = EditorFileSwapper.EP_NAME.getExtensionList();
            return StreamEx.of(allEditors).mapToEntry(editor -> {
                if (editor.getFile().isValid()) {
                    for (EditorFileSwapper each : swappers) {
                        Pair<VirtualFile, Integer> fileAndOffset = each.getFileToSwapTo(FileEditorManagerImpl.this.myProject, (EditorWithProviderComposite)editor);
                        if (fileAndOffset == null) continue;
                        return fileAndOffset;
                    }
                }
                return null;
            }).nonNullValues().toMap();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void replaceEditors(Map<EditorWithProviderComposite, Pair<VirtualFile, Integer>> replacements) {
            if (replacements.isEmpty()) {
                return;
            }
            for (EditorWindow eachWindow : FileEditorManagerImpl.this.getWindows()) {
                EditorWithProviderComposite selected = eachWindow.getSelectedEditor();
                EditorWithProviderComposite[] editors = eachWindow.getEditors();
                for (int i = 0; i < editors.length; ++i) {
                    VirtualFile newFile;
                    Pair<VirtualFile, Integer> newFilePair;
                    EditorWithProviderComposite editor = editors[i];
                    VirtualFile file2 = editor.getFile();
                    if (!file2.isValid() || (newFilePair = replacements.get(editor)) == null || (newFile = (VirtualFile)newFilePair.first) == null || eachWindow.findFileIndex(newFile) != -1) continue;
                    try {
                        TextEditorImpl openedEditor;
                        newFile.putUserData(EditorWindow.INITIAL_INDEX_KEY, (Object)i);
                        Pair<FileEditor[], FileEditorProvider[]> pair = FileEditorManagerImpl.this.openFileImpl2(eachWindow, newFile, editor == selected);
                        if (newFilePair.second != null && (openedEditor = EditorFileSwapper.findSinglePsiAwareEditor((FileEditor[])pair.first)) != null) {
                            openedEditor.getEditor().getCaretModel().moveToOffset(((Integer)newFilePair.second).intValue());
                            openedEditor.getEditor().getScrollingModel().scrollToCaret(ScrollType.CENTER);
                        }
                    }
                    finally {
                        newFile.putUserData(EditorWindow.INITIAL_INDEX_KEY, null);
                    }
                    FileEditorManagerImpl.this.closeFile(file2, eachWindow);
                }
            }
        }
    }

    private final class MyFileTypeListener
    implements FileTypeListener {
        private MyFileTypeListener() {
        }

        public void fileTypesChanged(@NotNull FileTypeEvent event) {
            FileEditorManagerImpl.assertDispatchThread();
            VirtualFile[] openFiles = FileEditorManagerImpl.this.getOpenFiles();
            for (int i = openFiles.length - 1; i >= 0; --i) {
                VirtualFile file2 = openFiles[i];
                LOG.assertTrue(file2 != null);
                FileEditorManagerImpl.this.updateFileIcon(file2);
            }
        }
    }

    private final class MyFileStatusListener
    implements FileStatusListener {
        private MyFileStatusListener() {
        }

        public void fileStatusesChanged() {
            FileEditorManagerImpl.assertDispatchThread();
            LOG.debug("FileEditorManagerImpl.MyFileStatusListener.fileStatusesChanged()");
            VirtualFile[] openFiles = FileEditorManagerImpl.this.getOpenFiles();
            for (int i = openFiles.length - 1; i >= 0; --i) {
                VirtualFile file2 = openFiles[i];
                LOG.assertTrue(file2 != null);
                ApplicationManager.getApplication().invokeLater(() -> {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("updating file status in tab for " + file2.getPath());
                    }
                    this.updateFileStatus(file2);
                }, ModalityState.NON_MODAL, FileEditorManagerImpl.this.myProject.getDisposed());
            }
        }

        public void fileStatusChanged(@NotNull VirtualFile file2) {
            FileEditorManagerImpl.assertDispatchThread();
            if (FileEditorManagerImpl.this.isFileOpen(file2)) {
                this.updateFileStatus(file2);
            }
        }

        private void updateFileStatus(VirtualFile file2) {
            FileEditorManagerImpl.this.updateFileColor(file2);
            FileEditorManagerImpl.this.updateFileIcon(file2);
        }
    }

    private final class MyEditorPropertyChangeListener
    implements PropertyChangeListener {
        private MyEditorPropertyChangeListener() {
        }

        @Override
        public void propertyChange(@NotNull PropertyChangeEvent e) {
            boolean valid;
            FileEditorManagerImpl.assertDispatchThread();
            String propertyName = e.getPropertyName();
            if ("modified".equals(propertyName)) {
                FileEditor editor = (FileEditor)e.getSource();
                EditorWithProviderComposite composite = FileEditorManagerImpl.this.getEditorComposite(editor);
                if (composite != null) {
                    FileEditorManagerImpl.this.updateFileIcon(composite.getFile());
                }
            } else if ("valid".equals(propertyName) && !(valid = ((Boolean)e.getNewValue()).booleanValue())) {
                FileEditor editor = (FileEditor)e.getSource();
                LOG.assertTrue(editor != null);
                EditorWithProviderComposite composite = FileEditorManagerImpl.this.getEditorComposite(editor);
                if (composite != null) {
                    FileEditorManagerImpl.this.closeFile(composite.getFile());
                }
            }
        }
    }

    private final class MyVirtualFileListener
    implements VirtualFileListener {
        private MyVirtualFileListener() {
        }

        public void beforeFileDeletion(@NotNull VirtualFileEvent e) {
            FileEditorManagerImpl.assertDispatchThread();
            VirtualFile file2 = e.getFile();
            VirtualFile[] openFiles = FileEditorManagerImpl.this.getOpenFiles();
            for (int i = openFiles.length - 1; i >= 0; --i) {
                if (!VfsUtilCore.isAncestor((VirtualFile)file2, (VirtualFile)openFiles[i], (boolean)false)) continue;
                FileEditorManagerImpl.this.closeFile(openFiles[i], true, true);
            }
        }

        public void propertyChanged(@NotNull VirtualFilePropertyEvent e) {
            if ("name".equals(e.getPropertyName())) {
                FileEditorManagerImpl.assertDispatchThread();
                VirtualFile file2 = e.getFile();
                if (FileEditorManagerImpl.this.isFileOpen(file2)) {
                    FileEditorManagerImpl.this.updateFileName(file2);
                    FileEditorManagerImpl.this.updateFileIcon(file2);
                    FileEditorManagerImpl.this.updateFileBackgroundColor(file2);
                }
            } else if ("writable".equals(e.getPropertyName()) || "encoding".equals(e.getPropertyName())) {
                this.updateIconAndStatusBar(e);
            }
        }

        private void updateIconAndStatusBar(VirtualFilePropertyEvent e) {
            FileEditorManagerImpl.assertDispatchThread();
            VirtualFile file2 = e.getFile();
            if (FileEditorManagerImpl.this.isFileOpen(file2)) {
                FileEditorManagerImpl.this.updateFileIcon(file2);
                if (file2.equals(FileEditorManagerImpl.this.getSelectedFiles()[0])) {
                    StatusBarEx statusBar = (StatusBarEx)WindowManager.getInstance().getStatusBar(FileEditorManagerImpl.this.myProject);
                    assert (statusBar != null);
                    statusBar.updateWidgets();
                }
            }
        }

        public void fileMoved(@NotNull VirtualFileMoveEvent e) {
            VirtualFile[] openFiles;
            VirtualFile file2 = e.getFile();
            for (VirtualFile openFile2 : openFiles = FileEditorManagerImpl.this.getOpenFiles()) {
                if (!VfsUtilCore.isAncestor((VirtualFile)file2, (VirtualFile)openFile2, (boolean)false)) continue;
                FileEditorManagerImpl.this.updateFileName(openFile2);
                FileEditorManagerImpl.this.updateFileBackgroundColor(openFile2);
            }
        }
    }

    private static class MyBorder
    implements Border {
        private MyBorder() {
        }

        @Override
        public void paintBorder(@NotNull Component c, @NotNull Graphics g, int x, int y, int width, int height) {
            if (UIUtil.isUnderAquaLookAndFeel()) {
                g.setColor(JBTabsImpl.MAC_AQUA_BG_COLOR);
                Insets insets = this.getBorderInsets(c);
                if (insets.top > 0) {
                    g.fillRect(x, y, width, height + insets.top);
                }
            }
        }

        @Override
        @NotNull
        public Insets getBorderInsets(Component c) {
            return JBUI.emptyInsets();
        }

        @Override
        public boolean isBorderOpaque() {
            return false;
        }
    }
}

