/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileEditor.impl;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.ex.FileEditorManagerEx;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiTreeChangeAdapter;
import com.intellij.psi.PsiTreeChangeEvent;
import org.jetbrains.annotations.NotNull;

public final class FileEditorPsiTreeChangeListener
extends PsiTreeChangeAdapter {
    private static final Logger LOG = Logger.getInstance(FileEditorPsiTreeChangeListener.class);
    private final FileEditorManagerEx myFileEditorManager;

    public FileEditorPsiTreeChangeListener(FileEditorManagerEx psiAwareFileEditorManager) {
        this.myFileEditorManager = psiAwareFileEditorManager;
    }

    public void propertyChanged(@NotNull PsiTreeChangeEvent e) {
        if ("roots".equals(e.getPropertyName())) {
            ApplicationManager.getApplication().assertIsDispatchThread();
            VirtualFile[] openFiles = this.myFileEditorManager.getOpenFiles();
            for (int i = openFiles.length - 1; i >= 0; --i) {
                VirtualFile file2 = openFiles[i];
                LOG.assertTrue(file2 != null);
                this.myFileEditorManager.updateFilePresentation(file2);
            }
        }
    }

    public void childAdded(@NotNull PsiTreeChangeEvent event) {
        this.doChange(event);
    }

    public void childRemoved(@NotNull PsiTreeChangeEvent event) {
        this.doChange(event);
    }

    public void childReplaced(@NotNull PsiTreeChangeEvent event) {
        this.doChange(event);
    }

    public void childMoved(@NotNull PsiTreeChangeEvent event) {
        this.doChange(event);
    }

    public void childrenChanged(@NotNull PsiTreeChangeEvent event) {
        this.doChange(event);
    }

    private void doChange(PsiTreeChangeEvent event) {
        PsiFile psiFile = event.getFile();
        if (psiFile == null) {
            return;
        }
        VirtualFile file2 = psiFile.getVirtualFile();
        if (file2 == null) {
            return;
        }
        FileEditor[] editors = this.myFileEditorManager.getAllEditors(file2);
        if (editors.length == 0) {
            return;
        }
        VirtualFile currentFile = this.myFileEditorManager.getCurrentFile();
        if (currentFile != null && Comparing.equal((Object)psiFile.getVirtualFile(), (Object)currentFile)) {
            this.myFileEditorManager.updateFilePresentation(currentFile);
        }
    }
}

