/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileEditor.impl;

import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.fileEditor.impl.LoadTextUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.IntArrayList;
import com.intellij.util.text.CharArrayUtil;
import gnu.trove.THashMap;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class FileOffsetsManager {
    private final Map<VirtualFile, LineOffsets> myLineOffsetsMap = new THashMap();

    @NotNull
    public static FileOffsetsManager getInstance() {
        return (FileOffsetsManager)ServiceManager.getService(FileOffsetsManager.class);
    }

    public int getConvertedOffset(@NotNull VirtualFile file2, int originalOffset) {
        LineOffsets offsets = this.getLineOffsets(file2);
        if (offsets.myLineOffsetsAreTheSame) {
            return originalOffset;
        }
        return FileOffsetsManager.getCorrespondingOffset(offsets.myOriginalLineOffsets, offsets.myConvertedLineOffsets, originalOffset);
    }

    public int getOriginalOffset(@NotNull VirtualFile file2, int convertedOffset) {
        LineOffsets offsets = this.getLineOffsets(file2);
        if (offsets.myLineOffsetsAreTheSame) {
            return convertedOffset;
        }
        return FileOffsetsManager.getCorrespondingOffset(offsets.myConvertedLineOffsets, offsets.myOriginalLineOffsets, convertedOffset);
    }

    private static int getCorrespondingOffset(int[] offsets1, int[] offsets2, int offset1) {
        int line = Arrays.binarySearch(offsets1, offset1);
        if (line < 0) {
            line = -line - 2;
        }
        try {
            return offsets2[line] + offset1 - offsets1[line];
        }
        catch (Exception e) {
            return offset1;
        }
    }

    @NotNull
    private synchronized LineOffsets getLineOffsets(@NotNull VirtualFile file2) {
        LineOffsets offsets = this.myLineOffsetsMap.get(file2);
        if (offsets != null && file2.getModificationStamp() == offsets.myFileModificationStamp) {
            return offsets;
        }
        offsets = FileOffsetsManager.loadLineOffsets(file2);
        this.myLineOffsetsMap.put(file2, offsets);
        return offsets;
    }

    @NotNull
    private static LineOffsets loadLineOffsets(@NotNull VirtualFile file2) {
        assert (!file2.getFileType().isBinary());
        try {
            byte[] bytes = file2.contentsToByteArray();
            Charset charset = LoadTextUtil.detectCharsetAndSetBOM(file2, bytes, file2.getFileType());
            byte[] bom = file2.getBOM();
            int bomLength = bom == null ? 0 : bom.length;
            return FileOffsetsManager.loadLineOffsets(bytes, charset, bomLength, file2.getModificationStamp());
        }
        catch (IOException e) {
            return new LineOffsets(file2.getModificationStamp(), new int[]{0}, new int[]{0});
        }
    }

    @NotNull
    private static LineOffsets loadLineOffsets(@NotNull byte[] bytes, @NotNull Charset charset, int startOffset, long modificationStamp) {
        CharBuffer charBuffer;
        ByteBuffer byteBuffer = ByteBuffer.wrap(bytes, startOffset, bytes.length - startOffset);
        try {
            charBuffer = charset.decode(byteBuffer);
        }
        catch (Exception e) {
            charBuffer = CharBuffer.wrap(ArrayUtil.EMPTY_CHAR_ARRAY);
        }
        return FileOffsetsManager.loadLineOffsets(charBuffer, modificationStamp);
    }

    @NotNull
    private static LineOffsets loadLineOffsets(@NotNull CharBuffer buffer, long modificationStamp) {
        int dst = 0;
        int prev2 = 32;
        int crlfCount = 0;
        IntArrayList originalLineOffsets = new IntArrayList();
        IntArrayList convertedLineOffsets = new IntArrayList();
        originalLineOffsets.add(0);
        convertedLineOffsets.add(0);
        int length = buffer.length();
        char[] bufferArray = CharArrayUtil.fromSequenceWithoutCopying((CharSequence)buffer);
        for (int src = 0; src < length; ++src) {
            int c = bufferArray != null ? bufferArray[src] : buffer.charAt(src);
            switch (c) {
                case 13: {
                    if (bufferArray != null) {
                        bufferArray[dst++] = 10;
                    } else {
                        buffer.put(dst++, '\n');
                    }
                    originalLineOffsets.add(dst + crlfCount);
                    convertedLineOffsets.add(dst);
                    break;
                }
                case 10: {
                    if (prev2 == 13) {
                        originalLineOffsets.set(originalLineOffsets.size() - 1, dst + ++crlfCount);
                        break;
                    }
                    if (bufferArray != null) {
                        bufferArray[dst++] = 10;
                    } else {
                        buffer.put(dst++, '\n');
                    }
                    originalLineOffsets.add(dst + crlfCount);
                    convertedLineOffsets.add(dst);
                    break;
                }
                default: {
                    if (bufferArray != null) {
                        bufferArray[dst++] = c;
                        break;
                    }
                    buffer.put(dst++, (char)c);
                }
            }
            prev2 = c;
        }
        return new LineOffsets(modificationStamp, originalLineOffsets.toArray(), convertedLineOffsets.toArray());
    }

    private static class LineOffsets {
        private final long myFileModificationStamp;
        private final int[] myOriginalLineOffsets;
        private final int[] myConvertedLineOffsets;
        private final boolean myLineOffsetsAreTheSame;

        LineOffsets(long modificationStamp, @NotNull int[] originalLineOffsets, @NotNull int[] convertedLineOffsets) {
            assert (convertedLineOffsets.length > 0 && originalLineOffsets.length == convertedLineOffsets.length) : originalLineOffsets.length + " " + convertedLineOffsets.length;
            this.myFileModificationStamp = modificationStamp;
            this.myOriginalLineOffsets = originalLineOffsets;
            this.myConvertedLineOffsets = convertedLineOffsets;
            this.myLineOffsetsAreTheSame = originalLineOffsets[originalLineOffsets.length - 1] == convertedLineOffsets[convertedLineOffsets.length - 1];
        }
    }
}

