/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileEditor.impl;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.fileEditor.FileEditorProvider;
import com.intellij.openapi.fileEditor.FileEditorState;
import com.intellij.openapi.fileEditor.ex.FileEditorProviderManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.impl.LightFilePointer;
import com.intellij.openapi.vfs.pointers.VirtualFilePointer;
import com.intellij.openapi.vfs.pointers.VirtualFilePointerManager;
import com.intellij.util.SmartList;
import gnu.trove.THashMap;
import java.util.List;
import java.util.Map;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class HistoryEntry {
    @NonNls
    static final String TAG = "entry";
    static final String FILE_ATTR = "file";
    @NonNls
    private static final String PROVIDER_ELEMENT = "provider";
    @NonNls
    private static final String EDITOR_TYPE_ID_ATTR = "editor-type-id";
    @NonNls
    private static final String SELECTED_ATTR_VALUE = "selected";
    @NonNls
    private static final String STATE_ELEMENT = "state";
    @NotNull
    private final VirtualFilePointer myFilePointer;
    private static final Element EMPTY_ELEMENT = JDOMUtil.internElement((Element)new Element("state"));
    @Nullable
    private FileEditorProvider mySelectedProvider;
    @NotNull
    private final Map<FileEditorProvider, FileEditorState> myProviderToState = new THashMap();
    @Nullable
    private final Disposable myDisposable;

    private HistoryEntry(@NotNull VirtualFilePointer filePointer, @Nullable FileEditorProvider selectedProvider, @Nullable Disposable disposable) {
        this.myFilePointer = filePointer;
        this.mySelectedProvider = selectedProvider;
        this.myDisposable = disposable;
    }

    @NotNull
    static HistoryEntry createLight(@NotNull VirtualFile file2, @NotNull FileEditorProvider[] providers, @NotNull FileEditorState[] states, @NotNull FileEditorProvider selectedProvider) {
        LightFilePointer pointer = new LightFilePointer(file2);
        HistoryEntry entry = new HistoryEntry(pointer, selectedProvider, null);
        for (int i = 0; i < providers.length; ++i) {
            entry.putState(providers[i], states[i]);
        }
        return entry;
    }

    @NotNull
    static HistoryEntry createLight(@NotNull Project project, @NotNull Element e) throws InvalidDataException {
        EntryData entryData = HistoryEntry.parseEntry(project, e);
        LightFilePointer pointer = new LightFilePointer(entryData.url);
        HistoryEntry entry = new HistoryEntry(pointer, entryData.selectedProvider, null);
        for (Pair state : entryData.providerStates) {
            entry.putState((FileEditorProvider)state.first, (FileEditorState)state.second);
        }
        return entry;
    }

    @NotNull
    static HistoryEntry createHeavy(@NotNull Project project, @NotNull VirtualFile file2, @NotNull FileEditorProvider[] providers, @NotNull FileEditorState[] states, @NotNull FileEditorProvider selectedProvider) {
        if (project.isDisposed()) {
            return HistoryEntry.createLight(file2, providers, states, selectedProvider);
        }
        Disposable disposable = Disposer.newDisposable();
        VirtualFilePointer pointer = VirtualFilePointerManager.getInstance().create(file2, disposable, null);
        HistoryEntry entry = new HistoryEntry(pointer, selectedProvider, disposable);
        for (int i = 0; i < providers.length; ++i) {
            FileEditorProvider provider = providers[i];
            FileEditorState state = states[i];
            if (provider == null || state == null) continue;
            entry.putState(provider, state);
        }
        return entry;
    }

    @NotNull
    static HistoryEntry createHeavy(@NotNull Project project, @NotNull Element e) throws InvalidDataException {
        if (project.isDisposed()) {
            return HistoryEntry.createLight(project, e);
        }
        EntryData entryData = HistoryEntry.parseEntry(project, e);
        Disposable disposable = Disposer.newDisposable();
        VirtualFilePointer pointer = VirtualFilePointerManager.getInstance().create(entryData.url, disposable, null);
        HistoryEntry entry = new HistoryEntry(pointer, entryData.selectedProvider, disposable);
        for (Pair state : entryData.providerStates) {
            entry.putState((FileEditorProvider)state.first, (FileEditorState)state.second);
        }
        return entry;
    }

    @NotNull
    public VirtualFilePointer getFilePointer() {
        return this.myFilePointer;
    }

    @Nullable
    public VirtualFile getFile() {
        return this.myFilePointer.getFile();
    }

    public FileEditorState getState(@NotNull FileEditorProvider provider) {
        return this.myProviderToState.get(provider);
    }

    void putState(@NotNull FileEditorProvider provider, @NotNull FileEditorState state) {
        this.myProviderToState.put(provider, state);
    }

    @Nullable
    FileEditorProvider getSelectedProvider() {
        return this.mySelectedProvider;
    }

    void setSelectedProvider(@Nullable FileEditorProvider value) {
        this.mySelectedProvider = value;
    }

    public void destroy() {
        if (this.myDisposable != null) {
            Disposer.dispose((Disposable)this.myDisposable);
        }
    }

    @NotNull
    public Element writeExternal(@NotNull Element element, @NotNull Project project) {
        Element e = new Element(TAG);
        element.addContent(e);
        e.setAttribute(FILE_ATTR, this.myFilePointer.getUrl());
        this.myProviderToState.forEach((provider, state) -> {
            Element providerElement = new Element(PROVIDER_ELEMENT);
            if (provider.equals(this.mySelectedProvider)) {
                providerElement.setAttribute(SELECTED_ATTR_VALUE, Boolean.TRUE.toString());
            }
            providerElement.setAttribute(EDITOR_TYPE_ID_ATTR, provider.getEditorTypeId());
            Element stateElement = new Element(STATE_ELEMENT);
            provider.writeState(state, project, stateElement);
            if (!JDOMUtil.isEmpty((Element)stateElement)) {
                providerElement.addContent(stateElement);
            }
            e.addContent(providerElement);
        });
        return e;
    }

    @NotNull
    private static EntryData parseEntry(@NotNull Project project, @NotNull Element e) {
        if (!e.getName().equals(TAG)) {
            throw new IllegalArgumentException("unexpected tag: " + e);
        }
        String url = e.getAttributeValue(FILE_ATTR);
        SmartList providerStates = new SmartList();
        FileEditorProvider selectedProvider = null;
        VirtualFile file2 = VirtualFileManager.getInstance().findFileByUrl(url);
        for (Element providerElement : e.getChildren(PROVIDER_ELEMENT)) {
            String typeId = providerElement.getAttributeValue(EDITOR_TYPE_ID_ATTR);
            FileEditorProvider provider = FileEditorProviderManager.getInstance().getProvider(typeId);
            if (provider == null) continue;
            if (Boolean.parseBoolean(providerElement.getAttributeValue(SELECTED_ATTR_VALUE))) {
                selectedProvider = provider;
            }
            if (file2 == null) continue;
            Element stateElement = providerElement.getChild(STATE_ELEMENT);
            FileEditorState state = provider.readState(stateElement == null ? EMPTY_ELEMENT : stateElement, project, file2);
            providerStates.add(Pair.create((Object)provider, (Object)state));
        }
        return new EntryData(url, (List<Pair<FileEditorProvider, FileEditorState>>)providerStates, selectedProvider);
    }

    static class EntryData {
        @NotNull
        private final String url;
        @NotNull
        private final List<Pair<FileEditorProvider, FileEditorState>> providerStates;
        @Nullable
        private final FileEditorProvider selectedProvider;

        EntryData(@NotNull String url, @NotNull List<Pair<FileEditorProvider, FileEditorState>> providerStates, @Nullable FileEditorProvider selectedProvider) {
            this.url = url;
            this.providerStates = providerStates;
            this.selectedProvider = selectedProvider;
        }
    }
}

