/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileEditor.impl;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.BinaryFileDecompiler;
import com.intellij.openapi.fileTypes.BinaryFileTypeDecompilers;
import com.intellij.openapi.fileTypes.CharsetUtil;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.encoding.EncodingManager;
import com.intellij.openapi.vfs.encoding.EncodingRegistry;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.util.ArrayUtil;
import com.intellij.util.NotNullFunction;
import com.intellij.util.ObjectUtils;
import com.intellij.util.text.ByteArrayCharSequence;
import com.intellij.util.text.CharArrayUtil;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class LoadTextUtil {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.fileEditor.impl.LoadTextUtil");
    private static final int UNLIMITED = -1;
    private static final Charset INTERNAL_SEVEN_BIT_UTF8 = new SevenBitCharset(CharsetToolkit.UTF8_CHARSET);
    private static final Charset INTERNAL_SEVEN_BIT_ISO_8859_1 = new SevenBitCharset(CharsetToolkit.ISO_8859_1_CHARSET);
    private static final Charset INTERNAL_SEVEN_BIT_WIN_1251 = new SevenBitCharset(CharsetToolkit.WIN_1251_CHARSET);
    private static final boolean GUESS_UTF = Boolean.parseBoolean(System.getProperty("idea.guess.utf.encoding", "true"));
    private static final Key<AutoDetectionReason> CHARSET_WAS_DETECTED_FROM_BYTES = Key.create((String)"CHARSET_WAS_DETECTED_FROM_BYTES");

    private LoadTextUtil() {
    }

    @NotNull
    private static ConvertResult convertLineSeparatorsToSlashN(@NotNull CharBuffer buffer) {
        int dst = 0;
        int prev2 = 32;
        int crCount = 0;
        int lfCount = 0;
        int crlfCount = 0;
        int length = buffer.length();
        char[] bufferArray = CharArrayUtil.fromSequenceWithoutCopying((CharSequence)buffer);
        for (int src = 0; src < length; ++src) {
            int c = bufferArray != null ? bufferArray[src] : buffer.charAt(src);
            switch (c) {
                case 13: {
                    if (bufferArray != null) {
                        bufferArray[dst++] = 10;
                    } else {
                        buffer.put(dst++, '\n');
                    }
                    ++crCount;
                    break;
                }
                case 10: {
                    if (prev2 == 13) {
                        --crCount;
                        ++crlfCount;
                        break;
                    }
                    if (bufferArray != null) {
                        bufferArray[dst++] = 10;
                    } else {
                        buffer.put(dst++, '\n');
                    }
                    ++lfCount;
                    break;
                }
                default: {
                    if (bufferArray != null) {
                        bufferArray[dst++] = c;
                        break;
                    }
                    buffer.put(dst++, (char)c);
                }
            }
            prev2 = c;
        }
        String detectedLineSeparator = LoadTextUtil.guessLineSeparator(crCount, lfCount, crlfCount);
        CharBuffer result2 = buffer.length() == dst ? buffer : buffer.subSequence(0, dst);
        return new ConvertResult(result2, detectedLineSeparator);
    }

    @NotNull
    private static ConvertResult convertLineSeparatorsToSlashN(@NotNull byte[] charsAsBytes, int startOffset, int endOffset) {
        int index = LoadTextUtil.indexOf(charsAsBytes, (byte)13, startOffset, endOffset);
        if (index == -1) {
            ByteArrayCharSequence sequence = new ByteArrayCharSequence(charsAsBytes, startOffset, endOffset);
            String detectedLineSeparator = LoadTextUtil.indexOf(charsAsBytes, (byte)10, startOffset, endOffset) == -1 ? null : "\n";
            return new ConvertResult((CharSequence)sequence, detectedLineSeparator);
        }
        int dst = 0;
        int prev2 = 32;
        int crCount = 0;
        int lfCount = 0;
        int crlfCount = 0;
        byte[] result2 = new byte[endOffset - startOffset];
        for (int src = startOffset; src < endOffset; ++src) {
            char c = (char)charsAsBytes[src];
            switch (c) {
                case '\r': {
                    result2[dst++] = 10;
                    ++crCount;
                    break;
                }
                case '\n': {
                    if (prev2 == 13) {
                        --crCount;
                        ++crlfCount;
                        break;
                    }
                    result2[dst++] = 10;
                    ++lfCount;
                    break;
                }
                default: {
                    result2[dst++] = (byte)c;
                }
            }
            prev2 = c;
        }
        String detectedLineSeparator = LoadTextUtil.guessLineSeparator(crCount, lfCount, crlfCount);
        ByteArrayCharSequence sequence = new ByteArrayCharSequence(result2, 0, dst);
        return new ConvertResult((CharSequence)sequence, detectedLineSeparator);
    }

    private static int indexOf(byte[] ints, byte value, int start2, int end) {
        for (int i = start2; i < end; ++i) {
            if (ints[i] != value) continue;
            return i;
        }
        return -1;
    }

    @Nullable
    private static String guessLineSeparator(int crCount, int lfCount, int crlfCount) {
        String detectedLineSeparator = null;
        if (crlfCount > crCount && crlfCount > lfCount) {
            detectedLineSeparator = "\r\n";
        } else if (crCount > lfCount) {
            detectedLineSeparator = "\r";
        } else if (lfCount > 0) {
            detectedLineSeparator = "\n";
        }
        return detectedLineSeparator;
    }

    @NotNull
    private static DetectResult detectHardCharset(@NotNull VirtualFile virtualFile, @NotNull byte[] content, int length, @NotNull FileType fileType) {
        Charset hardCodedCharset;
        String charsetName = fileType.getCharset(virtualFile, content);
        DetectResult guessed = LoadTextUtil.guessFromContent(virtualFile, content, length);
        Charset charset = hardCodedCharset = charsetName == null ? guessed.hardCodedCharset : CharsetToolkit.forName((String)charsetName);
        if (hardCodedCharset == null && guessed.guessed == CharsetToolkit.GuessedEncoding.VALID_UTF8) {
            return new DetectResult(CharsetToolkit.UTF8_CHARSET, guessed.guessed, guessed.BOM);
        }
        return new DetectResult(hardCodedCharset, guessed.guessed, guessed.BOM);
    }

    @NotNull
    public static Charset detectCharsetAndSetBOM(@NotNull VirtualFile virtualFile, @NotNull byte[] content, @NotNull FileType fileType) {
        Charset internalCharset = LoadTextUtil.detectInternalCharsetAndSetBOM((VirtualFile)virtualFile, (byte[])content, (int)content.length, (boolean)true, (FileType)fileType).hardCodedCharset;
        return internalCharset instanceof SevenBitCharset ? ((SevenBitCharset)internalCharset).myBaseCharset : internalCharset;
    }

    @NotNull
    private static Charset getDefaultCharsetFromEncodingManager(@NotNull VirtualFile virtualFile) {
        Charset specifiedExplicitly = EncodingRegistry.getInstance().getEncoding(virtualFile, true);
        return (Charset)ObjectUtils.notNull((Object)specifiedExplicitly, (Object)EncodingRegistry.getInstance().getDefaultCharset());
    }

    @NotNull
    private static DetectResult detectInternalCharsetAndSetBOM(@NotNull VirtualFile file2, @NotNull byte[] content, int length, boolean saveBOM, @NotNull FileType fileType) {
        DetectResult info = LoadTextUtil.detectHardCharset(file2, content, length, fileType);
        Charset charset = info.hardCodedCharset == null ? (file2.isCharsetSet() ? file2.getCharset() : LoadTextUtil.getDefaultCharsetFromEncodingManager(file2)) : info.hardCodedCharset;
        byte[] bom = info.BOM;
        if (saveBOM && bom != null && bom.length != 0) {
            file2.setBOM(bom);
            LoadTextUtil.setCharsetAutoDetectionReason(file2, AutoDetectionReason.FROM_BOM);
        }
        file2.setCharset(charset);
        Charset result2 = charset;
        if (info.guessed == CharsetToolkit.GuessedEncoding.SEVEN_BIT) {
            if (charset == CharsetToolkit.UTF8_CHARSET) {
                result2 = INTERNAL_SEVEN_BIT_UTF8;
            } else if (charset == CharsetToolkit.ISO_8859_1_CHARSET) {
                result2 = INTERNAL_SEVEN_BIT_ISO_8859_1;
            } else if (charset == CharsetToolkit.WIN_1251_CHARSET) {
                result2 = INTERNAL_SEVEN_BIT_WIN_1251;
            }
        }
        return new DetectResult(result2, info.guessed, bom);
    }

    @NotNull
    public static DetectResult guessFromContent(@NotNull VirtualFile virtualFile, @NotNull byte[] content) {
        return LoadTextUtil.guessFromContent(virtualFile, content, content.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    private static DetectResult guessFromContent(@NotNull VirtualFile virtualFile, @NotNull byte[] content, int length) {
        DetectResult detectResult;
        AutoDetectionReason detectedFromBytes = null;
        try {
            DetectResult info;
            if (GUESS_UTF) {
                info = LoadTextUtil.guessFromBytes(content, 0, length, LoadTextUtil.getDefaultCharsetFromEncodingManager(virtualFile));
                if (info.BOM != null) {
                    detectedFromBytes = AutoDetectionReason.FROM_BOM;
                } else if (info.guessed == CharsetToolkit.GuessedEncoding.VALID_UTF8) {
                    detectedFromBytes = AutoDetectionReason.FROM_BYTES;
                }
            } else {
                info = new DetectResult(null, null, null);
            }
            detectResult = info;
        }
        catch (Throwable throwable) {
            LoadTextUtil.setCharsetAutoDetectionReason(virtualFile, detectedFromBytes);
            throw throwable;
        }
        LoadTextUtil.setCharsetAutoDetectionReason(virtualFile, detectedFromBytes);
        return detectResult;
    }

    @NotNull
    private static DetectResult guessFromBytes(@NotNull byte[] content, int startOffset, int endOffset, @NotNull Charset defaultCharset) {
        CharsetToolkit toolkit = new CharsetToolkit(content, defaultCharset);
        toolkit.setEnforce8Bit(true);
        Charset charset = toolkit.guessFromBOM();
        if (charset != null) {
            byte[] bom = (byte[])ObjectUtils.notNull((Object)CharsetToolkit.getMandatoryBom((Charset)charset), (Object)CharsetToolkit.UTF8_BOM);
            return new DetectResult(charset, null, bom);
        }
        CharsetToolkit.GuessedEncoding guessed = toolkit.guessFromContent(startOffset, endOffset);
        if (guessed == CharsetToolkit.GuessedEncoding.VALID_UTF8) {
            return new DetectResult(CharsetToolkit.UTF8_CHARSET, CharsetToolkit.GuessedEncoding.VALID_UTF8, null);
        }
        return new DetectResult(null, guessed, null);
    }

    public static String getTextFromBytesOrNull(@NotNull byte[] bytes, int startOffset, int endOffset) {
        Charset charset;
        Charset defaultCharset = EncodingManager.getInstance().getDefaultCharset();
        DetectResult info = LoadTextUtil.guessFromBytes(bytes, startOffset, endOffset, defaultCharset);
        if (info.hardCodedCharset != null) {
            charset = info.hardCodedCharset;
        } else {
            switch (info.guessed) {
                case SEVEN_BIT: {
                    charset = CharsetToolkit.US_ASCII_CHARSET;
                    break;
                }
                case VALID_UTF8: {
                    charset = CharsetToolkit.UTF8_CHARSET;
                    break;
                }
                case INVALID_UTF8: 
                case BINARY: {
                    return null;
                }
                default: {
                    throw new IllegalStateException(String.valueOf(info.guessed));
                }
            }
        }
        byte[] bom = info.BOM;
        ConvertResult result2 = LoadTextUtil.convertBytes(bytes, Math.min(startOffset + (bom == null ? 0 : bom.length), endOffset), endOffset, charset);
        return result2.text.toString();
    }

    @NotNull
    private static Pair.NonNull<Charset, byte[]> getOverriddenCharsetByBOM(@NotNull byte[] content, @NotNull Charset charset) {
        if (charset.name().contains("UTF-8") && CharsetToolkit.hasUTF8Bom((byte[])content)) {
            return Pair.createNonNull((Object)charset, (Object)CharsetToolkit.UTF8_BOM);
        }
        Charset charsetFromBOM = CharsetToolkit.guessFromBOM((byte[])content);
        if (charsetFromBOM != null) {
            byte[] bom = (byte[])ObjectUtils.notNull((Object)CharsetToolkit.getMandatoryBom((Charset)charsetFromBOM), (Object)ArrayUtil.EMPTY_BYTE_ARRAY);
            return Pair.createNonNull((Object)charsetFromBOM, (Object)bom);
        }
        return Pair.createNonNull((Object)charset, (Object)ArrayUtil.EMPTY_BYTE_ARRAY);
    }

    public static void changeLineSeparators(@Nullable Project project, @NotNull VirtualFile file2, @NotNull String newSeparator, @NotNull Object requestor) throws IOException {
        CharSequence currentText = LoadTextUtil.getTextByBinaryPresentation(file2.contentsToByteArray(), file2, true, false);
        String currentSeparator = LoadTextUtil.detectLineSeparator(file2, false);
        if (newSeparator.equals(currentSeparator)) {
            return;
        }
        String newText = StringUtil.convertLineSeparators((String)currentText.toString(), (String)newSeparator);
        file2.setDetectedLineSeparator(newSeparator);
        LoadTextUtil.write(project, file2, requestor, newText, -1L);
    }

    public static void write(@Nullable Project project, @NotNull VirtualFile virtualFile, @NotNull Object requestor, @NotNull String text, long newModificationStamp) throws IOException {
        Charset existing = virtualFile.getCharset();
        Pair.NonNull<Charset, byte[]> chosen = LoadTextUtil.charsetForWriting(project, virtualFile, text, existing);
        Charset charset = (Charset)chosen.first;
        byte[] buffer = (byte[])chosen.second;
        if (!charset.equals(existing)) {
            virtualFile.setCharset(charset);
        }
        LoadTextUtil.setDetectedFromBytesFlagBack(virtualFile, buffer);
        virtualFile.setBinaryContent(buffer, newModificationStamp, -1L, requestor);
    }

    @NotNull
    public static Pair.NonNull<Charset, byte[]> charsetForWriting(@Nullable Project project, @NotNull VirtualFile virtualFile, @NotNull String text, @NotNull Charset existing) {
        Charset fromBom;
        Charset specified = LoadTextUtil.extractCharsetFromFileContent(project, virtualFile, text);
        Pair.NonNull chosen = LoadTextUtil.chooseMostlyHarmlessCharset(existing, specified, text);
        Charset charset = (Charset)chosen.first;
        byte[] bom = virtualFile.getBOM();
        Charset charset2 = fromBom = bom == null ? null : CharsetToolkit.guessFromBOM((byte[])bom);
        if (fromBom != null && !fromBom.equals(charset)) {
            chosen = Pair.createNonNull((Object)fromBom, (Object)text.getBytes(fromBom));
        }
        return chosen;
    }

    private static void setDetectedFromBytesFlagBack(@NotNull VirtualFile virtualFile, @NotNull byte[] content) {
        if (virtualFile.getBOM() == null) {
            LoadTextUtil.guessFromContent(virtualFile, content);
        } else {
            LoadTextUtil.setCharsetAutoDetectionReason(virtualFile, AutoDetectionReason.FROM_BOM);
        }
    }

    @NotNull
    public static Pair.NonNull<Charset, byte[]> chooseMostlyHarmlessCharset(@NotNull Charset existing, @NotNull Charset specified, @NotNull String text) {
        try {
            if (specified.equals(existing)) {
                return Pair.createNonNull((Object)specified, (Object)text.getBytes(existing));
            }
            byte[] out = LoadTextUtil.isSupported(specified, text);
            if (out != null) {
                return Pair.createNonNull((Object)specified, (Object)out);
            }
            out = LoadTextUtil.isSupported(existing, text);
            if (out != null) {
                return Pair.createNonNull((Object)existing, (Object)out);
            }
            return Pair.createNonNull((Object)specified, (Object)text.getBytes(specified));
        }
        catch (RuntimeException e) {
            Charset defaultCharset = Charset.defaultCharset();
            return Pair.createNonNull((Object)defaultCharset, (Object)text.getBytes(defaultCharset));
        }
    }

    @Nullable(value="null means not supported, otherwise it is converted byte stream")
    private static byte[] isSupported(@NotNull Charset charset, @NotNull String str) {
        try {
            if (!charset.canEncode()) {
                return null;
            }
            byte[] bytes = str.getBytes(charset);
            if (!str.equals(new String(bytes, charset))) {
                return null;
            }
            return bytes;
        }
        catch (Exception e) {
            return null;
        }
    }

    @NotNull
    public static Charset extractCharsetFromFileContent(@Nullable Project project, @NotNull VirtualFile virtualFile, @NotNull CharSequence text) {
        return (Charset)ObjectUtils.notNull((Object)LoadTextUtil.charsetFromContentOrNull(project, virtualFile, text), (Object)virtualFile.getCharset());
    }

    @Nullable(value="returns null if cannot determine from content")
    public static Charset charsetFromContentOrNull(@Nullable Project project, @NotNull VirtualFile virtualFile, @NotNull CharSequence text) {
        return CharsetUtil.extractCharsetFromFileContent((Project)project, (VirtualFile)virtualFile, (FileType)virtualFile.getFileType(), (CharSequence)text);
    }

    @NotNull
    public static CharSequence loadText(@NotNull VirtualFile file2) {
        FileType type = file2.getFileType();
        if (type.isBinary()) {
            BinaryFileDecompiler decompiler = (BinaryFileDecompiler)BinaryFileTypeDecompilers.INSTANCE.forFileType(type);
            if (decompiler != null) {
                CharSequence text = decompiler.decompile(file2);
                try {
                    StringUtil.assertValidSeparators((CharSequence)text);
                }
                catch (AssertionError e) {
                    LOG.error((Throwable)((Object)e));
                }
                return text;
            }
            throw new IllegalArgumentException("Attempt to load text for binary file which doesn't have a decompiler plugged in: " + file2.getPresentableUrl() + ". File type: " + type.getName());
        }
        return LoadTextUtil.loadText(file2, -1);
    }

    @NotNull
    public static CharSequence loadText(@NotNull VirtualFile file2, int limit) {
        FileType type = file2.getFileType();
        if (type.isBinary()) {
            throw new IllegalArgumentException("Attempt to load truncated text for binary file: " + file2.getPresentableUrl() + ". File type: " + type.getName());
        }
        if (file2 instanceof LightVirtualFile) {
            return LoadTextUtil.limitCharSequence(((LightVirtualFile)file2).getContent(), limit);
        }
        if (file2.isDirectory()) {
            throw new AssertionError((Object)("'" + file2.getPresentableUrl() + "' is a directory"));
        }
        try {
            byte[] bytes = limit == -1 ? file2.contentsToByteArray() : FileUtil.loadFirstAndClose((InputStream)file2.getInputStream(), (int)limit);
            return LoadTextUtil.getTextByBinaryPresentation(bytes, file2);
        }
        catch (IOException e) {
            return ArrayUtil.EMPTY_CHAR_SEQUENCE;
        }
    }

    @NotNull
    private static CharSequence limitCharSequence(@NotNull CharSequence sequence, int limit) {
        return limit == -1 ? sequence : sequence.subSequence(0, Math.min(limit, sequence.length()));
    }

    @NotNull
    public static CharSequence getTextByBinaryPresentation(@NotNull byte[] bytes, @NotNull VirtualFile virtualFile) {
        return LoadTextUtil.getTextByBinaryPresentation(bytes, virtualFile, true, true);
    }

    @NotNull
    public static CharSequence getTextByBinaryPresentation(@NotNull byte[] bytes, @NotNull VirtualFile virtualFile, boolean saveDetectedSeparators, boolean saveBOM) {
        DetectResult info = LoadTextUtil.detectInternalCharsetAndSetBOM(virtualFile, bytes, bytes.length, saveBOM, virtualFile.getFileType());
        byte[] bom = info.BOM;
        ConvertResult result2 = LoadTextUtil.convertBytes(bytes, Math.min(bom == null ? 0 : bom.length, bytes.length), bytes.length, info.hardCodedCharset);
        if (saveDetectedSeparators) {
            virtualFile.setDetectedLineSeparator(result2.lineSeparator);
        }
        return result2.text;
    }

    @NotNull
    public static FileType processTextFromBinaryPresentationOrNull(@NotNull byte[] bytes, int length, @NotNull VirtualFile virtualFile, boolean saveDetectedSeparators, boolean saveBOM, @NotNull FileType fileType, @NotNull NotNullFunction<? super CharSequence, ? extends FileType> fileTextProcessor) {
        CharSequence toProcess;
        DetectResult info = LoadTextUtil.detectInternalCharsetAndSetBOM(virtualFile, bytes, length, saveBOM, fileType);
        Charset internalCharset = info.hardCodedCharset;
        CharsetToolkit.GuessedEncoding guessed = info.guessed;
        if (internalCharset == null || guessed == CharsetToolkit.GuessedEncoding.BINARY || guessed == CharsetToolkit.GuessedEncoding.INVALID_UTF8) {
            toProcess = null;
        } else {
            byte[] bom = info.BOM;
            int BOMEndOffset = Math.min(length, bom == null ? 0 : bom.length);
            ConvertResult result2 = LoadTextUtil.convertBytes(bytes, BOMEndOffset, length, internalCharset);
            if (saveDetectedSeparators) {
                virtualFile.setDetectedLineSeparator(result2.lineSeparator);
            }
            toProcess = result2.text;
        }
        return (FileType)fileTextProcessor.fun(toProcess);
    }

    @Nullable
    public static String detectLineSeparator(@NotNull VirtualFile file2, boolean checkFile) {
        String lineSeparator = LoadTextUtil.getDetectedLineSeparator(file2);
        if (lineSeparator == null && checkFile) {
            try {
                LoadTextUtil.getTextByBinaryPresentation(file2.contentsToByteArray(), file2);
                lineSeparator = LoadTextUtil.getDetectedLineSeparator(file2);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return lineSeparator;
    }

    static String getDetectedLineSeparator(@NotNull VirtualFile file2) {
        return file2.getDetectedLineSeparator();
    }

    @NotNull
    public static CharSequence getTextByBinaryPresentation(@NotNull byte[] bytes, @NotNull Charset charset) {
        Pair.NonNull<Charset, byte[]> pair = LoadTextUtil.getOverriddenCharsetByBOM(bytes, charset);
        byte[] bom = (byte[])pair.getSecond();
        ConvertResult result2 = LoadTextUtil.convertBytes(bytes, Math.min(bom.length, bytes.length), bytes.length, (Charset)pair.first);
        return result2.text;
    }

    @NotNull
    private static ConvertResult convertBytes(@NotNull byte[] bytes, int startOffset, int endOffset, @NotNull Charset internalCharset) {
        CharBuffer charBuffer;
        assert (startOffset >= 0 && startOffset <= endOffset && endOffset <= bytes.length) : startOffset + "," + endOffset + ": " + bytes.length;
        if (internalCharset instanceof SevenBitCharset || internalCharset == CharsetToolkit.US_ASCII_CHARSET) {
            return LoadTextUtil.convertLineSeparatorsToSlashN(bytes, startOffset, endOffset);
        }
        ByteBuffer byteBuffer = ByteBuffer.wrap(bytes, startOffset, endOffset - startOffset);
        try {
            charBuffer = internalCharset.decode(byteBuffer);
        }
        catch (Exception e) {
            charBuffer = CharBuffer.wrap(ArrayUtil.EMPTY_CHAR_ARRAY);
        }
        return LoadTextUtil.convertLineSeparatorsToSlashN(charBuffer);
    }

    @Nullable(value="null if was not detected, otherwise the reason it was")
    public static AutoDetectionReason getCharsetAutoDetectionReason(@NotNull VirtualFile virtualFile) {
        return (AutoDetectionReason)((Object)virtualFile.getUserData(CHARSET_WAS_DETECTED_FROM_BYTES));
    }

    private static void setCharsetAutoDetectionReason(@NotNull VirtualFile virtualFile, @Nullable(value="null if was not detected, otherwise the reason it was") AutoDetectionReason reason) {
        virtualFile.putUserData(CHARSET_WAS_DETECTED_FROM_BYTES, (Object)reason);
    }

    public static void clearCharsetAutoDetectionReason(@NotNull VirtualFile virtualFile) {
        virtualFile.putUserData(CHARSET_WAS_DETECTED_FROM_BYTES, null);
    }

    private static class ConvertResult {
        @NotNull
        private final CharSequence text;
        @Nullable
        private final String lineSeparator;

        ConvertResult(@NotNull CharSequence text, @Nullable String lineSeparator) {
            this.text = text;
            this.lineSeparator = lineSeparator;
        }
    }

    public static class DetectResult {
        public final Charset hardCodedCharset;
        public final CharsetToolkit.GuessedEncoding guessed;
        @Nullable
        public final byte[] BOM;

        DetectResult(Charset hardCodedCharset, CharsetToolkit.GuessedEncoding guessed, @Nullable byte[] BOM) {
            this.hardCodedCharset = hardCodedCharset;
            this.guessed = guessed;
            this.BOM = BOM;
        }
    }

    private static class SevenBitCharset
    extends Charset {
        private final Charset myBaseCharset;

        SevenBitCharset(Charset baseCharset) {
            super("IJ__7BIT_" + baseCharset.name(), ArrayUtil.EMPTY_STRING_ARRAY);
            this.myBaseCharset = baseCharset;
        }

        @Override
        public boolean contains(Charset cs) {
            throw new IllegalStateException();
        }

        @Override
        public CharsetDecoder newDecoder() {
            throw new IllegalStateException();
        }

        @Override
        public CharsetEncoder newEncoder() {
            throw new IllegalStateException();
        }
    }

    public static enum AutoDetectionReason {
        FROM_BOM,
        FROM_BYTES;

    }
}

