/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileEditor.impl;

import com.intellij.ide.PowerSaveMode;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.fileEditor.impl.FileEditorManagerImpl;
import com.intellij.openapi.fileEditor.impl.FileEditorPsiTreeChangeListener;
import com.intellij.openapi.fileEditor.impl.text.TextEditorPsiDataProvider;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.problems.ProblemListener;
import com.intellij.problems.WolfTheProblemSolver;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiTreeChangeListener;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.ui.docking.DockManager;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.ui.UIUtil;
import org.jetbrains.annotations.NotNull;

public class PsiAwareFileEditorManagerImpl
extends FileEditorManagerImpl {
    private final PsiManager myPsiManager;
    private final WolfTheProblemSolver myProblemSolver;
    private final FileEditorPsiTreeChangeListener myPsiTreeChangeListener;

    public PsiAwareFileEditorManagerImpl(Project project, PsiManager psiManager, WolfTheProblemSolver problemSolver, DockManager dockManager) {
        super(project, dockManager);
        this.myPsiManager = psiManager;
        this.myProblemSolver = problemSolver;
        this.myPsiTreeChangeListener = new FileEditorPsiTreeChangeListener(this);
        this.registerExtraEditorDataProvider(new TextEditorPsiDataProvider(), null);
        MessageBusConnection connection = project.getMessageBus().connect();
        connection.subscribe(PowerSaveMode.TOPIC, (Object)new PowerSaveMode.Listener(){

            public void powerSaveStateChanged() {
                UIUtil.invokeLaterIfNeeded(() -> {
                    for (Editor editor : EditorFactory.getInstance().getAllEditors()) {
                        ((EditorEx)editor).reinitSettings();
                    }
                });
            }
        });
        connection.subscribe(ProblemListener.TOPIC, (Object)new MyProblemListener());
    }

    @Override
    protected void projectOpened(@NotNull MessageBusConnection connection) {
        super.projectOpened(connection);
        this.myPsiManager.addPsiTreeChangeListener((PsiTreeChangeListener)this.myPsiTreeChangeListener);
    }

    @Override
    public boolean isProblem(@NotNull VirtualFile file2) {
        return this.myProblemSolver.isProblemFile(file2);
    }

    @Override
    @NotNull
    public String getFileTooltipText(@NotNull VirtualFile file2) {
        StringBuilder tooltipText = new StringBuilder();
        Module module = ModuleUtilCore.findModuleForFile((VirtualFile)file2, (Project)this.getProject());
        if (module != null) {
            tooltipText.append("[");
            tooltipText.append(module.getName());
            tooltipText.append("] ");
        }
        tooltipText.append(super.getFileTooltipText(file2));
        return tooltipText.toString();
    }

    @Override
    protected Editor getOpenedEditor(@NotNull Editor editor, boolean focusEditor) {
        PsiDocumentManager documentManager = PsiDocumentManager.getInstance((Project)this.getProject());
        Document document = editor.getDocument();
        PsiFile psiFile = documentManager.getPsiFile(document);
        if (!focusEditor || documentManager.isUncommited(document)) {
            return editor;
        }
        return InjectedLanguageUtil.getEditorForInjectedLanguageNoCommit(editor, psiFile);
    }

    private class MyProblemListener
    implements ProblemListener {
        private MyProblemListener() {
        }

        public void problemsAppeared(@NotNull VirtualFile file2) {
            this.updateFile(file2);
        }

        public void problemsDisappeared(@NotNull VirtualFile file2) {
            this.updateFile(file2);
        }

        public void problemsChanged(@NotNull VirtualFile file2) {
            this.updateFile(file2);
        }

        private void updateFile(@NotNull VirtualFile file2) {
            PsiAwareFileEditorManagerImpl.this.queueUpdateFile(file2);
        }
    }
}

