/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileEditor.impl;

import com.intellij.ide.highlighter.HighlighterFactory;
import com.intellij.lang.Language;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.FileEditorManagerEvent;
import com.intellij.openapi.fileEditor.FileEditorManagerListener;
import com.intellij.openapi.fileEditor.FileEditorPolicy;
import com.intellij.openapi.fileEditor.FileEditorProvider;
import com.intellij.openapi.fileEditor.FileEditorState;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.fileEditor.ex.FileEditorManagerEx;
import com.intellij.openapi.fileEditor.ex.FileEditorWithProvider;
import com.intellij.openapi.fileEditor.impl.EditorComposite;
import com.intellij.openapi.fileEditor.impl.EditorWindow;
import com.intellij.openapi.fileEditor.impl.EditorsSplitters;
import com.intellij.openapi.fileEditor.impl.TestEditorSplitter;
import com.intellij.openapi.fileEditor.impl.text.TextEditorImpl;
import com.intellij.openapi.fileEditor.impl.text.TextEditorProvider;
import com.intellij.openapi.fileEditor.impl.text.TextEditorPsiDataProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.ProjectManagerListener;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.events.VFileDeleteEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.messages.MessageBusConnection;
import java.awt.Component;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JLabel;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;

final class TestEditorManagerImpl
extends FileEditorManagerEx
implements Disposable {
    private static final Logger LOG = Logger.getInstance(TestEditorManagerImpl.class);
    private final TestEditorSplitter myTestEditorSplitter = new TestEditorSplitter();
    private final Project myProject;
    private int counter = 0;
    private final Map<VirtualFile, Editor> myVirtualFile2Editor = new HashMap<VirtualFile, Editor>();
    private VirtualFile myActiveFile;
    private static final LightVirtualFile LIGHT_VIRTUAL_FILE = new LightVirtualFile("Dummy.java");

    TestEditorManagerImpl(@NotNull Project project) {
        this.myProject = project;
        this.registerExtraEditorDataProvider(new TextEditorPsiDataProvider(), null);
        MessageBusConnection busConnection = project.getMessageBus().connect((Disposable)this);
        busConnection.subscribe(ProjectManager.TOPIC, (Object)new ProjectManagerListener(){

            public void projectClosed(@NotNull Project project) {
                if (project == TestEditorManagerImpl.this.myProject) {
                    TestEditorManagerImpl.this.closeAllFiles();
                }
            }
        });
        busConnection.subscribe(VirtualFileManager.VFS_CHANGES, (Object)new BulkFileListener(){

            public void before(@NotNull List<? extends VFileEvent> events) {
                for (VFileEvent vFileEvent : events) {
                    if (!(vFileEvent instanceof VFileDeleteEvent)) continue;
                    for (VirtualFile file2 : TestEditorManagerImpl.this.getOpenFiles()) {
                        if (!VfsUtilCore.isAncestor((VirtualFile)((VFileDeleteEvent)vFileEvent).getFile(), (VirtualFile)file2, (boolean)false)) continue;
                        TestEditorManagerImpl.this.closeFile(file2);
                    }
                }
            }
        });
    }

    @Override
    @NotNull
    public Pair<FileEditor[], FileEditorProvider[]> openFileWithProviders(@NotNull VirtualFile file2, boolean focusEditor, boolean searchForSplitter) {
        Ref result2 = new Ref();
        CommandProcessor.getInstance().executeCommand(this.myProject, () -> result2.set(this.openFileImpl3(new OpenFileDescriptor(this.myProject, file2), focusEditor)), "", null);
        return (Pair)result2.get();
    }

    private Pair<FileEditor[], FileEditorProvider[]> openFileImpl3(OpenFileDescriptor openFileDescriptor, boolean focusEditor) {
        Pair result2;
        VirtualFile file2 = openFileDescriptor.getFile();
        boolean isNewEditor = !this.myVirtualFile2Editor.containsKey(file2);
        FileEditorProvider provider = (FileEditorProvider)file2.getUserData(FileEditorProvider.KEY);
        if (provider != null && provider.accept(this.getProject(), file2)) {
            result2 = Pair.create((Object)new FileEditor[]{provider.createEditor(this.getProject(), file2)}, (Object)new FileEditorProvider[]{provider});
        } else {
            Editor editor = this.doOpenTextEditor(openFileDescriptor);
            TextEditor fileEditor = TextEditorProvider.getInstance().getTextEditor(editor);
            FileEditorProvider fileEditorProvider = TestEditorManagerImpl.getProvider();
            result2 = Pair.create((Object)new FileEditor[]{fileEditor}, (Object)new FileEditorProvider[]{fileEditorProvider});
        }
        this.modifyTabWell(() -> {
            this.myTestEditorSplitter.openAndFocusTab(file2, ((FileEditor[])result2.first)[0], ((FileEditorProvider[])result2.second)[0]);
            if (isNewEditor) {
                this.eventPublisher().fileOpened((FileEditorManager)this, file2);
            }
        });
        return result2;
    }

    private void modifyTabWell(Runnable tabWellModification) {
        if (this.myProject.isDisposed()) {
            return;
        }
        FileEditor lastFocusedEditor = this.myTestEditorSplitter.getFocusedFileEditor();
        VirtualFile lastFocusedFile = this.myTestEditorSplitter.getFocusedFile();
        FileEditorProvider oldProvider = this.myTestEditorSplitter.getProviderFromFocused();
        tabWellModification.run();
        FileEditor currentlyFocusedEditor = this.myTestEditorSplitter.getFocusedFileEditor();
        VirtualFile currentlyFocusedFile = this.myTestEditorSplitter.getFocusedFile();
        FileEditorProvider newProvider = this.myTestEditorSplitter.getProviderFromFocused();
        FileEditorManagerEvent event = new FileEditorManagerEvent((FileEditorManager)this, lastFocusedFile, lastFocusedEditor, oldProvider, currentlyFocusedFile, currentlyFocusedEditor, newProvider);
        this.eventPublisher().selectionChanged(event);
    }

    @NotNull
    private FileEditorManagerListener eventPublisher() {
        return (FileEditorManagerListener)this.getProject().getMessageBus().syncPublisher(FileEditorManagerListener.FILE_EDITOR_MANAGER);
    }

    @Override
    @NotNull
    public Pair<FileEditor[], FileEditorProvider[]> openFileWithProviders(@NotNull VirtualFile file2, boolean focusEditor, @NotNull EditorWindow window) {
        return this.openFileWithProviders(file2, focusEditor, false);
    }

    @Override
    public boolean isInsideChange() {
        return false;
    }

    @Override
    @NotNull
    public ActionCallback notifyPublisher(@NotNull Runnable runnable2) {
        runnable2.run();
        return ActionCallback.DONE;
    }

    @Override
    public EditorsSplitters getSplittersFor(Component c) {
        return null;
    }

    @Override
    public void createSplitter(int orientation, EditorWindow window) {
        String containerName = this.createNewTabbedContainerName();
        this.myTestEditorSplitter.setActiveTabGroup(containerName);
    }

    private String createNewTabbedContainerName() {
        ++this.counter;
        return "SplitTabContainer" + ((Object)this.counter).toString();
    }

    @Override
    public void changeSplitterOrientation() {
    }

    @Override
    public void flipTabs() {
    }

    @Override
    public boolean tabsMode() {
        return false;
    }

    @Override
    public boolean isInSplitter() {
        return false;
    }

    @Override
    public boolean hasOpenedFile() {
        return false;
    }

    @Override
    public VirtualFile getCurrentFile() {
        return this.myActiveFile;
    }

    @Override
    public FileEditorWithProvider getSelectedEditorWithProvider(@NotNull VirtualFile file2) {
        return null;
    }

    @Override
    public boolean isChanged(@NotNull EditorComposite editor) {
        return false;
    }

    @Override
    public EditorWindow getNextWindow(@NotNull EditorWindow window) {
        return null;
    }

    @Override
    public EditorWindow getPrevWindow(@NotNull EditorWindow window) {
        return null;
    }

    public void addTopComponent(@NotNull FileEditor editor, @NotNull JComponent component) {
    }

    public void removeTopComponent(@NotNull FileEditor editor, @NotNull JComponent component) {
    }

    public void addBottomComponent(@NotNull FileEditor editor, @NotNull JComponent component) {
    }

    public void removeBottomComponent(@NotNull FileEditor editor, @NotNull JComponent component) {
    }

    @Override
    public void closeAllFiles() {
        for (VirtualFile file2 : this.getOpenFiles()) {
            this.closeFile(file2);
        }
    }

    private static FileEditorProvider getProvider() {
        return new FileEditorProvider(){

            public boolean accept(@NotNull Project project, @NotNull VirtualFile file2) {
                return false;
            }

            @NotNull
            public FileEditor createEditor(@NotNull Project project, @NotNull VirtualFile file2) {
                throw new IncorrectOperationException();
            }

            public void disposeEditor(@NotNull FileEditor editor) {
            }

            @NotNull
            public FileEditorState readState(@NotNull Element sourceElement, @NotNull Project project, @NotNull VirtualFile file2) {
                throw new IncorrectOperationException();
            }

            @NotNull
            public String getEditorTypeId() {
                return "";
            }

            @NotNull
            public FileEditorPolicy getPolicy() {
                throw new IncorrectOperationException();
            }
        };
    }

    @Override
    public EditorWindow getCurrentWindow() {
        return null;
    }

    @Override
    @NotNull
    public Promise<EditorWindow> getActiveWindow() {
        return Promises.resolvedPromise();
    }

    @Override
    public void setCurrentWindow(EditorWindow window) {
    }

    @Override
    public VirtualFile getFile(@NotNull FileEditor editor) {
        return LIGHT_VIRTUAL_FILE;
    }

    @Override
    public void updateFilePresentation(@NotNull VirtualFile file2) {
    }

    @Override
    public void unsplitWindow() {
    }

    @Override
    public void unsplitAllWindow() {
    }

    @Override
    @NotNull
    public EditorWindow[] getWindows() {
        return new EditorWindow[0];
    }

    public FileEditor getSelectedEditor(@NotNull VirtualFile file2) {
        Editor editor = this.getEditor(file2);
        if (editor != null) {
            return TextEditorProvider.getInstance().getTextEditor(editor);
        }
        Pair<FileEditor, FileEditorProvider> editorAndProvider = this.myTestEditorSplitter.getEditorAndProvider(file2);
        if (editorAndProvider != null) {
            return (FileEditor)editorAndProvider.first;
        }
        return null;
    }

    public boolean isFileOpen(@NotNull VirtualFile file2) {
        return this.getEditor(file2) != null;
    }

    @NotNull
    public FileEditor[] getEditors(@NotNull VirtualFile file2) {
        FileEditor e = this.getSelectedEditor(file2);
        if (e == null) {
            return new FileEditor[0];
        }
        return new FileEditor[]{e};
    }

    @NotNull
    public FileEditor[] getAllEditors(@NotNull VirtualFile file2) {
        return this.getEditors(file2);
    }

    @Override
    @NotNull
    public VirtualFile[] getSiblings(@NotNull VirtualFile file2) {
        throw new UnsupportedOperationException();
    }

    public void dispose() {
        this.closeAllFiles();
    }

    public void closeFile(@NotNull VirtualFile file2) {
        Editor editor = this.myVirtualFile2Editor.remove(file2);
        if (editor != null) {
            TextEditorProvider editorProvider = TextEditorProvider.getInstance();
            editorProvider.disposeEditor((FileEditor)editorProvider.getTextEditor(editor));
            EditorFactory.getInstance().releaseEditor(editor);
            this.eventPublisher().fileClosed((FileEditorManager)this, file2);
        }
        if (Comparing.equal((Object)file2, (Object)this.myActiveFile)) {
            this.myActiveFile = null;
        }
        this.modifyTabWell(() -> this.myTestEditorSplitter.closeFile(file2));
    }

    @Override
    public void closeFile(@NotNull VirtualFile file2, @NotNull EditorWindow window) {
        this.closeFile(file2);
    }

    @NotNull
    public VirtualFile[] getSelectedFiles() {
        VirtualFile[] virtualFileArray;
        if (this.myActiveFile == null) {
            virtualFileArray = VirtualFile.EMPTY_ARRAY;
        } else {
            VirtualFile[] virtualFileArray2 = new VirtualFile[1];
            virtualFileArray = virtualFileArray2;
            virtualFileArray2[0] = this.myActiveFile;
        }
        return virtualFileArray;
    }

    @NotNull
    public FileEditor[] getSelectedEditors() {
        return this.myActiveFile == null ? new FileEditor[]{} : this.getEditors(this.myActiveFile);
    }

    public Editor getSelectedTextEditor() {
        return this.myActiveFile != null ? this.getEditor(this.myActiveFile) : null;
    }

    @Override
    public JComponent getComponent() {
        return new JLabel();
    }

    @NotNull
    public VirtualFile[] getOpenFiles() {
        return VfsUtilCore.toVirtualFileArray(this.myVirtualFile2Editor.keySet());
    }

    public Editor getEditor(VirtualFile file2) {
        return this.myVirtualFile2Editor.get(file2);
    }

    @NotNull
    public FileEditor[] getAllEditors() {
        FileEditor[] result2 = new FileEditor[this.myVirtualFile2Editor.size()];
        int i = 0;
        for (Map.Entry<VirtualFile, Editor> entry : this.myVirtualFile2Editor.entrySet()) {
            TextEditor textEditor = TextEditorProvider.getInstance().getTextEditor(entry.getValue());
            result2[i++] = textEditor;
        }
        return result2;
    }

    public Editor openTextEditor(@NotNull OpenFileDescriptor descriptor, boolean focusEditor) {
        Ref result2 = new Ref();
        CommandProcessor.getInstance().executeCommand(this.myProject, () -> result2.set(this.openFileImpl3(descriptor, focusEditor)), "", null);
        Pair pair = (Pair)result2.get();
        for (FileEditor editor : (FileEditor[])pair.first) {
            if (!(editor instanceof TextEditor)) continue;
            return ((TextEditor)editor).getEditor();
        }
        return null;
    }

    @NotNull
    private Editor doOpenTextEditor(@NotNull OpenFileDescriptor descriptor) {
        VirtualFile file2 = descriptor.getFile();
        Editor editor = this.myVirtualFile2Editor.get(file2);
        if (editor == null) {
            PsiFile psiFile = PsiManager.getInstance((Project)this.myProject).findFile(file2);
            LOG.assertTrue(psiFile != null, (Object)file2);
            Document document = PsiDocumentManager.getInstance((Project)this.myProject).getDocument(psiFile);
            LOG.assertTrue(document != null, (Object)psiFile);
            editor = EditorFactory.getInstance().createEditor(document, this.myProject);
            EditorHighlighter highlighter = HighlighterFactory.createHighlighter((Project)this.myProject, (VirtualFile)file2);
            Language language = TextEditorImpl.getDocumentLanguage(editor);
            editor.getSettings().setLanguage(language);
            ((EditorEx)editor).setHighlighter(highlighter);
            ((EditorEx)editor).setFile(file2);
            this.myVirtualFile2Editor.put(file2, editor);
        }
        editor.getSelectionModel().removeSelection();
        descriptor.navigateIn(editor);
        this.myActiveFile = file2;
        return editor;
    }

    public void addFileEditorManagerListener(@NotNull FileEditorManagerListener listener2) {
    }

    public void addFileEditorManagerListener(@NotNull FileEditorManagerListener listener2, @NotNull Disposable parentDisposable) {
    }

    public void removeFileEditorManagerListener(@NotNull FileEditorManagerListener listener2) {
    }

    @NotNull
    public List<FileEditor> openEditor(@NotNull OpenFileDescriptor descriptor, boolean focusEditor) {
        Ref result2 = new Ref();
        CommandProcessor.getInstance().executeCommand(this.myProject, () -> result2.set(this.openFileImpl3(descriptor, focusEditor)), "", null);
        return Arrays.asList((Object[])((Pair)result2.get()).first);
    }

    @NotNull
    public Project getProject() {
        return this.myProject;
    }

    @Override
    public JComponent getPreferredFocusedComponent() {
        throw new UnsupportedOperationException();
    }

    @Override
    @NotNull
    public Pair<FileEditor[], FileEditorProvider[]> getEditorsWithProviders(@NotNull VirtualFile file2) {
        Pair<FileEditor, FileEditorProvider> editorAndProvider = this.myTestEditorSplitter.getEditorAndProvider(file2);
        FileEditor[] fileEditor = new FileEditor[]{};
        FileEditorProvider[] fileEditorProvider = new FileEditorProvider[]{};
        if (editorAndProvider != null) {
            fileEditor = new FileEditor[]{(FileEditor)editorAndProvider.first};
            fileEditorProvider = new FileEditorProvider[]{(FileEditorProvider)editorAndProvider.second};
        }
        return Pair.create((Object)fileEditor, (Object)fileEditorProvider);
    }

    @Override
    public int getWindowSplitCount() {
        return 0;
    }

    @Override
    public boolean hasSplitOrUndockedWindows() {
        return false;
    }

    @Override
    @NotNull
    public EditorsSplitters getSplitters() {
        throw new IncorrectOperationException();
    }

    @NotNull
    public ActionCallback getReady(@NotNull Object requestor) {
        return ActionCallback.DONE;
    }

    public void setSelectedEditor(@NotNull VirtualFile file2, @NotNull String fileEditorProviderId) {
        if (this.myVirtualFile2Editor.containsKey(file2)) {
            this.modifyTabWell(() -> {
                this.myActiveFile = file2;
                this.myTestEditorSplitter.setFocusedFile(file2);
            });
        }
    }
}

