/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileEditor.impl;

import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.UniqueVFilePathBuilder;
import com.intellij.openapi.fileEditor.impl.EditorHistoryManager;
import com.intellij.openapi.fileEditor.impl.FileEditorManagerImpl;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.UniqueNameBuilder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFilePathWrapper;
import com.intellij.psi.search.FilenameIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.util.ConcurrencyUtil;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashSet;
import java.io.File;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UniqueVFilePathBuilderImpl
extends UniqueVFilePathBuilder {
    private static final Key<CachedValue<Map<GlobalSearchScope, Map<String, UniqueNameBuilder<VirtualFile>>>>> ourShortNameBuilderCacheKey = Key.create((String)"project's.short.file.name.builder");
    private static final Key<CachedValue<Map<GlobalSearchScope, Map<String, UniqueNameBuilder<VirtualFile>>>>> ourShortNameOpenedBuilderCacheKey = Key.create((String)"project's.short.file.name.opened.builder");
    private static final UniqueNameBuilder<VirtualFile> ourEmptyBuilder = new UniqueNameBuilder(null, null, -1);

    @NotNull
    public String getUniqueVirtualFilePath(@NotNull Project project, @NotNull VirtualFile file2, @NotNull GlobalSearchScope scope) {
        return UniqueVFilePathBuilderImpl.getUniqueVirtualFilePath(project, file2, false, scope);
    }

    @NotNull
    public String getUniqueVirtualFilePath(@NotNull Project project, @NotNull VirtualFile vFile) {
        return this.getUniqueVirtualFilePath(project, vFile, GlobalSearchScope.projectScope((Project)project));
    }

    @NotNull
    public String getUniqueVirtualFilePathWithinOpenedFileEditors(@NotNull Project project, @NotNull VirtualFile vFile) {
        return UniqueVFilePathBuilderImpl.getUniqueVirtualFilePath(project, vFile, true, GlobalSearchScope.projectScope((Project)project));
    }

    private static String getUniqueVirtualFilePath(Project project, VirtualFile file2, boolean skipNonOpenedFiles, GlobalSearchScope scope) {
        String fileName2;
        UniqueNameBuilder<VirtualFile> uniqueNameBuilderForShortName;
        ConcurrentMap scope2ValueMap;
        Map valueMap;
        Key<CachedValue<Map<GlobalSearchScope, Map<String, UniqueNameBuilder<VirtualFile>>>>> key = skipNonOpenedFiles ? ourShortNameOpenedBuilderCacheKey : ourShortNameBuilderCacheKey;
        CachedValue data = (CachedValue)project.getUserData(key);
        if (data == null) {
            data = CachedValuesManager.getManager((Project)project).createCachedValue(() -> new CachedValueProvider.Result(new ConcurrentHashMap(2), new Object[]{PsiModificationTracker.MODIFICATION_COUNT, FileEditorManagerImpl.OPEN_FILE_SET_MODIFICATION_COUNT}), false);
            project.putUserData(key, (Object)data);
        }
        if ((valueMap = (Map)(scope2ValueMap = (ConcurrentMap)data.getValue()).get(scope)) == null) {
            valueMap = (Map)ConcurrencyUtil.cacheOrGet((ConcurrentMap)scope2ValueMap, (Object)scope, (Object)ContainerUtil.createConcurrentSoftValueMap());
        }
        if ((uniqueNameBuilderForShortName = (UniqueNameBuilder<VirtualFile>)valueMap.get(fileName2 = file2.getName())) == null) {
            UniqueNameBuilder<VirtualFile> builder2 = UniqueVFilePathBuilderImpl.filesWithTheSameName(fileName2, project, skipNonOpenedFiles, scope);
            valueMap.put(fileName2, builder2 != null ? builder2 : ourEmptyBuilder);
            uniqueNameBuilderForShortName = builder2;
        } else if (uniqueNameBuilderForShortName == ourEmptyBuilder) {
            uniqueNameBuilderForShortName = null;
        }
        if (uniqueNameBuilderForShortName != null && uniqueNameBuilderForShortName.contains((Object)file2)) {
            return uniqueNameBuilderForShortName.getShortPath((Object)file2);
        }
        return file2 instanceof VirtualFilePathWrapper ? file2.getPresentableName() : file2.getName();
    }

    @Nullable
    private static UniqueNameBuilder<VirtualFile> filesWithTheSameName(String fileName2, Project project, boolean skipNonOpenedFiles, GlobalSearchScope scope) {
        THashSet filesWithSameName = skipNonOpenedFiles ? Collections.emptySet() : FilenameIndex.getVirtualFilesByName(project, fileName2, scope);
        THashSet setOfFilesWithTheSameName = new THashSet(filesWithSameName);
        for (VirtualFile openFile2 : FileEditorManager.getInstance((Project)project).getOpenFiles()) {
            if (!openFile2.getName().equals(fileName2)) continue;
            setOfFilesWithTheSameName.add((Object)openFile2);
        }
        if (!skipNonOpenedFiles) {
            for (VirtualFile recentlyEditedFile : EditorHistoryManager.getInstance(project).getFileList()) {
                if (!recentlyEditedFile.getName().equals(fileName2)) continue;
                setOfFilesWithTheSameName.add((Object)recentlyEditedFile);
            }
        }
        if ((filesWithSameName = setOfFilesWithTheSameName).size() > 1) {
            String path = project.getBasePath();
            path = path == null ? "" : FileUtil.toSystemIndependentName((String)path);
            UniqueNameBuilder builder2 = new UniqueNameBuilder(path, File.separator, 25);
            for (VirtualFile virtualFile : filesWithSameName) {
                String presentablePath = virtualFile instanceof VirtualFilePathWrapper ? ((VirtualFilePathWrapper)virtualFile).getPresentablePath() : virtualFile.getPath();
                builder2.addPath((Object)virtualFile, presentablePath);
            }
            return builder2;
        }
        return null;
    }
}

