/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileEditor.impl.text;

import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.application.impl.NonBlockingReadActionImpl;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.editor.highlighter.EditorHighlighterFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.concurrency.CancellablePromise;

public class AsyncHighlighterUpdater {
    private static final ExecutorService ourExecutor = AppExecutorUtil.createBoundedApplicationPoolExecutor((String)"AsyncEditorLoader Pool", (int)2);
    private static final Map<Editor, CancellablePromise<?>> ourHighlighterFutures = ContainerUtil.newConcurrentMap();

    public static void updateHighlighters(@NotNull Project project, @NotNull Editor editor, @NotNull VirtualFile file2) {
        CancellablePromise promise = ReadAction.nonBlocking(() -> AsyncHighlighterUpdater.updateHighlighter(project, editor, file2)).expireWhen(() -> !file2.isValid() || editor.isDisposed() || project.isDisposed()).finishOnUiThread(ModalityState.any(), highlighter -> ((EditorEx)editor).setHighlighter((EditorHighlighter)highlighter)).submit((Executor)ourExecutor);
        CancellablePromise prev2 = ourHighlighterFutures.put(editor, promise);
        if (prev2 != null) {
            prev2.cancel();
        }
        promise.onProcessed(__ -> ourHighlighterFutures.remove(editor, promise));
    }

    @NotNull
    private static EditorHighlighter updateHighlighter(@NotNull Project project, @NotNull Editor editor, @NotNull VirtualFile file2) {
        EditorHighlighter highlighter = EditorHighlighterFactory.getInstance().createEditorHighlighter(project, file2);
        highlighter.setText(editor.getDocument().getImmutableCharSequence());
        return highlighter;
    }

    public static void completeAsyncTasks() {
        NonBlockingReadActionImpl.waitForAsyncTaskCompletion();
    }
}

