/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileEditor.impl.text;

import com.intellij.codeHighlighting.BackgroundEditorHighlighter;
import com.intellij.ide.structureView.StructureViewBuilder;
import com.intellij.lang.Language;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.editor.highlighter.EditorHighlighterFactory;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditorLocation;
import com.intellij.openapi.fileEditor.FileEditorState;
import com.intellij.openapi.fileEditor.FileEditorStateLevel;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.fileEditor.TextEditorLocation;
import com.intellij.openapi.fileEditor.impl.FileEditorManagerImpl;
import com.intellij.openapi.fileEditor.impl.text.AsyncEditorLoader;
import com.intellij.openapi.fileEditor.impl.text.TextEditorComponent;
import com.intellij.openapi.fileEditor.impl.text.TextEditorProvider;
import com.intellij.openapi.fileEditor.impl.text.TextEditorState;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TextEditorImpl
extends UserDataHolderBase
implements TextEditor {
    private static final Logger LOG = Logger.getInstance(TextEditorImpl.class);
    private static final Key<TransientEditorState> TRANSIENT_EDITOR_STATE_KEY = Key.create((String)"transientState");
    protected final Project myProject;
    private final PropertyChangeSupport myChangeSupport;
    @NotNull
    private final TextEditorComponent myComponent;
    @NotNull
    protected final VirtualFile myFile;
    private final AsyncEditorLoader myAsyncLoader;
    private final Future<?> myLoadingFinished;

    TextEditorImpl(@NotNull Project project, @NotNull VirtualFile file2, TextEditorProvider provider) {
        this.myProject = project;
        this.myFile = file2;
        this.myChangeSupport = new PropertyChangeSupport((Object)this);
        this.myComponent = this.createEditorComponent(project, file2);
        TransientEditorState state = (TransientEditorState)this.myFile.getUserData(TRANSIENT_EDITOR_STATE_KEY);
        if (state != null) {
            state.applyTo(this.getEditor());
            this.myFile.putUserData(TRANSIENT_EDITOR_STATE_KEY, null);
        }
        Disposer.register((Disposable)this, (Disposable)this.myComponent);
        this.myAsyncLoader = new AsyncEditorLoader(this, this.myComponent, provider);
        this.myLoadingFinished = this.myAsyncLoader.start();
    }

    @NotNull
    protected AsyncEditorLoader.LoadEditorResult loadEditorInBackground() {
        EditorColorsScheme scheme2 = EditorColorsManager.getInstance().getGlobalScheme();
        EditorHighlighter highlighter = EditorHighlighterFactory.getInstance().createEditorHighlighter(this.myFile, scheme2, this.myProject);
        EditorEx editor = (EditorEx)this.getEditor();
        highlighter.setText(editor.getDocument().getImmutableCharSequence());
        long stamp = editor.getDocument().getModificationStamp();
        Language language = TextEditorImpl.getDocumentLanguage(editor);
        return new AsyncEditorLoader.LoadEditorResult(document -> stamp == document.getModificationStamp(), () -> {
            editor.getSettings().setLanguage(language);
            editor.setHighlighter(highlighter);
        });
    }

    @Nullable
    public static Language getDocumentLanguage(@NotNull Editor editor) {
        Project project = editor.getProject();
        LOG.assertTrue(project != null);
        if (!project.isDisposed()) {
            PsiDocumentManager documentManager = PsiDocumentManager.getInstance((Project)project);
            PsiFile file2 = documentManager.getPsiFile(editor.getDocument());
            if (file2 != null) {
                return file2.getLanguage();
            }
        } else {
            LOG.warn("Attempting to get a language for document on a disposed project: " + project.getName());
        }
        return null;
    }

    @NotNull
    protected TextEditorComponent createEditorComponent(Project project, VirtualFile file2) {
        return new TextEditorComponent(project, file2, this);
    }

    public void dispose() {
        if (Boolean.TRUE.equals(this.myFile.getUserData(FileEditorManagerImpl.CLOSING_TO_REOPEN))) {
            this.myFile.putUserData(TRANSIENT_EDITOR_STATE_KEY, (Object)TransientEditorState.forEditor(this.getEditor()));
        }
    }

    @NotNull
    public VirtualFile getFile() {
        return this.myFile;
    }

    @NotNull
    public TextEditorComponent getComponent() {
        return this.myComponent;
    }

    @NotNull
    public JComponent getPreferredFocusedComponent() {
        return this.getActiveEditor().getContentComponent();
    }

    @NotNull
    public Editor getEditor() {
        return this.getActiveEditor();
    }

    @NotNull
    private Editor getActiveEditor() {
        return this.myComponent.getEditor();
    }

    @NotNull
    public String getName() {
        return "Text";
    }

    @NotNull
    public FileEditorState getState(@NotNull FileEditorStateLevel level) {
        return this.myAsyncLoader.getEditorState(level);
    }

    public void setState(@NotNull FileEditorState state) {
        this.setState(state, false);
    }

    public void setState(@NotNull FileEditorState state, boolean exactState) {
        if (state instanceof TextEditorState) {
            this.myAsyncLoader.setEditorState((TextEditorState)state, exactState);
        }
    }

    public boolean isModified() {
        return this.myComponent.isModified();
    }

    public boolean isValid() {
        return this.myComponent.isEditorValid();
    }

    public void selectNotify() {
        this.myComponent.selectNotify();
    }

    public void deselectNotify() {
    }

    public void updateModifiedProperty() {
        this.myComponent.updateModifiedProperty();
    }

    void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        this.myChangeSupport.firePropertyChange(propertyName, oldValue, newValue);
    }

    public void addPropertyChangeListener(@NotNull PropertyChangeListener listener2) {
        this.myChangeSupport.addPropertyChangeListener(listener2);
    }

    public void removePropertyChangeListener(@NotNull PropertyChangeListener listener2) {
        this.myChangeSupport.removePropertyChangeListener(listener2);
    }

    public BackgroundEditorHighlighter getBackgroundHighlighter() {
        return null;
    }

    public FileEditorLocation getCurrentLocation() {
        return new TextEditorLocation(this.getEditor().getCaretModel().getLogicalPosition(), (TextEditor)this);
    }

    public StructureViewBuilder getStructureViewBuilder() {
        Document document = this.myComponent.getEditor().getDocument();
        VirtualFile file2 = FileDocumentManager.getInstance().getFile(document);
        if (file2 == null || !file2.isValid()) {
            return null;
        }
        return StructureViewBuilder.PROVIDER.getStructureViewBuilder(file2.getFileType(), file2, this.myProject);
    }

    public boolean canNavigateTo(@NotNull Navigatable navigatable) {
        return navigatable instanceof OpenFileDescriptor && (((OpenFileDescriptor)navigatable).getLine() >= 0 || ((OpenFileDescriptor)navigatable).getOffset() >= 0);
    }

    public void navigateTo(@NotNull Navigatable navigatable) {
        ((OpenFileDescriptor)navigatable).navigateIn(this.getEditor());
    }

    public String toString() {
        return "Editor: " + this.myComponent.getFile();
    }

    public void waitForLoaded(long timeout, @NotNull TimeUnit unit) throws TimeoutException {
        try {
            this.myLoadingFinished.get(timeout, unit);
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    private static class TransientEditorState {
        private boolean softWrapsEnabled;

        private TransientEditorState() {
        }

        private static TransientEditorState forEditor(Editor editor) {
            TransientEditorState state = new TransientEditorState();
            state.softWrapsEnabled = editor.getSettings().isUseSoftWraps();
            return state;
        }

        private void applyTo(Editor editor) {
            editor.getSettings().setUseSoftWraps(this.softWrapsEnabled);
        }
    }
}

