/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileEditor.impl.text;

import com.intellij.codeHighlighting.BackgroundEditorHighlighter;
import com.intellij.ide.structureView.StructureViewBuilder;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.CaretState;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.fileEditor.DocumentsEditor;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorLocation;
import com.intellij.openapi.fileEditor.FileEditorPolicy;
import com.intellij.openapi.fileEditor.FileEditorProvider;
import com.intellij.openapi.fileEditor.FileEditorState;
import com.intellij.openapi.fileEditor.FileEditorStateLevel;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.fileEditor.ex.FileEditorManagerEx;
import com.intellij.openapi.fileEditor.impl.text.TextEditorImpl;
import com.intellij.openapi.fileEditor.impl.text.TextEditorState;
import com.intellij.openapi.fileTypes.BinaryFileTypeDecompilers;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.util.text.StringUtilRt;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import com.intellij.psi.SingleRootFileViewProvider;
import com.intellij.util.ui.update.UiNotifyConnector;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.JComponent;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TextEditorProvider
implements FileEditorProvider,
DumbAware {
    protected static final Logger LOG = Logger.getInstance(TextEditorProvider.class);
    private static final Key<TextEditor> TEXT_EDITOR_KEY = Key.create((String)"textEditor");
    @NonNls
    private static final String TYPE_ID = "text-editor";
    @NonNls
    private static final String LINE_ATTR = "line";
    @NonNls
    private static final String COLUMN_ATTR = "column";
    @NonNls
    private static final String LEAN_FORWARD_ATTR = "lean-forward";
    @NonNls
    private static final String SELECTION_START_LINE_ATTR = "selection-start-line";
    @NonNls
    private static final String SELECTION_START_COLUMN_ATTR = "selection-start-column";
    @NonNls
    private static final String SELECTION_END_LINE_ATTR = "selection-end-line";
    @NonNls
    private static final String SELECTION_END_COLUMN_ATTR = "selection-end-column";
    @NonNls
    private static final String RELATIVE_CARET_POSITION_ATTR = "relative-caret-position";
    @NonNls
    private static final String CARET_ELEMENT = "caret";

    @NotNull
    public static TextEditorProvider getInstance() {
        return (TextEditorProvider)FileEditorProvider.EP_FILE_EDITOR_PROVIDER.findExtensionOrFail(TextEditorProvider.class);
    }

    public boolean accept(@NotNull Project project, @NotNull VirtualFile file2) {
        return TextEditorProvider.isTextFile(file2) && !SingleRootFileViewProvider.isTooLargeForContentLoading(file2);
    }

    @NotNull
    public FileEditor createEditor(@NotNull Project project, @NotNull VirtualFile file2) {
        LOG.assertTrue(this.accept(project, file2));
        return new TextEditorImpl(project, file2, this);
    }

    @NotNull
    public FileEditorState readState(@NotNull Element element, @NotNull Project project, @NotNull VirtualFile file2) {
        TextEditorState state = new TextEditorState();
        if (JDOMUtil.isEmpty((Element)element)) {
            return state;
        }
        List caretElements = element.getChildren(CARET_ELEMENT);
        if (caretElements.isEmpty()) {
            state.CARETS = new TextEditorState.CaretState[]{TextEditorProvider.readCaretInfo(element)};
        } else {
            state.CARETS = new TextEditorState.CaretState[caretElements.size()];
            for (int i = 0; i < caretElements.size(); ++i) {
                state.CARETS[i] = TextEditorProvider.readCaretInfo((Element)caretElements.get(i));
            }
        }
        state.RELATIVE_CARET_POSITION = StringUtilRt.parseInt((String)element.getAttributeValue(RELATIVE_CARET_POSITION_ATTR), (int)0);
        return state;
    }

    private static TextEditorState.CaretState readCaretInfo(@NotNull Element element) {
        TextEditorState.CaretState caretState = new TextEditorState.CaretState();
        caretState.LINE = TextEditorProvider.parseWithDefault(element, LINE_ATTR);
        caretState.COLUMN = TextEditorProvider.parseWithDefault(element, COLUMN_ATTR);
        caretState.LEAN_FORWARD = Boolean.parseBoolean(element.getAttributeValue(LEAN_FORWARD_ATTR));
        caretState.SELECTION_START_LINE = TextEditorProvider.parseWithDefault(element, SELECTION_START_LINE_ATTR);
        caretState.SELECTION_START_COLUMN = TextEditorProvider.parseWithDefault(element, SELECTION_START_COLUMN_ATTR);
        caretState.SELECTION_END_LINE = TextEditorProvider.parseWithDefault(element, SELECTION_END_LINE_ATTR);
        caretState.SELECTION_END_COLUMN = TextEditorProvider.parseWithDefault(element, SELECTION_END_COLUMN_ATTR);
        return caretState;
    }

    private static int parseWithDefault(@NotNull Element element, @NotNull String attributeName) {
        return StringUtilRt.parseInt((String)element.getAttributeValue(attributeName), (int)0);
    }

    public void writeState(@NotNull FileEditorState _state, @NotNull Project project, @NotNull Element element) {
        TextEditorState state = (TextEditorState)_state;
        if (state.RELATIVE_CARET_POSITION != 0) {
            element.setAttribute(RELATIVE_CARET_POSITION_ATTR, Integer.toString(state.RELATIVE_CARET_POSITION));
        }
        if (state.CARETS != null) {
            for (TextEditorState.CaretState caretState : state.CARETS) {
                Element e = new Element(CARET_ELEMENT);
                TextEditorProvider.writeIfNot0(e, LINE_ATTR, caretState.LINE);
                TextEditorProvider.writeIfNot0(e, COLUMN_ATTR, caretState.COLUMN);
                if (caretState.LEAN_FORWARD) {
                    e.setAttribute(LEAN_FORWARD_ATTR, Boolean.toString(true));
                }
                TextEditorProvider.writeIfNot0(e, SELECTION_START_LINE_ATTR, caretState.SELECTION_START_LINE);
                TextEditorProvider.writeIfNot0(e, SELECTION_START_COLUMN_ATTR, caretState.SELECTION_START_COLUMN);
                TextEditorProvider.writeIfNot0(e, SELECTION_END_LINE_ATTR, caretState.SELECTION_END_LINE);
                TextEditorProvider.writeIfNot0(e, SELECTION_END_LINE_ATTR, caretState.SELECTION_END_LINE);
                TextEditorProvider.writeIfNot0(e, SELECTION_END_COLUMN_ATTR, caretState.SELECTION_END_COLUMN);
                if (JDOMUtil.isEmpty((Element)e)) continue;
                element.addContent(e);
            }
        }
    }

    private static void writeIfNot0(@NotNull Element element, @NotNull String name, int value) {
        if (value != 0) {
            element.setAttribute(name, Integer.toString(value));
        }
    }

    @NotNull
    public String getEditorTypeId() {
        return TYPE_ID;
    }

    @NotNull
    public FileEditorPolicy getPolicy() {
        return FileEditorPolicy.NONE;
    }

    @NotNull
    public TextEditor getTextEditor(@NotNull Editor editor) {
        TextEditor textEditor = (TextEditor)editor.getUserData(TEXT_EDITOR_KEY);
        if (textEditor == null) {
            textEditor = this.createWrapperForEditor(editor);
            TextEditorProvider.putTextEditor(editor, textEditor);
        }
        return textEditor;
    }

    @NotNull
    protected EditorWrapper createWrapperForEditor(@NotNull Editor editor) {
        return new EditorWrapper(editor);
    }

    @Nullable
    public static Document[] getDocuments(@NotNull FileEditor editor) {
        if (editor instanceof DocumentsEditor) {
            DocumentsEditor documentsEditor = (DocumentsEditor)editor;
            Document[] documents = documentsEditor.getDocuments();
            return documents.length > 0 ? documents : null;
        }
        if (editor instanceof TextEditor) {
            Document document = ((TextEditor)editor).getEditor().getDocument();
            return new Document[]{document};
        }
        Project[] projects = ProjectManager.getInstance().getOpenProjects();
        for (int i = projects.length - 1; i >= 0; --i) {
            Document document;
            VirtualFile file2 = FileEditorManagerEx.getInstanceEx(projects[i]).getFile(editor);
            if (file2 == null || (document = FileDocumentManager.getInstance().getDocument(file2)) == null) continue;
            return new Document[]{document};
        }
        return null;
    }

    static void putTextEditor(Editor editor, TextEditor textEditor) {
        editor.putUserData(TEXT_EDITOR_KEY, (Object)textEditor);
    }

    @NotNull
    protected TextEditorState getStateImpl(Project project, @NotNull Editor editor, @NotNull FileEditorStateLevel level) {
        TextEditorState state = new TextEditorState();
        CaretModel caretModel = editor.getCaretModel();
        List caretsAndSelections = caretModel.getCaretsAndSelections();
        state.CARETS = new TextEditorState.CaretState[caretsAndSelections.size()];
        for (int i = 0; i < caretsAndSelections.size(); ++i) {
            CaretState caretState = (CaretState)caretsAndSelections.get(i);
            LogicalPosition caretPosition = caretState.getCaretPosition();
            LogicalPosition selectionStartPosition = caretState.getSelectionStart();
            LogicalPosition selectionEndPosition = caretState.getSelectionEnd();
            TextEditorState.CaretState s = new TextEditorState.CaretState();
            s.LINE = TextEditorProvider.getLine(caretPosition);
            s.COLUMN = TextEditorProvider.getColumn(caretPosition);
            s.LEAN_FORWARD = caretPosition != null && caretPosition.leansForward;
            s.VISUAL_COLUMN_ADJUSTMENT = caretState.getVisualColumnAdjustment();
            s.SELECTION_START_LINE = TextEditorProvider.getLine(selectionStartPosition);
            s.SELECTION_START_COLUMN = TextEditorProvider.getColumn(selectionStartPosition);
            s.SELECTION_END_LINE = TextEditorProvider.getLine(selectionEndPosition);
            s.SELECTION_END_COLUMN = TextEditorProvider.getColumn(selectionEndPosition);
            state.CARETS[i] = s;
        }
        state.RELATIVE_CARET_POSITION = level == FileEditorStateLevel.UNDO ? Integer.MAX_VALUE : EditorUtil.calcRelativeCaretPosition(editor);
        return state;
    }

    public static boolean isTextFile(@NotNull VirtualFile file2) {
        if (file2.isDirectory() || !file2.isValid()) {
            return false;
        }
        FileType ft = file2.getFileType();
        return !ft.isBinary() || BinaryFileTypeDecompilers.INSTANCE.forFileType(ft) != null;
    }

    private static int getLine(@Nullable LogicalPosition pos) {
        return pos == null ? 0 : pos.line;
    }

    private static int getColumn(@Nullable LogicalPosition pos) {
        return pos == null ? 0 : pos.column;
    }

    protected void setStateImpl(Project project, Editor editor, TextEditorState state, boolean exactState) {
        TextEditorState.CaretState[] carets = state.CARETS;
        if (carets != null && carets.length > 0) {
            if (!editor.getCaretModel().supportsMultipleCarets()) {
                carets = Arrays.copyOf(carets, 1);
            }
            CaretModel caretModel = editor.getCaretModel();
            ArrayList<CaretState> states = new ArrayList<CaretState>(carets.length);
            for (TextEditorState.CaretState caretState : carets) {
                states.add(new CaretState(new LogicalPosition(caretState.LINE, caretState.COLUMN, caretState.LEAN_FORWARD), caretState.VISUAL_COLUMN_ADJUSTMENT, new LogicalPosition(caretState.SELECTION_START_LINE, caretState.SELECTION_START_COLUMN), new LogicalPosition(caretState.SELECTION_END_LINE, caretState.SELECTION_END_COLUMN)));
            }
            caretModel.setCaretsAndSelections(states, false);
        }
        int relativeCaretPosition = state.RELATIVE_CARET_POSITION;
        Runnable scrollingRunnable = () -> {
            if (!editor.isDisposed()) {
                editor.getScrollingModel().disableAnimation();
                if (relativeCaretPosition != Integer.MAX_VALUE) {
                    EditorUtil.setRelativeCaretPosition(editor, relativeCaretPosition);
                }
                if (!exactState) {
                    editor.getScrollingModel().scrollToCaret(ScrollType.RELATIVE);
                }
                editor.getScrollingModel().enableAnimation();
            }
        };
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            scrollingRunnable.run();
        } else {
            UiNotifyConnector.doWhenFirstShown((JComponent)editor.getContentComponent(), (Runnable)scrollingRunnable);
        }
    }

    protected class EditorWrapper
    extends UserDataHolderBase
    implements TextEditor {
        private final Editor myEditor;

        EditorWrapper(Editor editor) {
            this.myEditor = editor;
        }

        @NotNull
        public Editor getEditor() {
            return this.myEditor;
        }

        @NotNull
        public JComponent getComponent() {
            return this.myEditor.getComponent();
        }

        public JComponent getPreferredFocusedComponent() {
            return this.myEditor.getContentComponent();
        }

        @NotNull
        public String getName() {
            return "Text";
        }

        public StructureViewBuilder getStructureViewBuilder() {
            VirtualFile file2 = this.getFile();
            if (file2 == null) {
                return null;
            }
            Project project = this.myEditor.getProject();
            if (project == null) {
                return null;
            }
            return StructureViewBuilder.PROVIDER.getStructureViewBuilder(file2.getFileType(), file2, project);
        }

        @NotNull
        public FileEditorState getState(@NotNull FileEditorStateLevel level) {
            return TextEditorProvider.this.getStateImpl(null, this.myEditor, level);
        }

        public void setState(@NotNull FileEditorState state) {
            this.setState(state, false);
        }

        public void setState(@NotNull FileEditorState state, boolean exactState) {
            TextEditorProvider.this.setStateImpl(null, this.myEditor, (TextEditorState)state, exactState);
        }

        public boolean isModified() {
            return false;
        }

        public boolean isValid() {
            return true;
        }

        public void dispose() {
        }

        public void selectNotify() {
        }

        public void deselectNotify() {
        }

        public void addPropertyChangeListener(@NotNull PropertyChangeListener listener2) {
        }

        public void removePropertyChangeListener(@NotNull PropertyChangeListener listener2) {
        }

        public BackgroundEditorHighlighter getBackgroundHighlighter() {
            return null;
        }

        public FileEditorLocation getCurrentLocation() {
            return null;
        }

        public boolean canNavigateTo(@NotNull Navigatable navigatable) {
            return false;
        }

        public void navigateTo(@NotNull Navigatable navigatable) {
        }

        @Nullable
        public VirtualFile getFile() {
            return FileDocumentManager.getInstance().getFile(this.myEditor.getDocument());
        }
    }
}

