/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileTypes.impl;

import com.google.common.annotations.VisibleForTesting;
import com.intellij.ide.highlighter.custom.SyntaxTable;
import com.intellij.ide.plugins.PluginManager;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.components.BaseComponent;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.impl.LoadTextUtil;
import com.intellij.openapi.fileTypes.ExactFileNameMatcher;
import com.intellij.openapi.fileTypes.ExtensionFileNameMatcher;
import com.intellij.openapi.fileTypes.FileNameMatcher;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeConsumer;
import com.intellij.openapi.fileTypes.FileTypeEvent;
import com.intellij.openapi.fileTypes.FileTypeFactory;
import com.intellij.openapi.fileTypes.FileTypeListener;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.fileTypes.PlainTextFileType;
import com.intellij.openapi.fileTypes.UnknownFileType;
import com.intellij.openapi.fileTypes.UserBinaryFileType;
import com.intellij.openapi.fileTypes.UserFileType;
import com.intellij.openapi.fileTypes.ex.CustomFileTypeFactory;
import com.intellij.openapi.fileTypes.ex.ExternalizableFileType;
import com.intellij.openapi.fileTypes.ex.FileTypeChooser;
import com.intellij.openapi.fileTypes.ex.FileTypeIdentifiableByVirtualFile;
import com.intellij.openapi.fileTypes.ex.FileTypeManagerEx;
import com.intellij.openapi.fileTypes.impl.AbstractFileType;
import com.intellij.openapi.fileTypes.impl.FileTypeAssocTable;
import com.intellij.openapi.fileTypes.impl.IgnoredFileCache;
import com.intellij.openapi.fileTypes.impl.IgnoredPatternSet;
import com.intellij.openapi.options.NonLazySchemeProcessor;
import com.intellij.openapi.options.SchemeManager;
import com.intellij.openapi.options.SchemeManagerFactory;
import com.intellij.openapi.options.SchemeState;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.JDOMExternalizer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Trinity;
import com.intellij.openapi.util.io.ByteArraySequence;
import com.intellij.openapi.util.io.ByteSequence;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.util.text.StringUtilRt;
import com.intellij.openapi.vfs.VFileProperty;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFileWithId;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.FileAttribute;
import com.intellij.openapi.vfs.newvfs.FileSystemInterface;
import com.intellij.openapi.vfs.newvfs.events.VFileCreateEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.openapi.vfs.newvfs.impl.StubVirtualFile;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.ui.GuiUtils;
import com.intellij.util.ArrayFactory;
import com.intellij.util.ArrayUtil;
import com.intellij.util.BitUtil;
import com.intellij.util.DeprecatedMethodException;
import com.intellij.util.FileContentUtilCore;
import com.intellij.util.JdomKt;
import com.intellij.util.NotNullFunction;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PlatformUtils;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.concurrency.BoundedTaskExecutor;
import com.intellij.util.containers.ConcurrentPackedBitsArray;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.HashSetQueue;
import com.intellij.util.io.URLUtil;
import com.intellij.util.messages.MessageBus;
import com.intellij.util.messages.MessageBusConnection;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.ide.PooledThreadExecutor;

@State(name="FileTypeManager", storages={@Storage(value="filetypes.xml")}, additionalExportFile="filetypes")
public class FileTypeManagerImpl
extends FileTypeManagerEx
implements PersistentStateComponent<Element>,
Disposable,
BaseComponent {
    private static final Logger LOG = Logger.getInstance(FileTypeManagerImpl.class);
    private static final int VERSION = 17;
    private static final ThreadLocal<Pair<VirtualFile, FileType>> FILE_TYPE_FIXED_TEMPORARILY = new ThreadLocal();
    static final Key<FileType> DETECTED_FROM_CONTENT_FILE_TYPE_KEY = Key.create((String)"DETECTED_FROM_CONTENT_FILE_TYPE_KEY");
    private static final String DEFAULT_IGNORED = "*.hprof;*.pyc;*.pyo;*.rbc;*.yarb;*~;.DS_Store;.git;.hg;.svn;CVS;__pycache__;_svn;vssver.scc;vssver2.scc;";
    private static boolean RE_DETECT_ASYNC;
    private final Set<FileType> myDefaultTypes = new THashSet();
    private FileTypeIdentifiableByVirtualFile[] mySpecialFileTypes = FileTypeIdentifiableByVirtualFile.EMPTY_ARRAY;
    private FileTypeAssocTable<FileType> myPatternsTable = new FileTypeAssocTable();
    private final IgnoredPatternSet myIgnoredPatterns = new IgnoredPatternSet();
    private final IgnoredFileCache myIgnoredFileCache = new IgnoredFileCache(this.myIgnoredPatterns);
    private final FileTypeAssocTable<FileType> myInitialAssociations = new FileTypeAssocTable();
    private final Map<FileNameMatcher, String> myUnresolvedMappings = new THashMap();
    private final Map<FileNameMatcher, Trinity<String, String, Boolean>> myUnresolvedRemovedMappings = new THashMap();
    private final Map<FileNameMatcher, Pair<FileType, Boolean>> myRemovedMappings = new THashMap();
    @NonNls
    private static final String ELEMENT_FILETYPE = "filetype";
    @NonNls
    private static final String ELEMENT_IGNORE_FILES = "ignoreFiles";
    @NonNls
    private static final String ATTRIBUTE_LIST = "list";
    @NonNls
    private static final String ATTRIBUTE_VERSION = "version";
    @NonNls
    private static final String ATTRIBUTE_NAME = "name";
    @NonNls
    private static final String ATTRIBUTE_DESCRIPTION = "description";
    private final MessageBus myMessageBus;
    private final Map<String, StandardFileType> myStandardFileTypes = new LinkedHashMap<String, StandardFileType>();
    @NonNls
    private static final String[] FILE_TYPES_WITH_PREDEFINED_EXTENSIONS;
    private final SchemeManager<FileType> mySchemeManager;
    @NonNls
    static final String FILE_SPEC = "filetypes";
    private static final byte AUTO_DETECTED_AS_TEXT_MASK = 1;
    private static final byte AUTO_DETECTED_AS_BINARY_MASK = 2;
    private static final byte AUTO_DETECT_WAS_RUN_MASK = 4;
    private static final byte ATTRIBUTES_WERE_LOADED_MASK = 8;
    private final ConcurrentPackedBitsArray packedFlags = new ConcurrentPackedBitsArray(4);
    private final AtomicInteger counterAutoDetect = new AtomicInteger();
    private final AtomicLong elapsedAutoDetect = new AtomicLong();
    boolean toLog;
    private final ExecutorService reDetectExecutor = AppExecutorUtil.createBoundedApplicationPoolExecutor((String)"FileTypeManager Redetect Pool", (Executor)PooledThreadExecutor.INSTANCE, (int)1, (Disposable)this);
    private final HashSetQueue<VirtualFile> filesToRedetect = new HashSetQueue();
    private static final int CHUNK_SIZE = 10;
    private volatile FileAttribute autoDetectedAttribute;
    private final AtomicInteger fileTypeChangedCount;
    private final Map<FileTypeListener, MessageBusConnection> myAdapters = new HashMap<FileTypeListener, MessageBusConnection>();

    public FileTypeManagerImpl(MessageBus bus, SchemeManagerFactory schemeManagerFactory, PropertiesComponent propertiesComponent) {
        int fileTypeChangedCounter = StringUtilRt.parseInt((String)propertiesComponent.getValue("fileTypeChangedCounter"), (int)0);
        this.fileTypeChangedCount = new AtomicInteger(fileTypeChangedCounter);
        this.autoDetectedAttribute = new FileAttribute("AUTO_DETECTION_CACHE_ATTRIBUTE", fileTypeChangedCounter, true);
        this.myMessageBus = bus;
        this.mySchemeManager = schemeManagerFactory.create(FILE_SPEC, new NonLazySchemeProcessor<FileType, AbstractFileType>(){

            @Override
            @NotNull
            public AbstractFileType readScheme(@NotNull Element element, boolean duringLoad) {
                if (!duringLoad) {
                    FileTypeManagerImpl.this.fireBeforeFileTypesChanged();
                }
                AbstractFileType type = (AbstractFileType)FileTypeManagerImpl.this.loadFileType(element, false);
                if (!duringLoad) {
                    FileTypeManagerImpl.this.fireFileTypesChanged();
                }
                return type;
            }

            @Override
            @NotNull
            public SchemeState getState(@NotNull FileType fileType) {
                if (!(fileType instanceof AbstractFileType) || !FileTypeManagerImpl.shouldSave(fileType)) {
                    return SchemeState.NON_PERSISTENT;
                }
                if (!FileTypeManagerImpl.this.myDefaultTypes.contains(fileType)) {
                    return SchemeState.POSSIBLY_CHANGED;
                }
                return ((AbstractFileType)fileType).isModified() ? SchemeState.POSSIBLY_CHANGED : SchemeState.NON_PERSISTENT;
            }

            @NotNull
            public Element writeScheme(@NotNull AbstractFileType fileType) {
                Element root = new Element(FileTypeManagerImpl.ELEMENT_FILETYPE);
                root.setAttribute("binary", String.valueOf(fileType.isBinary()));
                if (!StringUtil.isEmpty((String)fileType.getDefaultExtension())) {
                    root.setAttribute("default_extension", fileType.getDefaultExtension());
                }
                root.setAttribute(FileTypeManagerImpl.ATTRIBUTE_DESCRIPTION, fileType.getDescription());
                root.setAttribute(FileTypeManagerImpl.ATTRIBUTE_NAME, fileType.getName());
                fileType.writeExternal(root);
                Element map2 = new Element("extensionMap");
                FileTypeManagerImpl.this.writeExtensionsMap(map2, fileType, false);
                if (!map2.getChildren().isEmpty()) {
                    root.addContent(map2);
                }
                return root;
            }

            @Override
            public void onSchemeDeleted(@NotNull AbstractFileType scheme2) {
                GuiUtils.invokeLaterIfNeeded(() -> {
                    Application app = ApplicationManager.getApplication();
                    app.runWriteAction(() -> FileTypeManagerImpl.this.fireBeforeFileTypesChanged());
                    FileTypeManagerImpl.this.myPatternsTable.removeAllAssociations((Object)scheme2);
                    app.runWriteAction(() -> FileTypeManagerImpl.this.fireFileTypesChanged());
                }, (ModalityState)ModalityState.NON_MODAL);
            }
        });
        bus.connect().subscribe(VirtualFileManager.VFS_CHANGES, (Object)new BulkFileListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void after(@NotNull List<? extends VFileEvent> events) {
                Set files2 = ContainerUtil.map2Set(events, event -> {
                    VirtualFile filtered;
                    VirtualFile file2 = event instanceof VFileCreateEvent ? null : event.getFile();
                    VirtualFile virtualFile = filtered = file2 != null && FileTypeManagerImpl.this.wasAutoDetectedBefore(file2) && FileTypeManagerImpl.isDetectable(file2) ? file2 : null;
                    if (FileTypeManagerImpl.this.toLog()) {
                        FileTypeManagerImpl.log("F: after() VFS event " + event + "; filtered file: " + filtered + " (file: " + file2 + "; wasAutoDetectedBefore(file): " + (file2 == null ? null : Boolean.valueOf(FileTypeManagerImpl.this.wasAutoDetectedBefore(file2))) + "; isDetectable(file): " + (file2 == null ? null : Boolean.valueOf(FileTypeManagerImpl.isDetectable(file2))) + "; file.getLength(): " + (file2 == null ? null : Long.valueOf(file2.getLength())) + "; file.isValid(): " + (file2 == null ? null : Boolean.valueOf(file2.isValid())) + "; file.is(VFileProperty.SPECIAL): " + (file2 == null ? null : Boolean.valueOf(file2.is(VFileProperty.SPECIAL))) + "; packedFlags.get(id): " + (file2 instanceof VirtualFileWithId ? FileTypeManagerImpl.readableFlags(FileTypeManagerImpl.this.packedFlags.get(((VirtualFileWithId)file2).getId())) : null) + "; file.getFileSystem():" + (file2 == null ? null : file2.getFileSystem()) + ")");
                    }
                    return filtered;
                });
                files2.remove(null);
                if (FileTypeManagerImpl.this.toLog()) {
                    FileTypeManagerImpl.log("F: after() VFS events: " + events + "; files: " + files2);
                }
                if (!files2.isEmpty() && RE_DETECT_ASYNC) {
                    if (FileTypeManagerImpl.this.toLog()) {
                        FileTypeManagerImpl.log("F: after() queued to redetect: " + files2);
                    }
                    HashSetQueue hashSetQueue = FileTypeManagerImpl.this.filesToRedetect;
                    synchronized (hashSetQueue) {
                        if (FileTypeManagerImpl.this.filesToRedetect.addAll((Collection)files2)) {
                            FileTypeManagerImpl.this.awakeReDetectExecutor();
                        }
                    }
                }
            }
        });
        this.myIgnoredPatterns.setIgnoreMasks(DEFAULT_IGNORED);
        this.initStandardFileTypes();
    }

    @VisibleForTesting
    void initStandardFileTypes() {
        block10: {
            FileTypeConsumer consumer = new FileTypeConsumer(){

                public void consume(@NotNull FileType fileType) {
                    this.register(fileType, FileTypeManagerImpl.parse(fileType.getDefaultExtension()));
                }

                public void consume(@NotNull FileType fileType, String extensions) {
                    this.register(fileType, FileTypeManagerImpl.parse(extensions));
                }

                public void consume(@NotNull FileType fileType, FileNameMatcher ... matchers) {
                    this.register(fileType, new ArrayList<FileNameMatcher>(Arrays.asList(matchers)));
                }

                public FileType getStandardFileTypeByName(@NotNull String name) {
                    StandardFileType type = (StandardFileType)FileTypeManagerImpl.this.myStandardFileTypes.get(name);
                    return type != null ? type.fileType : null;
                }

                private void register(@NotNull FileType fileType, @NotNull List<FileNameMatcher> fileNameMatchers) {
                    StandardFileType type = (StandardFileType)FileTypeManagerImpl.this.myStandardFileTypes.get(fileType.getName());
                    if (type != null) {
                        type.matchers.addAll(fileNameMatchers);
                    } else {
                        FileTypeManagerImpl.this.myStandardFileTypes.put(fileType.getName(), new StandardFileType(fileType, fileNameMatchers));
                    }
                }
            };
            for (FileTypeFactory factory : (FileTypeFactory[])FileTypeFactory.FILE_TYPE_FACTORY_EP.getExtensions()) {
                try {
                    factory.createFileTypes(consumer);
                }
                catch (Throwable e) {
                    PluginManager.handleComponentError(e, factory.getClass().getName(), null);
                }
            }
            for (StandardFileType pair : this.myStandardFileTypes.values()) {
                this.registerFileTypeWithoutNotification(pair.fileType, pair.matchers, true);
            }
            try {
                URL defaultFileTypesUrl = FileTypeManagerImpl.class.getResource("/defaultFileTypes.xml");
                if (defaultFileTypesUrl == null) break block10;
                Element defaultFileTypesElement = JdomKt.loadElement((InputStream)URLUtil.openStream((URL)defaultFileTypesUrl));
                for (Element e : defaultFileTypesElement.getChildren()) {
                    if (FILE_SPEC.equals(e.getName())) {
                        for (Element element : e.getChildren(ELEMENT_FILETYPE)) {
                            this.loadFileType(element, true);
                        }
                        continue;
                    }
                    if (!"extensionMap".equals(e.getName())) continue;
                    this.readGlobalMappings(e, true);
                }
                if (PlatformUtils.isIdeaCommunity()) {
                    Element extensionMap = new Element("extensionMap");
                    extensionMap.addContent(new Element("mapping").setAttribute("ext", "jspx").setAttribute("type", "XML"));
                    extensionMap.addContent(new Element("mapping").setAttribute("ext", "tagx").setAttribute("type", "XML"));
                    this.readGlobalMappings(extensionMap, true);
                }
            }
            catch (Exception e) {
                LOG.error((Throwable)e);
            }
        }
    }

    private boolean toLog() {
        return this.toLog;
    }

    private static void log(String message) {
        LOG.debug(message + " - " + Thread.currentThread());
    }

    private void awakeReDetectExecutor() {
        this.reDetectExecutor.submit(() -> {
            ArrayList<VirtualFile> files2 = new ArrayList<VirtualFile>(10);
            HashSetQueue<VirtualFile> hashSetQueue = this.filesToRedetect;
            synchronized (hashSetQueue) {
                VirtualFile file2;
                for (int i = 0; i < 10 && (file2 = (VirtualFile)this.filesToRedetect.poll()) != null; ++i) {
                    files2.add(file2);
                }
            }
            if (files2.size() == 10) {
                this.awakeReDetectExecutor();
            }
            this.reDetect(files2);
        });
    }

    public void drainReDetectQueue() {
        try {
            ((BoundedTaskExecutor)this.reDetectExecutor).waitAllTasksExecuted(1L, TimeUnit.MINUTES);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    Collection<VirtualFile> dumpReDetectQueue() {
        HashSetQueue<VirtualFile> hashSetQueue = this.filesToRedetect;
        synchronized (hashSetQueue) {
            return new ArrayList<VirtualFile>((Collection<VirtualFile>)this.filesToRedetect);
        }
    }

    static void reDetectAsync(boolean enable) {
        RE_DETECT_ASYNC = enable;
    }

    private void reDetect(@NotNull Collection<? extends VirtualFile> files2) {
        ArrayList<VirtualFile> changed = new ArrayList<VirtualFile>();
        ArrayList<VirtualFile> crashed = new ArrayList<VirtualFile>();
        for (VirtualFile virtualFile : files2) {
            FileType after;
            FileType before;
            block9: {
                boolean shouldRedetect;
                boolean bl = shouldRedetect = this.wasAutoDetectedBefore(virtualFile) && FileTypeManagerImpl.isDetectable(virtualFile);
                if (this.toLog()) {
                    FileTypeManagerImpl.log("F: reDetect(" + virtualFile.getName() + ") " + virtualFile.getName() + "; shouldRedetect: " + shouldRedetect);
                }
                if (!shouldRedetect) continue;
                int id = ((VirtualFileWithId)virtualFile).getId();
                long flags = this.packedFlags.get(id);
                before = (FileType)ObjectUtils.notNull((Object)FileTypeManagerImpl.textOrBinaryFromCachedFlags(flags), (Object)ObjectUtils.notNull((Object)virtualFile.getUserData(DETECTED_FROM_CONTENT_FILE_TYPE_KEY), (Object)((Object)PlainTextFileType.INSTANCE)));
                after = this.getByFile(virtualFile);
                if (this.toLog()) {
                    FileTypeManagerImpl.log("F: reDetect(" + virtualFile.getName() + ") prepare to redetect. flags: " + FileTypeManagerImpl.readableFlags(flags) + "; beforeType: " + before.getName() + "; afterByFileType: " + (after == null ? null : after.getName()));
                }
                if (after == null) {
                    try {
                        after = this.detectFromContentAndCache(virtualFile);
                        break block9;
                    }
                    catch (IOException e) {
                        crashed.add(virtualFile);
                        if (!this.toLog()) continue;
                        FileTypeManagerImpl.log("F: reDetect(" + virtualFile.getName() + ") before: " + before.getName() + "; after: crashed with " + e.getMessage() + "; now getFileType()=" + virtualFile.getFileType().getName() + "; getUserData(DETECTED_FROM_CONTENT_FILE_TYPE_KEY): " + virtualFile.getUserData(DETECTED_FROM_CONTENT_FILE_TYPE_KEY));
                        continue;
                    }
                }
                virtualFile.putUserData(DETECTED_FROM_CONTENT_FILE_TYPE_KEY, null);
                flags = 0L;
                this.packedFlags.set(id, flags);
            }
            if (this.toLog()) {
                FileTypeManagerImpl.log("F: reDetect(" + virtualFile.getName() + ") before: " + before.getName() + "; after: " + after.getName() + "; now getFileType()=" + virtualFile.getFileType().getName() + "; getUserData(DETECTED_FROM_CONTENT_FILE_TYPE_KEY): " + virtualFile.getUserData(DETECTED_FROM_CONTENT_FILE_TYPE_KEY));
            }
            if (before == after) continue;
            changed.add(virtualFile);
        }
        if (!changed.isEmpty()) {
            FileTypeManagerImpl.reparseLater(changed);
        }
        if (!crashed.isEmpty()) {
            AppExecutorUtil.getAppScheduledExecutorService().schedule(() -> FileTypeManagerImpl.reparseLater(crashed), 10L, TimeUnit.SECONDS);
        }
    }

    private static void reparseLater(@NotNull List<VirtualFile> changed) {
        ApplicationManager.getApplication().invokeLater(() -> FileContentUtilCore.reparseFiles((Collection)changed), ApplicationManager.getApplication().getDisposed());
    }

    private boolean wasAutoDetectedBefore(@NotNull VirtualFile file2) {
        if (file2.getUserData(DETECTED_FROM_CONTENT_FILE_TYPE_KEY) != null) {
            return true;
        }
        if (file2 instanceof VirtualFileWithId) {
            int id = ((VirtualFileWithId)file2).getId();
            return (this.packedFlags.get(id) & 6L) == 4L;
        }
        return false;
    }

    @NotNull
    public FileType getStdFileType(@NotNull @NonNls String name) {
        StandardFileType stdFileType = this.myStandardFileTypes.get(name);
        return stdFileType != null ? stdFileType.fileType : PlainTextFileType.INSTANCE;
    }

    public void initComponent() {
        if (!this.myUnresolvedMappings.isEmpty()) {
            for (StandardFileType pair : this.myStandardFileTypes.values()) {
                this.registerReDetectedMappings(pair);
            }
        }
        if (!this.myUnresolvedMappings.isEmpty()) {
            for (StandardFileType pair : this.myStandardFileTypes.values()) {
                this.bindUnresolvedMappings(pair.fileType);
            }
        }
        boolean isAtLeastOneStandardFileTypeHasBeenRead = false;
        for (FileType fileType : this.mySchemeManager.loadSchemes()) {
            isAtLeastOneStandardFileTypeHasBeenRead |= this.myInitialAssociations.hasAssociationsFor((Object)fileType);
        }
        if (isAtLeastOneStandardFileTypeHasBeenRead) {
            this.restoreStandardFileExtensions();
        }
    }

    @NotNull
    public FileType getFileTypeByFileName(@NotNull String fileName2) {
        return this.getFileTypeByFileName((CharSequence)fileName2);
    }

    @NotNull
    public FileType getFileTypeByFileName(@NotNull CharSequence fileName2) {
        FileType type = (FileType)this.myPatternsTable.findAssociatedFileType(fileName2);
        return (FileType)ObjectUtils.notNull((Object)type, (Object)UnknownFileType.INSTANCE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void freezeFileTypeTemporarilyIn(@NotNull VirtualFile file2, @NotNull Runnable runnable2) {
        FileType fileType = file2.getFileType();
        Pair<VirtualFile, FileType> old = FILE_TYPE_FIXED_TEMPORARILY.get();
        FILE_TYPE_FIXED_TEMPORARILY.set((Pair<VirtualFile, FileType>)Pair.create((Object)file2, (Object)fileType));
        if (this.toLog()) {
            FileTypeManagerImpl.log("F: freezeFileTypeTemporarilyIn(" + file2.getName() + ") to " + fileType.getName() + " in " + Thread.currentThread());
        }
        try {
            runnable2.run();
        }
        finally {
            if (old == null) {
                FILE_TYPE_FIXED_TEMPORARILY.remove();
            } else {
                FILE_TYPE_FIXED_TEMPORARILY.set(old);
            }
            if (this.toLog()) {
                FileTypeManagerImpl.log("F: unfreezeFileType(" + file2.getName() + ") in " + Thread.currentThread());
            }
        }
    }

    @NotNull
    public FileType getFileTypeByFile(@NotNull VirtualFile file2) {
        FileType fileType = this.getByFile(file2);
        if (fileType == null) {
            fileType = file2 instanceof StubVirtualFile ? UnknownFileType.INSTANCE : this.getOrDetectFromContent(file2);
        }
        return fileType;
    }

    @Nullable
    public FileType getByFile(@NotNull VirtualFile file2) {
        FileType fileType;
        Pair<VirtualFile, FileType> fixedType = FILE_TYPE_FIXED_TEMPORARILY.get();
        if (fixedType != null && ((VirtualFile)fixedType.getFirst()).equals(file2)) {
            FileType fileType2 = (FileType)fixedType.getSecond();
            if (this.toLog()) {
                FileTypeManagerImpl.log("F: getByFile(" + file2.getName() + ") was frozen to " + fileType2.getName() + " in " + Thread.currentThread());
            }
            return fileType2;
        }
        if (file2 instanceof LightVirtualFile && (fileType = ((LightVirtualFile)file2).getAssignedFileType()) != null) {
            return fileType;
        }
        for (FileType type : this.mySpecialFileTypes) {
            if (!type.isMyFileType(file2)) continue;
            if (this.toLog()) {
                FileTypeManagerImpl.log("F: getByFile(" + file2.getName() + "): Special file type: " + type.getName());
            }
            return type;
        }
        fileType = this.getFileTypeByFileName(file2.getNameSequence());
        if (fileType == UnknownFileType.INSTANCE) {
            fileType = null;
        }
        if (this.toLog()) {
            FileTypeManagerImpl.log("F: getByFile(" + file2.getName() + ") By name file type: " + (fileType == null ? null : fileType.getName()));
        }
        return fileType;
    }

    @NotNull
    private FileType getOrDetectFromContent(@NotNull VirtualFile file2) {
        if (!FileTypeManagerImpl.isDetectable(file2)) {
            return UnknownFileType.INSTANCE;
        }
        if (file2 instanceof VirtualFileWithId) {
            boolean autoDetectWasRun;
            int id = ((VirtualFileWithId)file2).getId();
            long flags = this.packedFlags.get(id);
            if (!BitUtil.isSet((long)flags, (long)8L)) {
                flags = this.readFlagsFromCache(file2);
                flags = BitUtil.set((long)flags, (long)8L, (boolean)true);
                this.packedFlags.set(id, flags);
                if (this.toLog()) {
                    FileTypeManagerImpl.log("F: getOrDetectFromContent(" + file2.getName() + "): readFlagsFromCache() = " + FileTypeManagerImpl.readableFlags(flags));
                }
            }
            if (autoDetectWasRun = BitUtil.isSet((long)flags, (long)4L)) {
                FileType type = FileTypeManagerImpl.textOrBinaryFromCachedFlags(flags);
                if (this.toLog()) {
                    FileTypeManagerImpl.log("F: getOrDetectFromContent(" + file2.getName() + "): cached type = " + (type == null ? null : type.getName()) + "; packedFlags.get(id):" + FileTypeManagerImpl.readableFlags(flags) + "; getUserData(DETECTED_FROM_CONTENT_FILE_TYPE_KEY): " + file2.getUserData(DETECTED_FROM_CONTENT_FILE_TYPE_KEY));
                }
                if (type != null) {
                    return type;
                }
            }
        }
        FileType fileType = (FileType)file2.getUserData(DETECTED_FROM_CONTENT_FILE_TYPE_KEY);
        if (this.toLog()) {
            FileTypeManagerImpl.log("F: getOrDetectFromContent(" + file2.getName() + "): getUserData(DETECTED_FROM_CONTENT_FILE_TYPE_KEY) = " + (fileType == null ? null : fileType.getName()));
        }
        if (fileType == null) {
            try {
                fileType = this.detectFromContentAndCache(file2);
            }
            catch (IOException e) {
                fileType = UnknownFileType.INSTANCE;
            }
        }
        if (this.toLog()) {
            FileTypeManagerImpl.log("F: getOrDetectFromContent(" + file2.getName() + "): getFileType after detect run = " + fileType.getName());
        }
        return fileType;
    }

    private static String readableFlags(long flags) {
        String result2 = "";
        if (BitUtil.isSet((long)flags, (long)8L)) {
            result2 = result2 + (result2.isEmpty() ? "" : " | ") + "ATTRIBUTES_WERE_LOADED_MASK";
        }
        if (BitUtil.isSet((long)flags, (long)4L)) {
            result2 = result2 + (result2.isEmpty() ? "" : " | ") + "AUTO_DETECT_WAS_RUN_MASK";
        }
        if (BitUtil.isSet((long)flags, (long)2L)) {
            result2 = result2 + (result2.isEmpty() ? "" : " | ") + "AUTO_DETECTED_AS_BINARY_MASK";
        }
        if (BitUtil.isSet((long)flags, (long)1L)) {
            result2 = result2 + (result2.isEmpty() ? "" : " | ") + "AUTO_DETECTED_AS_TEXT_MASK";
        }
        return result2;
    }

    protected byte readFlagsFromCache(@NotNull VirtualFile file2) {
        boolean wasAutoDetectRun = false;
        byte status = 0;
        try (DataInputStream stream = this.autoDetectedAttribute.readAttribute(file2);){
            status = stream == null ? (byte)0 : stream.readByte();
            wasAutoDetectRun = stream != null;
        }
        catch (IOException iOException) {
            // empty catch block
        }
        status = BitUtil.set((byte)status, (byte)4, (boolean)wasAutoDetectRun);
        return (byte)(status & 7);
    }

    protected void writeFlagsToCache(@NotNull VirtualFile file2, int flags) {
        try (DataOutputStream stream = this.autoDetectedAttribute.writeAttribute(file2);){
            stream.writeByte(flags & 3);
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
        }
    }

    void clearCaches() {
        this.packedFlags.clear();
        if (this.toLog()) {
            FileTypeManagerImpl.log("F: clearCaches()");
        }
    }

    private void clearPersistentAttributes() {
        int count = this.fileTypeChangedCount.incrementAndGet();
        this.autoDetectedAttribute = this.autoDetectedAttribute.newVersion(count);
        PropertiesComponent.getInstance().setValue("fileTypeChangedCounter", Integer.toString(count));
        if (this.toLog()) {
            FileTypeManagerImpl.log("F: clearPersistentAttributes()");
        }
    }

    @Nullable
    private static FileType textOrBinaryFromCachedFlags(long flags) {
        return BitUtil.isSet((long)flags, (long)1L) ? PlainTextFileType.INSTANCE : (BitUtil.isSet((long)flags, (long)2L) ? UnknownFileType.INSTANCE : null);
    }

    private void cacheAutoDetectedFileType(@NotNull VirtualFile file2, @NotNull FileType fileType) {
        boolean wasAutodetectedAsText = fileType == PlainTextFileType.INSTANCE;
        boolean wasAutodetectedAsBinary = fileType == UnknownFileType.INSTANCE;
        int flags = BitUtil.set((int)0, (int)1, (boolean)wasAutodetectedAsText);
        flags = BitUtil.set((int)flags, (int)2, (boolean)wasAutodetectedAsBinary);
        this.writeFlagsToCache(file2, flags);
        if (file2 instanceof VirtualFileWithId) {
            int id = ((VirtualFileWithId)file2).getId();
            flags = BitUtil.set((int)flags, (int)4, (boolean)true);
            flags = BitUtil.set((int)flags, (int)8, (boolean)true);
            this.packedFlags.set(id, (long)flags);
            if (wasAutodetectedAsText || wasAutodetectedAsBinary) {
                file2.putUserData(DETECTED_FROM_CONTENT_FILE_TYPE_KEY, null);
                if (this.toLog()) {
                    FileTypeManagerImpl.log("F: cacheAutoDetectedFileType(" + file2.getName() + ") cached to " + fileType.getName() + " flags = " + FileTypeManagerImpl.readableFlags(flags) + "; getUserData(DETECTED_FROM_CONTENT_FILE_TYPE_KEY): " + file2.getUserData(DETECTED_FROM_CONTENT_FILE_TYPE_KEY));
                }
                return;
            }
        }
        file2.putUserData(DETECTED_FROM_CONTENT_FILE_TYPE_KEY, (Object)fileType);
        if (this.toLog()) {
            FileTypeManagerImpl.log("F: cacheAutoDetectedFileType(" + file2.getName() + ") cached to " + fileType.getName() + " flags = " + FileTypeManagerImpl.readableFlags(flags) + "; getUserData(DETECTED_FROM_CONTENT_FILE_TYPE_KEY): " + file2.getUserData(DETECTED_FROM_CONTENT_FILE_TYPE_KEY));
        }
    }

    public FileType findFileTypeByName(@NotNull String fileTypeName) {
        FileType type = this.getStdFileType(fileTypeName);
        if (type == PlainTextFileType.INSTANCE && !fileTypeName.equals(type.getName())) {
            for (FileType fileType : this.mySchemeManager.getAllSchemes()) {
                if (!fileTypeName.equals(fileType.getName())) continue;
                return fileType;
            }
        }
        return type;
    }

    private static boolean isDetectable(@NotNull VirtualFile file2) {
        if (file2.isDirectory() || !file2.isValid() || file2.is(VFileProperty.SPECIAL) || file2.getLength() == 0L) {
            return false;
        }
        return file2.getFileSystem() instanceof FileSystemInterface;
    }

    private int readSafely(InputStream stream, byte[] buffer, int offset, int length) throws IOException {
        int n = stream.read(buffer, offset, length);
        if (n <= 0) {
            if (this.toLog()) {
                FileTypeManagerImpl.log("F: processFirstBytes(): inputStream.read() returned " + n + "; retrying with read action. stream=" + FileTypeManagerImpl.streamInfo(stream));
            }
            n = (Integer)ReadAction.compute(() -> stream.read(buffer, offset, length));
            if (this.toLog()) {
                FileTypeManagerImpl.log("F: processFirstBytes(): under read action inputStream.read() returned " + n + "; stream=" + FileTypeManagerImpl.streamInfo(stream));
            }
        }
        return n;
    }

    @NotNull
    private FileType detectFromContentAndCache(@NotNull VirtualFile file2) throws IOException {
        FileType fileType;
        long start2;
        block30: {
            start2 = System.currentTimeMillis();
            try (InputStream inputStream = ((FileSystemInterface)file2.getFileSystem()).getInputStream(file2);){
                int fileLength;
                byte[] buffer;
                int n;
                if (this.toLog()) {
                    FileTypeManagerImpl.log("F: detectFromContentAndCache(" + file2.getName() + "): inputStream=" + FileTypeManagerImpl.streamInfo(inputStream));
                }
                if ((n = this.readSafely(inputStream, buffer = (fileLength = (int)file2.getLength()) <= 20480 ? FileUtilRt.getThreadLocalBuffer() : new byte[Math.min(fileLength, FileUtilRt.getUserContentLoadLimit())], 0, buffer.length)) <= 0) {
                    FileType fileType2 = UnknownFileType.INSTANCE;
                    return fileType2;
                }
                fileType = this.detect(file2, buffer, n);
                if (!this.toLog()) break block30;
                try (InputStream newStream = ((FileSystemInterface)file2.getFileSystem()).getInputStream(file2);){
                    byte[] buffer2 = new byte[50];
                    int n2 = newStream.read(buffer2, 0, buffer2.length);
                    FileTypeManagerImpl.log("F: detectFromContentAndCache(" + file2.getName() + "): result: " + fileType.getName() + "; stream: " + FileTypeManagerImpl.streamInfo(inputStream) + "; newStream: " + FileTypeManagerImpl.streamInfo(newStream) + "; read: " + n2 + "; buffer: " + Arrays.toString(buffer2));
                }
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug(file2 + "; type=" + fileType.getDescription() + "; " + this.counterAutoDetect);
        }
        this.cacheAutoDetectedFileType(file2, fileType);
        this.counterAutoDetect.incrementAndGet();
        long elapsed = System.currentTimeMillis() - start2;
        this.elapsedAutoDetect.addAndGet(elapsed);
        return fileType;
    }

    @NotNull
    private FileType detect(@NotNull VirtualFile file2, @NotNull byte[] bytes, int length) {
        return LoadTextUtil.processTextFromBinaryPresentationOrNull(bytes, length, file2, true, true, (FileType)PlainTextFileType.INSTANCE, (NotNullFunction<? super CharSequence, ? extends FileType>)((NotNullFunction)text -> {
            List detectors = FileTypeRegistry.FileTypeDetector.EP_NAME.getExtensionList();
            if (this.toLog()) {
                FileTypeManagerImpl.log("F: detectFromContentAndCache.processFirstBytes(" + file2.getName() + "): bytes length=" + length + "; isText=" + (text != null) + "; text='" + (text == null ? null : StringUtil.first((CharSequence)text, (int)100, (boolean)true)) + "', detectors=" + detectors);
            }
            Object detected = null;
            ByteArraySequence firstBytes = new ByteArraySequence(bytes, 0, length);
            for (FileTypeRegistry.FileTypeDetector detector : detectors) {
                try {
                    detected = detector.detect(file2, (ByteSequence)firstBytes, text);
                }
                catch (Exception e) {
                    LOG.error("Detector " + detector + " (" + detector.getClass() + ") exception occurred:", (Throwable)e);
                }
                if (detected == null) continue;
                if (!this.toLog()) break;
                FileTypeManagerImpl.log("F: detectFromContentAndCache.processFirstBytes(" + file2.getName() + "): detector " + detector + " type as " + detected.getName());
                break;
            }
            if (detected == null) {
                Object object = detected = text == null ? UnknownFileType.INSTANCE : PlainTextFileType.INSTANCE;
                if (this.toLog()) {
                    FileTypeManagerImpl.log("F: detectFromContentAndCache.processFirstBytes(" + file2.getName() + "): no detector was able to detect. assigned " + detected.getName());
                }
            }
            return detected;
        }));
    }

    private static Object streamInfo(InputStream stream) throws IOException {
        if (stream instanceof BufferedInputStream) {
            InputStream in = (InputStream)ReflectionUtil.getField(stream.getClass(), (Object)stream, InputStream.class, (String)"in");
            byte[] buf = (byte[])ReflectionUtil.getField(stream.getClass(), (Object)stream, byte[].class, (String)"buf");
            int count = (Integer)ReflectionUtil.getField(stream.getClass(), (Object)stream, Integer.TYPE, (String)"count");
            int pos = (Integer)ReflectionUtil.getField(stream.getClass(), (Object)stream, Integer.TYPE, (String)"pos");
            return "BufferedInputStream(buf=" + (buf == null ? null : Arrays.toString(Arrays.copyOf(buf, count))) + ", count=" + count + ", pos=" + pos + ", in=" + FileTypeManagerImpl.streamInfo(in) + ")";
        }
        if (stream instanceof FileInputStream) {
            String path = (String)ReflectionUtil.getField(stream.getClass(), (Object)stream, String.class, (String)"path");
            FileChannel channel = (FileChannel)ReflectionUtil.getField(stream.getClass(), (Object)stream, FileChannel.class, (String)"channel");
            boolean closed = (Boolean)ReflectionUtil.getField(stream.getClass(), (Object)stream, Boolean.TYPE, (String)"closed");
            int available = stream.available();
            File file2 = new File(path);
            return "FileInputStream(path=" + path + ", available=" + available + ", closed=" + closed + ", channel=" + channel + ", channel.size=" + (channel == null ? null : Long.valueOf(channel.size())) + ", file.exists=" + file2.exists() + ", file.content='" + FileUtil.loadFile((File)file2) + "')";
        }
        return stream;
    }

    public boolean isFileOfType(@NotNull VirtualFile file2, @NotNull FileType type) {
        if (type instanceof FileTypeIdentifiableByVirtualFile) {
            return ((FileTypeIdentifiableByVirtualFile)type).isMyFileType(file2);
        }
        return this.getFileTypeByFileName(file2.getNameSequence()) == type;
    }

    @NotNull
    public FileType getFileTypeByExtension(@NotNull String extension) {
        return this.getFileTypeByFileName("IntelliJ_IDEA_RULES." + extension);
    }

    @Override
    public void registerFileType(@NotNull FileType fileType) {
        this.registerFileType(fileType, ArrayUtil.EMPTY_STRING_ARRAY);
    }

    public void registerFileType(@NotNull FileType type, @NotNull List<FileNameMatcher> defaultAssociations) {
        DeprecatedMethodException.report((String)"Use FileTypeFactory instead.");
        ApplicationManager.getApplication().runWriteAction(() -> {
            this.fireBeforeFileTypesChanged();
            this.registerFileTypeWithoutNotification(type, defaultAssociations, true);
            this.fireFileTypesChanged();
        });
    }

    @Override
    public void unregisterFileType(@NotNull FileType fileType) {
        ApplicationManager.getApplication().runWriteAction(() -> {
            this.fireBeforeFileTypesChanged();
            this.unregisterFileTypeWithoutNotification(fileType);
            this.fireFileTypesChanged();
        });
    }

    private void unregisterFileTypeWithoutNotification(@NotNull FileType fileType) {
        this.myPatternsTable.removeAllAssociations((Object)fileType);
        this.mySchemeManager.removeScheme(fileType);
        if (fileType instanceof FileTypeIdentifiableByVirtualFile) {
            FileTypeIdentifiableByVirtualFile fakeFileType = (FileTypeIdentifiableByVirtualFile)fileType;
            this.mySpecialFileTypes = (FileTypeIdentifiableByVirtualFile[])ArrayUtil.remove((Object[])this.mySpecialFileTypes, (Object)fakeFileType, (ArrayFactory)FileTypeIdentifiableByVirtualFile.ARRAY_FACTORY);
        }
    }

    @NotNull
    public FileType[] getRegisteredFileTypes() {
        List<FileType> fileTypes = this.mySchemeManager.getAllSchemes();
        return fileTypes.toArray(FileType.EMPTY_ARRAY);
    }

    @Override
    @NotNull
    public String getExtension(@NotNull String fileName2) {
        return FileUtilRt.getExtension((String)fileName2);
    }

    @NotNull
    public String getIgnoredFilesList() {
        Set masks = this.myIgnoredPatterns.getIgnoreMasks();
        return masks.isEmpty() ? "" : StringUtil.join((Collection)masks, (String)";") + ";";
    }

    public void setIgnoredFilesList(@NotNull String list2) {
        this.fireBeforeFileTypesChanged();
        this.myIgnoredFileCache.clearCache();
        this.myIgnoredPatterns.setIgnoreMasks(list2);
        this.fireFileTypesChanged();
    }

    @Override
    public boolean isIgnoredFilesListEqualToCurrent(@NotNull String list2) {
        THashSet tempSet = new THashSet();
        StringTokenizer tokenizer = new StringTokenizer(list2, ";");
        while (tokenizer.hasMoreTokens()) {
            tempSet.add(tokenizer.nextToken());
        }
        return tempSet.equals(this.myIgnoredPatterns.getIgnoreMasks());
    }

    public boolean isFileIgnored(@NotNull String name) {
        return this.myIgnoredPatterns.isIgnored((CharSequence)name);
    }

    public boolean isFileIgnored(@NotNull VirtualFile file2) {
        return this.myIgnoredFileCache.isFileIgnored(file2);
    }

    @NotNull
    public String[] getAssociatedExtensions(@NotNull FileType type) {
        return this.myPatternsTable.getAssociatedExtensions((Object)type);
    }

    @NotNull
    public List<FileNameMatcher> getAssociations(@NotNull FileType type) {
        return this.myPatternsTable.getAssociations((Object)type);
    }

    public void associate(@NotNull FileType type, @NotNull FileNameMatcher matcher) {
        this.associate(type, matcher, true);
    }

    public void removeAssociation(@NotNull FileType type, @NotNull FileNameMatcher matcher) {
        this.removeAssociation(type, matcher, true);
    }

    @Override
    public void fireBeforeFileTypesChanged() {
        FileTypeEvent event = new FileTypeEvent((Object)this);
        ((FileTypeListener)this.myMessageBus.syncPublisher(TOPIC)).beforeFileTypesChanged(event);
    }

    @Override
    public void fireFileTypesChanged() {
        this.clearCaches();
        this.clearPersistentAttributes();
        ((FileTypeListener)this.myMessageBus.syncPublisher(TOPIC)).fileTypesChanged(new FileTypeEvent((Object)this));
    }

    public void addFileTypeListener(@NotNull FileTypeListener listener2) {
        MessageBusConnection connection = this.myMessageBus.connect();
        connection.subscribe(TOPIC, (Object)listener2);
        this.myAdapters.put(listener2, connection);
    }

    public void removeFileTypeListener(@NotNull FileTypeListener listener2) {
        MessageBusConnection connection = this.myAdapters.remove(listener2);
        if (connection != null) {
            connection.disconnect();
        }
    }

    public void loadState(@NotNull Element state) {
        int savedVersion = StringUtilRt.parseInt((String)state.getAttributeValue(ATTRIBUTE_VERSION), (int)0);
        for (Element element : state.getChildren()) {
            if (element.getName().equals(ELEMENT_IGNORE_FILES)) {
                this.myIgnoredPatterns.setIgnoreMasks(element.getAttributeValue(ATTRIBUTE_LIST));
                continue;
            }
            if (!"extensionMap".equals(element.getName())) continue;
            this.readGlobalMappings(element, false);
        }
        if (savedVersion < 4) {
            if (savedVersion == 0) {
                this.addIgnore(".svn");
            }
            if (savedVersion < 2) {
                this.restoreStandardFileExtensions();
            }
            this.addIgnore("*.pyc");
            this.addIgnore("*.pyo");
            this.addIgnore(".git");
        }
        if (savedVersion < 5) {
            this.addIgnore("*.hprof");
        }
        if (savedVersion < 6) {
            this.addIgnore("_svn");
        }
        if (savedVersion < 7) {
            this.addIgnore(".hg");
        }
        if (savedVersion < 8) {
            this.addIgnore("*~");
        }
        if (savedVersion < 9) {
            this.addIgnore("__pycache__");
        }
        if (savedVersion < 11) {
            this.addIgnore("*.rbc");
        }
        if (savedVersion < 13) {
            this.unignoreMask("*.lib");
        }
        if (savedVersion < 15) {
            this.unignoreMask(".bundle");
        }
        if (savedVersion < 16) {
            this.unignoreMask(".tox");
        }
        if (savedVersion < 17) {
            this.addIgnore("*.rbc");
        }
        this.myIgnoredFileCache.clearCache();
        String counter = JDOMExternalizer.readString((Element)state, (String)"fileTypeChangedCounter");
        if (counter != null) {
            this.fileTypeChangedCount.set(StringUtilRt.parseInt((String)counter, (int)0));
            this.autoDetectedAttribute = this.autoDetectedAttribute.newVersion(this.fileTypeChangedCount.get());
        }
    }

    private void unignoreMask(@NotNull String maskToRemove) {
        LinkedHashSet masks = new LinkedHashSet(this.myIgnoredPatterns.getIgnoreMasks());
        masks.remove(maskToRemove);
        this.myIgnoredPatterns.clearPatterns();
        for (String each : masks) {
            this.myIgnoredPatterns.addIgnoreMask(each);
        }
    }

    private void readGlobalMappings(@NotNull Element e, boolean isAddToInit) {
        for (Pair<FileNameMatcher, String> association : AbstractFileType.readAssociations(e)) {
            FileType type = this.getFileTypeByName((String)association.getSecond());
            FileNameMatcher matcher = (FileNameMatcher)association.getFirst();
            if (type != null) {
                FileType newFileType;
                if (PlainTextFileType.INSTANCE == type && (newFileType = (FileType)this.myPatternsTable.findAssociatedFileType(matcher)) != null && newFileType != PlainTextFileType.INSTANCE && newFileType != UnknownFileType.INSTANCE) {
                    this.myRemovedMappings.put(matcher, (Pair<FileType, Boolean>)Pair.create((Object)newFileType, (Object)false));
                }
                this.associate(type, matcher, false);
                if (!isAddToInit) continue;
                this.myInitialAssociations.addAssociation(matcher, (Object)type);
                continue;
            }
            this.myUnresolvedMappings.put(matcher, (String)association.getSecond());
        }
        List<Trinity<FileNameMatcher, String, Boolean>> removedAssociations = AbstractFileType.readRemovedAssociations(e);
        for (Trinity<FileNameMatcher, String, Boolean> trinity : removedAssociations) {
            FileType type = this.getFileTypeByName((String)trinity.getSecond());
            FileNameMatcher matcher = (FileNameMatcher)trinity.getFirst();
            if (type != null) {
                this.removeAssociation(type, matcher, false);
                this.myRemovedMappings.put(matcher, (Pair<FileType, Boolean>)Pair.create((Object)type, (Object)trinity.third));
                continue;
            }
            this.myUnresolvedRemovedMappings.put(matcher, (Trinity<String, String, Boolean>)Trinity.create((Object)trinity.getSecond(), (Object)this.myUnresolvedMappings.get(matcher), (Object)trinity.getThird()));
        }
    }

    private void addIgnore(@NonNls @NotNull String ignoreMask) {
        this.myIgnoredPatterns.addIgnoreMask(ignoreMask);
    }

    private void restoreStandardFileExtensions() {
        for (String name : FILE_TYPES_WITH_PREDEFINED_EXTENSIONS) {
            StandardFileType stdFileType = this.myStandardFileTypes.get(name);
            if (stdFileType == null) continue;
            FileType fileType = stdFileType.fileType;
            for (FileNameMatcher matcher : this.myPatternsTable.getAssociations((Object)fileType)) {
                FileType defaultFileType = (FileType)this.myInitialAssociations.findAssociatedFileType(matcher);
                if (defaultFileType == null || defaultFileType == fileType) continue;
                this.removeAssociation(fileType, matcher, false);
                this.associate(defaultFileType, matcher, false);
            }
            for (FileNameMatcher matcher : this.myInitialAssociations.getAssociations((Object)fileType)) {
                this.associate(fileType, matcher, false);
            }
        }
    }

    @NotNull
    public Element getState() {
        String ignoreFiles;
        Element state = new Element("state");
        Set masks = this.myIgnoredPatterns.getIgnoreMasks();
        if (masks.isEmpty()) {
            ignoreFiles = "";
        } else {
            Object[] strings = ArrayUtil.toStringArray((Collection)masks);
            Arrays.sort(strings);
            ignoreFiles = StringUtil.join((String[])strings, (String)";") + ";";
        }
        if (!ignoreFiles.equalsIgnoreCase(DEFAULT_IGNORED)) {
            state.addContent(new Element(ELEMENT_IGNORE_FILES).setAttribute(ATTRIBUTE_LIST, ignoreFiles));
        }
        Element map2 = new Element("extensionMap");
        ArrayList<FileType> notExternalizableFileTypes = new ArrayList<FileType>();
        for (FileType fileType : this.mySchemeManager.getAllSchemes()) {
            if (fileType instanceof AbstractFileType && !this.myDefaultTypes.contains(fileType)) continue;
            notExternalizableFileTypes.add(fileType);
        }
        if (!notExternalizableFileTypes.isEmpty()) {
            Collections.sort(notExternalizableFileTypes, Comparator.comparing(FileType::getName));
            for (FileType fileType : notExternalizableFileTypes) {
                this.writeExtensionsMap(map2, fileType, true);
            }
        }
        for (Map.Entry entry : this.myRemovedMappings.entrySet()) {
            Pair value = (Pair)entry.getValue();
            Element content = AbstractFileType.writeRemovedMapping((FileType)value.first, (FileNameMatcher)entry.getKey(), true, (Boolean)value.second);
            if (content == null) continue;
            map2.addContent(content);
        }
        if (!this.myUnresolvedMappings.isEmpty()) {
            FileNameMatcher[] unresolvedMappingKeys = this.myUnresolvedMappings.keySet().toArray(new FileNameMatcher[0]);
            Arrays.sort(unresolvedMappingKeys, Comparator.comparing(FileNameMatcher::getPresentableString));
            for (FileNameMatcher fileNameMatcher : unresolvedMappingKeys) {
                Element content = AbstractFileType.writeMapping(this.myUnresolvedMappings.get(fileNameMatcher), fileNameMatcher, true);
                if (content == null) continue;
                map2.addContent(content);
            }
        }
        if (!map2.getChildren().isEmpty()) {
            state.addContent(map2);
        }
        if (!state.getChildren().isEmpty()) {
            state.setAttribute(ATTRIBUTE_VERSION, String.valueOf(17));
        }
        return state;
    }

    private void writeExtensionsMap(@NotNull Element map2, @NotNull FileType type, boolean specifyTypeName) {
        List associations = this.myPatternsTable.getAssociations((Object)type);
        THashSet defaultAssociations = new THashSet((Collection)this.myInitialAssociations.getAssociations((Object)type));
        for (FileNameMatcher matcher : associations) {
            Element content;
            boolean isDefaultAssociationContains = defaultAssociations.remove(matcher);
            if (isDefaultAssociationContains || !FileTypeManagerImpl.shouldSave(type) || (content = AbstractFileType.writeMapping(type.getName(), matcher, specifyTypeName)) == null) continue;
            map2.addContent(content);
        }
        for (FileNameMatcher matcher : defaultAssociations) {
            Element content = AbstractFileType.writeRemovedMapping(type, matcher, specifyTypeName, this.isApproved(matcher));
            if (content == null) continue;
            map2.addContent(content);
        }
    }

    private boolean isApproved(@NotNull FileNameMatcher matcher) {
        Pair<FileType, Boolean> pair = this.myRemovedMappings.get(matcher);
        return pair != null && (Boolean)pair.getSecond() != false;
    }

    @Nullable
    private FileType getFileTypeByName(@NotNull String name) {
        return this.mySchemeManager.findSchemeByName(name);
    }

    @NotNull
    private static List<FileNameMatcher> parse(@Nullable String semicolonDelimited) {
        if (semicolonDelimited == null) {
            return Collections.emptyList();
        }
        StringTokenizer tokenizer = new StringTokenizer(semicolonDelimited, ";", false);
        ArrayList<FileNameMatcher> list2 = new ArrayList<FileNameMatcher>(semicolonDelimited.length() / "py;".length());
        while (tokenizer.hasMoreTokens()) {
            list2.add((FileNameMatcher)new ExtensionFileNameMatcher(tokenizer.nextToken().trim()));
        }
        return list2;
    }

    private void registerFileTypeWithoutNotification(@NotNull FileType fileType, @NotNull List<? extends FileNameMatcher> matchers, boolean addScheme) {
        if (addScheme) {
            this.mySchemeManager.addScheme(fileType);
        }
        for (FileNameMatcher fileNameMatcher : matchers) {
            this.myPatternsTable.addAssociation(fileNameMatcher, (Object)fileType);
            this.myInitialAssociations.addAssociation(fileNameMatcher, (Object)fileType);
        }
        if (fileType instanceof FileTypeIdentifiableByVirtualFile) {
            this.mySpecialFileTypes = (FileTypeIdentifiableByVirtualFile[])ArrayUtil.append((Object[])this.mySpecialFileTypes, (Object)((FileTypeIdentifiableByVirtualFile)fileType), (ArrayFactory)FileTypeIdentifiableByVirtualFile.ARRAY_FACTORY);
        }
    }

    private void bindUnresolvedMappings(@NotNull FileType fileType) {
        for (FileNameMatcher matcher : new THashSet(this.myUnresolvedMappings.keySet())) {
            String name = this.myUnresolvedMappings.get(matcher);
            if (!Comparing.equal((String)name, (String)fileType.getName())) continue;
            this.myPatternsTable.addAssociation(matcher, (Object)fileType);
            this.myUnresolvedMappings.remove(matcher);
        }
        for (FileNameMatcher matcher : new THashSet(this.myUnresolvedRemovedMappings.keySet())) {
            Trinity<String, String, Boolean> trinity = this.myUnresolvedRemovedMappings.get(matcher);
            if (!Comparing.equal((String)((String)trinity.getFirst()), (String)fileType.getName())) continue;
            this.removeAssociation(fileType, matcher, false);
            this.myUnresolvedRemovedMappings.remove(matcher);
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    private FileType loadFileType(@NotNull Element typeElement, boolean isDefault) {
        FileType type;
        String fileTypeName = typeElement.getAttributeValue(ATTRIBUTE_NAME);
        String fileTypeDescr = typeElement.getAttributeValue(ATTRIBUTE_DESCRIPTION);
        String iconPath = typeElement.getAttributeValue("icon");
        String extensionsStr = StringUtil.nullize((String)typeElement.getAttributeValue("extensions"));
        if (isDefault && extensionsStr != null) {
            extensionsStr = this.filterAlreadyRegisteredExtensions(extensionsStr);
        }
        FileType fileType = type = isDefault ? this.getFileTypeByName(fileTypeName) : null;
        if (type != null) {
            return type;
        }
        Element element = typeElement.getChild("highlighting");
        if (element == null) {
            CustomFileTypeFactory factory;
            void var11_13;
            CustomFileTypeFactory[] customFileTypeFactoryArray = (CustomFileTypeFactory[])CustomFileTypeFactory.EP_NAME.getExtensions();
            int n = customFileTypeFactoryArray.length;
            boolean i = false;
            while (var11_13 < n && (type = (factory = customFileTypeFactoryArray[var11_13]).createFileType(typeElement)) == null) {
                ++var11_13;
            }
            if (type == null) {
                type = new UserBinaryFileType();
            }
        } else {
            SyntaxTable table = AbstractFileType.readSyntaxTable(element);
            type = new AbstractFileType(table);
            ((AbstractFileType)type).initSupport();
        }
        FileTypeManagerImpl.setFileTypeAttributes((UserFileType)type, fileTypeName, fileTypeDescr, iconPath);
        this.registerFileTypeWithoutNotification(type, FileTypeManagerImpl.parse(extensionsStr), isDefault);
        if (isDefault) {
            this.myDefaultTypes.add(type);
            if (type instanceof ExternalizableFileType) {
                ((ExternalizableFileType)type).markDefaultSettings();
            }
        } else {
            Element extensions = typeElement.getChild("extensionMap");
            if (extensions != null) {
                for (Pair<FileNameMatcher, String> pair : AbstractFileType.readAssociations(extensions)) {
                    this.associate(type, (FileNameMatcher)pair.getFirst(), false);
                }
                for (Trinity trinity : AbstractFileType.readRemovedAssociations(extensions)) {
                    this.removeAssociation(type, (FileNameMatcher)trinity.getFirst(), false);
                }
            }
        }
        return type;
    }

    @Nullable
    private String filterAlreadyRegisteredExtensions(@NotNull String semicolonDelimited) {
        StringTokenizer tokenizer = new StringTokenizer(semicolonDelimited, ";", false);
        StringBuilder builder2 = null;
        while (tokenizer.hasMoreTokens()) {
            String extension = tokenizer.nextToken().trim();
            if (this.getFileTypeByExtension(extension) != UnknownFileType.INSTANCE) continue;
            if (builder2 == null) {
                builder2 = new StringBuilder();
            } else if (builder2.length() > 0) {
                builder2.append(";");
            }
            builder2.append(extension);
        }
        return builder2 == null ? null : builder2.toString();
    }

    private static void setFileTypeAttributes(@NotNull UserFileType fileType, @Nullable String name, @Nullable String description, @Nullable String iconPath) {
        if (!StringUtil.isEmptyOrSpaces((String)iconPath)) {
            fileType.setIcon(IconLoader.getIcon((String)iconPath));
        }
        if (description != null) {
            fileType.setDescription(description);
        }
        if (name != null) {
            fileType.setName(name);
        }
    }

    private static boolean shouldSave(@NotNull FileType fileType) {
        return fileType != UnknownFileType.INSTANCE && !fileType.isReadOnly();
    }

    @NotNull
    FileTypeAssocTable<FileType> getExtensionMap() {
        return this.myPatternsTable;
    }

    void setPatternsTable(@NotNull Set<? extends FileType> fileTypes, @NotNull FileTypeAssocTable<FileType> assocTable) {
        this.fireBeforeFileTypesChanged();
        for (FileType existing : this.getRegisteredFileTypes()) {
            if (fileTypes.contains(existing)) continue;
            this.mySchemeManager.removeScheme(existing);
        }
        for (FileType fileType : fileTypes) {
            this.mySchemeManager.addScheme(fileType);
            if (!(fileType instanceof AbstractFileType)) continue;
            ((AbstractFileType)fileType).initSupport();
        }
        this.myPatternsTable = assocTable.copy();
        this.fireFileTypesChanged();
    }

    public void associate(@NotNull FileType fileType, @NotNull FileNameMatcher matcher, boolean fireChange) {
        if (!this.myPatternsTable.isAssociatedWith((Object)fileType, matcher)) {
            if (fireChange) {
                this.fireBeforeFileTypesChanged();
            }
            this.myPatternsTable.addAssociation(matcher, (Object)fileType);
            if (fireChange) {
                this.fireFileTypesChanged();
            }
        }
    }

    public void removeAssociation(@NotNull FileType fileType, @NotNull FileNameMatcher matcher, boolean fireChange) {
        if (this.myPatternsTable.isAssociatedWith((Object)fileType, matcher)) {
            if (fireChange) {
                this.fireBeforeFileTypesChanged();
            }
            this.myPatternsTable.removeAssociation(matcher, (Object)fileType);
            if (fireChange) {
                this.fireFileTypesChanged();
            }
        }
    }

    @Nullable
    public FileType getKnownFileTypeOrAssociate(@NotNull VirtualFile file2) {
        FileType type = file2.getFileType();
        if (type == UnknownFileType.INSTANCE) {
            type = FileTypeChooser.associateFileType(file2.getName());
        }
        return type;
    }

    public FileType getKnownFileTypeOrAssociate(@NotNull VirtualFile file2, @NotNull Project project) {
        return FileTypeChooser.getKnownFileTypeOrAssociate(file2, project);
    }

    private void registerReDetectedMappings(@NotNull StandardFileType pair) {
        FileType fileType = pair.fileType;
        if (fileType == PlainTextFileType.INSTANCE) {
            return;
        }
        for (FileNameMatcher matcher : pair.matchers) {
            this.registerReDetectedMapping(fileType, matcher);
            if (!(matcher instanceof ExtensionFileNameMatcher)) continue;
            ExtensionFileNameMatcher extMatcher = (ExtensionFileNameMatcher)matcher;
            this.registerReDetectedMapping(fileType, (FileNameMatcher)new ExactFileNameMatcher("." + extMatcher.getExtension()));
        }
    }

    private void registerReDetectedMapping(@NotNull FileType fileType, @NotNull FileNameMatcher matcher) {
        String typeName = this.myUnresolvedMappings.get(matcher);
        if (typeName != null && !typeName.equals(fileType.getName())) {
            Trinity<String, String, Boolean> trinity = this.myUnresolvedRemovedMappings.get(matcher);
            this.myRemovedMappings.put(matcher, (Pair<FileType, Boolean>)Pair.create((Object)fileType, (Object)(trinity != null && (Boolean)trinity.third != false ? 1 : 0)));
            this.myUnresolvedMappings.remove(matcher);
        }
    }

    @NotNull
    Map<FileNameMatcher, Pair<FileType, Boolean>> getRemovedMappings() {
        return this.myRemovedMappings;
    }

    void clearForTests() {
        for (StandardFileType fileType : this.myStandardFileTypes.values()) {
            this.myPatternsTable.removeAllAssociations((Object)fileType.fileType);
        }
        this.myStandardFileTypes.clear();
        this.myUnresolvedMappings.clear();
        this.myRemovedMappings.clear();
        this.mySchemeManager.setSchemes(Collections.emptyList());
    }

    public void dispose() {
        LOG.info("FileTypeManager: " + this.counterAutoDetect + " auto-detected files\nElapsed time on auto-detect: " + this.elapsedAutoDetect + " ms");
    }

    static {
        List strings = StringUtil.split((String)DEFAULT_IGNORED, (String)";");
        for (int i = 0; i < strings.size(); ++i) {
            String prev2;
            String string = (String)strings.get(i);
            String string2 = prev2 = i == 0 ? "" : (String)strings.get(i - 1);
            assert (prev2.compareTo(string) < 0) : "DEFAULT_IGNORED must be sorted, but got: '" + prev2 + "' >= '" + string + "'";
        }
        RE_DETECT_ASYNC = !ApplicationManager.getApplication().isUnitTestMode();
        FILE_TYPES_WITH_PREDEFINED_EXTENSIONS = new String[]{"JSP", "JSPX", "DTD", "HTML", "Properties", "XHTML"};
    }

    private static class StandardFileType {
        @NotNull
        private final FileType fileType;
        @NotNull
        private final List<FileNameMatcher> matchers;

        private StandardFileType(@NotNull FileType fileType, @NotNull List<FileNameMatcher> matchers) {
            this.fileType = fileType;
            this.matchers = matchers;
        }
    }
}

