/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileTypes.impl;

import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.LayeredIcon;
import com.intellij.ui.ListCellRendererWrapper;
import com.intellij.util.ui.EmptyIcon;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Pattern;
import javax.swing.Icon;
import javax.swing.JList;
import org.jetbrains.annotations.NotNull;

public class FileTypeRenderer
extends ListCellRendererWrapper<FileType> {
    private static final Icon EMPTY_ICON = EmptyIcon.ICON_18;
    private static final Pattern CLEANUP = Pattern.compile("(?i)\\s+file(?:s)?$");
    private final FileTypeListProvider myFileTypeListProvider;

    public FileTypeRenderer() {
        this(new DefaultFileTypeListProvider());
    }

    public FileTypeRenderer(@NotNull FileTypeListProvider fileTypeListProvider) {
        this.myFileTypeListProvider = fileTypeListProvider;
    }

    public void customize(JList list2, FileType type, int index, boolean selected, boolean hasFocus) {
        LayeredIcon layeredIcon = new LayeredIcon(2);
        layeredIcon.setIcon(EMPTY_ICON, 0);
        Icon icon = type.getIcon();
        if (icon != null) {
            layeredIcon.setIcon(icon, 1, (-icon.getIconWidth() + EMPTY_ICON.getIconWidth()) / 2, (EMPTY_ICON.getIconHeight() - icon.getIconHeight()) / 2);
        }
        this.setIcon((Icon)layeredIcon);
        String description = type.getDescription();
        String trimmedDescription = StringUtil.capitalizeWords((String)CLEANUP.matcher(description).replaceAll(""), (boolean)true);
        if (this.isDuplicated(description)) {
            this.setText(trimmedDescription + " (" + type.getName() + ")");
        } else {
            this.setText(trimmedDescription);
        }
    }

    private boolean isDuplicated(String description) {
        boolean found = false;
        for (FileType type : this.myFileTypeListProvider.getCurrentFileTypeList()) {
            if (!description.equals(type.getDescription())) continue;
            if (!found) {
                found = true;
                continue;
            }
            return true;
        }
        return false;
    }

    private static class DefaultFileTypeListProvider
    implements FileTypeListProvider {
        private final List<FileType> myFileTypes = Arrays.asList(FileTypeManager.getInstance().getRegisteredFileTypes());

        DefaultFileTypeListProvider() {
        }

        @Override
        public Iterable<FileType> getCurrentFileTypeList() {
            return this.myFileTypes;
        }
    }

    public static interface FileTypeListProvider {
        public Iterable<FileType> getCurrentFileTypeList();
    }
}

