/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.keymap.impl;

import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.util.io.FileUtilRt;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;

public interface BundledKeymapProvider {
    public static final ExtensionPointName<BundledKeymapProvider> EP_NAME = ExtensionPointName.create((String)"com.intellij.bundledKeymapProvider");

    @NotNull
    public List<String> getKeymapFileNames();

    default public <R> R load(@NotNull String key, @NotNull Function<? super InputStream, ? extends R> consumer) throws IOException {
        try (InputStream stream = BundledKeymapProvider.class.getResourceAsStream("/keymaps/" + key);){
            R r = consumer.apply(stream);
            return r;
        }
    }

    default public String getKeyFromFileName(String filename) {
        return FileUtilRt.getNameWithoutExtension((String)filename);
    }
}

