/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.keymap.impl.keyGestures;

import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.AnActionEventVisitor;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.KeyboardGestureAction;
import com.intellij.openapi.actionSystem.KeyboardModifierGestureShortcut;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.keymap.impl.ActionProcessor;
import com.intellij.openapi.keymap.impl.IdeKeyEventDispatcher;
import com.intellij.openapi.keymap.impl.KeyState;
import com.intellij.openapi.keymap.impl.keyGestures.KeyGestureState;
import com.intellij.openapi.keymap.impl.keyGestures.StateContext;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.util.ui.UIUtil;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.InputEvent;
import javax.swing.KeyStroke;
import javax.swing.Timer;
import org.jetbrains.annotations.NotNull;

public class KeyboardGestureProcessor {
    IdeKeyEventDispatcher myDispatcher;
    StateContext myContext = new StateContext();
    final KeyGestureState myWaitForStart = new KeyGestureState.WaitForStart(this);
    final KeyGestureState myModifierPressed = new KeyGestureState.ModifierPressed(this);
    final KeyGestureState myWaitForDblClick = new KeyGestureState.WaitForDblClick(this);
    final KeyGestureState myWaitForAction = new KeyGestureState.WaitForAction(this);
    final KeyGestureState myWaitForActionEnd = new KeyGestureState.WaitForActionEnd(this);
    final KeyGestureState myFinish = new KeyGestureState.ProcessFinish(this);
    KeyGestureState myState = this.myWaitForStart;
    final Timer myHoldTimer = UIUtil.createNamedTimer((String)"Keyboard hold", (int)1200, (ActionListener)new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
        }
    });
    final Timer myDblClickTimer = UIUtil.createNamedTimer((String)"Double click", (int)Registry.intValue((String)"actionSystem.keyGestureDblClickTime"), (ActionListener)new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            KeyboardGestureProcessor.this.myState.processDblClickTimer();
        }
    });
    private final ActionProcessor myActionProcessor = new MyActionProcessor();

    public KeyboardGestureProcessor(IdeKeyEventDispatcher dispatcher) {
        this.myDispatcher = dispatcher;
    }

    public boolean process() {
        boolean wasNotInWaitState;
        boolean bl = wasNotInWaitState = this.myState != this.myWaitForStart;
        if (Registry.is((String)"ide.debugMode") && wasNotInWaitState) {
            System.out.println("-- key gesture context: before process, state=" + this.myState);
            System.out.println(this.myContext);
        }
        this.myContext.keyToProcess = this.myDispatcher.getContext().getInputEvent();
        this.myContext.isModal = this.myDispatcher.getContext().isModalContext();
        this.myContext.dataContext = this.myDispatcher.getContext().getDataContext();
        boolean result2 = this.myState.process();
        if (Registry.is((String)"ide.debugMode") && (wasNotInWaitState || this.myState != this.myWaitForStart)) {
            System.out.println("-- key gesture context: after process, state=" + this.myState);
            System.out.println(this.myContext);
        }
        return result2;
    }

    public boolean processInitState() {
        if (!Registry.is((String)"actionSystem.keyGestures.enabled")) {
            return false;
        }
        this.myContext.focusOwner = this.myDispatcher.getContext().getFocusOwner();
        return this.process();
    }

    void executeAction() {
        this.myDispatcher.updateCurrentContext(this.myContext.focusOwner, this.getCurrentShortcut(), this.myContext.isModal);
        this.myDispatcher.processAction(this.myContext.keyToProcess, this.myActionProcessor);
    }

    @NotNull
    private Shortcut getCurrentShortcut() {
        return KeyboardModifierGestureShortcut.newInstance((KeyboardGestureAction.ModifierType)this.myContext.modifierType, (KeyStroke)this.myContext.actionShortcut);
    }

    void setState(KeyGestureState state) {
        boolean isGestureProcessingState;
        boolean bl = isGestureProcessingState = this.myDispatcher.getState() == KeyState.STATE_KEY_GESTURE_PROCESSOR;
        if (state == this.myWaitForStart) {
            this.myContext.actionKey = null;
            if (isGestureProcessingState) {
                this.myDispatcher.setState(KeyState.STATE_INIT);
            }
        } else if (state == this.myWaitForAction) {
            this.myDispatcher.setState(KeyState.STATE_KEY_GESTURE_PROCESSOR);
        }
        this.myState = state;
    }

    private class MyActionProcessor
    implements ActionProcessor {
        private MyActionProcessor() {
        }

        @Override
        @NotNull
        public AnActionEvent createEvent(InputEvent inputEvent, @NotNull DataContext context, @NotNull String place, @NotNull Presentation presentation, @NotNull ActionManager manager) {
            KeyboardGestureProcessor.this.myContext.actionPresentation = presentation;
            KeyboardGestureProcessor.this.myContext.actionPlace = place;
            return KeyboardGestureProcessor.this.myState.createActionEvent();
        }

        @Override
        public void onUpdatePassed(InputEvent inputEvent, @NotNull AnAction action, @NotNull AnActionEvent actionEvent) {
        }

        @Override
        public void performAction(final InputEvent e, final @NotNull AnAction action, @NotNull AnActionEvent actionEvent) {
            final boolean isGestureAction = action instanceof KeyboardGestureAction;
            actionEvent.accept(new AnActionEventVisitor(){

                public void visitGestureInitEvent(@NotNull AnActionEvent anActionEvent) {
                    if (isGestureAction) {
                        MyActionProcessor.this.execute(anActionEvent, action, e);
                    }
                }

                public void visitGesturePerformedEvent(@NotNull AnActionEvent anActionEvent) {
                    MyActionProcessor.this.execute(anActionEvent, action, e);
                }

                public void visitGestureFinishEvent(@NotNull AnActionEvent anActionEvent) {
                    if (isGestureAction) {
                        MyActionProcessor.this.execute(anActionEvent, action, e);
                    }
                }
            });
        }

        private void execute(AnActionEvent anActionEvent, AnAction action, InputEvent e) {
            action.actionPerformed(anActionEvent);
            e.consume();
        }
    }
}

