/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.keymap.impl.ui;

import com.intellij.diagnostic.VMOptions;
import com.intellij.icons.AllIcons;
import com.intellij.ide.CommonActionsManager;
import com.intellij.ide.DataManager;
import com.intellij.ide.TreeExpander;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AbbreviationManager;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonShortcuts;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.KeyboardShortcut;
import com.intellij.openapi.actionSystem.MouseShortcut;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.actionSystem.ex.QuickList;
import com.intellij.openapi.actionSystem.ex.QuickListsManager;
import com.intellij.openapi.actionSystem.impl.ActionToolbarImpl;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.keymap.KeyMapBundle;
import com.intellij.openapi.keymap.KeyboardSettingsExternalizable;
import com.intellij.openapi.keymap.Keymap;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.keymap.impl.ActionShortcutRestrictions;
import com.intellij.openapi.keymap.impl.KeymapImpl;
import com.intellij.openapi.keymap.impl.ShortcutRestrictions;
import com.intellij.openapi.keymap.impl.ui.ActionsTree;
import com.intellij.openapi.keymap.impl.ui.KeyboardShortcutDialog;
import com.intellij.openapi.keymap.impl.ui.KeymapListener;
import com.intellij.openapi.keymap.impl.ui.KeymapSchemeManager;
import com.intellij.openapi.keymap.impl.ui.KeymapSelector;
import com.intellij.openapi.keymap.impl.ui.MouseShortcutDialog;
import com.intellij.openapi.keymap.impl.ui.ShortcutFilteringPanel;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.packageDependencies.ui.TreeExpansionMonitor;
import com.intellij.ui.DoubleClickListener;
import com.intellij.ui.FilterComponent;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.mac.foundation.NSDefaults;
import com.intellij.ui.mac.touchbar.TouchBarsManager;
import com.intellij.ui.mac.touchbar.Utils;
import com.intellij.util.Alarm;
import com.intellij.util.ui.EmptyIcon;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.tree.TreeUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.InputEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class KeymapPanel
extends JPanel
implements SearchableConfigurable,
Configurable.NoScroll,
KeymapListener,
Disposable {
    private JCheckBox preferKeyPositionOverCharOption;
    private final KeymapSchemeManager myManager = new KeymapSelector(this::currentKeymapChanged).getManager();
    private final ActionsTree myActionsTree = new ActionsTree();
    private FilterComponent myFilterComponent;
    private TreeExpansionMonitor myTreeExpansionMonitor;
    private final ShortcutFilteringPanel myFilteringPanel = new ShortcutFilteringPanel();
    private boolean myQuickListsModified = false;
    private QuickList[] myQuickLists = QuickListsManager.getInstance().getAllQuickLists();
    private ShowFNKeysSettingWrapper myShowFN;

    public KeymapPanel() {
        this.setLayout(new BorderLayout());
        JPanel keymapPanel = new JPanel(new BorderLayout());
        keymapPanel.add(this.myManager.getSchemesPanel(), "North");
        keymapPanel.add((Component)this.createKeymapSettingsPanel(), "Center");
        IdeFrame ideFrame = IdeFocusManager.getGlobalInstance().getLastFocusedFrame();
        if (ideFrame != null && KeyboardSettingsExternalizable.isSupportedKeyboardLayout((Component)ideFrame.getComponent())) {
            this.preferKeyPositionOverCharOption = new JCheckBox(new AbstractAction(" " + KeyMapBundle.message((String)"prefer.key.position", (Object[])new Object[0])){

                @Override
                public void actionPerformed(ActionEvent e) {
                    KeyboardSettingsExternalizable.getInstance().setPreferKeyPositionOverCharOption(KeymapPanel.this.preferKeyPositionOverCharOption.isSelected());
                    VMOptions.writeOption("com.jetbrains.use.old.keyevent.processing", "=", Boolean.toString(KeyboardSettingsExternalizable.getInstance().isPreferKeyPositionOverCharOption()));
                    ApplicationManager.getApplication().invokeLater(() -> ApplicationManager.getApplication().restart(), ModalityState.NON_MODAL);
                }
            });
            this.preferKeyPositionOverCharOption.setBorder((Border)JBUI.Borders.empty());
            keymapPanel.add((Component)this.preferKeyPositionOverCharOption, "South");
        }
        this.add((Component)keymapPanel, "Center");
        this.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(@NotNull PropertyChangeEvent evt) {
                if (evt.getPropertyName().equals("ancestor") && evt.getNewValue() != null && evt.getOldValue() == null && KeymapPanel.this.myQuickListsModified) {
                    KeymapPanel.this.currentKeymapChanged();
                    KeymapPanel.this.myQuickListsModified = false;
                }
            }
        });
        this.myFilteringPanel.addPropertyChangeListener("shortcut", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent event) {
                KeymapPanel.this.filterTreeByShortcut(KeymapPanel.this.myFilteringPanel.getShortcut());
            }
        });
    }

    @Override
    public void updateUI() {
        super.updateUI();
        if (this.myFilteringPanel != null) {
            SwingUtilities.updateComponentTreeUI(this.myFilteringPanel);
        }
    }

    @Override
    public void quickListRenamed(@NotNull QuickList oldQuickList, @NotNull QuickList newQuickList) {
        this.myManager.visitMutableKeymaps(keymap -> {
            String actionId = oldQuickList.getActionId();
            Shortcut[] shortcuts = keymap.getShortcuts(actionId);
            if (shortcuts.length != 0) {
                String newActionId = newQuickList.getActionId();
                for (Shortcut shortcut : shortcuts) {
                    keymap.removeShortcut(actionId, shortcut);
                    keymap.addShortcut(newActionId, shortcut);
                }
            }
        });
        this.myQuickListsModified = true;
    }

    public Runnable enableSearch(String option2) {
        return () -> this.showOption(option2);
    }

    @Override
    public void processCurrentKeymapChanged() {
        this.currentKeymapChanged();
    }

    @Override
    public void processCurrentKeymapChanged(@NotNull QuickList[] ids) {
        this.myQuickLists = ids;
        this.currentKeymapChanged();
    }

    private void currentKeymapChanged() {
        this.currentKeymapChanged(this.myManager.getSelectedKeymap());
    }

    private void currentKeymapChanged(Keymap selectedKeymap) {
        if (selectedKeymap == null) {
            selectedKeymap = new KeymapImpl();
        }
        this.myActionsTree.reset(selectedKeymap, this.myQuickLists);
    }

    private JPanel createKeymapSettingsPanel() {
        JPanel panel2 = new JPanel();
        panel2.setLayout(new BorderLayout());
        panel2.add((Component)this.createToolbarPanel(), "North");
        panel2.add((Component)this.myActionsTree.getComponent(), "Center");
        this.myTreeExpansionMonitor = TreeExpansionMonitor.install(this.myActionsTree.getTree());
        new DoubleClickListener(){

            protected boolean onDoubleClick(MouseEvent e) {
                KeymapPanel.this.editSelection(e, true);
                return true;
            }
        }.installOn((Component)this.myActionsTree.getTree());
        this.myActionsTree.getTree().addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(@NotNull MouseEvent e) {
                if (e.isPopupTrigger()) {
                    KeymapPanel.this.editSelection(e, false);
                    e.consume();
                }
            }

            @Override
            public void mouseReleased(@NotNull MouseEvent e) {
                if (e.isPopupTrigger()) {
                    KeymapPanel.this.editSelection(e, false);
                    e.consume();
                }
            }
        });
        if (TouchBarsManager.isTouchBarAvailable()) {
            this.myShowFN = new ShowFNKeysSettingWrapper();
            if (this.myShowFN.getCheckbox() != null) {
                panel2.add((Component)this.myShowFN.getCheckbox(), "South");
            }
            Disposer.register((Disposable)this, (Disposable)this.myShowFN);
        }
        return panel2;
    }

    private JPanel createToolbarPanel() {
        JPanel panel2 = new JPanel(new GridBagLayout());
        DefaultActionGroup group = new DefaultActionGroup();
        JComponent toolbar = ActionManager.getInstance().createActionToolbar("KeymapEdit", (ActionGroup)group, true).getComponent();
        CommonActionsManager commonActionsManager = CommonActionsManager.getInstance();
        TreeExpander treeExpander = KeymapPanel.createTreeExpander(this.myActionsTree);
        group.add(commonActionsManager.createExpandAllAction(treeExpander, (JComponent)this.myActionsTree.getTree()));
        group.add(commonActionsManager.createCollapseAllAction(treeExpander, (JComponent)this.myActionsTree.getTree()));
        group.add(new AnAction("Edit Shortcut", "Edit Shortcut", AllIcons.Actions.Edit){
            {
                this.registerCustomShortcutSet(CommonShortcuts.ENTER, KeymapPanel.this.myActionsTree.getTree());
            }

            public void update(@NotNull AnActionEvent e) {
                String actionId = KeymapPanel.this.myActionsTree.getSelectedActionId();
                e.getPresentation().setEnabled(actionId != null);
            }

            public void actionPerformed(@NotNull AnActionEvent e) {
                KeymapPanel.this.editSelection(e.getInputEvent(), false);
            }
        });
        panel2.add((Component)toolbar, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 0, (Insets)JBUI.insetsTop((int)8), 0, 0));
        group = new DefaultActionGroup();
        ActionToolbar actionToolbar = ActionManager.getInstance().createActionToolbar("Keymap", (ActionGroup)group, true);
        actionToolbar.setReservePlaceAutoPopupIcon(false);
        final JComponent searchToolbar = actionToolbar.getComponent();
        final Alarm alarm = new Alarm();
        this.myFilterComponent = new FilterComponent("KEYMAP", 5){

            public void filter() {
                alarm.cancelAllRequests();
                alarm.addRequest(() -> {
                    if (!KeymapPanel.this.myFilterComponent.isShowing()) {
                        return;
                    }
                    KeymapPanel.this.myTreeExpansionMonitor.freeze();
                    KeymapPanel.this.myFilteringPanel.setShortcut(null);
                    String filter = this.getFilter();
                    KeymapPanel.this.myActionsTree.filter(filter, KeymapPanel.this.myQuickLists);
                    JTree tree = KeymapPanel.this.myActionsTree.getTree();
                    TreeUtil.expandAll((JTree)tree);
                    if (filter == null || filter.length() == 0) {
                        TreeUtil.collapseAll((JTree)tree, (int)0);
                        KeymapPanel.this.myTreeExpansionMonitor.restore();
                    } else {
                        KeymapPanel.this.myTreeExpansionMonitor.unfreeze();
                    }
                }, 300);
            }
        };
        this.myFilterComponent.reset();
        panel2.add((Component)this.myFilterComponent, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 13, 0, (Insets)JBUI.insetsTop((int)8), 0, 0));
        group.add((AnAction)new DumbAwareAction(KeyMapBundle.message((String)"filter.shortcut.action.text", (Object[])new Object[0]), KeyMapBundle.message((String)"filter.shortcut.action.text", (Object[])new Object[0]), AllIcons.Actions.ShortcutFilter){

            public void actionPerformed(@NotNull AnActionEvent e) {
                KeymapPanel.this.myFilterComponent.reset();
                KeymapPanel.this.currentKeymapChanged();
                KeymapPanel.this.myFilteringPanel.showPopup(searchToolbar, e.getInputEvent().getComponent());
            }
        });
        group.add((AnAction)new DumbAwareAction(KeyMapBundle.message((String)"filter.clear.action.text", (Object[])new Object[0]), KeyMapBundle.message((String)"filter.clear.action.text", (Object[])new Object[0]), AllIcons.Actions.GC){

            public void update(@NotNull AnActionEvent event) {
                boolean enabled = null != KeymapPanel.this.myFilteringPanel.getShortcut();
                Presentation presentation = event.getPresentation();
                presentation.setEnabled(enabled);
                presentation.setIcon(enabled ? AllIcons.Actions.Cancel : EmptyIcon.ICON_16);
            }

            public void actionPerformed(@NotNull AnActionEvent e) {
                KeymapPanel.this.myTreeExpansionMonitor.freeze();
                KeymapPanel.this.myFilteringPanel.setShortcut(null);
                KeymapPanel.this.myActionsTree.filter(null, KeymapPanel.this.myQuickLists);
                TreeUtil.collapseAll((JTree)KeymapPanel.this.myActionsTree.getTree(), (int)0);
                KeymapPanel.this.myTreeExpansionMonitor.restore();
            }
        });
        panel2.add((Component)searchToolbar, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 13, 0, (Insets)JBUI.insetsTop((int)8), 0, 0));
        return panel2;
    }

    @NotNull
    public static TreeExpander createTreeExpander(final ActionsTree actionsTree) {
        return new TreeExpander(){

            public void expandAll() {
                TreeUtil.expandAll((JTree)actionsTree.getTree());
            }

            public boolean canExpand() {
                return true;
            }

            public void collapseAll() {
                TreeUtil.collapseAll((JTree)actionsTree.getTree(), (int)0);
            }

            public boolean canCollapse() {
                return true;
            }
        };
    }

    private void filterTreeByShortcut(Shortcut shortcut) {
        boolean wasFreezed = this.myTreeExpansionMonitor.isFreeze();
        if (!wasFreezed) {
            this.myTreeExpansionMonitor.freeze();
        }
        this.myActionsTree.filterTree(shortcut, this.myQuickLists);
        JTree tree = this.myActionsTree.getTree();
        TreeUtil.expandAll((JTree)tree);
        if (!wasFreezed) {
            this.myTreeExpansionMonitor.restore();
        }
    }

    public void showOption(String option2) {
        this.currentKeymapChanged();
        this.myFilterComponent.setFilter(option2);
        this.myFilteringPanel.setShortcut(null);
        this.myActionsTree.filter(option2, this.myQuickLists);
    }

    public static void addKeyboardShortcut(@NotNull String actionId, @NotNull ShortcutRestrictions restrictions, @NotNull Keymap keymapSelected, @NotNull Component parent, QuickList ... quickLists) {
        if (!restrictions.allowKeyboardShortcut) {
            return;
        }
        KeyboardShortcutDialog dialog2 = new KeyboardShortcutDialog(parent, restrictions.allowKeyboardSecondStroke);
        KeyboardShortcut keyboardShortcut = (KeyboardShortcut)dialog2.showAndGet(actionId, keymapSelected, quickLists);
        if (keyboardShortcut == null) {
            return;
        }
        SafeKeymapAccessor accessor = new SafeKeymapAccessor(parent, keymapSelected);
        if (dialog2.hasConflicts()) {
            int result2 = KeymapPanel.showConfirmationDialog(parent);
            if (result2 == 0) {
                Keymap keymap = accessor.keymap();
                Map conflicts = keymap.getConflicts(actionId, keyboardShortcut);
                for (String id : conflicts.keySet()) {
                    for (KeyboardShortcut s : (List)conflicts.get(id)) {
                        keymap.removeShortcut(id, (Shortcut)s);
                    }
                }
            } else if (result2 != 1) {
                return;
            }
        }
        accessor.add(actionId, (Shortcut)keyboardShortcut);
    }

    private static void addMouseShortcut(@NotNull String actionId, @NotNull ShortcutRestrictions restrictions, @NotNull Keymap keymapSelected, @NotNull Component parent, QuickList ... quickLists) {
        if (!restrictions.allowMouseShortcut) {
            return;
        }
        MouseShortcutDialog dialog2 = new MouseShortcutDialog(parent, restrictions.allowMouseDoubleClick);
        MouseShortcut mouseShortcut = (MouseShortcut)dialog2.showAndGet(actionId, keymapSelected, quickLists);
        if (mouseShortcut == null) {
            return;
        }
        SafeKeymapAccessor accessor = new SafeKeymapAccessor(parent, keymapSelected);
        if (dialog2.hasConflicts()) {
            int result2 = KeymapPanel.showConfirmationDialog(parent);
            if (result2 == 0) {
                String[] actionIds;
                Keymap keymap = accessor.keymap();
                for (String id : actionIds = keymap.getActionIds(mouseShortcut)) {
                    keymap.removeShortcut(id, (Shortcut)mouseShortcut);
                }
            } else if (result2 != 1) {
                return;
            }
        }
        accessor.add(actionId, (Shortcut)mouseShortcut);
    }

    private void repaintLists() {
        this.myActionsTree.getComponent().repaint();
    }

    @NotNull
    public String getId() {
        return "preferences.keymap";
    }

    public void reset() {
        if (this.preferKeyPositionOverCharOption != null) {
            this.preferKeyPositionOverCharOption.setSelected(KeyboardSettingsExternalizable.getInstance().isPreferKeyPositionOverCharOption());
        }
        this.myManager.reset();
    }

    public void apply() throws ConfigurationException {
        String error = this.myManager.apply();
        if (error != null) {
            throw new ConfigurationException(error);
        }
        ActionToolbarImpl.updateAllToolbarsImmediately();
        if (this.myShowFN != null) {
            this.myShowFN.applyChanges();
        }
    }

    public boolean isModified() {
        return this.myManager.isModified() || this.myShowFN != null && this.myShowFN.isModified();
    }

    public void selectAction(String actionId) {
        this.myActionsTree.selectAction(actionId);
    }

    @Nls
    public String getDisplayName() {
        return KeyMapBundle.message((String)"keymap.display.name", (Object[])new Object[0]);
    }

    public String getHelpTopic() {
        return "preferences.keymap";
    }

    public JComponent createComponent() {
        ApplicationManager.getApplication().getMessageBus().connect((Disposable)this).subscribe(CHANGE_TOPIC, (Object)this);
        return this;
    }

    public void disposeUIResources() {
        this.myFilteringPanel.hidePopup();
        if (this.myFilterComponent != null) {
            this.myFilterComponent.dispose();
        }
        Disposer.dispose((Disposable)this);
    }

    public void dispose() {
    }

    @Nullable
    public Shortcut[] getCurrentShortcuts(@NotNull String actionId) {
        Keymap keymap = this.myManager.getSelectedKeymap();
        return keymap == null ? null : keymap.getShortcuts(actionId);
    }

    private void editSelection(InputEvent e, boolean isDoubleClick) {
        String actionId = this.myActionsTree.getSelectedActionId();
        if (actionId == null) {
            return;
        }
        Keymap selectedKeymap = this.myManager.getSelectedKeymap();
        if (selectedKeymap == null) {
            return;
        }
        DefaultActionGroup group = this.createEditActionGroup(actionId, selectedKeymap);
        if (e instanceof MouseEvent && ((MouseEvent)e).isPopupTrigger()) {
            ActionManager.getInstance().createActionPopupMenu("unknown", (ActionGroup)group).getComponent().show(e.getComponent(), ((MouseEvent)e).getX(), ((MouseEvent)e).getY());
        } else if (!isDoubleClick || !ActionManager.getInstance().isGroup(actionId)) {
            DataContext dataContext = DataManager.getInstance().getDataContext((Component)this);
            ListPopup popup2 = JBPopupFactory.getInstance().createActionGroupPopup("Edit Shortcuts", (ActionGroup)group, dataContext, JBPopupFactory.ActionSelectionAid.SPEEDSEARCH, true);
            if (e instanceof MouseEvent) {
                popup2.show(new RelativePoint((MouseEvent)e));
            } else {
                popup2.showInBestPositionFor(dataContext);
            }
        }
    }

    @NotNull
    private DefaultActionGroup createEditActionGroup(final @NotNull String actionId, final Keymap selectedKeymap) {
        DefaultActionGroup group = new DefaultActionGroup();
        final ShortcutRestrictions restrictions = ActionShortcutRestrictions.getInstance().getForActionId(actionId);
        if (restrictions.allowKeyboardShortcut) {
            group.add((AnAction)new DumbAwareAction("Add Keyboard Shortcut"){

                public void actionPerformed(@NotNull AnActionEvent e) {
                    KeymapPanel.addKeyboardShortcut(actionId, restrictions, selectedKeymap, KeymapPanel.this, KeymapPanel.this.myQuickLists);
                    KeymapPanel.this.currentKeymapChanged();
                }
            });
        }
        if (restrictions.allowMouseShortcut) {
            group.add((AnAction)new DumbAwareAction("Add Mouse Shortcut"){

                public void actionPerformed(@NotNull AnActionEvent e) {
                    KeymapPanel.addMouseShortcut(actionId, restrictions, selectedKeymap, KeymapPanel.this, KeymapPanel.this.myQuickLists);
                    KeymapPanel.this.currentKeymapChanged();
                }
            });
        }
        if (Registry.is((String)"actionSystem.enableAbbreviations") && restrictions.allowAbbreviation) {
            group.add((AnAction)new DumbAwareAction("Add Abbreviation"){

                public void actionPerformed(@NotNull AnActionEvent e) {
                    String abbr = Messages.showInputDialog((String)"Enter new abbreviation:", (String)"Abbreviation", null);
                    if (abbr != null) {
                        AbbreviationManager.getInstance().register(abbr, actionId);
                        KeymapPanel.this.repaintLists();
                    }
                }
            });
        }
        group.addSeparator();
        for (final Shortcut shortcut : selectedKeymap.getShortcuts(actionId)) {
            group.add((AnAction)new DumbAwareAction("Remove " + KeymapUtil.getShortcutText((Shortcut)shortcut)){

                public void actionPerformed(@NotNull AnActionEvent e) {
                    Keymap keymap = KeymapPanel.this.myManager.getMutableKeymap(selectedKeymap);
                    keymap.removeShortcut(actionId, shortcut);
                    if (StringUtil.startsWithChar((CharSequence)actionId, (char)'$')) {
                        keymap.removeShortcut(KeyMapBundle.message((String)"editor.shortcut", (Object[])new Object[]{actionId.substring(1)}), shortcut);
                    }
                    KeymapPanel.this.currentKeymapChanged();
                }
            });
        }
        if (Registry.is((String)"actionSystem.enableAbbreviations")) {
            for (final String abbreviation : AbbreviationManager.getInstance().getAbbreviations(actionId)) {
                group.addAction((AnAction)new DumbAwareAction("Remove Abbreviation '" + abbreviation + "'"){

                    public void actionPerformed(@NotNull AnActionEvent e) {
                        AbbreviationManager.getInstance().remove(abbreviation, actionId);
                        KeymapPanel.this.repaintLists();
                    }
                });
            }
        }
        if (this.myManager.canResetActionInKeymap(selectedKeymap, actionId)) {
            group.add((AnAction)new Separator());
            group.add((AnAction)new DumbAwareAction("Reset Shortcuts"){

                public void actionPerformed(@NotNull AnActionEvent event) {
                    KeymapPanel.this.myManager.resetActionInKeymap(selectedKeymap, actionId);
                    KeymapPanel.this.repaintLists();
                }
            });
        }
        return group;
    }

    private static int showConfirmationDialog(Component parent) {
        return Messages.showYesNoCancelDialog((Component)parent, (String)KeyMapBundle.message((String)"conflict.shortcut.dialog.message", (Object[])new Object[0]), (String)KeyMapBundle.message((String)"conflict.shortcut.dialog.title", (Object[])new Object[0]), (String)KeyMapBundle.message((String)"conflict.shortcut.dialog.remove.button", (Object[])new Object[0]), (String)KeyMapBundle.message((String)"conflict.shortcut.dialog.leave.button", (Object[])new Object[0]), (String)KeyMapBundle.message((String)"conflict.shortcut.dialog.cancel.button", (Object[])new Object[0]), (Icon)Messages.getWarningIcon());
    }

    private static final class SafeKeymapAccessor {
        private final Component parent;
        private final Keymap selected;
        private KeymapSchemeManager manager;
        private Keymap mutable;

        SafeKeymapAccessor(@NotNull Component parent, @NotNull Keymap selected) {
            this.parent = parent;
            this.selected = selected;
        }

        Keymap keymap() {
            if (this.mutable == null) {
                if (this.parent instanceof KeymapPanel) {
                    KeymapPanel panel2 = (KeymapPanel)this.parent;
                    this.mutable = panel2.myManager.getMutableKeymap(this.selected);
                } else {
                    if (this.manager == null) {
                        this.manager = new KeymapSelector(selectedKeymap -> {}).getManager();
                        this.manager.reset();
                    }
                    this.mutable = this.manager.getMutableKeymap(this.selected);
                }
            }
            return this.mutable;
        }

        void add(@NotNull String actionId, @NotNull Shortcut newShortcut) {
            Shortcut[] shortcuts;
            Keymap keymap = this.keymap();
            for (Shortcut shortcut : shortcuts = keymap.getShortcuts(actionId)) {
                if (!shortcut.equals(newShortcut)) continue;
                if (this.manager != null) {
                    this.manager.apply();
                }
                return;
            }
            keymap.addShortcut(actionId, newShortcut);
            if (StringUtil.startsWithChar((CharSequence)actionId, (char)'$')) {
                keymap.addShortcut(KeyMapBundle.message((String)"editor.shortcut", (Object[])new Object[]{actionId.substring(1)}), newShortcut);
            }
            if (this.manager != null) {
                this.manager.apply();
            }
        }
    }

    private static class ShowFNKeysSettingWrapper
    implements Disposable {
        private boolean myShowFnInitial = false;
        private JCheckBox myCheckbox = null;
        private volatile boolean myDisposed;

        ShowFNKeysSettingWrapper() {
            if (TouchBarsManager.isTouchBarAvailable()) {
                String appId = Utils.getAppId();
                if (appId != null && !appId.isEmpty()) {
                    this.myShowFnInitial = NSDefaults.isShowFnKeysEnabled((String)appId);
                    this.myCheckbox = new JCheckBox("Show F1, F2, etc. keys on the Touch Bar", this.myShowFnInitial);
                } else {
                    Logger.getInstance(KeymapPanel.class).error("can't obtain application id from NSBundle");
                }
            }
        }

        JCheckBox getCheckbox() {
            return this.myCheckbox;
        }

        boolean isModified() {
            return this.myCheckbox == null ? false : this.myShowFnInitial != this.myCheckbox.isSelected();
        }

        void applyChanges() {
            if (!TouchBarsManager.isTouchBarAvailable() || this.myCheckbox == null || !this.isModified()) {
                return;
            }
            String appId = Utils.getAppId();
            if (appId == null || appId.isEmpty()) {
                Logger.getInstance(KeymapPanel.class).error("can't obtain application id from NSBundle");
                return;
            }
            boolean prevVal = this.myShowFnInitial;
            this.myShowFnInitial = this.myCheckbox.isSelected();
            NSDefaults.setShowFnKeysEnabled((String)appId, (boolean)this.myShowFnInitial);
            if (this.myShowFnInitial != NSDefaults.isShowFnKeysEnabled((String)appId)) {
                NSDefaults.setShowFnKeysEnabled((String)appId, (boolean)this.myShowFnInitial, (boolean)true);
                if (this.myShowFnInitial != NSDefaults.isShowFnKeysEnabled((String)appId)) {
                    return;
                }
            }
            ApplicationManager.getApplication().executeOnPooledThread(() -> {
                boolean result2 = Utils.restartTouchBarServer();
                if (!result2) {
                    this.myShowFnInitial = prevVal;
                    NSDefaults.setShowFnKeysEnabled((String)appId, (boolean)this.myShowFnInitial);
                    if (!this.myDisposed) {
                        ApplicationManager.getApplication().invokeLater(() -> {
                            if (!this.myDisposed) {
                                this.myCheckbox.setSelected(prevVal);
                            }
                        }, ModalityState.stateForComponent((Component)this.myCheckbox));
                    }
                }
            });
        }

        public void dispose() {
            if (!this.myDisposed) {
                this.myDisposed = true;
                this.myCheckbox = null;
            }
        }
    }
}

