/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.keymap.impl.ui;

import com.intellij.openapi.keymap.Keymap;
import com.intellij.openapi.keymap.impl.KeymapImpl;
import com.intellij.openapi.options.Scheme;
import org.jetbrains.annotations.NotNull;

final class KeymapScheme
implements Scheme {
    private final KeymapImpl original;
    private KeymapImpl mutable;

    KeymapScheme(@NotNull Keymap keymap) {
        this.original = (KeymapImpl)keymap;
    }

    @NotNull
    public String getName() {
        return this.getCurrent().getPresentableName();
    }

    void setName(@NotNull String name) {
        this.getMutable().setName(name);
    }

    Keymap getParent() {
        return !this.isMutable() ? null : this.original.getParent();
    }

    @NotNull
    Keymap getOriginal() {
        return this.original;
    }

    @NotNull
    KeymapImpl getCurrent() {
        return this.mutable != null ? this.mutable : this.original;
    }

    @NotNull
    KeymapImpl getMutable() {
        if (this.mutable != null) {
            return this.mutable;
        }
        assert (this.isMutable()) : "create a mutable copy for immutable keymap";
        this.mutable = this.original.copyTo(new KeymapImpl());
        return this.mutable;
    }

    boolean isMutable() {
        return this.original.canModify();
    }

    boolean contains(@NotNull Keymap keymap) {
        return keymap == this.original || keymap == this.mutable;
    }

    private static boolean contains(@NotNull Keymap keymap, @NotNull String name) {
        return name.equals(keymap.getName()) || name.equals(keymap.getPresentableName());
    }

    boolean contains(@NotNull String name) {
        return KeymapScheme.contains(this.original, name) || this.mutable != null && KeymapScheme.contains(this.mutable, name);
    }

    boolean canReset() {
        return this.isMutable() && this.getCurrent().getOwnActionIds().length > 0;
    }

    void reset() {
        assert (this.canReset()) : "reset all modified shortcuts unexpectedly";
        this.getMutable().clearOwnActionsIds();
    }

    boolean canReset(@NotNull String actionId) {
        return this.isMutable() && this.getCurrent().hasOwnActionId(actionId);
    }

    void reset(@NotNull String actionId) {
        assert (this.canReset(actionId)) : "reset modified action shortcuts unexpectedly";
        this.getMutable().clearOwnActionsId(actionId);
    }

    @NotNull
    Keymap apply() {
        if (this.mutable != null) {
            this.mutable.copyTo(this.original);
        }
        return this.original;
    }

    @NotNull
    KeymapScheme copy(@NotNull String name) {
        KeymapImpl keymap = this.original.deriveKeymap(name);
        if (this.mutable != null) {
            this.mutable.copyTo(keymap);
        }
        return new KeymapScheme(keymap);
    }
}

