/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.keymap.impl.ui;

import com.intellij.application.options.schemes.AbstractSchemeActions;
import com.intellij.application.options.schemes.SchemesModel;
import com.intellij.openapi.keymap.KeyMapBundle;
import com.intellij.openapi.keymap.Keymap;
import com.intellij.openapi.keymap.KeymapManager;
import com.intellij.openapi.keymap.impl.KeymapManagerImpl;
import com.intellij.openapi.keymap.impl.ui.KeymapScheme;
import com.intellij.openapi.keymap.impl.ui.KeymapSelector;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class KeymapSchemeManager
extends AbstractSchemeActions<KeymapScheme>
implements SchemesModel<KeymapScheme> {
    private static final Predicate<Keymap> FILTER = keymap -> !SystemInfo.isMac || !"$default".equals(keymap.getName());
    private final List<KeymapScheme> list = new ArrayList<KeymapScheme>();
    private final KeymapSelector selector;
    private static final Comparator<Keymap> KEYMAP_COMPARATOR = (keymap1, keymap2) -> {
        Keymap parent2;
        if (keymap1 == keymap2) {
            return 0;
        }
        if (keymap1 == null) {
            return -1;
        }
        if (keymap2 == null) {
            return 1;
        }
        Keymap parent1 = !keymap1.canModify() ? null : keymap1.getParent();
        Keymap keymap = parent2 = !keymap2.canModify() ? null : keymap2.getParent();
        if (parent1 == null) {
            parent1 = keymap1;
        }
        if (parent2 == null) {
            parent2 = keymap2;
        }
        if (parent1 == parent2) {
            if (!keymap1.canModify()) {
                return -1;
            }
            if (!keymap2.canModify()) {
                return 1;
            }
            return StringUtil.naturalCompare((String)keymap1.getPresentableName(), (String)keymap2.getPresentableName());
        }
        return StringUtil.naturalCompare((String)parent1.getPresentableName(), (String)parent2.getPresentableName());
    };
    private static final Comparator<KeymapScheme> SCHEME_COMPARATOR = (scheme1, scheme2) -> {
        if (scheme1 == scheme2) {
            return 0;
        }
        if (scheme1 == null) {
            return -1;
        }
        if (scheme2 == null) {
            return 1;
        }
        return KEYMAP_COMPARATOR.compare(scheme1.getCurrent(), scheme2.getCurrent());
    };

    KeymapSchemeManager(KeymapSelector selector) {
        super(selector);
        this.selector = selector;
    }

    Keymap getSelectedKeymap() {
        KeymapScheme scheme2 = (KeymapScheme)this.selector.getSelectedScheme();
        return scheme2 == null ? null : scheme2.getCurrent();
    }

    Keymap getMutableKeymap(Keymap keymap) {
        KeymapScheme scheme2 = this.find(keymap);
        if (scheme2 == null) {
            return null;
        }
        if (scheme2.isMutable()) {
            return scheme2.getMutable();
        }
        String name = KeyMapBundle.message((String)"new.keymap.name", (Object[])new Object[]{keymap.getPresentableName()});
        int i = 1;
        while (this.containsScheme(name, false)) {
            name = KeyMapBundle.message((String)"new.indexed.keymap.name", (Object[])new Object[]{keymap.getPresentableName(), i});
            ++i;
        }
        return this.copyScheme(scheme2, name).getMutable();
    }

    void visitMutableKeymaps(Consumer<? super Keymap> consumer) {
        for (KeymapScheme scheme2 : this.list) {
            if (!scheme2.isMutable()) continue;
            consumer.accept(scheme2.getMutable());
        }
    }

    @Override
    @NotNull
    protected Class<KeymapScheme> getSchemeType() {
        return KeymapScheme.class;
    }

    @Override
    protected void onSchemeChanged(@Nullable KeymapScheme scheme2) {
        this.selector.notifyConsumer(scheme2);
    }

    @Override
    public boolean isProjectScheme(@NotNull KeymapScheme scheme2) {
        return false;
    }

    @Override
    public boolean canDuplicateScheme(@NotNull KeymapScheme scheme2) {
        return true;
    }

    @Override
    protected void duplicateScheme(@NotNull KeymapScheme parent, @NotNull String name) {
        this.copyScheme(parent, name);
    }

    @NotNull
    private KeymapScheme copyScheme(@NotNull KeymapScheme parent, @NotNull String name) {
        KeymapScheme scheme2 = parent.copy(name);
        this.list.add(scheme2);
        this.selector.selectKeymap(scheme2, true);
        return scheme2;
    }

    @Override
    public boolean canDeleteScheme(@NotNull KeymapScheme scheme2) {
        return scheme2.isMutable();
    }

    @Override
    public void removeScheme(@NotNull KeymapScheme scheme2) {
        this.list.remove(scheme2);
        this.selector.selectKeymap(this.getSchemeToSelect(scheme2.getParent()), true);
    }

    @Override
    public boolean canRenameScheme(@NotNull KeymapScheme scheme2) {
        return scheme2.isMutable();
    }

    @Override
    protected void renameScheme(@NotNull KeymapScheme scheme2, @NotNull String name) {
        scheme2.setName(name);
        this.selector.selectKeymap(scheme2, true);
    }

    @Override
    public boolean containsScheme(@NotNull String name, boolean projectScheme) {
        return null != this.find((? super KeymapScheme scheme2) -> scheme2.contains(name));
    }

    @Override
    public boolean differsFromDefault(@NotNull KeymapScheme scheme2) {
        return scheme2.canReset();
    }

    @Override
    public boolean canResetScheme(@NotNull KeymapScheme scheme2) {
        return scheme2.isMutable();
    }

    @Override
    protected void resetScheme(@NotNull KeymapScheme scheme2) {
        scheme2.reset();
        this.selector.selectKeymap(scheme2, true);
    }

    boolean canResetActionInKeymap(Keymap mutable, String actionId) {
        KeymapScheme scheme2 = this.find(mutable);
        return scheme2 != null && scheme2.canReset(actionId);
    }

    void resetActionInKeymap(Keymap mutable, String actionId) {
        KeymapScheme scheme2 = this.find(mutable);
        if (scheme2 == null) {
            return;
        }
        scheme2.reset(actionId);
        this.selector.selectKeymap(scheme2, false);
    }

    private KeymapScheme find(Keymap keymap) {
        return keymap == null ? null : this.find((? super KeymapScheme scheme2) -> scheme2.contains(keymap));
    }

    private KeymapScheme find(@NotNull Predicate<? super KeymapScheme> predicate) {
        for (KeymapScheme scheme2 : this.list) {
            if (!predicate.test(scheme2)) continue;
            return scheme2;
        }
        return null;
    }

    void reset() {
        this.list.clear();
        KeymapSchemeManager.getKeymaps().forEach(keymap -> this.list.add(new KeymapScheme((Keymap)keymap)));
        this.selector.selectKeymap(this.getSchemeToSelect(null), true);
    }

    String apply() {
        HashSet<String> set2 = new HashSet<String>();
        for (KeymapScheme scheme3 : this.list) {
            String name = scheme3.getName();
            if (StringUtil.isEmptyOrSpaces((String)name)) {
                return KeyMapBundle.message((String)"configuration.all.keymaps.should.have.non.empty.names.error.message", (Object[])new Object[0]);
            }
            if (set2.add(name)) continue;
            return KeyMapBundle.message((String)"configuration.all.keymaps.should.have.unique.names.error.message", (Object[])new Object[0]);
        }
        KeymapScheme selected = (KeymapScheme)this.selector.getSelectedScheme();
        Keymap active = selected == null ? null : selected.getOriginal();
        List keymaps = ContainerUtil.map(this.list, scheme2 -> scheme2.apply());
        KeymapManagerImpl manager = (KeymapManagerImpl)KeymapManager.getInstance();
        manager.setKeymaps(keymaps, active, FILTER);
        this.selector.notifyConsumer(selected);
        return null;
    }

    @NotNull
    private static List<Keymap> getKeymaps() {
        KeymapManagerImpl manager = (KeymapManagerImpl)KeymapManager.getInstance();
        return manager.getKeymaps(FILTER);
    }

    private KeymapScheme getSchemeToSelect(Keymap active) {
        if (active == null) {
            active = KeymapManager.getInstance().getActiveKeymap();
        }
        KeymapScheme found = null;
        for (KeymapScheme scheme2 : this.list) {
            Keymap keymap = scheme2.getOriginal();
            if (keymap == active) {
                return scheme2;
            }
            if (found != null && !"Mac OS X 10.5+".equals(keymap.getName())) continue;
            found = scheme2;
        }
        return found;
    }

    boolean isModified() {
        Keymap active;
        KeymapScheme selected = (KeymapScheme)this.selector.getSelectedScheme();
        Keymap keymap = active = selected == null ? null : selected.getOriginal();
        if (!Objects.equals(active, KeymapManager.getInstance().getActiveKeymap())) {
            return true;
        }
        Iterator keymaps = KeymapSchemeManager.getKeymaps().stream().sorted(KEYMAP_COMPARATOR).iterator();
        Iterator<KeymapScheme> schemes = this.list.iterator();
        while (keymaps.hasNext() && schemes.hasNext()) {
            if (Objects.equals(keymaps.next(), schemes.next().getCurrent())) continue;
            return true;
        }
        return keymaps.hasNext() || schemes.hasNext();
    }

    List<KeymapScheme> getSchemes() {
        this.list.sort(SCHEME_COMPARATOR);
        return this.list;
    }
}

