/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.keymap.impl.ui;

import com.intellij.application.options.schemes.AbstractSchemeActions;
import com.intellij.application.options.schemes.SchemesModel;
import com.intellij.application.options.schemes.SimpleSchemesPanel;
import com.intellij.openapi.keymap.KeyMapBundle;
import com.intellij.openapi.keymap.Keymap;
import com.intellij.openapi.keymap.impl.ui.KeymapScheme;
import com.intellij.openapi.keymap.impl.ui.KeymapSchemeManager;
import com.intellij.openapi.ui.MessageType;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class KeymapSelector
extends SimpleSchemesPanel<KeymapScheme> {
    private KeymapSchemeManager manager;
    private final Consumer<? super Keymap> consumer;
    private String messageReplacement;
    private boolean messageShown;
    private boolean internal;

    KeymapSelector(Consumer<? super Keymap> consumer) {
        super(0);
        this.consumer = consumer;
    }

    @NotNull
    public KeymapSchemeManager getManager() {
        if (this.manager == null) {
            this.manager = new KeymapSchemeManager(this);
        }
        return this.manager;
    }

    @Override
    @NotNull
    public SchemesModel<KeymapScheme> getModel() {
        return this.getManager();
    }

    @Override
    @Nullable
    protected String getComboBoxLabel() {
        return null;
    }

    @Override
    @NotNull
    protected String getSchemeTypeName() {
        return "Keymap";
    }

    @Override
    @NotNull
    protected AbstractSchemeActions<KeymapScheme> createSchemeActions() {
        return this.getManager();
    }

    @Override
    protected int getIndent(@NotNull KeymapScheme scheme2) {
        return scheme2.isMutable() ? 1 : 0;
    }

    @Override
    protected boolean supportsProjectSchemes() {
        return false;
    }

    @Override
    protected boolean highlightNonDefaultSchemes() {
        return false;
    }

    @Override
    public boolean useBoldForNonRemovableSchemes() {
        return true;
    }

    @Override
    public void showMessage(@Nullable String message, @NotNull MessageType messageType) {
        this.messageShown = true;
        super.showMessage(message, messageType);
    }

    @Override
    public void clearMessage() {
        this.messageShown = false;
        super.showMessage(this.messageReplacement, MessageType.INFO);
    }

    void notifyConsumer(KeymapScheme scheme2) {
        if (this.internal) {
            return;
        }
        Keymap keymap = scheme2 == null ? null : scheme2.getParent();
        String string = this.messageReplacement = keymap == null ? null : KeyMapBundle.message((String)"based.on.keymap.label", (Object[])new Object[]{keymap.getPresentableName()});
        if (!this.messageShown) {
            this.clearMessage();
        }
        this.consumer.accept(scheme2 == null ? null : scheme2.getCurrent());
    }

    void selectKeymap(KeymapScheme scheme2, boolean reset) {
        try {
            this.internal = true;
            if (reset) {
                this.resetSchemes(this.getManager().getSchemes());
            }
            if (scheme2 != null) {
                this.selectScheme(scheme2);
            }
        }
        finally {
            this.internal = false;
            this.notifyConsumer((KeymapScheme)this.getSelectedScheme());
        }
    }
}

