/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.module.impl;

import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.impl.ApplicationInfoImpl;
import com.intellij.openapi.components.ComponentConfig;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceKt;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.impl.ModuleServiceManagerImpl;
import com.intellij.openapi.components.impl.PlatformComponentManagerImpl;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleComponent;
import com.intellij.openapi.module.ModuleServiceManager;
import com.intellij.openapi.module.impl.ModuleEx;
import com.intellij.openapi.module.impl.ModuleScopeProvider;
import com.intellij.openapi.module.impl.scopes.ModuleScopeProviderImpl;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.impl.ProjectImpl;
import com.intellij.openapi.roots.ExternalProjectSystemRegistry;
import com.intellij.openapi.roots.ProjectModelElement;
import com.intellij.openapi.roots.ProjectModelExternalSource;
import com.intellij.openapi.util.SimpleModificationTracker;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.pointers.VirtualFilePointer;
import com.intellij.openapi.vfs.pointers.VirtualFilePointerManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.xmlb.annotations.MapAnnotation;
import com.intellij.util.xmlb.annotations.Property;
import gnu.trove.THashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.picocontainer.MutablePicoContainer;

public class ModuleImpl
extends PlatformComponentManagerImpl
implements ModuleEx {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.module.impl.ModuleImpl");
    @NotNull
    private final Project myProject;
    private final VirtualFilePointer myImlFilePointer;
    private volatile boolean isModuleAdded;
    private String myName;
    private final ModuleScopeProvider myModuleScopeProvider;

    ModuleImpl(@NotNull String name, @NotNull Project project, @NotNull String filePath) {
        super((ComponentManager)project, "Module " + name);
        this.getPicoContainer().registerComponentInstance(Module.class, (Object)this);
        this.myProject = project;
        this.myModuleScopeProvider = new ModuleScopeProviderImpl(this);
        this.myName = name;
        this.myImlFilePointer = VirtualFilePointerManager.getInstance().create(VfsUtilCore.pathToUrl((String)filePath), (Disposable)this, null);
    }

    @Override
    protected void bootstrapPicoContainer(@NotNull String name) {
        Extensions.instantiateArea((String)"IDEA_MODULE", (AreaInstance)this, (AreaInstance)((AreaInstance)this.getParentComponentManager()));
        super.bootstrapPicoContainer(name);
    }

    @Override
    public void init(@Nullable Runnable beforeComponentCreation) {
        this.init(null, () -> {
            this.getPicoContainer().getComponentInstance(ModuleServiceManagerImpl.class);
            if (beforeComponentCreation != null) {
                beforeComponentCreation.run();
            }
        });
    }

    @Override
    @Nullable
    protected ProgressIndicator getProgressIndicator() {
        return null;
    }

    @Override
    public boolean isDisposed() {
        return super.isDisposed() || ((ProjectImpl)this.myProject).isLight() && this.myProject.isDisposed();
    }

    @Override
    protected boolean isComponentSuitable(@Nullable Map<String, String> options) {
        if (!super.isComponentSuitable(options)) {
            return false;
        }
        if (options == null || options.isEmpty()) {
            return true;
        }
        for (String optionName : options.keySet()) {
            if ("workspace".equals(optionName)) continue;
            String message = "Don't specify " + optionName + " in the component registration, transform component to service and implement your logic in your getInstance() method";
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                LOG.error(message);
                continue;
            }
            LOG.warn(message);
        }
        return true;
    }

    @Nullable
    public VirtualFile getModuleFile() {
        return this.myImlFilePointer.getFile();
    }

    @Override
    public void rename(@NotNull String newName, boolean notifyStorage) {
        this.myName = newName;
        if (notifyStorage) {
            ServiceKt.getStateStore(this).getStorageManager().rename("$MODULE_FILE$", newName + ".iml");
        }
    }

    @NotNull
    public String getModuleFilePath() {
        return ServiceKt.getStateStore(this).getStorageManager().expandMacros("$MODULE_FILE$");
    }

    @Override
    public synchronized void dispose() {
        this.isModuleAdded = false;
        this.disposeComponents();
        Extensions.disposeArea((AreaInstance)this);
        super.dispose();
    }

    @Override
    @NotNull
    public List<ComponentConfig> getMyComponentConfigsFromDescriptor(@NotNull IdeaPluginDescriptor plugin) {
        return plugin.getModuleComponents();
    }

    @Override
    public void projectOpened() {
        for (ModuleComponent component : this.getComponentInstancesOfType(ModuleComponent.class)) {
            try {
                component.projectOpened();
            }
            catch (Exception e) {
                LOG.error((Throwable)e);
            }
        }
    }

    @Override
    public void projectClosed() {
        List<ModuleComponent> components = this.getComponentInstancesOfType(ModuleComponent.class);
        for (int i = components.size() - 1; i >= 0; --i) {
            try {
                components.get(i).projectClosed();
                continue;
            }
            catch (Throwable e) {
                LOG.error(e);
            }
        }
    }

    @NotNull
    public Project getProject() {
        return this.myProject;
    }

    @NotNull
    public String getName() {
        return this.myName;
    }

    public boolean isLoaded() {
        return this.isModuleAdded;
    }

    @Override
    public void moduleAdded() {
        this.isModuleAdded = true;
        for (ModuleComponent component : this.getComponentInstancesOfType(ModuleComponent.class)) {
            component.moduleAdded();
        }
    }

    public void setOption(@NotNull String key, @Nullable String value) {
        DeprecatedModuleOptionManager manager = this.getOptionManager();
        if (value == null) {
            if (((DeprecatedModuleOptionManager)manager).state.options.remove(key) != null) {
                manager.incModificationCount();
            }
        } else if (!value.equals(((DeprecatedModuleOptionManager)manager).state.options.put(key, value))) {
            manager.incModificationCount();
        }
    }

    @NotNull
    private DeprecatedModuleOptionManager getOptionManager() {
        return (DeprecatedModuleOptionManager)((Object)ModuleServiceManager.getService((Module)this, DeprecatedModuleOptionManager.class));
    }

    public String getOptionValue(@NotNull String key) {
        return ((DeprecatedModuleOptionManager)this.getOptionManager()).state.options.get(key);
    }

    @NotNull
    public GlobalSearchScope getModuleScope() {
        return this.myModuleScopeProvider.getModuleScope();
    }

    @NotNull
    public GlobalSearchScope getModuleScope(boolean includeTests) {
        return this.myModuleScopeProvider.getModuleScope(includeTests);
    }

    @NotNull
    public GlobalSearchScope getModuleWithLibrariesScope() {
        return this.myModuleScopeProvider.getModuleWithLibrariesScope();
    }

    @NotNull
    public GlobalSearchScope getModuleWithDependenciesScope() {
        return this.myModuleScopeProvider.getModuleWithDependenciesScope();
    }

    @NotNull
    public GlobalSearchScope getModuleContentScope() {
        return this.myModuleScopeProvider.getModuleContentScope();
    }

    @NotNull
    public GlobalSearchScope getModuleContentWithDependenciesScope() {
        return this.myModuleScopeProvider.getModuleContentWithDependenciesScope();
    }

    @NotNull
    public GlobalSearchScope getModuleWithDependenciesAndLibrariesScope(boolean includeTests) {
        return this.myModuleScopeProvider.getModuleWithDependenciesAndLibrariesScope(includeTests);
    }

    @NotNull
    public GlobalSearchScope getModuleWithDependentsScope() {
        return this.myModuleScopeProvider.getModuleWithDependentsScope();
    }

    @NotNull
    public GlobalSearchScope getModuleTestsWithDependentsScope() {
        return this.myModuleScopeProvider.getModuleTestsWithDependentsScope();
    }

    @NotNull
    public GlobalSearchScope getModuleRuntimeScope(boolean includeTests) {
        return this.myModuleScopeProvider.getModuleRuntimeScope(includeTests);
    }

    @Override
    public void clearScopesCache() {
        this.myModuleScopeProvider.clearCache();
    }

    public String toString() {
        if (this.myName == null) {
            return "Module (not initialized)";
        }
        return "Module: '" + this.getName() + "'";
    }

    @NotNull
    public <T> T[] getExtensions(@NotNull ExtensionPointName<T> extensionPointName) {
        return Extensions.getArea((AreaInstance)this).getExtensionPoint(extensionPointName).getExtensions();
    }

    @Override
    protected boolean logSlowComponents() {
        return super.logSlowComponents() || ApplicationInfoImpl.getShadowInstance().isEAP();
    }

    @Override
    @NotNull
    protected MutablePicoContainer createPicoContainer() {
        return Extensions.getArea((AreaInstance)this).getPicoContainer();
    }

    @Override
    public long getOptionsModificationCount() {
        return this.getOptionManager().getModificationCount();
    }

    @com.intellij.openapi.components.State(name="DeprecatedModuleOptionManager", useLoadedStateAsExisting=false)
    static class DeprecatedModuleOptionManager
    extends SimpleModificationTracker
    implements PersistentStateComponent<State>,
    ProjectModelElement {
        private final Module module;
        private State state = new State();

        DeprecatedModuleOptionManager(@NotNull Module module) {
            this.module = module;
        }

        @Nullable
        public ProjectModelExternalSource getExternalSource() {
            if (this.state.options.size() > 1 || this.state.options.size() == 1 && !this.state.options.containsKey("type")) {
                return null;
            }
            return ExternalProjectSystemRegistry.getInstance().getExternalSource(this.module);
        }

        @Nullable
        public State getState() {
            return this.state;
        }

        public void loadState(@NotNull State state) {
            this.state = state;
        }

        static final class State {
            @Property(surroundWithTag=false)
            @MapAnnotation(surroundKeyWithTag=false, surroundValueWithTag=false, surroundWithTag=false, entryTagName="option")
            public final Map<String, String> options = new THashMap();

            State() {
            }
        }
    }
}

