/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.module.impl;

import com.intellij.openapi.module.ConfigurationErrorDescription;
import com.intellij.openapi.module.ConfigurationErrorType;
import com.intellij.openapi.module.impl.ModuleManagerImpl;
import com.intellij.openapi.module.impl.ModulePath;
import com.intellij.openapi.project.ProjectBundle;
import org.jetbrains.annotations.NotNull;

public class ModuleLoadingErrorDescription
extends ConfigurationErrorDescription {
    private static final ConfigurationErrorType INVALID_MODULE = new ConfigurationErrorType(ProjectBundle.message((String)"element.kind.name.module", (Object[])new Object[0]), false);
    private final ModulePath myModulePath;
    private final ModuleManagerImpl myModuleManager;

    ModuleLoadingErrorDescription(String description, @NotNull ModulePath modulePath, @NotNull ModuleManagerImpl moduleManager) {
        super(modulePath.getModuleName(), description, INVALID_MODULE);
        this.myModulePath = modulePath;
        this.myModuleManager = moduleManager;
    }

    @NotNull
    public ModulePath getModulePath() {
        return this.myModulePath;
    }

    @Override
    public void ignoreInvalidElement() {
        this.myModuleManager.removeFailedModulePath(this.myModulePath);
    }

    @Override
    public String getIgnoreConfirmationMessage() {
        return ProjectBundle.message((String)"module.remove.from.project.confirmation", (Object[])new Object[]{this.getElementName()});
    }
}

