/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.module.impl;

import com.intellij.ProjectTopics;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.TransactionGuard;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.module.UnknownModuleType;
import com.intellij.openapi.module.impl.AutomaticModuleUnloader;
import com.intellij.openapi.module.impl.ModuleEx;
import com.intellij.openapi.module.impl.ModuleFileListener;
import com.intellij.openapi.module.impl.ModuleImpl;
import com.intellij.openapi.module.impl.ModuleManagerImpl;
import com.intellij.openapi.module.impl.ModulePath;
import com.intellij.openapi.module.impl.ModulePathKt;
import com.intellij.openapi.module.impl.UnloadedModuleDescriptionImpl;
import com.intellij.openapi.module.impl.UnloadedModulesListChange;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.project.impl.ProjectLifecycleListener;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.util.messages.MessageBusConnection;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

@State(name="ProjectModuleManager", storages={@Storage(value="modules.xml")})
public class ModuleManagerComponent
extends ModuleManagerImpl {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.module.impl.ModuleManagerComponent");
    private final MessageBusConnection myMessageBusConnection;

    public ModuleManagerComponent(@NotNull Project project) {
        super(project);
        this.myMessageBusConnection = project.getMessageBus().connect((Disposable)this);
        this.myMessageBusConnection.setDefaultHandler((event, params) -> this.cleanCachedStuff());
        this.myMessageBusConnection.subscribe(ProjectTopics.PROJECT_ROOTS);
        if (project.isDefault()) {
            return;
        }
        this.myMessageBusConnection.subscribe(ProjectLifecycleListener.TOPIC, (Object)new ProjectLifecycleListener(){

            public void projectComponentsInitialized(@NotNull Project project) {
                if (project != ModuleManagerComponent.this.myProject) {
                    return;
                }
                long t = System.currentTimeMillis();
                ModuleManagerComponent.this.loadModules(ModuleManagerComponent.this.myModuleModel);
                t = System.currentTimeMillis() - t;
                if (!ApplicationManager.getApplication().isUnitTestMode()) {
                    LOG.info(ModuleManagerComponent.this.myModuleModel.getModules().length + " module(s) loaded in " + t + " ms");
                }
            }
        });
        this.myMessageBusConnection.subscribe(VirtualFileManager.VFS_CHANGES, (Object)new ModuleFileListener(this));
    }

    @Override
    protected void unloadNewlyAddedModulesIfPossible(@NotNull Set<ModulePath> modulesToLoad, @NotNull List<UnloadedModuleDescriptionImpl> modulesToUnload) {
        UnloadedModulesListChange change = AutomaticModuleUnloader.getInstance(this.myProject).processNewModules(modulesToLoad, modulesToUnload);
        modulesToLoad.removeAll(change.getToUnload());
        modulesToUnload.addAll(change.getToUnloadDescriptions());
    }

    @Override
    protected void showUnknownModuleTypeNotification(@NotNull List<? extends Module> modulesWithUnknownTypes) {
        if (!ApplicationManager.getApplication().isHeadlessEnvironment() && !modulesWithUnknownTypes.isEmpty()) {
            String message;
            if (modulesWithUnknownTypes.size() == 1) {
                message = ProjectBundle.message((String)"module.unknown.type.single.error", (Object[])new Object[]{modulesWithUnknownTypes.get(0).getName(), ModuleType.get((Module)modulesWithUnknownTypes.get(0)).getId()});
            } else {
                StringBuilder modulesBuilder = new StringBuilder();
                for (Module module : modulesWithUnknownTypes) {
                    modulesBuilder.append("<br>\"");
                    modulesBuilder.append(module.getName()).append("\" (type '").append(ModuleType.get((Module)module).getId()).append("')");
                }
                modulesBuilder.append("<br>");
                message = ProjectBundle.message((String)"module.unknown.type.multiple.error", (Object[])new Object[]{modulesBuilder.toString()});
            }
            Notifications.Bus.notify((Notification)new Notification("Module Manager", ProjectBundle.message((String)"module.unknown.type.title", (Object[])new Object[0]), message, NotificationType.WARNING), (Project)this.myProject);
        }
    }

    @Override
    @NotNull
    protected ModuleEx createModule(@NotNull String filePath) {
        return new ModuleImpl(ModulePathKt.getModuleNameByFilePath(filePath), this.myProject, filePath);
    }

    @Override
    @NotNull
    protected ModuleEx createAndLoadModule(@NotNull String filePath) {
        return this.createModule(filePath);
    }

    @Override
    protected void setUnloadedModuleNames(@NotNull List<String> unloadedModuleNames) {
        super.setUnloadedModuleNames(unloadedModuleNames);
        if (!unloadedModuleNames.isEmpty()) {
            ArrayList<String> loadedModules = new ArrayList<String>(this.myModuleModel.myModules.keySet());
            loadedModules.removeAll(new HashSet<String>(unloadedModuleNames));
            AutomaticModuleUnloader.getInstance(this.myProject).setLoadedModules(loadedModules);
        }
    }

    @Override
    protected boolean isUnknownModuleType(@NotNull Module module) {
        return ModuleType.get((Module)module) instanceof UnknownModuleType;
    }

    @Override
    protected void fireModulesAdded() {
        for (Module module : this.myModuleModel.getModules()) {
            TransactionGuard.getInstance().submitTransactionAndWait(() -> this.fireModuleAddedInWriteAction((ModuleEx)module));
        }
    }

    @Override
    protected void deliverPendingEvents() {
        this.myMessageBusConnection.deliverImmediately();
    }
}

