/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.module.impl.scopes;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.UnloadedModuleDescription;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleOrderEntry;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.TestSourcesFilter;
import com.intellij.openapi.roots.impl.DirectoryIndex;
import com.intellij.openapi.roots.impl.DirectoryInfo;
import com.intellij.openapi.roots.impl.ModuleOrderEntryImpl;
import com.intellij.openapi.roots.impl.ProjectFileIndexImpl;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.util.containers.HashSetQueue;
import com.intellij.util.containers.MultiMap;
import gnu.trove.THashSet;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class ModuleWithDependentsScope
extends GlobalSearchScope {
    private final Set<Module> myRootModules;
    private final ProjectFileIndexImpl myProjectFileIndex;
    private final Set<Module> myModules = new THashSet();
    private final Set<Module> myProductionOnTestModules = new THashSet();

    ModuleWithDependentsScope(@NotNull Module module) {
        this(module.getProject(), Collections.singleton(module));
    }

    public ModuleWithDependentsScope(@NotNull Project project, @NotNull Collection<Module> modules) {
        super(project);
        this.myRootModules = new LinkedHashSet<Module>(modules);
        this.myProjectFileIndex = (ProjectFileIndexImpl)ProjectRootManager.getInstance((Project)project).getFileIndex();
        this.myModules.addAll(this.myRootModules);
        ModuleIndex index = ModuleWithDependentsScope.getModuleIndex(project);
        HashSetQueue walkingQueue = new HashSetQueue();
        walkingQueue.addAll(this.myRootModules);
        for (Module current : walkingQueue) {
            Collection usages = index.allUsages.get((Object)current);
            this.myModules.addAll(usages);
            walkingQueue.addAll(index.exportingUsages.get((Object)current));
            if (this.myProductionOnTestModules.contains(current)) {
                this.myProductionOnTestModules.addAll(usages);
            }
            this.myProductionOnTestModules.addAll(index.productionOnTestUsages.get((Object)current));
        }
    }

    @NotNull
    public Project getProject() {
        return Objects.requireNonNull(super.getProject());
    }

    @NotNull
    private static ModuleIndex getModuleIndex(@NotNull Project project) {
        return (ModuleIndex)CachedValuesManager.getManager((Project)project).getCachedValue((UserDataHolder)project, () -> {
            ModuleIndex index = new ModuleIndex();
            for (Module module : ModuleManager.getInstance((Project)project).getModules()) {
                for (OrderEntry orderEntry : ModuleRootManager.getInstance((Module)module).getOrderEntries()) {
                    Module referenced;
                    if (!(orderEntry instanceof ModuleOrderEntry) || (referenced = ((ModuleOrderEntry)orderEntry).getModule()) == null) continue;
                    index.allUsages.putValue((Object)referenced, (Object)module);
                    if (((ModuleOrderEntry)orderEntry).isExported()) {
                        index.exportingUsages.putValue((Object)referenced, (Object)module);
                    }
                    if (!(orderEntry instanceof ModuleOrderEntryImpl) || !((ModuleOrderEntryImpl)orderEntry).isProductionOnTestDependency()) continue;
                    index.productionOnTestUsages.putValue((Object)referenced, (Object)module);
                }
            }
            return CachedValueProvider.Result.create((Object)index, (Object[])new Object[]{ProjectRootManager.getInstance((Project)project)});
        });
    }

    public boolean contains(@NotNull VirtualFile file2) {
        return this.contains(file2, false);
    }

    boolean contains(@NotNull VirtualFile file2, boolean fromTests) {
        DirectoryInfo info = this.myProjectFileIndex.getInfoForFileOrDirectory(file2);
        Module moduleOfFile = info.getModule();
        if (moduleOfFile == null || !this.myModules.contains(moduleOfFile)) {
            return false;
        }
        if (fromTests && !this.myProductionOnTestModules.contains(moduleOfFile) && !TestSourcesFilter.isTestSources((VirtualFile)file2, (Project)moduleOfFile.getProject())) {
            return false;
        }
        return ProjectFileIndexImpl.isFileInContent(file2, info);
    }

    public boolean isSearchInModuleContent(@NotNull Module module) {
        return this.myModules.contains(module);
    }

    public boolean isSearchInLibraries() {
        return false;
    }

    @NotNull
    public Collection<UnloadedModuleDescription> getUnloadedModulesBelongingToScope() {
        Project project = this.getProject();
        ModuleManager moduleManager = ModuleManager.getInstance((Project)project);
        return this.myRootModules.stream().flatMap(module -> DirectoryIndex.getInstance(project).getDependentUnloadedModules((Module)module).stream()).map(arg_0 -> ((ModuleManager)moduleManager).getUnloadedModuleDescription(arg_0)).filter(Objects::nonNull).collect(Collectors.toList());
    }

    @NonNls
    public String toString() {
        return "Module with dependents:" + StringUtil.join(this.myRootModules, Module::getName, (String)",");
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        return o instanceof ModuleWithDependentsScope && this.myRootModules.equals(((ModuleWithDependentsScope)((Object)o)).myRootModules);
    }

    public int calcHashCode() {
        return this.myRootModules.hashCode();
    }

    private static class ModuleIndex {
        final MultiMap<Module, Module> allUsages = MultiMap.create();
        final MultiMap<Module, Module> exportingUsages = MultiMap.create();
        final MultiMap<Module, Module> productionOnTestUsages = MultiMap.create();

        private ModuleIndex() {
        }
    }
}

