/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.options;

import com.intellij.openapi.options.BaseConfigurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.UnnamedConfigurable;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public abstract class CompositeConfigurable<T extends UnnamedConfigurable>
extends BaseConfigurable {
    private List<T> myConfigurables;

    public void reset() {
        for (UnnamedConfigurable configurable : this.getConfigurables()) {
            configurable.reset();
        }
    }

    public void apply() throws ConfigurationException {
        for (UnnamedConfigurable configurable : this.getConfigurables()) {
            configurable.apply();
        }
    }

    public boolean isModified() {
        for (UnnamedConfigurable configurable : this.getConfigurables()) {
            if (!configurable.isModified()) continue;
            return true;
        }
        return false;
    }

    public void disposeUIResources() {
        if (this.myConfigurables != null) {
            for (UnnamedConfigurable myConfigurable : this.myConfigurables) {
                myConfigurable.disposeUIResources();
            }
            this.myConfigurables = null;
        }
    }

    @NotNull
    protected abstract List<T> createConfigurables();

    @NotNull
    public List<T> getConfigurables() {
        if (this.myConfigurables == null) {
            this.myConfigurables = this.createConfigurables();
        }
        return this.myConfigurables;
    }
}

