/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.options;

import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDialog;
import com.intellij.openapi.fileChooser.FileChooserFactory;
import com.intellij.openapi.fileChooser.FileElement;
import com.intellij.openapi.options.SchemeImportException;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.vfs.VirtualFile;
import java.awt.Component;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashSet;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SchemeImportUtil {
    @Nullable
    public static VirtualFile selectImportSource(@NotNull String[] sourceExtensions, @NotNull Component parent, @Nullable VirtualFile preselect, @Nullable String description) {
        VirtualFile[] preselectFiles;
        FileChooserDialog fileChooser;
        VirtualFile[] virtualFiles;
        final HashSet<String> extensions = new HashSet<String>(Arrays.asList(sourceExtensions));
        FileChooserDescriptor descriptor = new FileChooserDescriptor(true, false, SchemeImportUtil.canSelectJarFile(sourceExtensions), false, false, false){

            public boolean isFileVisible(VirtualFile file2, boolean showHiddenFiles) {
                return !(!file2.isDirectory() && !extensions.contains(file2.getExtension()) || !showHiddenFiles && FileElement.isFileHidden((VirtualFile)file2));
            }

            public boolean isFileSelectable(VirtualFile file2) {
                return !file2.isDirectory() && extensions.contains(file2.getExtension());
            }
        };
        if (description != null) {
            descriptor.setDescription(description);
        }
        if ((virtualFiles = (fileChooser = FileChooserFactory.getInstance().createFileChooser(descriptor, null, parent)).choose(null, preselectFiles = preselect != null ? new VirtualFile[]{preselect} : VirtualFile.EMPTY_ARRAY)).length != 1) {
            return null;
        }
        virtualFiles[0].refresh(false, false);
        return virtualFiles[0];
    }

    private static boolean canSelectJarFile(@NotNull String[] sourceExtensions) {
        for (String ext : sourceExtensions) {
            if (!"jar".equals(ext)) continue;
            return true;
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    public static Element loadSchemeDom(@NotNull VirtualFile file2) throws SchemeImportException {
        try (InputStream inputStream = file2.getInputStream();){
            Element element = JDOMUtil.load((InputStream)inputStream);
            return element;
        }
        catch (IOException | JDOMException e) {
            throw new SchemeImportException();
        }
    }
}

