/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.options.ex;

import com.intellij.BundleBase;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurableEP;
import com.intellij.openapi.options.ConfigurableGroup;
import com.intellij.openapi.options.ConfigurableProvider;
import com.intellij.openapi.options.OptionalConfigurable;
import com.intellij.openapi.options.OptionsBundle;
import com.intellij.openapi.options.UnnamedConfigurable;
import com.intellij.openapi.options.ex.ConfigurableFilter;
import com.intellij.openapi.options.ex.ConfigurableWrapper;
import com.intellij.openapi.options.ex.SortedConfigurableGroup;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashMap;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ConfigurableExtensionPointUtil {
    private static final Logger LOG = Logger.getInstance(ConfigurableExtensionPointUtil.class);

    private ConfigurableExtensionPointUtil() {
    }

    public static List<Configurable> buildConfigurablesList(ConfigurableEP<Configurable>[] extensions, @Nullable ConfigurableFilter filter) {
        ArrayList<Configurable> result2 = new ArrayList<Configurable>();
        HashMap idToConfigurable = ContainerUtil.newHashMap();
        ArrayList idsInEpOrder = ContainerUtil.newArrayList();
        for (ConfigurableEP<Configurable> ep : extensions) {
            Configurable configurable = ConfigurableWrapper.wrapConfigurable(ep);
            if (ConfigurableExtensionPointUtil.isSuppressed(configurable, filter)) continue;
            if (configurable instanceof ConfigurableWrapper) {
                ConfigurableWrapper wrapper2 = (ConfigurableWrapper)configurable;
                idToConfigurable.put(wrapper2.getId(), wrapper2);
                idsInEpOrder.add(wrapper2.getId());
                continue;
            }
            ContainerUtil.addIfNotNull(result2, (Object)configurable);
        }
        HashSet visited = ContainerUtil.newHashSet();
        Map<String, List<String>> idTree = ConfigurableExtensionPointUtil.buildIdTree(idToConfigurable, idsInEpOrder);
        for (String id : idsInEpOrder) {
            ConfigurableExtensionPointUtil.addChildrenRec(id, idToConfigurable, visited, idTree);
        }
        for (String id : idsInEpOrder) {
            ConfigurableWrapper wrapper3 = (ConfigurableWrapper)idToConfigurable.get(id);
            String parentId = wrapper3.getParentId();
            if (parentId != null && idToConfigurable.containsKey(parentId)) continue;
            result2.add((Configurable)wrapper3);
        }
        return result2;
    }

    @NotNull
    private static ConfigurableWrapper addChildrenRec(@NotNull String id, @NotNull Map<String, ConfigurableWrapper> idToConfigurable, @NotNull Set<? super String> visited, @NotNull Map<String, List<String>> idTree) {
        ConfigurableWrapper wrapper2 = idToConfigurable.get(id);
        if (visited.contains(id)) {
            return wrapper2;
        }
        visited.add(id);
        List<String> childIds = idTree.get(id);
        if (childIds != null) {
            for (String childId : childIds) {
                ConfigurableWrapper childWrapper = ConfigurableExtensionPointUtil.addChildrenRec(childId, idToConfigurable, visited, idTree);
                wrapper2 = wrapper2.addChild((Configurable)childWrapper);
            }
            idToConfigurable.put(id, wrapper2);
        }
        return wrapper2;
    }

    @NotNull
    private static Map<String, List<String>> buildIdTree(@NotNull Map<String, ConfigurableWrapper> idToConfigurable, @NotNull List<String> idsInEpOrder) {
        HashMap tree = ContainerUtil.newHashMap();
        for (String id : idsInEpOrder) {
            ConfigurableWrapper wrapper2 = idToConfigurable.get(id);
            String parentId = wrapper2.getParentId();
            if (parentId == null) continue;
            ConfigurableWrapper parent = idToConfigurable.get(parentId);
            if (parent == null) {
                LOG.warn("Can't find parent for " + parentId + " (" + wrapper2 + ")");
                continue;
            }
            List children2 = (List)tree.get(parentId);
            if (children2 == null) {
                children2 = ContainerUtil.newArrayListWithCapacity((int)5);
                tree.put(parentId, children2);
            }
            children2.add(id);
        }
        return tree;
    }

    public static ConfigurableGroup getConfigurableGroup(@Nullable Project project, boolean withIdeSettings) {
        if (!withIdeSettings && project == null) {
            project = ProjectManager.getInstance().getDefaultProject();
        }
        return ConfigurableExtensionPointUtil.getConfigurableGroup(ConfigurableExtensionPointUtil.getConfigurables(project, withIdeSettings), project);
    }

    public static ConfigurableGroup getConfigurableGroup(@NotNull List<? extends Configurable> configurables, @Nullable Project project) {
        Map<String, List<Configurable>> map2 = ConfigurableExtensionPointUtil.groupConfigurables(configurables);
        HashMap tree = ContainerUtil.newHashMap();
        for (Map.Entry<String, List<Configurable>> entry : map2.entrySet()) {
            ConfigurableExtensionPointUtil.addGroup(tree, project, entry.getKey(), entry.getValue(), null);
        }
        SortedConfigurableGroup root = ConfigurableExtensionPointUtil.getGroup(tree, "root");
        if (!tree.isEmpty()) {
            for (String groupId : tree.keySet()) {
                LOG.warn("ignore group: " + groupId);
            }
        }
        if (root != null && root.myList != null && Registry.is((String)"ide.settings.replace.group.with.single.configurable")) {
            ConfigurableExtensionPointUtil.replaceGroupWithSingleConfigurable(root.myList);
        }
        return root;
    }

    private static void replaceGroupWithSingleConfigurable(List<Configurable> list2) {
        for (int i = 0; i < list2.size(); ++i) {
            SortedConfigurableGroup group;
            Configurable configurable = list2.get(i);
            if (!(configurable instanceof SortedConfigurableGroup) || (configurable = ConfigurableExtensionPointUtil.getConfigurableToReplace(group.myList, (group = (SortedConfigurableGroup)configurable).getWeight())) == null) continue;
            list2.set(i, configurable);
        }
    }

    private static Configurable getConfigurableToReplace(List<Configurable> list2, int weight2) {
        if (list2 != null) {
            ConfigurableExtensionPointUtil.replaceGroupWithSingleConfigurable(list2);
            if (1 == list2.size()) {
                Configurable configurable = list2.get(0);
                if (configurable instanceof SortedConfigurableGroup) {
                    SortedConfigurableGroup group = (SortedConfigurableGroup)configurable;
                    group.myWeight = weight2;
                    return group;
                }
                if (configurable instanceof ConfigurableWrapper) {
                    ConfigurableWrapper wrapper2 = (ConfigurableWrapper)configurable;
                    wrapper2.myWeight = weight2;
                    return wrapper2;
                }
            }
        }
        return null;
    }

    private static SortedConfigurableGroup getGroup(Map<String, Node<SortedConfigurableGroup>> tree, String groupId) {
        Node<SortedConfigurableGroup> node = tree.remove(groupId);
        if (node.myChildren != null) {
            Iterator<Object> iterator = node.myChildren.iterator();
            while (iterator.hasNext()) {
                String childId = (String)iterator.next();
                ((SortedConfigurableGroup)node.myValue).myList.add((Configurable)ConfigurableExtensionPointUtil.getGroup(tree, childId));
                iterator.remove();
            }
        }
        return (SortedConfigurableGroup)node.myValue;
    }

    private static void addGroup(Map<String, Node<SortedConfigurableGroup>> tree, Project project, String groupId, List<? extends Configurable> configurables, ResourceBundle alternative) {
        String id = "configurable.group." + groupId;
        ResourceBundle bundle = ConfigurableExtensionPointUtil.getBundle(id + ".settings.display.name", configurables, alternative);
        if (bundle == null) {
            bundle = OptionsBundle.getBundle();
            if ("root".equals(groupId)) {
                try {
                    String value = bundle.getString("configurable.group.root.settings.display.name");
                    LOG.error("OptionsBundle does not contain root group", new String[]{value});
                }
                catch (Exception exception) {
                    LOG.error("OptionsBundle does not contain root group", (Throwable)exception);
                }
            } else {
                LOG.warn("use other group instead of unexpected one: " + groupId);
                groupId = "other";
                id = "configurable.group." + groupId;
            }
        }
        Node node = Node.get(tree, groupId);
        if (node.myValue == null) {
            int weight2 = ConfigurableExtensionPointUtil.getInt(bundle, id + ".settings.weight");
            String help = ConfigurableExtensionPointUtil.getString(bundle, id + ".settings.help.topic");
            String name = ConfigurableExtensionPointUtil.getString(bundle, id + ".settings.display.name");
            if (name != null && project != null) {
                if (!project.isDefault() && !name.contains("{")) {
                    String named = ConfigurableExtensionPointUtil.getString(bundle, id + ".named.settings.display.name");
                    String string = name = named != null ? named : name;
                }
                if (name.contains("{")) {
                    name = StringUtil.first((String)MessageFormat.format(name, project.getName()), (int)30, (boolean)true);
                }
            }
            node.myValue = new SortedConfigurableGroup(id, name, help, weight2);
        }
        if (configurables != null) {
            ((SortedConfigurableGroup)node.myValue).myList.addAll(configurables);
        }
        if (node.myParent == null && !groupId.equals("root")) {
            String parentId = ConfigurableExtensionPointUtil.getString(bundle, id + ".settings.parent");
            parentId = (String)Node.cyclic(tree, parentId, "root", groupId, node);
            node.myParent = Node.add(tree, parentId, groupId);
            ConfigurableExtensionPointUtil.addGroup(tree, project, parentId, null, bundle);
        }
    }

    public static Map<String, List<Configurable>> groupConfigurables(@NotNull List<? extends Configurable> configurables) {
        THashMap tree = new THashMap();
        for (Configurable configurable : configurables) {
            String id;
            if (!(configurable instanceof ConfigurableWrapper)) {
                Node.add((Map)tree, "other", configurable);
                continue;
            }
            ConfigurableWrapper wrapper2 = (ConfigurableWrapper)configurable;
            try {
                id = wrapper2.getId();
            }
            catch (Throwable e) {
                LOG.error("Cannot create configurable", e);
                continue;
            }
            Node node = Node.get((Map)tree, id);
            if (node.myValue != null) {
                LOG.warn("ignore configurable with duplicated id: " + id);
                continue;
            }
            String parentId = wrapper2.getParentId();
            String groupId = wrapper2.getExtensionPoint().groupId;
            if (groupId != null) {
                if (parentId != null) {
                    LOG.warn("ignore deprecated groupId: " + groupId + " for id: " + id);
                } else {
                    parentId = groupId;
                }
            }
            parentId = (String)Node.cyclic((Map)tree, parentId, "other", id, node);
            node.myParent = Node.add((Map)tree, parentId, node);
            node.myValue = wrapper2;
        }
        THashMap map2 = new THashMap();
        for (String id : ArrayUtilRt.toStringArray(tree.keySet())) {
            List<Configurable> list2;
            Node node = (Node)tree.get(id);
            if (node == null || (list2 = ConfigurableExtensionPointUtil.getConfigurables((Map<String, Node<ConfigurableWrapper>>)tree, node)) == null) continue;
            map2.put(id, list2);
            tree.remove(id);
        }
        return map2;
    }

    private static List<Configurable> getConfigurables(Map<String, Node<ConfigurableWrapper>> tree, Node<ConfigurableWrapper> node) {
        if (node.myChildren == null) {
            if (node.myValue == null) {
                return ContainerUtil.newArrayList();
            }
            return null;
        }
        ArrayList list2 = ContainerUtil.newArrayListWithCapacity((int)node.myChildren.size());
        Iterator<Object> iterator = node.myChildren.iterator();
        while (iterator.hasNext()) {
            Object child2 = iterator.next();
            if (child2 instanceof Configurable) {
                list2.add((Configurable)child2);
            } else {
                Node value = (Node)child2;
                if (ConfigurableExtensionPointUtil.getConfigurables(tree, value) != null) {
                    throw new IllegalStateException("unexpected algorithm state");
                }
                list2.add(value.myValue);
                tree.remove(((ConfigurableWrapper)value.myValue).getId());
            }
            iterator.remove();
        }
        if (node.myValue == null) {
            return list2;
        }
        for (Configurable configurable : list2) {
            node.myValue = ((ConfigurableWrapper)node.myValue).addChild(configurable);
        }
        return null;
    }

    private static List<Configurable> getConfigurables(@Nullable Project project, boolean withIdeSettings) {
        Application application;
        ArrayList list2 = ContainerUtil.newArrayList();
        if (withIdeSettings && (application = ApplicationManager.getApplication()) != null) {
            for (ConfigurableEP extension : Configurable.APPLICATION_CONFIGURABLE.getExtensionList()) {
                ConfigurableExtensionPointUtil.addValid(list2, (Configurable)ConfigurableWrapper.wrapConfigurable(extension, true), null);
            }
        }
        if (project != null && !project.isDisposed()) {
            for (ConfigurableEP extension : Configurable.PROJECT_CONFIGURABLE.getExtensionList((AreaInstance)project)) {
                ConfigurableExtensionPointUtil.addValid(list2, (Configurable)ConfigurableWrapper.wrapConfigurable(extension, true), project);
            }
        }
        return list2;
    }

    private static void addValid(List<? super Configurable> list2, Configurable configurable, Project project) {
        if (ConfigurableExtensionPointUtil.isValid(configurable, project)) {
            list2.add((Configurable)configurable);
        }
    }

    private static boolean isValid(Configurable configurable, Project project) {
        if (configurable == null) {
            return false;
        }
        OptionalConfigurable optional = ConfigurableWrapper.cast(OptionalConfigurable.class, (UnnamedConfigurable)configurable);
        if (optional != null && !optional.needDisplay()) {
            return false;
        }
        return project == null || !project.isDefault() || !ConfigurableWrapper.isNonDefaultProject(configurable);
    }

    @Nullable
    public static ResourceBundle getBundle(@NotNull String resource, @Nullable Iterable<? extends Configurable> configurables, @Nullable ResourceBundle alternative) {
        ResourceBundle bundle = OptionsBundle.getBundle();
        if (ConfigurableExtensionPointUtil.getString(bundle, resource) != null) {
            return bundle;
        }
        if (configurables != null) {
            for (Configurable configurable : configurables) {
                ConfigurableWrapper wrapper2;
                if (!(configurable instanceof ConfigurableWrapper) || ConfigurableExtensionPointUtil.getString(bundle = (wrapper2 = (ConfigurableWrapper)configurable).getExtensionPoint().findBundle(), resource) == null) continue;
                return bundle;
            }
        }
        if (ConfigurableExtensionPointUtil.getString(alternative, resource) != null) {
            return alternative;
        }
        return null;
    }

    private static String getString(ResourceBundle bundle, String resource) {
        if (bundle == null) {
            return null;
        }
        try {
            return BundleBase.replaceMnemonicAmpersand((String)bundle.getString(resource));
        }
        catch (MissingResourceException ignored) {
            return null;
        }
    }

    private static int getInt(ResourceBundle bundle, String resource) {
        try {
            String value = ConfigurableExtensionPointUtil.getString(bundle, resource);
            return value == null ? 0 : Integer.parseInt(value);
        }
        catch (NumberFormatException ignored) {
            return 0;
        }
    }

    private static boolean isSuppressed(Configurable each, ConfigurableFilter filter) {
        return !ConfigurableExtensionPointUtil.isValid(each, null) || filter != null && !filter.isIncluded(each);
    }

    @Deprecated
    @NotNull
    public static <T extends Configurable> T findProjectConfigurable(@NotNull Project project, @NotNull Class<T> configurableClass) {
        return ConfigurableExtensionPointUtil.findConfigurable(Configurable.PROJECT_CONFIGURABLE.getExtensionList((AreaInstance)project), configurableClass);
    }

    @NotNull
    private static <T extends Configurable> T findConfigurable(@NotNull List<ConfigurableEP<Configurable>> extensions, Class<T> configurableClass) {
        for (ConfigurableEP<Configurable> extension : extensions) {
            Configurable configurable;
            if (!extension.canCreateConfigurable() || !configurableClass.isInstance(configurable = (Configurable)extension.createConfigurable())) continue;
            return (T)((Configurable)configurableClass.cast(configurable));
        }
        throw new IllegalArgumentException("Cannot find configurable of " + configurableClass);
    }

    @Nullable
    public static Configurable createProjectConfigurableForProvider(@NotNull Project project, Class<? extends ConfigurableProvider> providerClass) {
        return ConfigurableExtensionPointUtil.createConfigurableForProvider(Configurable.PROJECT_CONFIGURABLE.getExtensionList((AreaInstance)project), providerClass);
    }

    @Nullable
    public static Configurable createApplicationConfigurableForProvider(Class<? extends ConfigurableProvider> providerClass) {
        return ConfigurableExtensionPointUtil.createConfigurableForProvider(Configurable.APPLICATION_CONFIGURABLE.getExtensionList(), providerClass);
    }

    @Nullable
    private static Configurable createConfigurableForProvider(@NotNull List<ConfigurableEP<Configurable>> extensions, Class<? extends ConfigurableProvider> providerClass) {
        for (ConfigurableEP<Configurable> extension : extensions) {
            Class aClass;
            if (extension.providerClass == null || (aClass = extension.findClassNoExceptions(extension.providerClass)) == null || !providerClass.isAssignableFrom(aClass)) continue;
            return (Configurable)extension.createConfigurable();
        }
        return null;
    }

    private static final class Node<V> {
        List<Object> myChildren;
        Node<V> myParent;
        V myValue;

        private Node() {
        }

        private static <I, V> Node<V> get(@NotNull Map<I, Node<V>> tree, @NotNull I id) {
            Node<V> node = tree.get(id);
            if (node == null) {
                node = new Node<V>();
                tree.put(id, node);
            }
            return node;
        }

        private static <I, V> Node<V> add(@NotNull Map<I, Node<V>> tree, @NotNull I id, Object child2) {
            Node<V> node = Node.get(tree, id);
            if (node.myChildren == null) {
                node.myChildren = new SmartList();
            }
            node.myChildren.add(child2);
            return node;
        }

        private static <I, V> boolean cyclic(@NotNull Map<I, Node<V>> tree, @NotNull I id, Node<V> parent) {
            Node<V> node = tree.get(id);
            while (node != null) {
                if (node == parent) {
                    return true;
                }
                node = node.myParent;
            }
            return false;
        }

        private static <I, V> I cyclic(@NotNull Map<I, Node<V>> tree, @Nullable I id, I idDefault, I idNode, Node<V> parent) {
            if (id == null) {
                id = idDefault;
            }
            if (Node.cyclic(tree, id, parent)) {
                LOG.warn("ignore cyclic dependency: " + id + " cannot contain " + idNode);
                id = idDefault;
            }
            return id;
        }
    }
}

