/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.options.ex;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurableEP;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.NonDefaultProjectConfigurable;
import com.intellij.openapi.options.OptionalConfigurable;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.options.UnnamedConfigurable;
import com.intellij.openapi.options.ex.ConfigurableCardPanel;
import com.intellij.openapi.options.ex.Weighted;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Function;
import com.intellij.util.NullableFunction;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.JComponent;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ConfigurableWrapper
implements SearchableConfigurable,
Weighted {
    private static final Logger LOG = Logger.getInstance(ConfigurableWrapper.class);
    private final ConfigurableEP myEp;
    int myWeight;
    @Nullable
    private UnnamedConfigurable myConfigurable;

    @Nullable
    public static <T extends UnnamedConfigurable> T wrapConfigurable(@NotNull ConfigurableEP<T> ep) {
        return ConfigurableWrapper.wrapConfigurable(ep, false);
    }

    @Nullable
    public static <T extends UnnamedConfigurable> T wrapConfigurable(@NotNull ConfigurableEP<T> ep, boolean settings) {
        if (!ep.canCreateConfigurable()) {
            return null;
        }
        if (settings || ep.displayName != null || ep.key != null || ep.parentId != null || ep.groupId != null) {
            return (T)(!ep.dynamic && ep.children == null && ep.childrenEPName == null ? new ConfigurableWrapper(ep) : new CompositeWrapper((ConfigurableEP)ep, new Configurable[0]));
        }
        return ConfigurableWrapper.createConfigurable(ep, LOG.isDebugEnabled());
    }

    private static <T extends UnnamedConfigurable> T createConfigurable(@NotNull ConfigurableEP<T> ep, boolean log2) {
        long time = System.currentTimeMillis();
        UnnamedConfigurable configurable = ep.createConfigurable();
        if (configurable instanceof Configurable) {
            ConfigurableCardPanel.warn((Configurable)configurable, "init", time);
            if (log2) {
                LOG.debug("cannot create configurable wrapper for " + configurable.getClass());
            }
        }
        return (T)configurable;
    }

    public static <T extends UnnamedConfigurable> List<T> createConfigurables(ExtensionPointName<? extends ConfigurableEP<T>> name) {
        return ContainerUtil.mapNotNull((Object[])name.getExtensions(), (Function)((NullableFunction)ep -> ConfigurableWrapper.wrapConfigurable(ep)));
    }

    public static boolean hasOwnContent(UnnamedConfigurable configurable) {
        SearchableConfigurable.Parent parent = ConfigurableWrapper.cast(SearchableConfigurable.Parent.class, configurable);
        return parent != null && parent.hasOwnContent();
    }

    public static boolean isNonDefaultProject(Configurable configurable) {
        return configurable instanceof NonDefaultProjectConfigurable || configurable instanceof ConfigurableWrapper && ((ConfigurableWrapper)configurable).myEp.nonDefaultProject;
    }

    @Nullable
    public static <T> T cast(@NotNull Class<T> type, UnnamedConfigurable configurable) {
        if (configurable instanceof ConfigurableWrapper) {
            Class configurableType;
            ConfigurableWrapper wrapper2 = (ConfigurableWrapper)configurable;
            if (wrapper2.myConfigurable == null && ((configurableType = wrapper2.getExtensionPoint().getConfigurableType()) != null ? !type.isAssignableFrom(configurableType) : type == OptionalConfigurable.class)) {
                return null;
            }
            configurable = wrapper2.getConfigurable();
        }
        return type.isInstance(configurable) ? (T)type.cast(configurable) : null;
    }

    private ConfigurableWrapper(@NotNull ConfigurableEP ep) {
        this.myEp = ep;
        this.myWeight = ep.groupWeight;
    }

    @Nullable
    public UnnamedConfigurable getRawConfigurable() {
        return this.myConfigurable;
    }

    public UnnamedConfigurable getConfigurable() {
        if (this.myConfigurable == null) {
            this.myConfigurable = ConfigurableWrapper.createConfigurable(this.myEp, false);
            if (this.myConfigurable == null) {
                LOG.error("Can't instantiate configurable for " + this.myEp);
            } else if (LOG.isDebugEnabled()) {
                LOG.debug("created configurable for " + this.myConfigurable.getClass());
            }
        }
        return this.myConfigurable;
    }

    @Override
    public int getWeight() {
        return this.myWeight;
    }

    @Nls
    public String getDisplayName() {
        if (this.myEp.displayName == null && this.myEp.key == null) {
            boolean loaded = this.myConfigurable != null;
            Configurable configurable = ConfigurableWrapper.cast(Configurable.class, (UnnamedConfigurable)this);
            if (configurable != null) {
                String name = configurable.getDisplayName();
                if (!loaded && LOG.isDebugEnabled()) {
                    LOG.debug("XML does not provide displayName for " + configurable.getClass());
                }
                return name;
            }
        }
        return this.myEp.getDisplayName();
    }

    public String getProviderClass() {
        return this.myEp.providerClass;
    }

    @Nullable
    public String getHelpTopic() {
        UnnamedConfigurable configurable = this.getConfigurable();
        return configurable instanceof Configurable ? ((Configurable)configurable).getHelpTopic() : null;
    }

    @Nullable
    public JComponent createComponent() {
        return this.getConfigurable().createComponent();
    }

    public boolean isModified() {
        return this.getConfigurable().isModified();
    }

    public void apply() throws ConfigurationException {
        this.getConfigurable().apply();
    }

    public void reset() {
        this.getConfigurable().reset();
    }

    public void disposeUIResources() {
        UnnamedConfigurable configurable = this.myConfigurable;
        if (configurable != null) {
            configurable.disposeUIResources();
        }
    }

    @NotNull
    public String getId() {
        if (this.myEp.id != null) {
            return this.myEp.id;
        }
        boolean loaded = this.myConfigurable != null;
        SearchableConfigurable configurable = ConfigurableWrapper.cast(SearchableConfigurable.class, (UnnamedConfigurable)this);
        if (configurable != null) {
            String id = configurable.getId();
            if (!loaded) {
                LOG.debug("XML does not provide id for " + configurable.getClass());
            }
            return id;
        }
        return this.myEp.providerClass != null ? this.myEp.providerClass : (this.myEp.instanceClass != null ? this.myEp.instanceClass : this.myEp.implementationClass);
    }

    @NotNull
    public ConfigurableEP getExtensionPoint() {
        return this.myEp;
    }

    public String getParentId() {
        return this.myEp.parentId;
    }

    public ConfigurableWrapper addChild(Configurable configurable) {
        return new CompositeWrapper(this.myEp, new Configurable[]{configurable});
    }

    public String toString() {
        return this.getDisplayName();
    }

    @Nullable
    public Runnable enableSearch(String option2) {
        UnnamedConfigurable configurable = this.getConfigurable();
        return configurable instanceof SearchableConfigurable ? ((SearchableConfigurable)configurable).enableSearch(option2) : null;
    }

    @NotNull
    public Class<?> getOriginalClass() {
        UnnamedConfigurable configurable = this.getConfigurable();
        return configurable instanceof SearchableConfigurable ? ((SearchableConfigurable)configurable).getOriginalClass() : configurable.getClass();
    }

    private static class CompositeWrapper
    extends ConfigurableWrapper
    implements Configurable.Composite {
        private Configurable[] myKids;
        private Comparator<Configurable> myComparator;
        private boolean isInitialized;

        private CompositeWrapper(@NotNull ConfigurableEP ep, Configurable ... kids) {
            super(ep);
            this.myKids = kids;
        }

        @NotNull
        public Configurable[] getConfigurables() {
            if (!this.isInitialized) {
                Object[] extensions;
                ConfigurableEP[] composite;
                long time = System.currentTimeMillis();
                ArrayList<Configurable> list2 = new ArrayList<Configurable>();
                if (((ConfigurableWrapper)this).myEp.dynamic && (composite = CompositeWrapper.cast(Configurable.Composite.class, (UnnamedConfigurable)this)) != null) {
                    Collections.addAll(list2, composite.getConfigurables());
                }
                if (((ConfigurableWrapper)this).myEp.children != null) {
                    for (ConfigurableEP ep : ((ConfigurableWrapper)this).myEp.getChildren()) {
                        if (!ep.isAvailable()) continue;
                        list2.add((Configurable)CompositeWrapper.wrapConfigurable(ep));
                    }
                }
                if (((ConfigurableWrapper)this).myEp.childrenEPName != null && (extensions = Extensions.getArea((AreaInstance)((ConfigurableWrapper)this).myEp.getProject()).getExtensionPoint(((ConfigurableWrapper)this).myEp.childrenEPName).getExtensions()).length > 0) {
                    Configurable.Composite composite2;
                    if (extensions[0] instanceof ConfigurableEP) {
                        for (Object object : extensions) {
                            list2.add((Configurable)CompositeWrapper.wrapConfigurable((ConfigurableEP)object));
                        }
                    } else if (!((ConfigurableWrapper)this).myEp.dynamic && (composite2 = CompositeWrapper.cast(Configurable.Composite.class, (UnnamedConfigurable)this)) != null) {
                        Collections.addAll(list2, composite2.getConfigurables());
                    }
                }
                Collections.addAll(list2, this.myKids);
                for (Configurable configurable : list2) {
                    if (!(configurable instanceof Weighted) || ((Weighted)configurable).getWeight() == 0) continue;
                    this.myComparator = COMPARATOR;
                    Collections.sort(list2, this.myComparator);
                    break;
                }
                this.myKids = list2.toArray(new Configurable[0]);
                this.isInitialized = true;
                ConfigurableCardPanel.warn((Configurable)this, "children", time);
            }
            return this.myKids;
        }

        @Override
        public ConfigurableWrapper addChild(Configurable configurable) {
            if (this.myComparator != null) {
                int index = Arrays.binarySearch(this.myKids, configurable, this.myComparator);
                LOG.assertTrue(index < 0, (Object)"similar configurable is already exist");
                this.myKids = (Configurable[])ArrayUtil.insert((Object[])this.myKids, (int)(-1 - index), (Object)configurable);
            } else {
                this.myKids = (Configurable[])ArrayUtil.append((Object[])this.myKids, (Object)configurable);
            }
            return this;
        }
    }
}

