/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.options.newEditor;

import com.intellij.CommonBundle;
import com.intellij.configurationStore.StoreUtil;
import com.intellij.ide.HelpTooltip;
import com.intellij.idea.ActionsBundle;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.application.TransactionGuard;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurableGroup;
import com.intellij.openapi.options.OptionsBundle;
import com.intellij.openapi.options.newEditor.AbstractEditor;
import com.intellij.openapi.options.newEditor.OptionsEditorColleague;
import com.intellij.openapi.options.newEditor.SettingsEditor;
import com.intellij.openapi.options.newEditor.SettingsFilter;
import com.intellij.openapi.options.newEditor.SettingsTreeView;
import com.intellij.openapi.options.newEditor.SingleSettingEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.IdeUICustomization;
import com.intellij.ui.SearchTextField;
import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SettingsDialog
extends DialogWrapper
implements DataProvider {
    public static final String DIMENSION_KEY = "SettingsEditor";
    private final String myDimensionServiceKey;
    private final AbstractEditor myEditor;
    private final boolean myApplyButtonNeeded;
    private boolean myResetButtonNeeded;

    public SettingsDialog(Project project, String key, @NotNull Configurable configurable, boolean showApplyButton, boolean showResetButton) {
        super(project, true);
        this.myDimensionServiceKey = key;
        this.myEditor = new SingleSettingEditor(this.myDisposable, configurable);
        this.myApplyButtonNeeded = showApplyButton;
        this.myResetButtonNeeded = showResetButton;
        this.init(configurable, project);
    }

    public SettingsDialog(@NotNull Component parent, String key, @NotNull Configurable configurable, boolean showApplyButton, boolean showResetButton) {
        super(parent, true);
        this.myDimensionServiceKey = key;
        this.myEditor = new SingleSettingEditor(this.myDisposable, configurable);
        this.myApplyButtonNeeded = showApplyButton;
        this.myResetButtonNeeded = showResetButton;
        this.init(configurable, null);
    }

    public SettingsDialog(@NotNull Project project, @NotNull ConfigurableGroup[] groups, Configurable configurable, String filter) {
        super(project, true);
        this.myDimensionServiceKey = DIMENSION_KEY;
        this.myEditor = new SettingsEditor(this.myDisposable, project, groups, configurable, filter, this::treeViewFactory);
        this.myApplyButtonNeeded = true;
        this.init(null, project);
    }

    protected SettingsTreeView treeViewFactory(SettingsFilter filter, ConfigurableGroup[] groups) {
        return new SettingsTreeView(filter, groups);
    }

    public void show() {
        TransactionGuard.getInstance().submitTransactionAndWait(() -> super.show());
    }

    private void init(Configurable configurable, @Nullable Project project) {
        String name = configurable == null ? null : configurable.getDisplayName();
        String title = CommonBundle.settingsTitle();
        if (project != null && project.isDefault()) {
            title = OptionsBundle.message((String)"title.for.new.projects", (Object[])new Object[]{title, StringUtil.capitalize((String)IdeUICustomization.getInstance().getProjectConceptName())});
        }
        this.setTitle(name == null ? title : name.replace('\n', ' '));
        ShortcutSet set2 = SettingsDialog.getFindActionShortcutSet();
        if (set2 != null) {
            new SearchTextField.FindAction().registerCustomShortcutSet(set2, (JComponent)this.getRootPane(), this.myDisposable);
        }
        this.init();
    }

    protected void setHelpTooltip(JButton helpButton) {
        if (Registry.is((String)"ide.helptooltip.enabled")) {
            new HelpTooltip().setDescription(ActionsBundle.actionDescription((String)"HelpTopics")).installOn((JComponent)helpButton);
        } else {
            super.setHelpTooltip(helpButton);
        }
    }

    public Object getData(@NotNull String dataId) {
        if (this.myEditor instanceof DataProvider) {
            DataProvider provider = (DataProvider)this.myEditor;
            return provider.getData(dataId);
        }
        return null;
    }

    protected String getDimensionServiceKey() {
        return this.myDimensionServiceKey;
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myEditor.getPreferredFocusedComponent();
    }

    public boolean isTypeAheadEnabled() {
        return true;
    }

    @NotNull
    protected DialogWrapper.DialogStyle getStyle() {
        return DialogWrapper.DialogStyle.COMPACT;
    }

    protected JComponent createCenterPanel() {
        return this.myEditor;
    }

    protected void tryAddOptionsListener(OptionsEditorColleague colleague) {
        if (this.myEditor instanceof SettingsEditor) {
            ((SettingsEditor)this.myEditor).addOptionsListener(colleague);
        }
    }

    @NotNull
    protected Action[] createActions() {
        Action reset;
        ArrayList<Action> actions = new ArrayList<Action>();
        actions.add(this.getOKAction());
        actions.add(this.getCancelAction());
        Action apply2 = this.myEditor.getApplyAction();
        if (apply2 != null && this.myApplyButtonNeeded) {
            actions.add(apply2);
        }
        if ((reset = this.myEditor.getResetAction()) != null && this.myResetButtonNeeded) {
            actions.add(reset);
        }
        if (this.getHelpId() != null) {
            actions.add(this.getHelpAction());
        }
        return actions.toArray(new Action[0]);
    }

    @Nullable
    protected String getHelpId() {
        return this.myEditor.getHelpTopic();
    }

    public void doOKAction() {
        this.applyAndClose(true);
    }

    public void applyAndClose(boolean scheduleSave) {
        if (this.myEditor.apply()) {
            if (scheduleSave) {
                StoreUtil.saveDocumentsAndProjectsAndApp(true);
            }
            super.doOKAction();
        }
    }

    public void doCancelAction(AWTEvent source) {
        if ((source instanceof KeyEvent || source instanceof ActionEvent) && !this.myEditor.cancel()) {
            return;
        }
        super.doCancelAction(source);
    }

    static ShortcutSet getFindActionShortcutSet() {
        AnAction action = ActionManager.getInstance().getAction("Find");
        return action == null ? null : action.getShortcutSet();
    }
}

