/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.paths;

import com.intellij.ide.BrowserUtil;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReferenceBase;
import com.intellij.psi.SyntheticElement;
import com.intellij.psi.impl.FakePsiElement;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WebReference
extends PsiReferenceBase<PsiElement> {
    @Nullable
    private final String myUrl;

    public WebReference(@NotNull PsiElement element) {
        this(element, (String)null);
    }

    public WebReference(@NotNull PsiElement element, @Nullable String url) {
        super(element, true);
        this.myUrl = url;
    }

    public WebReference(@NotNull PsiElement element, @NotNull TextRange textRange) {
        this(element, textRange, null);
    }

    public WebReference(@NotNull PsiElement element, TextRange textRange, @Nullable String url) {
        super(element, textRange, true);
        this.myUrl = url;
    }

    public PsiElement resolve() {
        return new MyFakePsiElement();
    }

    public String getUrl() {
        return this.myUrl != null ? this.myUrl : this.getValue();
    }

    class MyFakePsiElement
    extends FakePsiElement
    implements SyntheticElement {
        MyFakePsiElement() {
        }

        public PsiElement getParent() {
            return WebReference.this.myElement;
        }

        @Override
        public void navigate(boolean requestFocus) {
            BrowserUtil.browse((String)WebReference.this.getUrl());
        }

        @Override
        public String getPresentableText() {
            return WebReference.this.getUrl();
        }

        @Override
        public String getName() {
            return WebReference.this.getUrl();
        }

        @Override
        public TextRange getTextRange() {
            TextRange rangeInElement = WebReference.this.getRangeInElement();
            TextRange elementRange = WebReference.this.myElement.getTextRange();
            return elementRange != null ? rangeInElement.shiftRight(elementRange.getStartOffset()) : rangeInElement;
        }
    }
}

