/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.progress.impl;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.progress.PerformInBackgroundOption;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.progress.TaskInfo;
import com.intellij.openapi.progress.util.ProgressWindow;
import com.intellij.openapi.project.DumbModeAction;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.openapi.wm.ex.StatusBarEx;
import com.intellij.openapi.wm.ex.WindowManagerEx;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BackgroundableProcessIndicator
extends ProgressWindow {
    protected StatusBarEx myStatusBar;
    private PerformInBackgroundOption myOption;
    private TaskInfo myInfo;
    private boolean myDisposed;
    private DumbModeAction myDumbModeAction = DumbModeAction.NOTHING;

    public BackgroundableProcessIndicator(@NotNull Task.Backgroundable task2) {
        this(task2.getProject(), (TaskInfo)task2, (PerformInBackgroundOption)task2);
        this.myDumbModeAction = task2.getDumbModeAction();
        if (this.myDumbModeAction == DumbModeAction.CANCEL) {
            task2.getProject().getMessageBus().connect((Disposable)this).subscribe(DumbService.DUMB_MODE, (Object)new DumbService.DumbModeListener(){

                public void enteredDumbMode() {
                    BackgroundableProcessIndicator.this.cancel();
                }
            });
        }
    }

    public BackgroundableProcessIndicator(@Nullable Project project, @NotNull TaskInfo info, @NotNull PerformInBackgroundOption option2) {
        super(info.isCancellable(), true, project, info.getCancelText());
        this.setOwnerTask(info);
        this.myOption = option2;
        this.myInfo = info;
        this.setTitle(info.getTitle());
        Project nonDefaultProject = project == null || project.isDisposed() ? null : (project.isDefault() ? null : project);
        IdeFrame frame = ((WindowManagerEx)WindowManager.getInstance()).findFrameFor(nonDefaultProject);
        this.myStatusBar = frame != null ? (StatusBarEx)frame.getStatusBar() : null;
        this.myBackgrounded = this.shouldStartInBackground();
        if (this.myBackgrounded) {
            this.doBackground();
        }
    }

    private boolean shouldStartInBackground() {
        return this.myOption.shouldStartInBackground() && this.myStatusBar != null;
    }

    public BackgroundableProcessIndicator(Project project, final @Nls String progressTitle, @NotNull PerformInBackgroundOption option2, final @Nls String cancelButtonText, final @Nls String backgroundStopTooltip, final boolean cancellable) {
        this(project, new TaskInfo(){

            @NotNull
            public String getTitle() {
                return progressTitle;
            }

            public String getCancelText() {
                return cancelButtonText;
            }

            public String getCancelTooltipText() {
                return backgroundStopTooltip;
            }

            public boolean isCancellable() {
                return cancellable;
            }
        }, option2);
    }

    @Deprecated
    public DumbModeAction getDumbModeAction() {
        return this.myDumbModeAction;
    }

    @Override
    protected void showDialog() {
        if (this.myDisposed) {
            return;
        }
        if (this.shouldStartInBackground()) {
            return;
        }
        super.showDialog();
    }

    @Override
    public void background() {
        if (this.myDisposed) {
            return;
        }
        this.myOption.processSentToBackground();
        this.doBackground();
        super.background();
    }

    private void doBackground() {
        if (this.myStatusBar != null) {
            this.myStatusBar.addProgress(this, this.myInfo);
        }
    }

    @Override
    public void dispose() {
        super.dispose();
        this.myDisposed = true;
        this.myInfo = null;
        this.myStatusBar = null;
        this.myOption = null;
    }

    @Override
    public boolean isShowing() {
        return this.isModal() || !this.isBackgrounded();
    }

    @Override
    public String toString() {
        return super.toString() + "; task=" + this.myInfo;
    }
}

