/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.progress.impl;

import com.google.common.collect.ConcurrentHashMultiset;
import com.intellij.concurrency.JobScheduler;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ex.ApplicationEx;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.PerformInBackgroundOption;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.StandardProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.progress.TaskInfo;
import com.intellij.openapi.progress.WrappedProgressIndicator;
import com.intellij.openapi.progress.impl.NonCancelableIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.wm.ex.ProgressIndicatorEx;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.containers.ConcurrentLongObjectMap;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.SmartHashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.JComponent;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CoreProgressManager
extends ProgressManager
implements Disposable {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.progress.impl.CoreProgressManager");
    static final int CHECK_CANCELED_DELAY_MILLIS = 10;
    private final AtomicInteger myUnsafeProgressCount = new AtomicInteger(0);
    public static final boolean ENABLED = !"disabled".equals(System.getProperty("idea.ProcessCanceledException"));
    private static CheckCanceledHook ourCheckCanceledHook;
    private ScheduledFuture<?> myCheckCancelledFuture;
    private static final Map<ProgressIndicator, Set<Thread>> threadsUnderIndicator;
    private static final ConcurrentLongObjectMap<ProgressIndicator> currentIndicators;
    private static final ConcurrentLongObjectMap<ProgressIndicator> threadTopLevelIndicators;
    static final Set<Thread> threadsUnderCanceledIndicator;
    private static volatile boolean shouldCheckCanceled;
    private static final Collection<ProgressIndicator> nonStandardIndicators;
    private static final ThreadLocal<Boolean> isInNonCancelableSection;

    private void startBackgroundNonStandardIndicatorsPing() {
        if (this.myCheckCancelledFuture == null) {
            this.myCheckCancelledFuture = JobScheduler.getScheduler().scheduleWithFixedDelay(() -> {
                for (ProgressIndicator indicator : nonStandardIndicators) {
                    try {
                        indicator.checkCanceled();
                    }
                    catch (ProcessCanceledException e) {
                        this.indicatorCanceled(indicator);
                    }
                }
            }, 0L, 10L, TimeUnit.MILLISECONDS);
        }
    }

    private void stopBackgroundNonStandardIndicatorsPing() {
        if (this.myCheckCancelledFuture != null) {
            this.myCheckCancelledFuture.cancel(true);
            this.myCheckCancelledFuture = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        Map<ProgressIndicator, Set<Thread>> map2 = threadsUnderIndicator;
        synchronized (map2) {
            this.stopBackgroundNonStandardIndicatorsPing();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static boolean isThreadUnderIndicator(@NotNull ProgressIndicator indicator, @NotNull Thread thread) {
        Map<ProgressIndicator, Set<Thread>> map2 = threadsUnderIndicator;
        synchronized (map2) {
            Set<Thread> threads = threadsUnderIndicator.get(indicator);
            return threads != null && threads.contains(thread);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<ProgressIndicator> getCurrentIndicators() {
        Map<ProgressIndicator, Set<Thread>> map2 = threadsUnderIndicator;
        synchronized (map2) {
            return new ArrayList<ProgressIndicator>(threadsUnderIndicator.keySet());
        }
    }

    public static boolean runCheckCanceledHooks(@Nullable ProgressIndicator indicator) {
        CheckCanceledHook hook = ourCheckCanceledHook;
        return hook != null && hook.runHook(indicator);
    }

    protected void doCheckCanceled() throws ProcessCanceledException {
        if (!shouldCheckCanceled) {
            return;
        }
        ProgressIndicator progress = this.getProgressIndicator();
        if (progress != null && ENABLED) {
            progress.checkCanceled();
        } else {
            CoreProgressManager.runCheckCanceledHooks(progress);
        }
    }

    public boolean hasProgressIndicator() {
        return this.getProgressIndicator() != null;
    }

    public boolean hasUnsafeProgressIndicator() {
        return this.myUnsafeProgressCount.get() > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasModalProgressIndicator() {
        Map<ProgressIndicator, Set<Thread>> map2 = threadsUnderIndicator;
        synchronized (map2) {
            return ContainerUtil.or(threadsUnderIndicator.keySet(), i -> i.isModal());
        }
    }

    public void runProcess(@NotNull Runnable process2, @Nullable ProgressIndicator progress) {
        this.executeProcessUnderProgress(() -> {
            try {
                try {
                    if (progress != null && !progress.isRunning()) {
                        progress.start();
                    }
                }
                catch (RuntimeException e) {
                    throw e;
                }
                catch (Throwable e) {
                    throw new RuntimeException(e);
                }
                process2.run();
            }
            finally {
                if (progress != null && progress.isRunning()) {
                    progress.stop();
                    if (progress instanceof ProgressIndicatorEx) {
                        ((ProgressIndicatorEx)progress).processFinish();
                    }
                }
            }
        }, progress);
    }

    public <T> T runProcess(@NotNull Computable<T> process2, ProgressIndicator progress) throws ProcessCanceledException {
        Ref ref = new Ref();
        this.runProcess(() -> ref.set(process2.compute()), progress);
        return (T)ref.get();
    }

    public void executeNonCancelableSection(@NotNull Runnable runnable2) {
        if (this.isInNonCancelableSection()) {
            runnable2.run();
        } else {
            try {
                isInNonCancelableSection.set(Boolean.TRUE);
                this.executeProcessUnderProgress(runnable2, (ProgressIndicator)NonCancelableIndicator.INSTANCE);
            }
            finally {
                isInNonCancelableSection.remove();
            }
        }
    }

    public boolean runProcessWithProgressSynchronously(@NotNull Runnable process2, @NotNull @Nls String progressTitle, boolean canBeCanceled, @Nullable Project project) {
        return this.runProcessWithProgressSynchronously(process2, progressTitle, canBeCanceled, project, null);
    }

    public <T, E extends Exception> T runProcessWithProgressSynchronously(final @NotNull ThrowableComputable<T, E> process2, @NotNull @Nls String progressTitle, boolean canBeCanceled, @Nullable Project project) throws E {
        final AtomicReference result2 = new AtomicReference();
        final AtomicReference exception = new AtomicReference();
        this.runProcessWithProgressSynchronously((Task)new Task.Modal(project, progressTitle, canBeCanceled){

            public void run(@NotNull ProgressIndicator indicator) {
                try {
                    Object compute = process2.compute();
                    result2.set(compute);
                }
                catch (Throwable t) {
                    exception.set(t);
                }
            }
        }, null);
        Throwable t = (Throwable)exception.get();
        if (t != null) {
            ExceptionUtil.rethrowUnchecked((Throwable)t);
            Exception e = (Exception)t;
            throw e;
        }
        return (T)result2.get();
    }

    public boolean runProcessWithProgressSynchronously(final @NotNull Runnable process2, @NotNull @Nls String progressTitle, boolean canBeCanceled, @Nullable Project project, @Nullable JComponent parentComponent) {
        Task.Modal task2 = new Task.Modal(project, progressTitle, canBeCanceled){

            public void run(@NotNull ProgressIndicator indicator) {
                process2.run();
            }
        };
        return this.runProcessWithProgressSynchronously((Task)task2, parentComponent);
    }

    public void runProcessWithProgressAsynchronously(@NotNull Project project, @NotNull @Nls String progressTitle, @NotNull Runnable process2, @Nullable Runnable successRunnable, @Nullable Runnable canceledRunnable) {
        this.runProcessWithProgressAsynchronously(project, progressTitle, process2, successRunnable, canceledRunnable, PerformInBackgroundOption.DEAF);
    }

    public void runProcessWithProgressAsynchronously(@NotNull Project project, @NotNull @Nls String progressTitle, final @NotNull Runnable process2, final @Nullable Runnable successRunnable, final @Nullable Runnable canceledRunnable, @NotNull PerformInBackgroundOption option2) {
        this.runProcessWithProgressAsynchronously(new Task.Backgroundable(project, progressTitle, true, option2){

            public void run(@NotNull ProgressIndicator indicator) {
                process2.run();
            }

            public void onCancel() {
                if (canceledRunnable != null) {
                    canceledRunnable.run();
                }
            }

            public void onSuccess() {
                if (successRunnable != null) {
                    successRunnable.run();
                }
            }
        });
    }

    public void run(@NotNull Task task2) {
        if (task2.isHeadless()) {
            if (ApplicationManager.getApplication().isDispatchThread()) {
                this.runProcessWithProgressSynchronously(task2, null);
            } else {
                this.runProcessWithProgressInCurrentThread(task2, (ProgressIndicator)new EmptyProgressIndicator(), ModalityState.defaultModalityState());
            }
        } else if (task2.isModal()) {
            this.runSynchronously((Task)task2.asModal());
        } else {
            Task.Backgroundable backgroundable = task2.asBackgroundable();
            if (backgroundable.isConditionalModal() && !backgroundable.shouldStartInBackground()) {
                this.runSynchronously(task2);
            } else {
                this.runAsynchronously(backgroundable);
            }
        }
    }

    private void runSynchronously(@NotNull Task task2) {
        if (ApplicationManager.getApplication().isDispatchThread()) {
            this.runProcessWithProgressSynchronously(task2, null);
        } else {
            ApplicationManager.getApplication().invokeAndWait(() -> this.runProcessWithProgressSynchronously(task2, null));
        }
    }

    private void runAsynchronously(@NotNull Task.Backgroundable task2) {
        if (ApplicationManager.getApplication().isDispatchThread()) {
            this.runProcessWithProgressAsynchronously(task2);
        } else {
            ApplicationManager.getApplication().invokeLater(() -> {
                Project project = task2.getProject();
                if (project != null && project.isDisposed()) {
                    LOG.info("Task canceled because of project disposal: " + task2);
                    this.finishTask((Task)task2, true, null);
                    return;
                }
                this.runProcessWithProgressAsynchronously(task2);
            }, ModalityState.defaultModalityState());
        }
    }

    @NotNull
    public Future<?> runProcessWithProgressAsynchronously(@NotNull Task.Backgroundable task2) {
        return this.runProcessWithProgressAsynchronously(task2, (ProgressIndicator)new EmptyProgressIndicator(), null);
    }

    @NotNull
    public Future<?> runProcessWithProgressAsynchronously(@NotNull Task.Backgroundable task2, @NotNull ProgressIndicator progressIndicator, @Nullable Runnable continuation) {
        return this.runProcessWithProgressAsynchronously(task2, progressIndicator, continuation, progressIndicator.getModalityState());
    }

    @NotNull
    protected TaskRunnable createTaskRunnable(@NotNull Task task2, @NotNull ProgressIndicator indicator, @Nullable Runnable continuation) {
        return new TaskRunnable(task2, indicator, continuation);
    }

    @NotNull
    public Future<?> runProcessWithProgressAsynchronously(final @NotNull Task.Backgroundable task2, final @NotNull ProgressIndicator progressIndicator, @Nullable Runnable continuation, final @NotNull ModalityState modalityState) {
        IndicatorDisposable indicatorDisposable;
        if (progressIndicator instanceof Disposable) {
            indicatorDisposable = new IndicatorDisposable(progressIndicator);
            Disposer.register((Disposable)ApplicationManager.getApplication(), (Disposable)indicatorDisposable);
        } else {
            indicatorDisposable = null;
        }
        final TaskRunnable process2 = this.createTaskRunnable((Task)task2, progressIndicator, continuation);
        TaskContainer action = new TaskContainer((Task)task2){

            @Override
            public void run() {
                boolean processCanceled = false;
                Throwable exception = null;
                long start2 = System.currentTimeMillis();
                try {
                    CoreProgressManager.this.runProcess(process2, progressIndicator);
                }
                catch (ProcessCanceledException e) {
                    processCanceled = true;
                }
                catch (Throwable e) {
                    exception = e;
                }
                long elapsed = System.currentTimeMillis() - start2;
                boolean finalCanceled = processCanceled || progressIndicator.isCanceled();
                Throwable finalException = exception;
                if (!finalCanceled) {
                    CoreProgressManager.this.notifyTaskFinished(task2, elapsed);
                }
                ApplicationManager.getApplication().invokeLater(() -> {
                    CoreProgressManager.this.finishTask((Task)task2, finalCanceled, finalException);
                    if (indicatorDisposable != null) {
                        Disposer.dispose((Disposable)indicatorDisposable);
                    }
                }, modalityState);
            }
        };
        return ApplicationManager.getApplication().executeOnPooledThread((Runnable)action);
    }

    void notifyTaskFinished(@NotNull Task.Backgroundable task2, long elapsed) {
    }

    public boolean runProcessWithProgressSynchronously(final @NotNull Task task2, @Nullable JComponent parentComponent) {
        final Ref exceptionRef = new Ref();
        TaskContainer taskContainer = new TaskContainer(task2){

            @Override
            public void run() {
                try {
                    CoreProgressManager.this.createTaskRunnable(task2, CoreProgressManager.this.getProgressIndicator(), null).run();
                }
                catch (ProcessCanceledException e) {
                    throw e;
                }
                catch (Throwable e) {
                    exceptionRef.set((Object)e);
                }
            }
        };
        ApplicationEx application = (ApplicationEx)ApplicationManager.getApplication();
        boolean result2 = application.runProcessWithProgressSynchronously(taskContainer, task2.getTitle(), task2.isCancellable(), task2.getProject(), parentComponent, task2.getCancelText());
        this.finishTask(task2, !result2, (Throwable)exceptionRef.get());
        return result2;
    }

    public void runProcessWithProgressInCurrentThread(@NotNull Task task2, @NotNull ProgressIndicator progressIndicator, @NotNull ModalityState modalityState) {
        if (progressIndicator instanceof Disposable) {
            Disposer.register((Disposable)ApplicationManager.getApplication(), (Disposable)((Disposable)progressIndicator));
        }
        TaskRunnable process2 = this.createTaskRunnable(task2, progressIndicator, null);
        boolean processCanceled = false;
        Throwable exception = null;
        try {
            this.runProcess(process2, progressIndicator);
        }
        catch (ProcessCanceledException e) {
            processCanceled = true;
        }
        catch (Throwable e) {
            exception = e;
        }
        boolean finalCanceled = processCanceled || progressIndicator.isCanceled();
        Throwable finalException = exception;
        if (ApplicationManager.getApplication().isDispatchThread()) {
            this.finishTask(task2, finalCanceled, finalException);
        } else {
            ApplicationManager.getApplication().invokeAndWait(() -> this.finishTask(task2, finalCanceled, finalException), modalityState);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finishTask(@NotNull Task task2, boolean canceled, @Nullable Throwable error) {
        try {
            if (error != null) {
                task2.onThrowable(error);
            } else if (canceled) {
                task2.onCancel();
            } else {
                task2.onSuccess();
            }
        }
        finally {
            task2.onFinished();
        }
    }

    public void runProcessWithProgressAsynchronously(@NotNull Task.Backgroundable task2, @NotNull ProgressIndicator progressIndicator) {
        this.runProcessWithProgressAsynchronously(task2, progressIndicator, null);
    }

    public ProgressIndicator getProgressIndicator() {
        return CoreProgressManager.getCurrentIndicator(Thread.currentThread());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeProcessUnderProgress(@NotNull Runnable process2, ProgressIndicator progress) throws ProcessCanceledException {
        block9: {
            if (progress == null) {
                this.myUnsafeProgressCount.incrementAndGet();
            }
            try {
                boolean set2;
                ProgressIndicator oldIndicator = null;
                boolean bl = set2 = progress != null && progress != (oldIndicator = this.getProgressIndicator());
                if (set2) {
                    Thread currentThread = Thread.currentThread();
                    long threadId = currentThread.getId();
                    CoreProgressManager.setCurrentIndicator(threadId, progress);
                    try {
                        this.registerIndicatorAndRun(progress, currentThread, oldIndicator, process2);
                        break block9;
                    }
                    finally {
                        CoreProgressManager.setCurrentIndicator(threadId, oldIndicator);
                    }
                }
                process2.run();
            }
            finally {
                if (progress == null) {
                    this.myUnsafeProgressCount.decrementAndGet();
                }
            }
        }
    }

    public boolean runInReadActionWithWriteActionPriority(@NotNull Runnable action, @Nullable ProgressIndicator indicator) {
        ApplicationManager.getApplication().runReadAction(action);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerIndicatorAndRun(@NotNull ProgressIndicator indicator, @NotNull Thread currentThread, ProgressIndicator oldIndicator, @NotNull Runnable process2) {
        boolean isStandard;
        Set underIndicator;
        ArrayList<Set> threadsUnderThisIndicator = new ArrayList<Set>();
        Map<ProgressIndicator, Set<Thread>> map2 = threadsUnderIndicator;
        synchronized (map2) {
            boolean oneOfTheIndicatorsIsCanceled = false;
            ProgressIndicator thisIndicator = indicator;
            while (thisIndicator != null) {
                underIndicator = threadsUnderIndicator.computeIfAbsent(thisIndicator, __ -> new SmartHashSet());
                boolean alreadyUnder = !underIndicator.add(currentThread);
                threadsUnderThisIndicator.add(alreadyUnder ? null : underIndicator);
                isStandard = thisIndicator instanceof StandardProgressIndicator;
                if (!isStandard) {
                    nonStandardIndicators.add(thisIndicator);
                    this.startBackgroundNonStandardIndicatorsPing();
                }
                oneOfTheIndicatorsIsCanceled |= thisIndicator.isCanceled();
                thisIndicator = thisIndicator instanceof WrappedProgressIndicator ? ((WrappedProgressIndicator)thisIndicator).getOriginalProgressIndicator() : null;
            }
            if (oneOfTheIndicatorsIsCanceled) {
                threadsUnderCanceledIndicator.add(currentThread);
            } else {
                threadsUnderCanceledIndicator.remove(currentThread);
            }
            this.updateShouldCheckCanceled();
        }
        try {
            process2.run();
            map2 = threadsUnderIndicator;
        }
        catch (Throwable throwable) {
            Map<ProgressIndicator, Set<Thread>> map3 = threadsUnderIndicator;
            synchronized (map3) {
                ProgressIndicator thisIndicator = null;
                for (int i = 0; i < threadsUnderThisIndicator.size(); ++i) {
                    boolean isStandard2;
                    boolean removed;
                    thisIndicator = i == 0 ? indicator : ((WrappedProgressIndicator)thisIndicator).getOriginalProgressIndicator();
                    Set underIndicator2 = (Set)threadsUnderThisIndicator.get(i);
                    boolean bl = removed = underIndicator2 != null && underIndicator2.remove(currentThread);
                    if (removed && underIndicator2.isEmpty()) {
                        threadsUnderIndicator.remove(thisIndicator);
                    }
                    if (!(isStandard2 = thisIndicator instanceof StandardProgressIndicator)) {
                        nonStandardIndicators.remove(thisIndicator);
                        if (nonStandardIndicators.isEmpty()) {
                            this.stopBackgroundNonStandardIndicatorsPing();
                        }
                    }
                    if (oldIndicator != null && oldIndicator.isCanceled()) {
                        threadsUnderCanceledIndicator.add(currentThread);
                        continue;
                    }
                    threadsUnderCanceledIndicator.remove(currentThread);
                }
                this.updateShouldCheckCanceled();
            }
            throw throwable;
        }
        synchronized (map2) {
            ProgressIndicator thisIndicator = null;
            for (int i = 0; i < threadsUnderThisIndicator.size(); ++i) {
                boolean removed;
                thisIndicator = i == 0 ? indicator : ((WrappedProgressIndicator)thisIndicator).getOriginalProgressIndicator();
                underIndicator = (Set)threadsUnderThisIndicator.get(i);
                boolean bl = removed = underIndicator != null && underIndicator.remove(currentThread);
                if (removed && underIndicator.isEmpty()) {
                    threadsUnderIndicator.remove(thisIndicator);
                }
                if (!(isStandard = thisIndicator instanceof StandardProgressIndicator)) {
                    nonStandardIndicators.remove(thisIndicator);
                    if (nonStandardIndicators.isEmpty()) {
                        this.stopBackgroundNonStandardIndicatorsPing();
                    }
                }
                if (oldIndicator != null && oldIndicator.isCanceled()) {
                    threadsUnderCanceledIndicator.add(currentThread);
                    continue;
                }
                threadsUnderCanceledIndicator.remove(currentThread);
            }
            this.updateShouldCheckCanceled();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void updateShouldCheckCanceled() {
        ourCheckCanceledHook = this.createCheckCanceledHook();
        if (ourCheckCanceledHook != null) {
            shouldCheckCanceled = true;
            return;
        }
        Map<ProgressIndicator, Set<Thread>> map2 = threadsUnderIndicator;
        synchronized (map2) {
            shouldCheckCanceled = !threadsUnderCanceledIndicator.isEmpty();
        }
    }

    @Nullable
    protected CheckCanceledHook createCheckCanceledHook() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void indicatorCanceled(@NotNull ProgressIndicator indicator) {
        Map<ProgressIndicator, Set<Thread>> map2 = threadsUnderIndicator;
        synchronized (map2) {
            Set<Thread> threads = threadsUnderIndicator.get(indicator);
            if (threads != null) {
                for (Thread thread : threads) {
                    boolean underCancelledIndicator = false;
                    ProgressIndicator currentIndicator = CoreProgressManager.getCurrentIndicator(thread);
                    while (currentIndicator != null) {
                        if (currentIndicator == indicator) {
                            underCancelledIndicator = true;
                            break;
                        }
                        currentIndicator = currentIndicator instanceof WrappedProgressIndicator ? ((WrappedProgressIndicator)currentIndicator).getOriginalProgressIndicator() : null;
                    }
                    if (!underCancelledIndicator) continue;
                    threadsUnderCanceledIndicator.add(thread);
                    shouldCheckCanceled = true;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isCanceledThread(@NotNull Thread thread) {
        Map<ProgressIndicator, Set<Thread>> map2 = threadsUnderIndicator;
        synchronized (map2) {
            return threadsUnderCanceledIndicator.contains(thread);
        }
    }

    public boolean isInNonCancelableSection() {
        return isInNonCancelableSection.get() != null;
    }

    @NotNull
    public static ModalityState getCurrentThreadProgressModality() {
        ProgressIndicator indicator = (ProgressIndicator)threadTopLevelIndicators.get(Thread.currentThread().getId());
        ModalityState modality = indicator == null ? null : indicator.getModalityState();
        return modality != null ? modality : ModalityState.NON_MODAL;
    }

    private static void setCurrentIndicator(long threadId, ProgressIndicator indicator) {
        if (indicator == null) {
            currentIndicators.remove(threadId);
            threadTopLevelIndicators.remove(threadId);
        } else {
            currentIndicators.put(threadId, (Object)indicator);
            if (!threadTopLevelIndicators.containsKey(threadId)) {
                threadTopLevelIndicators.put(threadId, (Object)indicator);
            }
        }
    }

    private static ProgressIndicator getCurrentIndicator(@NotNull Thread thread) {
        return (ProgressIndicator)currentIndicators.get(thread.getId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void assertUnderProgress(@NotNull ProgressIndicator indicator) {
        Map<ProgressIndicator, Set<Thread>> map2 = threadsUnderIndicator;
        synchronized (map2) {
            Set<Thread> threads = threadsUnderIndicator.get(indicator);
            if (threads == null || !threads.contains(Thread.currentThread())) {
                LOG.error("Must be executed under progress indicator: " + indicator + ". Please see e.g. ProgressManager.runProcess()");
            }
        }
    }

    static {
        threadsUnderIndicator = new HashMap<ProgressIndicator, Set<Thread>>();
        currentIndicators = ContainerUtil.createConcurrentLongObjectMap();
        threadTopLevelIndicators = ContainerUtil.createConcurrentLongObjectMap();
        threadsUnderCanceledIndicator = new HashSet<Thread>();
        nonStandardIndicators = ConcurrentHashMultiset.create();
        isInNonCancelableSection = new ThreadLocal();
    }

    @FunctionalInterface
    static interface CheckCanceledHook {
        public boolean runHook(@Nullable ProgressIndicator var1);
    }

    protected static class TaskRunnable
    extends TaskContainer {
        private final ProgressIndicator myIndicator;
        private final Runnable myContinuation;

        TaskRunnable(@NotNull Task task2, @NotNull ProgressIndicator indicator, @Nullable Runnable continuation) {
            super(task2);
            this.myIndicator = indicator;
            this.myContinuation = continuation;
        }

        @Override
        public void run() {
            try {
                this.getTask().run(this.myIndicator);
            }
            finally {
                try {
                    if (this.myIndicator instanceof ProgressIndicatorEx) {
                        ((ProgressIndicatorEx)this.myIndicator).finish((TaskInfo)this.getTask());
                    }
                }
                finally {
                    if (this.myContinuation != null) {
                        this.myContinuation.run();
                    }
                }
            }
        }
    }

    protected static abstract class TaskContainer
    implements Runnable {
        private final Task myTask;

        protected TaskContainer(@NotNull Task task2) {
            this.myTask = task2;
        }

        @NotNull
        public Task getTask() {
            return this.myTask;
        }

        public String toString() {
            return this.myTask.toString();
        }
    }

    private static class IndicatorDisposable
    implements Disposable {
        @NotNull
        private final ProgressIndicator myIndicator;

        IndicatorDisposable(@NotNull ProgressIndicator indicator) {
            this.myIndicator = indicator;
        }

        public void dispose() {
            Disposer.dispose((Disposable)((Disposable)this.myIndicator), (boolean)false);
        }
    }
}

