/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.progress.impl;

import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.impl.CoreProgressManager;
import com.intellij.openapi.progress.impl.ProgressManagerImpl;
import com.intellij.openapi.progress.util.ProgressIndicatorListenerAdapter;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.wm.ex.ProgressIndicatorEx;
import com.intellij.util.messages.Topic;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ProgressSuspender
implements AutoCloseable {
    private static final Key<ProgressSuspender> PROGRESS_SUSPENDER = Key.create((String)"PROGRESS_SUSPENDER");
    public static final Topic<SuspenderListener> TOPIC = Topic.create((String)"ProgressSuspender", SuspenderListener.class);
    private final Object myLock = new Object();
    private final Thread myThread;
    private static final Application ourApp = ApplicationManager.getApplication();
    @NotNull
    private final String mySuspendedText;
    @Nullable
    private String myTempReason;
    private final SuspenderListener myPublisher;
    private volatile boolean mySuspended;
    private final CoreProgressManager.CheckCanceledHook myHook = this::freezeIfNeeded;
    @NotNull
    private final ProgressIndicatorEx myAttachedToProgress;
    private boolean myClosed;

    private ProgressSuspender(@NotNull ProgressIndicatorEx progress, @NotNull String suspendedText) {
        this.mySuspendedText = suspendedText;
        assert (progress.isRunning());
        assert (ProgressIndicatorProvider.getGlobalProgressIndicator() == progress);
        this.myAttachedToProgress = progress;
        this.myThread = Thread.currentThread();
        this.myPublisher = (SuspenderListener)ApplicationManager.getApplication().getMessageBus().syncPublisher(TOPIC);
        ((UserDataHolder)progress).putUserData(PROGRESS_SUSPENDER, (Object)this);
        new ProgressIndicatorListenerAdapter(){

            @Override
            public void cancelled() {
                ProgressSuspender.this.resumeProcess();
            }
        }.installToProgress(progress);
        this.myPublisher.suspendableProgressAppeared(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        Object object = this.myLock;
        synchronized (object) {
            this.myClosed = true;
            this.mySuspended = false;
            ((ProgressManagerImpl)ProgressManager.getInstance()).removeCheckCanceledHook(this.myHook);
        }
        ((UserDataHolder)this.myAttachedToProgress).putUserData(PROGRESS_SUSPENDER, null);
    }

    public static ProgressSuspender markSuspendable(@NotNull ProgressIndicator indicator, @NotNull String suspendedText) {
        return new ProgressSuspender((ProgressIndicatorEx)indicator, suspendedText);
    }

    @Nullable
    public static ProgressSuspender getSuspender(@NotNull ProgressIndicator indicator) {
        return indicator instanceof UserDataHolder ? (ProgressSuspender)((UserDataHolder)indicator).getUserData(PROGRESS_SUSPENDER) : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public String getSuspendedText() {
        Object object = this.myLock;
        synchronized (object) {
            return this.myTempReason != null ? this.myTempReason : this.mySuspendedText;
        }
    }

    public boolean isSuspended() {
        return this.mySuspended;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void suspendProcess(@Nullable String reason) {
        Object object = this.myLock;
        synchronized (object) {
            if (this.mySuspended || this.myClosed) {
                return;
            }
            this.mySuspended = true;
            this.myTempReason = reason;
            ((ProgressManagerImpl)ProgressManager.getInstance()).addCheckCanceledHook(this.myHook);
        }
        this.myPublisher.suspendedStatusChanged(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resumeProcess() {
        Object object = this.myLock;
        synchronized (object) {
            if (!this.mySuspended) {
                return;
            }
            this.mySuspended = false;
            this.myTempReason = null;
            ((ProgressManagerImpl)ProgressManager.getInstance()).removeCheckCanceledHook(this.myHook);
            this.myLock.notifyAll();
        }
        this.myPublisher.suspendedStatusChanged(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean freezeIfNeeded(@Nullable ProgressIndicator current) {
        if (current == null || ourApp.isReadAccessAllowed() || !CoreProgressManager.isThreadUnderIndicator(current, this.myThread)) {
            return false;
        }
        Object object = this.myLock;
        synchronized (object) {
            while (this.mySuspended) {
                try {
                    this.myLock.wait(10000L);
                }
                catch (InterruptedException interruptedException) {}
            }
            return true;
        }
    }

    public static interface SuspenderListener {
        default public void suspendableProgressAppeared(@NotNull ProgressSuspender suspender) {
        }

        default public void suspendedStatusChanged(@NotNull ProgressSuspender suspender) {
        }
    }
}

