/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.progress.util;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.TransactionGuard;
import com.intellij.openapi.application.TransactionGuardImpl;
import com.intellij.openapi.application.impl.ModalityStateEx;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.impl.CoreProgressManager;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.ui.mac.foundation.MacUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.Stack;
import gnu.trove.TDoubleArrayList;
import java.util.Arrays;
import java.util.Optional;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AbstractProgressIndicatorBase
extends UserDataHolderBase
implements ProgressIndicator {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.progress.util.ProgressIndicatorBase");
    private volatile String myText;
    private volatile double myFraction;
    private volatile String myText2;
    private volatile boolean myCanceled;
    private volatile boolean myRunning;
    private volatile boolean myFinished;
    private volatile boolean myIndeterminate = Registry.is((String)"ide.progress.indeterminate.by.default", (boolean)true);
    private volatile MacUtil.Activity myMacActivity;
    private volatile boolean myShouldStartActivity = true;
    private Stack<String> myTextStack;
    private TDoubleArrayList myFractionStack;
    private Stack<String> myText2Stack;
    ProgressIndicator myModalityProgress;
    private volatile ModalityState myModalityState = ModalityState.NON_MODAL;
    private volatile int myNonCancelableSectionCount;
    private static final Set<Class> ourReportedReuseExceptions = ContainerUtil.newConcurrentSet();

    public synchronized void start() {
        LOG.assertTrue(!this.isRunning(), (Object)"Attempt to start ProgressIndicator which is already running");
        if (this.myFinished) {
            if (this.myCanceled && !this.isReuseable() && ourReportedReuseExceptions.add(((Object)((Object)this)).getClass())) {
                LOG.error("Attempt to start ProgressIndicator which is cancelled and already stopped:" + (Object)((Object)this) + "," + ((Object)((Object)this)).getClass());
            }
            this.myCanceled = false;
            this.myFinished = false;
        }
        this.myText = "";
        this.myFraction = 0.0;
        this.myText2 = "";
        this.startSystemActivity();
        this.myRunning = true;
    }

    protected boolean isReuseable() {
        return false;
    }

    public synchronized void stop() {
        this.myRunning = false;
        this.myFinished = true;
        this.stopSystemActivity();
    }

    private void startSystemActivity() {
        this.myMacActivity = this.myShouldStartActivity ? MacUtil.wakeUpNeo((Object)((Object)this)) : null;
    }

    void stopSystemActivity() {
        MacUtil.Activity macActivity = this.myMacActivity;
        if (macActivity != null) {
            macActivity.matrixHasYou();
            this.myMacActivity = null;
        }
    }

    public boolean isRunning() {
        return this.myRunning;
    }

    public void cancel() {
        this.myCanceled = true;
        this.stopSystemActivity();
        if (ApplicationManager.getApplication() != null) {
            ProgressManager.canceled((ProgressIndicator)this);
        }
    }

    public boolean isCanceled() {
        return this.myCanceled;
    }

    public void checkCanceled() {
        this.throwIfCanceled();
        if (CoreProgressManager.runCheckCanceledHooks(this)) {
            this.throwIfCanceled();
        }
    }

    private void throwIfCanceled() {
        if (this.isCanceled() && this.isCancelable()) {
            Throwable trace = this.getCancellationTrace();
            throw trace instanceof ProcessCanceledException ? (ProcessCanceledException)trace : new ProcessCanceledException(trace);
        }
    }

    @Nullable
    protected Throwable getCancellationTrace() {
        if (this instanceof Disposable) {
            return (Throwable)ObjectUtils.tryCast((Object)Disposer.getTree().getDisposalInfo((Object)((Disposable)this)), Throwable.class);
        }
        return null;
    }

    public void setText(String text) {
        this.myText = text;
    }

    public String getText() {
        return this.myText;
    }

    public void setText2(String text) {
        this.myText2 = text;
    }

    public String getText2() {
        return this.myText2;
    }

    public double getFraction() {
        return this.myFraction;
    }

    public void setFraction(double fraction) {
        if (this.isIndeterminate()) {
            StackTraceElement[] trace = new Throwable().getStackTrace();
            Optional<StackTraceElement> first = Arrays.stream(trace).filter(element -> !element.getClassName().startsWith("com.intellij.openapi.progress.util")).findFirst();
            String message = "This progress indicator is indeterminate, this may lead to visual inconsistency. Please call setIndeterminate(false) before you start progress.";
            if (first.isPresent()) {
                message = message + "\n" + first.get();
            }
            LOG.warn(message);
            this.setIndeterminate(false);
        }
        this.myFraction = fraction;
    }

    public synchronized void pushState() {
        this.getTextStack().push((Object)this.myText);
        this.getFractionStack().add(this.myFraction);
        this.getText2Stack().push((Object)this.myText2);
    }

    public synchronized void popState() {
        LOG.assertTrue(!this.myTextStack.isEmpty());
        String oldText = (String)this.myTextStack.pop();
        String oldText2 = (String)this.myText2Stack.pop();
        this.setText(oldText);
        this.setText2(oldText2);
        double oldFraction = this.myFractionStack.remove(this.myFractionStack.size() - 1);
        if (!this.isIndeterminate()) {
            this.setFraction(oldFraction);
        }
    }

    public void startNonCancelableSection() {
        ++this.myNonCancelableSectionCount;
    }

    public void finishNonCancelableSection() {
        --this.myNonCancelableSectionCount;
    }

    protected boolean isCancelable() {
        return this.myNonCancelableSectionCount == 0 && !ProgressManager.getInstance().isInNonCancelableSection();
    }

    public final boolean isModal() {
        return this.myModalityProgress != null;
    }

    @NotNull
    public ModalityState getModalityState() {
        return this.myModalityState;
    }

    public void setModalityProgress(ProgressIndicator modalityProgress) {
        LOG.assertTrue(!this.isRunning());
        this.myModalityProgress = modalityProgress;
        ModalityState currentModality = ApplicationManager.getApplication().getCurrentModalityState();
        ModalityState modalityState = this.myModalityState = this.myModalityProgress != null ? ((ModalityStateEx)currentModality).appendProgress(this.myModalityProgress) : currentModality;
        if (modalityProgress != null) {
            ((TransactionGuardImpl)TransactionGuard.getInstance()).enteredModality(this.myModalityState);
        }
    }

    public boolean isIndeterminate() {
        return this.myIndeterminate;
    }

    public void setIndeterminate(boolean indeterminate) {
        this.myIndeterminate = indeterminate;
    }

    @NonNls
    public String toString() {
        return "ProgressIndicator " + System.identityHashCode((Object)this) + ": running=" + this.isRunning() + "; canceled=" + this.isCanceled();
    }

    public boolean isPopupWasShown() {
        return true;
    }

    public boolean isShowing() {
        return this.isModal();
    }

    public synchronized void initStateFrom(@NotNull ProgressIndicator indicator) {
        this.myRunning = indicator.isRunning();
        this.myCanceled = indicator.isCanceled();
        this.myFraction = indicator.getFraction();
        this.myIndeterminate = indicator.isIndeterminate();
        this.myText = indicator.getText();
        this.myText2 = indicator.getText2();
        this.myFraction = indicator.getFraction();
        if (indicator instanceof AbstractProgressIndicatorBase) {
            AbstractProgressIndicatorBase stacked = (AbstractProgressIndicatorBase)indicator;
            this.myTextStack = stacked.myTextStack == null ? null : new Stack(stacked.getTextStack());
            this.myText2Stack = stacked.myText2Stack == null ? null : new Stack(stacked.getText2Stack());
            this.myFractionStack = stacked.myFractionStack == null ? null : new TDoubleArrayList(stacked.getFractionStack().toNativeArray());
        }
        this.dontStartActivity();
    }

    protected void dontStartActivity() {
        this.myShouldStartActivity = false;
    }

    @NotNull
    private Stack<String> getTextStack() {
        Stack stack = this.myTextStack;
        if (stack == null) {
            this.myTextStack = stack = new Stack(2);
        }
        return stack;
    }

    @NotNull
    private TDoubleArrayList getFractionStack() {
        TDoubleArrayList stack = this.myFractionStack;
        if (stack == null) {
            this.myFractionStack = stack = new TDoubleArrayList(2);
        }
        return stack;
    }

    @NotNull
    private Stack<String> getText2Stack() {
        Stack stack = this.myText2Stack;
        if (stack == null) {
            this.myText2Stack = stack = new Stack(2);
        }
        return stack;
    }
}

