/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.progress.util;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.TaskInfo;
import com.intellij.openapi.progress.util.AbstractProgressIndicatorBase;
import com.intellij.openapi.wm.ex.ProgressIndicatorEx;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.WeakList;
import org.jetbrains.annotations.NotNull;

public class AbstractProgressIndicatorExBase
extends AbstractProgressIndicatorBase
implements ProgressIndicatorEx {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.progress.util.ProgressIndicatorBase");
    private final boolean myReusable;
    private volatile ProgressIndicatorEx[] myStateDelegates;
    private volatile WeakList<TaskInfo> myFinished;
    private volatile boolean myWasStarted;
    private TaskInfo myOwnerTask;

    public AbstractProgressIndicatorExBase(boolean reusable) {
        this.myReusable = reusable;
    }

    public AbstractProgressIndicatorExBase() {
        this(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start() {
        AbstractProgressIndicatorExBase abstractProgressIndicatorExBase = this;
        synchronized (abstractProgressIndicatorExBase) {
            super.start();
            this.delegateRunningChange(ProgressIndicator::start);
        }
        this.myWasStarted = true;
    }

    @Override
    public void stop() {
        super.stop();
        this.delegateRunningChange(ProgressIndicator::stop);
    }

    @Override
    public void cancel() {
        super.cancel();
        this.delegateRunningChange(ProgressIndicator::cancel);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void finish(@NotNull TaskInfo task2) {
        WeakList finished2 = this.myFinished;
        if (finished2 == null) {
            AbstractProgressIndicatorExBase abstractProgressIndicatorExBase = this;
            synchronized (abstractProgressIndicatorExBase) {
                finished2 = this.myFinished;
                if (finished2 == null) {
                    this.myFinished = finished2 = new WeakList();
                }
            }
        }
        if (!finished2.addIfAbsent((Object)task2)) {
            return;
        }
        this.delegateRunningChange(each -> each.finish(task2));
    }

    @Override
    public boolean isFinished(@NotNull TaskInfo task2) {
        WeakList<TaskInfo> list2 = this.myFinished;
        return list2 != null && list2.contains(task2);
    }

    protected void setOwnerTask(TaskInfo owner) {
        this.myOwnerTask = owner;
    }

    @Override
    public void processFinish() {
        if (this.myOwnerTask != null) {
            this.finish(this.myOwnerTask);
            this.myOwnerTask = null;
        }
    }

    @Override
    public final void checkCanceled() {
        super.checkCanceled();
        this.delegate(ProgressIndicator::checkCanceled);
    }

    @Override
    public void setText(String text) {
        super.setText(text);
        this.delegateProgressChange(each -> each.setText(text));
    }

    @Override
    public void setText2(String text) {
        super.setText2(text);
        this.delegateProgressChange(each -> each.setText2(text));
    }

    @Override
    public void setFraction(double fraction) {
        super.setFraction(fraction);
        this.delegateProgressChange(each -> each.setFraction(fraction));
    }

    @Override
    public synchronized void pushState() {
        super.pushState();
        this.delegateProgressChange(ProgressIndicator::pushState);
    }

    @Override
    public synchronized void popState() {
        super.popState();
        this.delegateProgressChange(ProgressIndicator::popState);
    }

    @Override
    protected boolean isReuseable() {
        return this.myReusable;
    }

    @Override
    public void setIndeterminate(boolean indeterminate) {
        super.setIndeterminate(indeterminate);
        this.delegateProgressChange(each -> each.setIndeterminate(indeterminate));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void addStateDelegate(@NotNull ProgressIndicatorEx delegate) {
        delegate.initStateFrom(this);
        AbstractProgressIndicatorExBase abstractProgressIndicatorExBase = this;
        synchronized (abstractProgressIndicatorExBase) {
            Object[] stateDelegates = this.myStateDelegates;
            if (stateDelegates == null) {
                stateDelegates = new ProgressIndicatorEx[1];
                this.myStateDelegates = stateDelegates;
                stateDelegates[0] = delegate;
            } else {
                LOG.assertTrue(!ArrayUtil.contains((Object)delegate, (Object[])stateDelegates), (Object)("Already registered: " + delegate));
                this.myStateDelegates = (ProgressIndicatorEx[])ArrayUtil.append((Object[])stateDelegates, (Object)delegate, ProgressIndicatorEx.class);
            }
        }
    }

    protected void delegateProgressChange(@NotNull IndicatorAction action) {
        this.delegate(action);
        this.onProgressChange();
    }

    protected void delegateRunningChange(@NotNull IndicatorAction action) {
        this.delegate(action);
        this.onRunningChange();
    }

    private void delegate(@NotNull IndicatorAction action) {
        ProgressIndicatorEx[] list2 = this.myStateDelegates;
        if (list2 != null) {
            for (ProgressIndicatorEx each : list2) {
                action.execute(each);
            }
        }
    }

    protected void onProgressChange() {
    }

    protected void onRunningChange() {
    }

    @Override
    public boolean wasStarted() {
        return this.myWasStarted;
    }

    @FunctionalInterface
    protected static interface IndicatorAction {
        public void execute(@NotNull ProgressIndicatorEx var1);
    }
}

