/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.progress.util;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.progress.util.PotemkinProgress;
import com.intellij.openapi.progress.util.ProgressWindow;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.DialogWrapperDialog;
import com.intellij.openapi.ui.DialogWrapperPeer;
import com.intellij.openapi.ui.impl.DialogWrapperPeerImpl;
import com.intellij.openapi.ui.impl.GlassPaneDialogWrapperPeer;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.ui.PopupBorder;
import com.intellij.ui.TitlePanel;
import com.intellij.ui.WindowMoveListener;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.Alarm;
import com.intellij.util.SingleAlarm;
import com.intellij.util.concurrency.EdtExecutorService;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.io.File;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class ProgressDialog
implements Disposable {
    private final ProgressWindow myProgressWindow;
    private long myLastTimeDrawn = -1L;
    private volatile boolean myShouldShowBackground;
    private final Alarm myUpdateAlarm;
    boolean myWasShown;
    final Runnable myRepaintRunnable;
    private final Runnable myUpdateRequest;
    JPanel myPanel;
    private JLabel myTextLabel;
    private JBLabel myText2Label;
    private JButton myCancelButton;
    private JButton myBackgroundButton;
    private JProgressBar myProgressBar;
    private boolean myRepaintedFlag;
    private TitlePanel myTitlePanel;
    private JPanel myInnerPanel;
    DialogWrapper myPopup;
    private final Window myParentWindow;
    private final SingleAlarm myDisableCancelAlarm;
    private final SingleAlarm myEnableCancelAlarm;
    static final int UPDATE_INTERVAL = 50;

    ProgressDialog(@NotNull ProgressWindow progressWindow, boolean shouldShowBackground, String cancelText, @Nullable Window parentWindow) {
        this.$$$setupUI$$$();
        this.myUpdateAlarm = new Alarm((Disposable)this);
        this.myRepaintRunnable = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                String text = ProgressDialog.this.myProgressWindow.getText();
                double fraction = ProgressDialog.this.myProgressWindow.getFraction();
                String text2 = ProgressDialog.this.myProgressWindow.getText2();
                if (ProgressDialog.this.myProgressBar.isShowing()) {
                    int perc = (int)(fraction * 100.0);
                    ProgressDialog.this.myProgressBar.setIndeterminate(ProgressDialog.this.myProgressWindow.isIndeterminate());
                    ProgressDialog.this.myProgressBar.setValue(perc);
                }
                ProgressDialog.this.myTextLabel.setText(ProgressDialog.fitTextToLabel(text, ProgressDialog.this.myTextLabel));
                ProgressDialog.this.myText2Label.setText(ProgressDialog.fitTextToLabel(text2, (JLabel)ProgressDialog.this.myText2Label));
                ProgressDialog.this.myTitlePanel.setText(ProgressDialog.this.myProgressWindow.getTitle() != null && !ProgressDialog.this.myProgressWindow.getTitle().isEmpty() ? ProgressDialog.this.myProgressWindow.getTitle() : " ");
                ProgressDialog.this.myLastTimeDrawn = System.currentTimeMillis();
                ProgressDialog progressDialog = ProgressDialog.this;
                synchronized (progressDialog) {
                    ProgressDialog.this.myRepaintedFlag = true;
                }
            }
        };
        this.myUpdateRequest = () -> this.update();
        this.myRepaintedFlag = true;
        this.myDisableCancelAlarm = new SingleAlarm(this::setCancelButtonDisabledInEDT, 500, ModalityState.any(), (Disposable)this);
        this.myEnableCancelAlarm = new SingleAlarm(this::setCancelButtonEnabledInEDT, 500, ModalityState.any(), (Disposable)this);
        this.myProgressWindow = progressWindow;
        this.myParentWindow = parentWindow;
        this.initDialog(shouldShowBackground, cancelText);
    }

    @NotNull
    private static String fitTextToLabel(@Nullable String fullText, @NotNull JLabel label2) {
        if (fullText == null || fullText.isEmpty()) {
            return " ";
        }
        while (label2.getFontMetrics(label2.getFont()).stringWidth(fullText) > label2.getWidth()) {
            int sep = fullText.indexOf(File.separatorChar, 4);
            if (sep < 0) {
                return fullText;
            }
            fullText = "..." + fullText.substring(sep);
        }
        return fullText;
    }

    private void initDialog(boolean shouldShowBackground, String cancelText) {
        if (SystemInfo.isMac) {
            UIUtil.applyStyle((UIUtil.ComponentStyle)UIUtil.ComponentStyle.SMALL, (Component)this.myText2Label);
        }
        this.myInnerPanel.setPreferredSize(new Dimension(SystemInfo.isMac ? 350 : JBUI.scale((int)450), -1));
        this.myCancelButton.addActionListener(__ -> this.doCancelAction());
        this.myCancelButton.registerKeyboardAction(__ -> {
            if (this.myCancelButton.isEnabled()) {
                this.doCancelAction();
            }
        }, KeyStroke.getKeyStroke(27, 0), 1);
        this.myShouldShowBackground = shouldShowBackground;
        if (cancelText != null) {
            this.myProgressWindow.setCancelButtonText(cancelText);
        }
        this.myProgressBar.setMaximum(100);
        this.createCenterPanel();
        this.myTitlePanel.setActive(true);
        WindowMoveListener moveListener = new WindowMoveListener((Component)this.myTitlePanel){

            @Override
            protected Component getView(Component component) {
                return SwingUtilities.getAncestorOfClass(DialogWrapperDialog.class, component);
            }
        };
        this.myTitlePanel.addMouseListener((MouseListener)moveListener);
        this.myTitlePanel.addMouseMotionListener((MouseMotionListener)moveListener);
    }

    public void dispose() {
        UIUtil.disposeProgress((JProgressBar)this.myProgressBar);
        UIUtil.dispose((Component)this.myTitlePanel);
        UIUtil.dispose((Component)this.myBackgroundButton);
        UIUtil.dispose((Component)this.myCancelButton);
    }

    @NotNull
    JPanel getPanel() {
        return this.myPanel;
    }

    void changeCancelButtonText(@NotNull String text) {
        this.myCancelButton.setText(text);
    }

    private void doCancelAction() {
        if (this.myProgressWindow.myShouldShowCancel) {
            this.myProgressWindow.cancel();
        }
    }

    void cancel() {
        this.enableCancelButtonIfNeeded(false);
    }

    private void setCancelButtonEnabledInEDT() {
        this.myCancelButton.setEnabled(true);
    }

    private void setCancelButtonDisabledInEDT() {
        this.myCancelButton.setEnabled(false);
    }

    void enableCancelButtonIfNeeded(boolean enable) {
        if (!this.myProgressWindow.myShouldShowCancel || this.myDisableCancelAlarm.isDisposed()) {
            return;
        }
        (enable ? this.myEnableCancelAlarm : this.myDisableCancelAlarm).request();
    }

    private void createCenterPanel() {
        if (this.myProgressWindow.myCancelText != null) {
            this.myCancelButton.setText(this.myProgressWindow.myCancelText);
        }
        this.myCancelButton.setVisible(this.myProgressWindow.myShouldShowCancel);
        this.myBackgroundButton.setVisible(this.myShouldShowBackground);
        this.myBackgroundButton.addActionListener(__ -> {
            if (this.myShouldShowBackground) {
                this.myProgressWindow.background();
            }
        });
    }

    synchronized void update() {
        if (this.myRepaintedFlag) {
            if (System.currentTimeMillis() > this.myLastTimeDrawn + 50L) {
                this.myRepaintedFlag = false;
                EdtExecutorService.getInstance().execute(this.myRepaintRunnable);
            } else if (!this.myUpdateAlarm.isDisposed() && this.myUpdateAlarm.getActiveRequestCount() == 0) {
                EdtExecutorService.getInstance().execute(() -> {
                    if (!this.myUpdateAlarm.isDisposed() && this.myUpdateAlarm.getActiveRequestCount() == 0) {
                        this.myUpdateAlarm.addRequest(this.myUpdateRequest, 500, this.myProgressWindow.getModalityState());
                    }
                });
            }
        }
    }

    synchronized void background() {
        if (this.myShouldShowBackground) {
            this.myBackgroundButton.setEnabled(false);
        }
        this.hide();
    }

    void hide() {
        ApplicationManager.getApplication().invokeLater(this::hideImmediately, ModalityState.any());
    }

    void hideImmediately() {
        if (this.myPopup != null) {
            this.myPopup.close(1);
            this.myPopup = null;
        }
    }

    @Nullable
    Window getParentWindow() {
        return this.myParentWindow;
    }

    void show() {
        this.myWasShown = true;
        if (ApplicationManager.getApplication().isHeadlessEnvironment()) {
            return;
        }
        if (this.myParentWindow == null) {
            return;
        }
        if (this.myPopup != null) {
            this.myPopup.close(1);
        }
        this.myPopup = this.myParentWindow.isShowing() ? new MyDialogWrapper(this.myParentWindow, this.myProgressWindow.myShouldShowCancel) : new MyDialogWrapper(this.myProgressWindow.myProject, this.myProgressWindow.myShouldShowCancel);
        this.myPopup.setUndecorated(true);
        if (this.myPopup.getPeer() instanceof DialogWrapperPeerImpl) {
            ((DialogWrapperPeerImpl)this.myPopup.getPeer()).setAutoRequestFocus(false);
            if (this.isWriteActionProgress()) {
                this.myPopup.setModal(false);
            }
        }
        this.myPopup.pack();
        SwingUtilities.invokeLater(() -> {
            if (this.myPopup != null) {
                this.myProgressWindow.getFocusManager().requestFocusInProject((Component)this.myCancelButton, this.myProgressWindow.myProject).doWhenDone(this.myRepaintRunnable);
            }
        });
        Disposer.register((Disposable)this.myPopup.getDisposable(), () -> this.myProgressWindow.exitModality());
        this.myPopup.show();
    }

    private boolean isWriteActionProgress() {
        return this.myProgressWindow instanceof PotemkinProgress;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        TitlePanel titlePanel;
        JButton jButton;
        JButton jButton2;
        JProgressBar jProgressBar;
        JBLabel jBLabel;
        JLabel jLabel;
        JPanel jPanel;
        JPanel jPanel2;
        this.myPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(6, 10, 10, 10), -1, -1, false, false));
        jPanel3.setOpaque(false);
        jPanel2.add((Component)jPanel3, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myInnerPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(3, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel3.add((Component)jPanel, new GridConstraints(0, 0, 1, 1, 0, 1, 7, 2, null, null, null));
        this.myTextLabel = jLabel = new JLabel();
        jLabel.setText(" ");
        jPanel.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 7, 0, new Dimension(0, -1), null, null));
        this.myText2Label = jBLabel = new JBLabel();
        jBLabel.setComponentStyle(UIUtil.ComponentStyle.REGULAR);
        jBLabel.setText("");
        jPanel.add((Component)jBLabel, new GridConstraints(2, 0, 1, 1, 9, 1, 7, 0, new Dimension(0, -1), null, null));
        this.myProgressBar = jProgressBar = new JProgressBar();
        jProgressBar.putClientProperty("html.disable", Boolean.FALSE);
        jPanel.add((Component)jProgressBar, new GridConstraints(1, 0, 1, 2, 0, 1, 7, 0, null, null, null));
        JLabel jLabel2 = new JLabel();
        jLabel2.setText(" ");
        jPanel.add((Component)jLabel2, new GridConstraints(2, 1, 1, 1, 8, 0, 0, 0, null, null, null));
        JLabel jLabel3 = new JLabel();
        jLabel3.setText(" ");
        jPanel.add((Component)jLabel3, new GridConstraints(0, 1, 1, 1, 8, 0, 0, 0, null, null, null));
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel3.add((Component)jPanel4, new GridConstraints(0, 1, 1, 1, 0, 1, 1, 2, null, null, null));
        this.myCancelButton = jButton2 = new JButton();
        ((Component)jButton2).setEnabled(true);
        jButton2.setFocusPainted(true);
        this.$$$loadButtonText$$$(jButton2, ResourceBundle.getBundle("messages/CommonBundle").getString("button.cancel"));
        jPanel4.add((Component)jButton2, new GridConstraints(0, 0, 1, 1, 0, 1, 3, 0, null, null, null));
        this.myBackgroundButton = jButton = new JButton();
        jButton.setFocusPainted(true);
        this.$$$loadButtonText$$$(jButton, ResourceBundle.getBundle("messages/CommonBundle").getString("button.background"));
        jPanel4.add((Component)jButton, new GridConstraints(1, 0, 1, 1, 0, 1, 3, 0, null, null, null));
        this.myTitlePanel = titlePanel = new TitlePanel();
        jPanel2.add((Component)titlePanel, new GridConstraints(0, 0, 1, 1, 0, 1, 7, 0, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }

    private class MyDialogWrapper
    extends DialogWrapper {
        private final boolean myIsCancellable;

        MyDialogWrapper(Project project, boolean cancellable) {
            super(project, false);
            this.init();
            this.myIsCancellable = cancellable;
        }

        MyDialogWrapper(Component parent, boolean cancellable) {
            super(parent, false);
            this.init();
            this.myIsCancellable = cancellable;
        }

        public void doCancelAction() {
            if (this.myIsCancellable) {
                super.doCancelAction();
            }
        }

        @NotNull
        protected DialogWrapperPeer createPeer(@NotNull Component parent, boolean canBeParent) {
            if (this.useLightPopup()) {
                try {
                    return new GlassPaneDialogWrapperPeer((DialogWrapper)this, parent, canBeParent);
                }
                catch (GlassPaneDialogWrapperPeer.GlasspanePeerUnavailableException e) {
                    return super.createPeer(parent, canBeParent);
                }
            }
            return super.createPeer(parent, canBeParent);
        }

        @NotNull
        protected DialogWrapperPeer createPeer(boolean canBeParent, boolean applicationModalIfPossible) {
            return this.createPeer(null, canBeParent, applicationModalIfPossible);
        }

        @NotNull
        protected DialogWrapperPeer createPeer(Window owner, boolean canBeParent, boolean applicationModalIfPossible) {
            if (this.useLightPopup()) {
                try {
                    return new GlassPaneDialogWrapperPeer(this, canBeParent);
                }
                catch (GlassPaneDialogWrapperPeer.GlasspanePeerUnavailableException e) {
                    return super.createPeer(WindowManager.getInstance().suggestParentWindow(((ProgressDialog)ProgressDialog.this).myProgressWindow.myProject), canBeParent, applicationModalIfPossible);
                }
            }
            return super.createPeer(WindowManager.getInstance().suggestParentWindow(((ProgressDialog)ProgressDialog.this).myProgressWindow.myProject), canBeParent, applicationModalIfPossible);
        }

        private boolean useLightPopup() {
            return System.getProperty("vintage.progress") == null && !ProgressDialog.this.isWriteActionProgress();
        }

        @NotNull
        protected DialogWrapperPeer createPeer(Project project, boolean canBeParent) {
            if (System.getProperty("vintage.progress") == null) {
                try {
                    return new GlassPaneDialogWrapperPeer((DialogWrapper)this, project, canBeParent);
                }
                catch (GlassPaneDialogWrapperPeer.GlasspanePeerUnavailableException e) {
                    return super.createPeer(project, canBeParent);
                }
            }
            return super.createPeer(project, canBeParent);
        }

        protected void init() {
            super.init();
            this.setUndecorated(true);
            this.getRootPane().setWindowDecorationStyle(0);
            ProgressDialog.this.myPanel.setBorder((Border)PopupBorder.Factory.create((boolean)true, (boolean)true));
        }

        protected boolean isProgressDialog() {
            return true;
        }

        protected JComponent createCenterPanel() {
            return ProgressDialog.this.myPanel;
        }

        @Nullable
        protected JComponent createSouthPanel() {
            return null;
        }

        @Nullable
        protected Border createContentPaneBorder() {
            return null;
        }
    }
}

