/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.progress.util;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationAdapter;
import com.intellij.openapi.application.ApplicationListener;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ex.ApplicationEx;
import com.intellij.openapi.application.ex.ApplicationManagerEx;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.util.ProgressIndicatorBase;
import com.intellij.openapi.progress.util.ReadTask;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.EmptyRunnable;
import com.intellij.openapi.util.Ref;
import com.intellij.util.concurrency.AppExecutorUtil;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.ide.PooledThreadExecutor;

public class ProgressIndicatorUtils {
    @NotNull
    public static ProgressIndicator forceWriteActionPriority(final @NotNull ProgressIndicator progress, @NotNull Disposable parentDisposable) {
        ApplicationManager.getApplication().addApplicationListener((ApplicationListener)new ApplicationAdapter(){

            public void beforeWriteActionStart(@NotNull Object action) {
                if (progress.isRunning()) {
                    progress.cancel();
                }
            }
        }, parentDisposable);
        return progress;
    }

    public static void scheduleWithWriteActionPriority(@NotNull ReadTask task2) {
        ProgressIndicatorUtils.scheduleWithWriteActionPriority(new ProgressIndicatorBase(), task2);
    }

    @NotNull
    public static CompletableFuture<?> scheduleWithWriteActionPriority(@NotNull ProgressIndicator progressIndicator, @NotNull ReadTask readTask) {
        return ProgressIndicatorUtils.scheduleWithWriteActionPriority(progressIndicator, PooledThreadExecutor.INSTANCE, readTask);
    }

    @NotNull
    public static CompletableFuture<?> scheduleWithWriteActionPriority(@NotNull Executor executor, @NotNull ReadTask task2) {
        return ProgressIndicatorUtils.scheduleWithWriteActionPriority(new ProgressIndicatorBase(), executor, task2);
    }

    public static boolean runInReadActionWithWriteActionPriority(@NotNull Runnable action, @Nullable ProgressIndicator progressIndicator) {
        Ref result2 = new Ref((Object)Boolean.FALSE);
        ProgressIndicatorUtils.runWithWriteActionPriority(() -> result2.set((Object)ApplicationManagerEx.getApplicationEx().tryRunReadAction(action)), progressIndicator == null ? new ProgressIndicatorBase() : progressIndicator);
        return (Boolean)result2.get();
    }

    public static boolean runInReadActionWithWriteActionPriority(@NotNull Runnable action) {
        return ProgressIndicatorUtils.runInReadActionWithWriteActionPriority(action, null);
    }

    public static boolean runWithWriteActionPriority(@NotNull Runnable action, final @NotNull ProgressIndicator progressIndicator) {
        ApplicationEx application = (ApplicationEx)ApplicationManager.getApplication();
        if (application.isDispatchThread()) {
            throw new IllegalStateException("Must not call from EDT");
        }
        if (ProgressIndicatorUtils.isWriting(application)) {
            ProgressIndicatorUtils.cancelProcess(progressIndicator);
            return false;
        }
        ApplicationListener listener2 = new ApplicationListener(){

            public void beforeWriteActionStart(@NotNull Object action) {
                ProgressIndicatorUtils.cancelProcess(progressIndicator);
            }
        };
        Ref wasCancelled = new Ref();
        ProgressManager.getInstance().runProcess(() -> {
            application.addApplicationListener(listener2);
            try {
                if (ProgressIndicatorUtils.isWriting(application)) {
                    ProgressIndicatorUtils.cancelProcess(progressIndicator);
                    wasCancelled.set((Object)Boolean.TRUE);
                    return;
                }
                action.run();
            }
            catch (ProcessCanceledException ignore) {
                wasCancelled.set((Object)Boolean.TRUE);
            }
            finally {
                application.removeApplicationListener(listener2);
            }
        }, progressIndicator);
        return wasCancelled.get() != Boolean.TRUE;
    }

    private static void cancelProcess(ProgressIndicator progressIndicator) {
        if (!progressIndicator.isCanceled()) {
            progressIndicator.cancel();
        }
    }

    private static boolean isWriting(ApplicationEx application) {
        return application.isWriteActionPending() || application.isWriteActionInProgress();
    }

    @NotNull
    public static CompletableFuture<?> scheduleWithWriteActionPriority(final @NotNull ProgressIndicator progressIndicator, @NotNull Executor executor, final @NotNull ReadTask readTask) {
        final CompletableFuture future2 = new CompletableFuture();
        final Application application = ApplicationManager.getApplication();
        application.invokeLater(() -> {
            if (application.isDisposed() || progressIndicator.isCanceled() || future2.isCancelled()) {
                future2.complete(null);
                return;
            }
            final ApplicationListener listener2 = new ApplicationListener(){

                public void beforeWriteActionStart(@NotNull Object action) {
                    if (!progressIndicator.isCanceled()) {
                        progressIndicator.cancel();
                        readTask.onCanceled(progressIndicator);
                    }
                }
            };
            application.addApplicationListener(listener2);
            future2.whenComplete((__, ___) -> application.removeApplicationListener(listener2));
            try {
                executor.execute(new Runnable(){

                    @Override
                    public void run() {
                        ReadTask.Continuation continuation;
                        try {
                            continuation = ProgressIndicatorUtils.runUnderProgress(progressIndicator, readTask);
                        }
                        catch (Throwable e) {
                            future2.completeExceptionally(e);
                            throw e;
                        }
                        if (continuation == null) {
                            future2.complete(null);
                        } else if (!future2.isCancelled()) {
                            application.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    if (future2.isCancelled()) {
                                        return;
                                    }
                                    application.removeApplicationListener(listener2);
                                    try {
                                        if (!progressIndicator.isCanceled()) {
                                            continuation.getAction().run();
                                        }
                                    }
                                    finally {
                                        future2.complete(null);
                                    }
                                }

                                public String toString() {
                                    return "continuation of " + readTask;
                                }
                            }, continuation.getModalityState());
                        }
                    }

                    public String toString() {
                        return readTask.toString();
                    }
                });
            }
            catch (Throwable e) {
                future2.completeExceptionally(e);
                throw e;
            }
        }, ModalityState.any());
        return future2;
    }

    private static ReadTask.Continuation runUnderProgress(@NotNull ProgressIndicator progressIndicator, @NotNull ReadTask task2) {
        return (ReadTask.Continuation)ProgressManager.getInstance().runProcess(() -> {
            try {
                return task2.runBackgroundProcess(progressIndicator);
            }
            catch (ProcessCanceledException ignore) {
                return null;
            }
        }, progressIndicator);
    }

    public static void yieldToPendingWriteActions() {
        Application application = ApplicationManager.getApplication();
        if (application.isReadAccessAllowed()) {
            throw new IllegalStateException("Mustn't be called from within read action");
        }
        if (application.isDispatchThread()) {
            throw new IllegalStateException("Mustn't be called from EDT");
        }
        application.invokeAndWait(EmptyRunnable.INSTANCE, ModalityState.any());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static <T> T withTimeout(long timeoutMs, @NotNull Computable<T> computable) {
        ProgressManager.checkCanceled();
        ProgressIndicatorBase progress = new ProgressIndicatorBase();
        ScheduledFuture<?> cancelProgress = AppExecutorUtil.getAppScheduledExecutorService().schedule(progress::cancel, timeoutMs, TimeUnit.MILLISECONDS);
        try {
            Object object = ProgressManager.getInstance().runProcess(computable, (ProgressIndicator)progress);
            return (T)object;
        }
        catch (ProcessCanceledException e) {
            T t = null;
            return t;
        }
        finally {
            cancelProgress.cancel(false);
        }
    }
}

