/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.progress.util;

import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ReadTask {
    public void computeInReadAction(@NotNull ProgressIndicator indicator) throws ProcessCanceledException {
        throw new UnsupportedOperationException();
    }

    @Nullable
    public Continuation performInReadAction(@NotNull ProgressIndicator indicator) throws ProcessCanceledException {
        this.computeInReadAction(indicator);
        return null;
    }

    public abstract void onCanceled(@NotNull ProgressIndicator var1);

    public Continuation runBackgroundProcess(@NotNull ProgressIndicator indicator) throws ProcessCanceledException {
        return (Continuation)ReadAction.compute(() -> this.performInReadAction(indicator));
    }

    public static final class Continuation {
        private final Runnable myAction;
        private final ModalityState myModalityState;

        public Continuation(@NotNull Runnable action) {
            this(action, ModalityState.defaultModalityState());
        }

        public Continuation(@NotNull Runnable action, @NotNull ModalityState modalityState) {
            this.myAction = action;
            this.myModalityState = modalityState;
        }

        @NotNull
        public ModalityState getModalityState() {
            return this.myModalityState;
        }

        @NotNull
        public Runnable getAction() {
            return this.myAction;
        }
    }
}

