/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.project;

import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectCoreUtil;
import com.intellij.openapi.project.ProjectLocator;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.SmartList;
import java.util.Collection;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ProjectLocatorImpl
extends ProjectLocator {
    @Nullable
    public Project guessProjectForFile(@Nullable VirtualFile file2) {
        Project project = ProjectCoreUtil.theOnlyOpenProject();
        if (project == null && file2 != null) {
            project = ProjectLocatorImpl.getPreferredProject((VirtualFile)file2);
        }
        if (project != null && !project.isDisposed()) {
            return project;
        }
        if (file2 == null) {
            return null;
        }
        return (Project)ReadAction.compute(() -> {
            Project[] openProjects;
            ProjectManager projectManager = ProjectManager.getInstance();
            if (projectManager == null) {
                return null;
            }
            for (Project openProject : openProjects = projectManager.getOpenProjects()) {
                if (!ProjectLocatorImpl.isUnder(openProject, file2)) continue;
                return openProject;
            }
            return null;
        });
    }

    private static boolean isUnder(@NotNull Project project, @NotNull VirtualFile file2) {
        if (!project.isInitialized() || project.isDisposed()) {
            return false;
        }
        ProjectFileIndex fileIndex = ProjectRootManager.getInstance((Project)project).getFileIndex();
        return fileIndex.isInContent(file2) || fileIndex.isExcluded(file2);
    }

    @NotNull
    public Collection<Project> getProjectsForFile(VirtualFile file2) {
        ProjectManager projectManager = ProjectManager.getInstance();
        if (projectManager == null || file2 == null) {
            return Collections.emptyList();
        }
        Project[] openProjects = projectManager.getOpenProjects();
        if (openProjects.length == 0) {
            return Collections.emptyList();
        }
        SmartList result2 = new SmartList();
        for (Project project : openProjects) {
            if (!ProjectLocatorImpl.isUnder(project, file2)) continue;
            result2.add(project);
        }
        return result2;
    }
}

