/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.project.impl;

import com.intellij.configurationStore.StoreUtil;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.startup.StartupManagerEx;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ex.ApplicationEx;
import com.intellij.openapi.application.ex.ApplicationManagerEx;
import com.intellij.openapi.application.impl.ApplicationInfoImpl;
import com.intellij.openapi.application.impl.LaterInvocator;
import com.intellij.openapi.components.ComponentConfig;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.PathMacroManager;
import com.intellij.openapi.components.StorageScheme;
import com.intellij.openapi.components.impl.PlatformComponentManagerImpl;
import com.intellij.openapi.components.impl.ProjectPathMacroManager;
import com.intellij.openapi.components.impl.stores.IComponentStore;
import com.intellij.openapi.components.impl.stores.IProjectStore;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.impl.EditorsSplitters;
import com.intellij.openapi.fileEditor.impl.FileEditorManagerImpl;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.impl.ModuleManagerImpl;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.DumbAwareRunnable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ex.ProjectEx;
import com.intellij.openapi.project.ex.ProjectManagerEx;
import com.intellij.openapi.project.impl.ProjectLifecycleListener;
import com.intellij.openapi.project.impl.ProjectStoreClassProvider;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.openapi.wm.impl.FrameTitleBuilder;
import com.intellij.project.ProjectKt;
import com.intellij.psi.impl.DebugUtil;
import com.intellij.util.PathUtil;
import com.intellij.util.TimedReference;
import com.intellij.util.pico.CachingConstructorInjectionComponentAdapter;
import java.util.List;
import javax.swing.JFrame;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.SystemDependent;
import org.jetbrains.annotations.SystemIndependent;
import org.picocontainer.ComponentAdapter;
import org.picocontainer.MutablePicoContainer;
import org.picocontainer.PicoContainer;
import org.picocontainer.PicoInitializationException;
import org.picocontainer.PicoIntrospectionException;
import org.picocontainer.PicoVisitor;

public class ProjectImpl
extends PlatformComponentManagerImpl
implements ProjectEx {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.project.impl.ProjectImpl");
    public static final String NAME_FILE = ".name";
    public static final Key<Long> CREATION_TIME = Key.create((String)"ProjectImpl.CREATION_TIME");
    public static final Key<String> CREATION_TRACE = Key.create((String)"ProjectImpl.CREATION_TRACE");
    public static final String LIGHT_PROJECT_NAME = "light_temp";
    private String myName;
    private final boolean myLight;
    private static boolean ourClassesAreLoaded;
    private volatile boolean temporarilyDisposed;

    protected ProjectImpl(@NotNull String filePath, @Nullable String projectName) {
        super((ComponentManager)ApplicationManager.getApplication(), "Project " + (projectName == null ? filePath : projectName));
        this.putUserData(CREATION_TIME, System.nanoTime());
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            this.putUserData(CREATION_TRACE, DebugUtil.currentStackTrace());
        }
        this.getPicoContainer().registerComponentInstance(Project.class, (Object)this);
        if (!this.isDefault()) {
            this.getStateStore().setPath(filePath);
        }
        this.myName = projectName;
        this.myLight = ApplicationManager.getApplication().isUnitTestMode() && filePath.contains(LIGHT_PROJECT_NAME);
    }

    @Override
    public boolean isDisposed() {
        return super.isDisposed() || this.temporarilyDisposed;
    }

    public boolean isLight() {
        return this.myLight;
    }

    void setTemporarilyDisposed(boolean disposed) {
        this.temporarilyDisposed = disposed;
    }

    boolean isTemporarilyDisposed() {
        return this.temporarilyDisposed;
    }

    @Override
    public void setProjectName(@NotNull String projectName) {
        if (!projectName.equals(this.myName)) {
            this.myName = projectName;
            StartupManager.getInstance((Project)this).runWhenProjectIsInitialized((Runnable)((DumbAwareRunnable)() -> {
                if (this.isDisposed()) {
                    return;
                }
                JFrame frame = WindowManager.getInstance().getFrame((Project)this);
                String title = FrameTitleBuilder.getInstance().getProjectTitle(this);
                if (frame != null && title != null) {
                    frame.setTitle(title);
                }
            }));
        }
    }

    @Override
    protected void bootstrapPicoContainer(@NotNull String name) {
        Extensions.instantiateArea((String)"IDEA_PROJECT", (AreaInstance)this, null);
        super.bootstrapPicoContainer(name);
        MutablePicoContainer picoContainer = this.getPicoContainer();
        final ProjectStoreClassProvider projectStoreClassProvider = (ProjectStoreClassProvider)picoContainer.getComponentInstanceOfType(ProjectStoreClassProvider.class);
        picoContainer.registerComponentImplementation(PathMacroManager.class, ProjectPathMacroManager.class);
        picoContainer.registerComponent(new ComponentAdapter(){
            private ComponentAdapter myDelegate;

            @NotNull
            private ComponentAdapter getDelegate() {
                if (this.myDelegate == null) {
                    Class<? extends IComponentStore> storeClass = projectStoreClassProvider.getProjectStoreClass(ProjectImpl.this.isDefault());
                    this.myDelegate = new CachingConstructorInjectionComponentAdapter(storeClass, storeClass, null, true);
                }
                return this.myDelegate;
            }

            public Object getComponentKey() {
                return IComponentStore.class;
            }

            public Class getComponentImplementation() {
                return this.getDelegate().getComponentImplementation();
            }

            public Object getComponentInstance(PicoContainer container) throws PicoInitializationException, PicoIntrospectionException {
                return this.getDelegate().getComponentInstance(container);
            }

            public void verify(PicoContainer container) throws PicoIntrospectionException {
                this.getDelegate().verify(container);
            }

            public void accept(PicoVisitor visitor) {
                visitor.visitComponentAdapter((ComponentAdapter)this);
                this.getDelegate().accept(visitor);
            }
        });
    }

    @NotNull
    IProjectStore getStateStore() {
        return ProjectKt.getStateStore(this);
    }

    public boolean isOpen() {
        return ProjectManagerEx.getInstanceEx().isProjectOpened(this);
    }

    public boolean isInitialized() {
        if (this.isDisposed() || !this.isOpen()) {
            return false;
        }
        StartupManagerEx managerEx = StartupManagerEx.getInstanceEx(this);
        return managerEx != null && managerEx.startupActivityPassed();
    }

    @Override
    @NotNull
    public List<ComponentConfig> getMyComponentConfigsFromDescriptor(@NotNull IdeaPluginDescriptor plugin) {
        return plugin.getProjectComponents();
    }

    @Nullable
    public @SystemIndependent String getProjectFilePath() {
        return this.isDefault() ? null : this.getStateStore().getProjectFilePath();
    }

    public VirtualFile getProjectFile() {
        return this.isDefault() ? null : LocalFileSystem.getInstance().findFileByPath(this.getStateStore().getProjectFilePath());
    }

    public VirtualFile getBaseDir() {
        return this.isDefault() ? null : LocalFileSystem.getInstance().findFileByPath(this.getStateStore().getProjectBasePath());
    }

    @Nullable
    public @SystemIndependent String getBasePath() {
        return this.isDefault() ? null : this.getStateStore().getProjectBasePath();
    }

    @NotNull
    public String getName() {
        if (this.myName == null) {
            return this.getStateStore().getProjectName();
        }
        return this.myName;
    }

    public @SystemDependent String getPresentableUrl() {
        if (this.isDefault()) {
            return null;
        }
        IProjectStore store = this.getStateStore();
        return PathUtil.toSystemDependentName((String)(store.getStorageScheme() == StorageScheme.DIRECTORY_BASED ? store.getProjectBasePath() : store.getProjectFilePath()));
    }

    @NotNull
    @NonNls
    public String getLocationHash() {
        String str = this.getPresentableUrl();
        if (str == null) {
            str = this.getName();
        }
        String prefix = !this.isDefault() && this.getStateStore().getStorageScheme() == StorageScheme.DIRECTORY_BASED ? "" : this.getName();
        return prefix + Integer.toHexString(str.hashCode());
    }

    @Nullable
    public VirtualFile getWorkspaceFile() {
        String workspaceFilePath = this.isDefault() ? null : this.getStateStore().getWorkspaceFilePath();
        return workspaceFilePath == null ? null : LocalFileSystem.getInstance().findFileByPath(workspaceFilePath);
    }

    @Override
    public void init() {
        Application application = ApplicationManager.getApplication();
        long start2 = System.currentTimeMillis();
        ProgressIndicator progressIndicator = this.isDefault() ? null : ProgressIndicatorProvider.getGlobalProgressIndicator();
        this.init(progressIndicator, () -> ((ProjectLifecycleListener)application.getMessageBus().syncPublisher(ProjectLifecycleListener.TOPIC)).projectComponentsRegistered((Project)this));
        long time = System.currentTimeMillis() - start2;
        String message = this.getComponentConfigCount() + " project components initialized in " + time + " ms";
        if (application.isUnitTestMode()) {
            LOG.debug(message);
        } else {
            LOG.info(message);
        }
        if (!this.isDefault() && !application.isHeadlessEnvironment()) {
            this.distributeProgress();
        }
        if (this.myName == null) {
            this.myName = this.getStateStore().getProjectName();
        }
        ((ProjectLifecycleListener)application.getMessageBus().syncPublisher(ProjectLifecycleListener.TOPIC)).projectComponentsInitialized((Project)this);
    }

    @Override
    protected void setProgressDuringInit(@NotNull ProgressIndicator indicator) {
        indicator.setFraction(this.getPercentageOfComponentsLoaded() / (double)(ourClassesAreLoaded ? 10 : 2));
    }

    private void distributeProgress() {
        double modulesPart;
        ProgressIndicator indicator = ProgressManager.getInstance().getProgressIndicator();
        if (indicator == null) {
            return;
        }
        ModuleManager moduleManager = ModuleManager.getInstance((Project)this);
        if (!(moduleManager instanceof ModuleManagerImpl)) {
            return;
        }
        double toDistribute = 1.0 - indicator.getFraction();
        int modulesCount = ((ModuleManagerImpl)moduleManager).getModulePathsCount();
        EditorsSplitters splitters = ((FileEditorManagerImpl)FileEditorManager.getInstance((Project)this)).getMainSplitters();
        int editors = splitters.getEditorsCount();
        double d = modulesPart = ourClassesAreLoaded || editors == 0 ? toDistribute : toDistribute * 0.5;
        if (modulesCount != 0) {
            double step = modulesPart / (double)modulesCount;
            ((ModuleManagerImpl)moduleManager).setProgressStep(step);
        }
        if (editors != 0) {
            splitters.setProgressStep(toDistribute - modulesPart / (double)editors);
        }
    }

    public void save() {
        if (!ApplicationManagerEx.getApplicationEx().isSaveAllowed()) {
            return;
        }
        if (!this.isInitialized()) {
            LOG.debug("Skip save for " + this.getName() + ": not initialized");
            return;
        }
        StoreUtil.saveSettings(this, false);
    }

    @Override
    public synchronized void dispose() {
        ApplicationEx application = ApplicationManagerEx.getApplicationEx();
        application.assertWriteAccessAllowed();
        if (ProjectManagerEx.getInstanceEx().isProjectOpened(this)) {
            throw new IllegalStateException("Must call .dispose() for a closed project only. See ProjectManager.closeProject() or ProjectUtil.closeAndDispose().");
        }
        LOG.assertTrue(!super.isDisposed(), (Object)(this + " is disposed already"));
        this.disposeComponents();
        Extensions.disposeArea((AreaInstance)this);
        super.dispose();
        if (!application.isDisposed()) {
            ((ProjectLifecycleListener)application.getMessageBus().syncPublisher(ProjectLifecycleListener.TOPIC)).afterProjectClosed((Project)this);
        }
        TimedReference.disposeTimed();
        LaterInvocator.purgeExpiredItems();
    }

    @NotNull
    public <T> T[] getExtensions(@NotNull ExtensionPointName<T> extensionPointName) {
        return Extensions.getArea((AreaInstance)this).getExtensionPoint(extensionPointName).getExtensions();
    }

    @Override
    @NotNull
    protected MutablePicoContainer createPicoContainer() {
        return Extensions.getArea((AreaInstance)this).getPicoContainer();
    }

    public boolean isDefault() {
        return false;
    }

    @NonNls
    public String toString() {
        return "Project" + (this.isDisposed() ? " (Disposed" + (this.temporarilyDisposed ? " temporarily" : "") + ")" : (this.isDefault() ? "" : " '" + this.getPresentableUrl() + "'")) + (this.isDefault() ? " (Default)" : "") + " " + this.getName();
    }

    @Override
    protected boolean logSlowComponents() {
        return super.logSlowComponents() || ApplicationInfoImpl.getShadowInstance().isEAP();
    }
}

