/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.project.impl;

import com.intellij.configurationStore.StorageUtilKt;
import com.intellij.configurationStore.StoreUtil;
import com.intellij.conversion.ConversionResult;
import com.intellij.conversion.ConversionService;
import com.intellij.featureStatistics.fusCollectors.LifecycleUsageTriggerCollector;
import com.intellij.ide.AppLifecycleListener;
import com.intellij.ide.impl.ProjectUtil;
import com.intellij.ide.plugins.PluginManager;
import com.intellij.ide.startup.StartupManagerEx;
import com.intellij.ide.startup.impl.StartupManagerImpl;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.notification.NotificationsManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.TransactionGuard;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.application.impl.LaterInvocator;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ProjectComponent;
import com.intellij.openapi.components.impl.ComponentManagerImpl;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.project.ProjectCoreUtil;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.ProjectManagerListener;
import com.intellij.openapi.project.ProjectReloadState;
import com.intellij.openapi.project.VetoableProjectManagerListener;
import com.intellij.openapi.project.ex.ProjectEx;
import com.intellij.openapi.project.ex.ProjectManagerEx;
import com.intellij.openapi.project.impl.DefaultProject;
import com.intellij.openapi.project.impl.ProjectImpl;
import com.intellij.openapi.project.impl.ProjectLifecycleListener;
import com.intellij.openapi.project.impl.TooManyProjectLeakedException;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.ShutDownTracker;
import com.intellij.openapi.util.UserDataHolderEx;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.impl.ZipHandler;
import com.intellij.openapi.wm.impl.welcomeScreen.WelcomeFrame;
import com.intellij.project.ProjectKt;
import com.intellij.ui.GuiUtils;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.UnsafeWeakList;
import com.intellij.util.messages.MessageBus;
import com.intellij.util.ref.GCUtil;
import com.intellij.util.ui.UIUtil;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.WeakHashMap;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ProjectManagerImpl
extends ProjectManagerEx
implements Disposable {
    private static final Logger LOG = Logger.getInstance(ProjectManagerImpl.class);
    private static final Key<List<ProjectManagerListener>> LISTENERS_IN_PROJECT_KEY = Key.create((String)"LISTENERS_IN_PROJECT_KEY");
    private ProjectEx myDefaultProject;
    private Project[] myOpenProjects = new Project[0];
    private final Map<String, Project> myOpenProjectByHash = ContainerUtil.newConcurrentMap();
    private final Object lock = new Object();
    private final List<ProjectManagerListener> myListeners = ContainerUtil.createLockFreeCopyOnWriteList();
    private final ProgressManager myProgressManager;
    private volatile boolean myDefaultProjectWasDisposed;
    private final ProjectManagerListener myBusPublisher;
    public static int TEST_PROJECTS_CREATED;
    private static final boolean LOG_PROJECT_LEAKAGE_IN_TESTS;
    private static final int MAX_LEAKY_PROJECTS = 5;
    private static final long LEAK_CHECK_INTERVAL;
    private static long CHECK_START;
    private final Map<Project, String> myProjects = new WeakHashMap<Project, String>();

    @NotNull
    private static List<ProjectManagerListener> getListeners(@NotNull Project project) {
        List array = (List)project.getUserData(LISTENERS_IN_PROJECT_KEY);
        if (array == null) {
            return Collections.emptyList();
        }
        return array;
    }

    public ProjectManagerImpl(ProgressManager progressManager) {
        this.myProgressManager = progressManager;
        MessageBus messageBus = ApplicationManager.getApplication().getMessageBus();
        this.myBusPublisher = (ProjectManagerListener)messageBus.syncPublisher(TOPIC);
        messageBus.connect().subscribe(ProjectManager.TOPIC, (Object)new ProjectManagerListener(){

            public void projectOpened(@NotNull Project project) {
                for (ProjectManagerListener listener2 : ProjectManagerImpl.this.getAllListeners(project)) {
                    try {
                        listener2.projectOpened(project);
                    }
                    catch (Exception e) {
                        ProjectManagerImpl.handleListenerError(e, listener2);
                    }
                }
            }

            public void projectClosed(@NotNull Project project) {
                for (ProjectManagerListener listener2 : ProjectManagerImpl.this.getAllListeners(project)) {
                    try {
                        listener2.projectClosed(project);
                    }
                    catch (Exception e) {
                        ProjectManagerImpl.handleListenerError(e, listener2);
                    }
                }
                ZipHandler.clearFileAccessorCache();
                LaterInvocator.purgeExpiredItems();
            }

            public void projectClosing(@NotNull Project project) {
                for (ProjectManagerListener listener2 : ProjectManagerImpl.this.getAllListeners(project)) {
                    try {
                        listener2.projectClosing(project);
                    }
                    catch (Exception e) {
                        ProjectManagerImpl.handleListenerError(e, listener2);
                    }
                }
            }

            public void projectClosingBeforeSave(@NotNull Project project) {
                for (ProjectManagerListener listener2 : ProjectManagerImpl.this.getAllListeners(project)) {
                    try {
                        listener2.projectClosingBeforeSave(project);
                    }
                    catch (Exception e) {
                        ProjectManagerImpl.handleListenerError(e, listener2);
                    }
                }
            }
        });
    }

    private static void handleListenerError(@NotNull Throwable e, @NotNull ProjectManagerListener listener2) {
        if (e instanceof ProcessCanceledException) {
            throw (ProcessCanceledException)e;
        }
        LOG.error("From listener " + listener2 + " (" + listener2.getClass() + ")", e);
    }

    public void dispose() {
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        if (this.myDefaultProject != null) {
            Disposer.dispose((Disposable)this.myDefaultProject);
            this.myDefaultProject = null;
            this.myDefaultProjectWasDisposed = true;
        }
    }

    @Override
    @Nullable
    public Project newProject(@Nullable String projectName, @NotNull String filePath, boolean useDefaultProjectSettings, boolean isDummy) {
        File projectFile;
        filePath = ProjectManagerImpl.toCanonicalName(filePath);
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            ++TEST_PROJECTS_CREATED;
            this.checkProjectLeaksInTests();
        }
        if ((projectFile = new File(filePath)).isFile()) {
            FileUtil.delete((File)projectFile);
        } else {
            File[] files2 = new File(projectFile, ".idea").listFiles();
            if (files2 != null) {
                for (File file2 : files2) {
                    FileUtil.delete((File)file2);
                }
            }
        }
        ProjectEx project = ProjectManagerImpl.createProject(projectName, filePath, false);
        try {
            this.initProject(project, useDefaultProjectSettings ? this.getDefaultProject() : null);
            if (LOG_PROJECT_LEAKAGE_IN_TESTS) {
                this.myProjects.put(project, null);
            }
            return project;
        }
        catch (Throwable t) {
            LOG.warn(t);
            try {
                Messages.showErrorDialog((String)ProjectManagerImpl.message(t), (String)ProjectBundle.message((String)"project.load.default.error", (Object[])new Object[0]));
            }
            catch (NoClassDefFoundError e) {
                LOG.info((Throwable)e);
            }
            return null;
        }
    }

    @NonNls
    @NotNull
    private static String message(@NotNull Throwable e) {
        String message = e.getMessage();
        if (message != null) {
            return message;
        }
        message = e.getLocalizedMessage();
        if (message != null) {
            return message;
        }
        message = e.toString();
        Throwable cause = e.getCause();
        if (cause != null) {
            String causeMessage = ProjectManagerImpl.message(cause);
            return message + " (cause: " + causeMessage + ")";
        }
        return message;
    }

    private void checkProjectLeaksInTests() {
        if (!LOG_PROJECT_LEAKAGE_IN_TESTS || this.getLeakedProjectsCount() < 5) {
            return;
        }
        long currentTime = System.currentTimeMillis();
        if (currentTime - CHECK_START < LEAK_CHECK_INTERVAL) {
            return;
        }
        for (int i = 0; i < 3 && this.getLeakedProjectsCount() >= 5; ++i) {
            GCUtil.tryGcSoftlyReachableObjects();
        }
        CHECK_START = currentTime;
        if (this.getLeakedProjectsCount() >= 5) {
            System.gc();
            Collection<Project> copy = this.getLeakedProjects();
            this.myProjects.clear();
            if (ContainerUtil.collect(copy.iterator()).size() >= 5) {
                throw new TooManyProjectLeakedException(copy);
            }
        }
    }

    private Collection<Project> getLeakedProjects() {
        this.myProjects.remove(this.getDefaultProject());
        return (Collection)this.myProjects.keySet().stream().filter(project -> project.isDisposed() && !((ProjectImpl)project).isTemporarilyDisposed()).collect(Collectors.toCollection(UnsafeWeakList::new));
    }

    private int getLeakedProjectsCount() {
        this.myProjects.remove(this.getDefaultProject());
        return (int)this.myProjects.keySet().stream().filter(project -> project.isDisposed() && !((ProjectImpl)project).isTemporarilyDisposed()).count();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initProject(@NotNull ProjectEx project, @Nullable Project template) {
        ProgressIndicator indicator = this.myProgressManager.getProgressIndicator();
        if (indicator != null && !project.isDefault()) {
            indicator.setIndeterminate(false);
            indicator.setText(ProjectBundle.message((String)"loading.components.for", (Object[])new Object[]{project.getName()}));
        }
        ((ProjectLifecycleListener)ApplicationManager.getApplication().getMessageBus().syncPublisher(ProjectLifecycleListener.TOPIC)).beforeProjectLoaded((Project)project);
        boolean succeed = false;
        try {
            if (template != null) {
                ProjectKt.getStateStore(project).loadProjectFromTemplate(template);
            }
            project.init();
            succeed = true;
        }
        finally {
            if (!succeed && !project.isDefault()) {
                TransactionGuard.submitTransaction((Disposable)project, () -> WriteAction.run(() -> Disposer.dispose((Disposable)project)));
            }
        }
    }

    @NotNull
    private static ProjectEx createProject(@Nullable String projectName, @NotNull String filePath, boolean isDefault) {
        if (isDefault) {
            return new DefaultProject("");
        }
        return new ProjectImpl(FileUtilRt.toSystemIndependentName((String)filePath), projectName);
    }

    @Override
    @Nullable
    public Project loadProject(@NotNull String filePath) throws IOException {
        return this.loadProject(filePath, null);
    }

    @Override
    @Nullable
    public Project loadProject(@NotNull String filePath, @Nullable String projectName) throws IOException {
        try {
            ProjectEx project = ProjectManagerImpl.createProject(projectName, new File(filePath).getAbsolutePath(), false);
            this.initProject(project, null);
            return project;
        }
        catch (Throwable t) {
            LOG.info(t);
            throw new IOException(t);
        }
    }

    @NotNull
    private static String toCanonicalName(@NotNull String filePath) {
        try {
            return FileUtil.resolveShortWindowsName((String)filePath);
        }
        catch (IOException iOException) {
            return filePath;
        }
    }

    @Override
    public synchronized boolean isDefaultProjectInitialized() {
        return this.myDefaultProject != null;
    }

    @NotNull
    public synchronized Project getDefaultProject() {
        LOG.assertTrue(!this.myDefaultProjectWasDisposed, (Object)"Default project has been already disposed!");
        if (this.myDefaultProject == null) {
            LOG.assertTrue(!ApplicationManager.getApplication().isDisposeInProgress(), (Object)"Application being disposed!");
            ProgressManager.getInstance().executeNonCancelableSection(() -> {
                try {
                    this.myDefaultProject = ProjectManagerImpl.createProject(null, "", true);
                    this.initProject(this.myDefaultProject, null);
                }
                catch (Throwable t) {
                    PluginManager.processException(t);
                }
            });
        }
        return this.myDefaultProject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public Project[] getOpenProjects() {
        Object object = this.lock;
        synchronized (object) {
            return this.myOpenProjects;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isProjectOpened(Project project) {
        Object object = this.lock;
        synchronized (object) {
            return ArrayUtil.contains((Object)project, (Object[])this.myOpenProjects);
        }
    }

    @Override
    public boolean openProject(@NotNull Project project) {
        if (ProjectManagerImpl.isLight(project)) {
            ((ProjectImpl)project).setTemporarilyDisposed(false);
            boolean isInitialized = StartupManagerEx.getInstanceEx(project).startupActivityPassed();
            if (isInitialized) {
                this.addToOpened(project);
                return true;
            }
        }
        for (Project p : this.getOpenProjects()) {
            if (!ProjectUtil.isSameProject(project.getProjectFilePath(), p)) continue;
            GuiUtils.invokeLaterIfNeeded(() -> ProjectUtil.focusProjectWindow(p, false), (ModalityState)ModalityState.NON_MODAL);
            return false;
        }
        if (!this.addToOpened(project)) {
            return false;
        }
        Runnable process2 = () -> {
            TransactionGuard.getInstance().submitTransactionAndWait(() -> this.fireProjectOpened(project));
            StartupManagerImpl startupManager = (StartupManagerImpl)StartupManager.getInstance((Project)project);
            startupManager.runStartupActivities();
            TransactionGuard.getInstance().submitTransactionAndWait(startupManager::startCacheUpdate);
            startupManager.runPostStartupActivitiesFromExtensions();
            GuiUtils.invokeLaterIfNeeded(() -> {
                if (!project.isDisposed()) {
                    startupManager.runPostStartupActivities();
                    Application application = ApplicationManager.getApplication();
                    if (!application.isHeadlessEnvironment() && !application.isUnitTestMode()) {
                        StorageUtilKt.checkUnknownMacros(project, true);
                    }
                }
            }, (ModalityState)ModalityState.NON_MODAL);
        };
        if (!this.loadProjectUnderProgress(project, process2)) {
            GuiUtils.invokeLaterIfNeeded(() -> {
                this.closeProject(project, false, false, false, true);
                WriteAction.run(() -> Disposer.dispose((Disposable)project));
                ProjectManagerImpl.notifyProjectOpenFailed();
            }, (ModalityState)ModalityState.defaultModalityState());
            return false;
        }
        return true;
    }

    private boolean loadProjectUnderProgress(@NotNull Project project, @NotNull Runnable performLoading) {
        ProgressIndicator indicator = this.myProgressManager.getProgressIndicator();
        if (!ApplicationManager.getApplication().isDispatchThread() && indicator != null) {
            indicator.setText("Preparing workspace...");
            try {
                performLoading.run();
                return true;
            }
            catch (ProcessCanceledException e) {
                return false;
            }
        }
        return this.myProgressManager.runProcessWithProgressSynchronously(performLoading, ProjectBundle.message((String)"project.load.progress", (Object[])new Object[0]), ProjectManagerImpl.canCancelProjectLoading(), project);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean addToOpened(@NotNull Project project) {
        assert (!project.isDisposed()) : "Must not open already disposed project";
        Object object = this.lock;
        synchronized (object) {
            if (this.isProjectOpened(project)) {
                return false;
            }
            this.myOpenProjects = (Project[])ArrayUtil.append((Object[])this.myOpenProjects, (Object)project);
            ProjectCoreUtil.theProject = this.myOpenProjects.length == 1 ? project : null;
            this.myOpenProjectByHash.put(project.getLocationHash(), project);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeFromOpened(@NotNull Project project) {
        Object object = this.lock;
        synchronized (object) {
            this.myOpenProjects = (Project[])ArrayUtil.remove((Object[])this.myOpenProjects, (Object)project);
            ProjectCoreUtil.theProject = this.myOpenProjects.length == 1 ? this.myOpenProjects[0] : null;
            this.myOpenProjectByHash.values().remove(project);
        }
    }

    @Override
    @Nullable
    public Project findOpenProjectByHash(@Nullable String locationHash) {
        return this.myOpenProjectByHash.get(locationHash);
    }

    private static boolean canCancelProjectLoading() {
        return !ProgressManager.getInstance().isInNonCancelableSection();
    }

    public Project loadAndOpenProject(@NotNull String originalFilePath) throws IOException {
        ProjectEx project;
        String filePath = ProjectManagerImpl.toCanonicalName(originalFilePath);
        final ConversionResult conversionResult = ConversionService.getInstance().convert(filePath);
        if (conversionResult.openingIsCanceled()) {
            project = null;
        } else {
            project = ProjectManagerImpl.createProject(null, filePath, false);
            this.myProgressManager.run((Task.WithResult)new Task.WithResult<Project, IOException>((Project)project, ProjectBundle.message((String)"project.load.progress", (Object[])new Object[0]), true){

                protected Project compute(@NotNull ProgressIndicator indicator) throws IOException {
                    if (!ProjectManagerImpl.this.loadProjectWithProgress(project)) {
                        return null;
                    }
                    if (!conversionResult.conversionNotNeeded()) {
                        StartupManager.getInstance((Project)project).registerPostStartupActivity(() -> conversionResult.postStartupActivity(project));
                    }
                    ProjectManagerImpl.this.openProject(project);
                    return project;
                }
            });
        }
        if (project == null) {
            WelcomeFrame.showIfNoProjectOpened();
            return null;
        }
        if (!project.isOpen()) {
            WelcomeFrame.showIfNoProjectOpened();
            ApplicationManager.getApplication().runWriteAction(() -> {
                if (!project.isDisposed()) {
                    Disposer.dispose((Disposable)project);
                }
            });
        }
        return project;
    }

    @Override
    @Nullable
    public Project convertAndLoadProject(@NotNull String filePath) throws IOException {
        String canonicalFilePath = ProjectManagerImpl.toCanonicalName(filePath);
        ConversionResult conversionResult = ConversionService.getInstance().convert(canonicalFilePath);
        if (conversionResult.openingIsCanceled()) {
            return null;
        }
        ProjectEx project = ProjectManagerImpl.createProject(null, canonicalFilePath, false);
        if (!this.loadProjectWithProgress(project)) {
            return null;
        }
        if (!conversionResult.conversionNotNeeded()) {
            StartupManager.getInstance((Project)project).registerPostStartupActivity(() -> conversionResult.postStartupActivity(project));
        }
        return project;
    }

    private boolean loadProjectWithProgress(ProjectEx project) throws IOException {
        try {
            if (!ApplicationManager.getApplication().isDispatchThread() && this.myProgressManager.getProgressIndicator() != null) {
                this.initProject(project, null);
                return true;
            }
            this.myProgressManager.runProcessWithProgressSynchronously(() -> {
                this.initProject(project, null);
                return project;
            }, ProjectBundle.message((String)"project.load.progress", (Object[])new Object[0]), ProjectManagerImpl.canCancelProjectLoading(), (Project)project);
            return true;
        }
        catch (ProcessCanceledException e) {
            return false;
        }
        catch (Throwable t) {
            LOG.info(t);
            throw new IOException(t);
        }
    }

    private static void notifyProjectOpenFailed() {
        Application application = ApplicationManager.getApplication();
        ((AppLifecycleListener)application.getMessageBus().syncPublisher(AppLifecycleListener.TOPIC)).projectOpenFailed();
        if (application.isUnitTestMode()) {
            return;
        }
        WelcomeFrame.showIfNoProjectOpened();
    }

    @Override
    public void openTestProject(@NotNull Project project) {
        assert (ApplicationManager.getApplication().isUnitTestMode());
        this.openProject(project);
        UIUtil.dispatchAllInvocationEvents();
    }

    @Override
    @NotNull
    public Collection<Project> closeTestProject(@NotNull Project project) {
        assert (ApplicationManager.getApplication().isUnitTestMode());
        this.forceCloseProject(project, false);
        Project[] projects = this.getOpenProjects();
        return projects.length == 0 ? Collections.emptyList() : Arrays.asList(projects);
    }

    public void reloadProject(@NotNull Project project) {
        ProjectManagerImpl.doReloadProject(project);
    }

    protected static void doReloadProject(@NotNull Project project) {
        Ref projectRef = Ref.create((Object)project);
        ProjectReloadState.getInstance((Project)project).onBeforeAutomaticProjectReload();
        ApplicationManager.getApplication().invokeLater(() -> {
            LOG.debug("Reloading project.");
            Project project1 = (Project)projectRef.get();
            projectRef.set(null);
            if (project1.isDisposed()) {
                return;
            }
            String presentableUrl = project1.getPresentableUrl();
            if (!ProjectUtil.closeAndDispose(project1)) {
                return;
            }
            ProjectUtil.openProject(Objects.requireNonNull(presentableUrl), null, true);
        }, ModalityState.NON_MODAL);
    }

    public boolean closeProject(@NotNull Project project) {
        return this.closeProject(project, true, true, false, true);
    }

    @Override
    public boolean forceCloseProject(@NotNull Project project, boolean dispose2) {
        return this.closeProject(project, false, false, dispose2, false);
    }

    @Override
    public boolean closeAndDisposeAllProjects(boolean checkCanClose) {
        for (Project project : this.getOpenProjects()) {
            if (this.closeProject(project, true, false, true, checkCanClose)) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean closeProject(@NotNull Project project, boolean isSaveProject, boolean isSaveApp, boolean dispose2, boolean checkCanClose) {
        Application app = ApplicationManager.getApplication();
        if (app.isWriteAccessAllowed()) {
            throw new IllegalStateException("Must not call closeProject() from under write action because fireProjectClosing() listeners must have a chance to do something useful");
        }
        app.assertIsDispatchThread();
        if (ProjectManagerImpl.isLight(project)) {
            if (!((ProjectImpl)project).isTemporarilyDisposed()) {
                ((ProjectImpl)project).setTemporarilyDisposed(true);
                this.removeFromOpened(project);
                return true;
            }
            ((ProjectImpl)project).setTemporarilyDisposed(false);
        } else if (!this.isProjectOpened(project)) {
            return true;
        }
        if (checkCanClose && !this.canClose(project)) {
            return false;
        }
        ShutDownTracker shutDownTracker = ShutDownTracker.getInstance();
        shutDownTracker.registerStopperThread(Thread.currentThread());
        try {
            this.myBusPublisher.projectClosingBeforeSave(project);
            if (isSaveProject) {
                FileDocumentManager.getInstance().saveAllDocuments();
                StoreUtil.saveSettings((ComponentManager)project, true);
                if (isSaveApp) {
                    StoreUtil.saveSettings((ComponentManager)app, true);
                }
            }
            if (checkCanClose && !ProjectManagerImpl.ensureCouldCloseIfUnableToSave(project)) {
                boolean bl = false;
                return bl;
            }
            this.fireProjectClosing(project);
            app.runWriteAction(() -> {
                this.removeFromOpened(project);
                this.fireProjectClosed(project);
                if (dispose2) {
                    Disposer.dispose((Disposable)project);
                }
            });
        }
        finally {
            shutDownTracker.unregisterStopperThread(Thread.currentThread());
        }
        return true;
    }

    public static boolean isLight(@NotNull Project project) {
        return project instanceof ProjectImpl && ((ProjectImpl)project).isLight();
    }

    @Override
    public boolean closeAndDispose(@NotNull Project project) {
        return this.closeProject(project, true, false, true, true);
    }

    private void fireProjectClosing(@NotNull Project project) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("enter: fireProjectClosing()");
        }
        this.myBusPublisher.projectClosing(project);
    }

    public void addProjectManagerListener(@NotNull ProjectManagerListener listener2) {
        this.myListeners.add(listener2);
    }

    public void addProjectManagerListener(@NotNull VetoableProjectManagerListener listener2) {
        this.myListeners.add((ProjectManagerListener)listener2);
    }

    public void addProjectManagerListener(@NotNull ProjectManagerListener listener2, @NotNull Disposable parentDisposable) {
        this.addProjectManagerListener(listener2);
        Disposer.register((Disposable)parentDisposable, () -> this.removeProjectManagerListener(listener2));
    }

    public void removeProjectManagerListener(@NotNull ProjectManagerListener listener2) {
        boolean removed = this.myListeners.remove(listener2);
        LOG.assertTrue(removed);
    }

    public void removeProjectManagerListener(@NotNull VetoableProjectManagerListener listener2) {
        boolean removed = this.myListeners.remove(listener2);
        LOG.assertTrue(removed);
    }

    public void addProjectManagerListener(@NotNull Project project, @NotNull ProjectManagerListener listener2) {
        List listeners = (List)project.getUserData(LISTENERS_IN_PROJECT_KEY);
        if (listeners == null) {
            listeners = (List)((UserDataHolderEx)project).putUserDataIfAbsent(LISTENERS_IN_PROJECT_KEY, (Object)ContainerUtil.createLockFreeCopyOnWriteList());
        }
        listeners.add(listener2);
    }

    public void removeProjectManagerListener(@NotNull Project project, @NotNull ProjectManagerListener listener2) {
        List listeners = (List)project.getUserData(LISTENERS_IN_PROJECT_KEY);
        LOG.assertTrue(listeners != null);
        boolean removed = listeners.remove(listener2);
        LOG.assertTrue(removed);
    }

    private void fireProjectOpened(@NotNull Project project) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("projectOpened");
        }
        LifecycleUsageTriggerCollector.onProjectOpened(project);
        this.myBusPublisher.projectOpened(project);
        if (project instanceof ComponentManagerImpl) {
            for (ProjectComponent component : ((ComponentManagerImpl)project).getComponentInstancesOfType(ProjectComponent.class)) {
                StartupManagerImpl.runActivity(() -> component.projectOpened());
            }
        }
    }

    private void fireProjectClosed(@NotNull Project project) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("projectClosed");
        }
        LifecycleUsageTriggerCollector.onProjectClosed(project);
        this.myBusPublisher.projectClosed(project);
        if (project instanceof ComponentManagerImpl) {
            List<ProjectComponent> components = ((ComponentManagerImpl)project).getComponentInstancesOfType(ProjectComponent.class);
            for (int i = components.size() - 1; i >= 0; --i) {
                ProjectComponent component = components.get(i);
                try {
                    component.projectClosed();
                    continue;
                }
                catch (Throwable e) {
                    LOG.error(component.toString(), e);
                }
            }
        }
    }

    @Override
    public boolean canClose(@NotNull Project project) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("enter: canClose()");
        }
        for (ProjectManagerListener listener2 : this.getAllListeners(project)) {
            try {
                boolean canClose = listener2 instanceof VetoableProjectManagerListener ? ((VetoableProjectManagerListener)listener2).canClose(project) : listener2.canCloseProject(project);
                if (canClose) continue;
                LOG.debug("close canceled by " + listener2);
                return false;
            }
            catch (Throwable e) {
                ProjectManagerImpl.handleListenerError(e, listener2);
            }
        }
        return true;
    }

    @NotNull
    private List<ProjectManagerListener> getAllListeners(@NotNull Project project) {
        List<ProjectManagerListener> projectLevelListeners = ProjectManagerImpl.getListeners(project);
        if (projectLevelListeners.isEmpty()) {
            return this.myListeners;
        }
        if (this.myListeners.isEmpty()) {
            return projectLevelListeners;
        }
        ArrayList<ProjectManagerListener> result2 = new ArrayList<ProjectManagerListener>(projectLevelListeners.size() + this.myListeners.size());
        result2.addAll(projectLevelListeners);
        result2.addAll(this.myListeners);
        return result2;
    }

    private static boolean ensureCouldCloseIfUnableToSave(@NotNull Project project) {
        UnableToSaveProjectNotification[] notifications = (UnableToSaveProjectNotification[])NotificationsManager.getNotificationsManager().getNotificationsOfType(UnableToSaveProjectNotification.class, project);
        if (notifications.length == 0) {
            return true;
        }
        StringBuilder message = new StringBuilder();
        message.append(String.format("%s was unable to save some project files,\nare you sure you want to close this project anyway?", ApplicationNamesInfo.getInstance().getProductName()));
        message.append("\n\nRead-only files:\n");
        int count = 0;
        List files2 = notifications[0].myFiles;
        for (VirtualFile file2 : files2) {
            if (count == 10) {
                message.append('\n').append("and ").append(files2.size() - count).append(" more").append('\n');
                continue;
            }
            message.append(file2.getPath()).append('\n');
            ++count;
        }
        return Messages.showYesNoDialog((Project)project, (String)message.toString(), (String)"Unsaved Project", (Icon)Messages.getWarningIcon()) == 0;
    }

    @Override
    public void saveChangedProjectFile(@NotNull VirtualFile file2, @NotNull Project project) {
    }

    @Override
    public void blockReloadingProjectOnExternalChanges() {
    }

    @Override
    public void unblockReloadingProjectOnExternalChanges() {
    }

    static {
        LOG_PROJECT_LEAKAGE_IN_TESTS = Boolean.parseBoolean(System.getProperty("idea.log.leaked.projects.in.tests", "false"));
        LEAK_CHECK_INTERVAL = TimeUnit.MINUTES.toMillis(30L);
        CHECK_START = System.currentTimeMillis();
    }

    public static class UnableToSaveProjectNotification
    extends Notification {
        private Project myProject;
        private List<VirtualFile> myFiles;

        public void setFiles(@NotNull List<VirtualFile> files2) {
            this.myFiles = files2;
        }

        public UnableToSaveProjectNotification(@NotNull Project project, @NotNull List<VirtualFile> readOnlyFiles) {
            super("Project Settings", "Could not save project", "Unable to save project files. Please ensure project files are writable and you have permissions to modify them. <a href=\"\">Try to save project again</a>.", NotificationType.ERROR, (notification, event) -> {
                UnableToSaveProjectNotification unableToSaveProjectNotification = (UnableToSaveProjectNotification)notification;
                Project _project = unableToSaveProjectNotification.myProject;
                notification.expire();
                if (_project != null && !_project.isDisposed()) {
                    _project.save();
                }
            });
            this.myProject = project;
            this.myFiles = readOnlyFiles;
        }

        public void expire() {
            this.myProject = null;
            super.expire();
        }
    }
}

