/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.projectRoots.impl;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkAdditionalData;
import com.intellij.openapi.projectRoots.SdkModificator;
import com.intellij.openapi.projectRoots.SdkTypeId;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.RootProvider;
import com.intellij.openapi.roots.ex.ProjectRootManagerEx;
import com.intellij.openapi.util.EmptyRunnable;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.vfs.StandardFileSystems;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MockSdk
implements Sdk,
SdkModificator {
    private String myName;
    private String myHomePath;
    @NotNull
    private String myVersionString;
    private final MultiMap<OrderRootType, VirtualFile> myRoots;
    private final SdkTypeId mySdkType;
    private SdkAdditionalData myData;

    public MockSdk(@NotNull String name, @NotNull String homePath, @NotNull String versionString, @NotNull MultiMap<OrderRootType, VirtualFile> roots, @NotNull SdkTypeId sdkType) {
        this.myName = name;
        this.myHomePath = homePath;
        this.myVersionString = versionString;
        this.myRoots = roots;
        this.mySdkType = sdkType;
    }

    @NotNull
    public SdkTypeId getSdkType() {
        return this.mySdkType;
    }

    @NotNull
    public String getName() {
        return this.myName;
    }

    @NotNull
    public String getVersionString() {
        return this.myVersionString;
    }

    public String getHomePath() {
        return this.myHomePath;
    }

    @Nullable
    public VirtualFile getHomeDirectory() {
        return StandardFileSystems.local().findFileByPath(this.myHomePath);
    }

    @Nullable
    public SdkAdditionalData getSdkAdditionalData() {
        return this.myData;
    }

    @NotNull
    public Sdk clone() {
        return new MockSdk(this.myName, this.myHomePath, this.myVersionString, new MultiMap(this.myRoots), this.mySdkType){
            private final UserDataHolder udh;
            {
                this.udh = new UserDataHolderBase();
            }

            @Override
            @NotNull
            public SdkModificator getSdkModificator() {
                return this;
            }

            @Override
            @Nullable
            public <T> T getUserData(@NotNull Key<T> key) {
                return (T)this.udh.getUserData(key);
            }

            @Override
            public <T> void putUserData(@NotNull Key<T> key, @Nullable T value) {
                this.udh.putUserData(key, value);
            }
        };
    }

    @NotNull
    public SdkModificator getSdkModificator() {
        MockSdk.throwReadOnly();
        return null;
    }

    @NotNull
    public VirtualFile[] getRoots(@NotNull OrderRootType rootType) {
        return this.myRoots.get((Object)rootType).toArray(VirtualFile.EMPTY_ARRAY);
    }

    public void setName(@NotNull String name) {
        this.myName = name;
    }

    public void setHomePath(String path) {
        this.myHomePath = path;
    }

    public void setVersionString(@NotNull String versionString) {
        this.myVersionString = versionString;
    }

    public void setSdkAdditionalData(SdkAdditionalData data) {
        this.myData = data;
    }

    public void addRoot(@NotNull VirtualFile root, @NotNull OrderRootType rootType) {
        this.myRoots.putValue((Object)rootType, (Object)root);
    }

    public void removeRoot(@NotNull VirtualFile root, @NotNull OrderRootType rootType) {
        this.myRoots.remove((Object)rootType, (Object)root);
    }

    public void removeRoots(@NotNull OrderRootType rootType) {
        this.myRoots.remove((Object)rootType);
    }

    public void removeAllRoots() {
        this.myRoots.clear();
    }

    public void commitChanges() {
        for (Project project : ProjectManager.getInstance().getOpenProjects()) {
            WriteAction.run(() -> ((ProjectRootManagerEx)ProjectRootManager.getInstance((Project)project)).makeRootsChange(EmptyRunnable.getInstance(), false, true));
        }
    }

    public boolean isWritable() {
        return true;
    }

    @NotNull
    public RootProvider getRootProvider() {
        return new RootProvider(){

            @NotNull
            public String[] getUrls(@NotNull OrderRootType rootType) {
                return (String[])ContainerUtil.map2Array((Object[])this.getFiles(rootType), String.class, VirtualFile::getUrl);
            }

            @NotNull
            public VirtualFile[] getFiles(@NotNull OrderRootType rootType) {
                return MockSdk.this.getRoots(rootType);
            }

            public void addRootSetChangedListener(@NotNull RootProvider.RootSetChangedListener listener2) {
            }

            public void addRootSetChangedListener(@NotNull RootProvider.RootSetChangedListener listener2, @NotNull Disposable parentDisposable) {
            }

            public void removeRootSetChangedListener(@NotNull RootProvider.RootSetChangedListener listener2) {
            }
        };
    }

    private static void throwReadOnly() {
        throw new IncorrectOperationException("Can't modify, MockJDK is read-only, consider calling .clone() first");
    }

    @Nullable
    public <T> T getUserData(@NotNull Key<T> key) {
        return null;
    }

    public <T> void putUserData(@NotNull Key<T> key, @Nullable T value) {
        MockSdk.throwReadOnly();
    }

    public String toString() {
        return "MockSDK[" + this.myName + "]";
    }
}

