/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.projectRoots.impl;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.projectRoots.ProjectJdkTable;
import com.intellij.openapi.projectRoots.ProjectRootListener;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkAdditionalData;
import com.intellij.openapi.projectRoots.SdkModificator;
import com.intellij.openapi.projectRoots.SdkTypeId;
import com.intellij.openapi.projectRoots.impl.RootsAsVirtualFilePointers;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.RootProvider;
import com.intellij.openapi.roots.impl.ProjectRootManagerImpl;
import com.intellij.openapi.roots.impl.RootProviderBaseImpl;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.vfs.StandardFileSystems;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.pointers.VirtualFilePointer;
import com.intellij.openapi.vfs.pointers.VirtualFilePointerListener;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ProjectJdkImpl
extends UserDataHolderBase
implements Sdk,
SdkModificator,
Disposable {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.projectRoots.impl.ProjectJdkImpl");
    private String myName;
    private String myVersionString;
    private boolean myVersionDefined;
    private String myHomePath = "";
    private final RootsAsVirtualFilePointers myRoots;
    private ProjectJdkImpl myOrigin;
    private SdkAdditionalData myAdditionalData;
    private SdkTypeId mySdkType;
    @NonNls
    public static final String ELEMENT_NAME = "name";
    @NonNls
    public static final String ATTRIBUTE_VALUE = "value";
    @NonNls
    public static final String ELEMENT_TYPE = "type";
    @NonNls
    private static final String ELEMENT_VERSION = "version";
    @NonNls
    private static final String ELEMENT_ROOTS = "roots";
    @NonNls
    private static final String ELEMENT_HOMEPATH = "homePath";
    @NonNls
    private static final String ELEMENT_ADDITIONAL = "additional";
    private final MyRootProvider myRootProvider = new MyRootProvider();
    private static final VirtualFilePointerListener tellAllProjectsTheirRootsAreGoingToChange = new VirtualFilePointerListener(){

        public void beforeValidityChanged(@NotNull VirtualFilePointer[] pointers) {
            for (Project project : ProjectManager.getInstance().getOpenProjects()) {
                VirtualFilePointerListener listener2 = ((ProjectRootManagerImpl)ProjectRootManager.getInstance((Project)project)).getRootsValidityChangedListener();
                listener2.beforeValidityChanged(pointers);
            }
        }

        public void validityChanged(@NotNull VirtualFilePointer[] pointers) {
            for (Project project : ProjectManager.getInstance().getOpenProjects()) {
                VirtualFilePointerListener listener2 = ((ProjectRootManagerImpl)ProjectRootManager.getInstance((Project)project)).getRootsValidityChangedListener();
                listener2.validityChanged(pointers);
            }
        }
    };

    public ProjectJdkImpl(String name, SdkTypeId sdkType) {
        this.mySdkType = sdkType;
        this.myName = name;
        this.myRoots = new RootsAsVirtualFilePointers(true, tellAllProjectsTheirRootsAreGoingToChange, this);
        Disposer.register((Disposable)ApplicationManager.getApplication(), (Disposable)this);
    }

    public ProjectJdkImpl(String name, SdkTypeId sdkType, String homePath, String version2) {
        this(name, sdkType);
        this.myHomePath = homePath;
        this.myVersionString = version2;
    }

    @NotNull
    public static VirtualFilePointerListener getGlobalVirtualFilePointerListener() {
        return tellAllProjectsTheirRootsAreGoingToChange;
    }

    public void dispose() {
    }

    @NotNull
    public SdkTypeId getSdkType() {
        if (this.mySdkType == null) {
            this.mySdkType = ProjectJdkTable.getInstance().getDefaultSdkType();
        }
        return this.mySdkType;
    }

    @NotNull
    public String getName() {
        return this.myName;
    }

    public void setName(@NotNull String name) {
        this.myName = name;
    }

    public final void setVersionString(@Nullable String versionString) {
        this.myVersionString = versionString == null || versionString.isEmpty() ? null : versionString;
        this.myVersionDefined = true;
    }

    public String getVersionString() {
        String homePath;
        if (this.myVersionString == null && !this.myVersionDefined && (homePath = this.getHomePath()) != null && !homePath.isEmpty()) {
            this.setVersionString(this.getSdkType().getVersionString((Sdk)this));
        }
        return this.myVersionString;
    }

    public final void resetVersionString() {
        this.myVersionDefined = false;
        this.myVersionString = null;
    }

    public String getHomePath() {
        return this.myHomePath;
    }

    public VirtualFile getHomeDirectory() {
        if (this.myHomePath == null) {
            return null;
        }
        return StandardFileSystems.local().findFileByPath(this.myHomePath);
    }

    public void readExternal(@NotNull Element element) {
        this.readExternal(element, null);
    }

    public void readExternal(@NotNull Element element, @Nullable ProjectJdkTable projectJdkTable) throws InvalidDataException {
        Element version2;
        String sdkTypeName;
        Element elementName = ProjectJdkImpl.assertNotMissing(element, ELEMENT_NAME);
        this.myName = elementName.getAttributeValue(ATTRIBUTE_VALUE);
        Element typeChild = element.getChild(ELEMENT_TYPE);
        String string = sdkTypeName = typeChild != null ? typeChild.getAttributeValue(ATTRIBUTE_VALUE) : null;
        if (sdkTypeName != null) {
            if (projectJdkTable == null) {
                projectJdkTable = ProjectJdkTable.getInstance();
            }
            this.mySdkType = projectJdkTable.getSdkTypeByName(sdkTypeName);
        }
        if ((version2 = element.getChild(ELEMENT_VERSION)) != null) {
            this.setVersionString(version2.getAttributeValue(ATTRIBUTE_VALUE));
        } else {
            this.myVersionDefined = false;
        }
        String versionValue = element.getAttributeValue(ELEMENT_VERSION, "");
        if (versionValue.isEmpty() || !"2".equals(versionValue)) {
            throw new InvalidDataException("Too old version is not supported: " + versionValue);
        }
        Element homePath = ProjectJdkImpl.assertNotMissing(element, ELEMENT_HOMEPATH);
        this.myHomePath = homePath.getAttributeValue(ATTRIBUTE_VALUE);
        Element elementRoots = ProjectJdkImpl.assertNotMissing(element, ELEMENT_ROOTS);
        this.myRoots.readExternal(elementRoots);
        Element additional = element.getChild(ELEMENT_ADDITIONAL);
        if (additional != null) {
            LOG.assertTrue(this.mySdkType != null);
            this.myAdditionalData = this.mySdkType.loadAdditionalData((Sdk)this, additional);
        } else {
            this.myAdditionalData = null;
        }
    }

    @NotNull
    private static Element assertNotMissing(@NotNull Element parent, @NotNull String childName) {
        Element child2 = parent.getChild(childName);
        if (child2 == null) {
            throw new InvalidDataException("mandatory element '" + childName + "' is missing: " + parent);
        }
        return child2;
    }

    public void writeExternal(@NotNull Element element) {
        element.setAttribute(ELEMENT_VERSION, "2");
        Element name = new Element(ELEMENT_NAME);
        name.setAttribute(ATTRIBUTE_VALUE, this.myName);
        element.addContent(name);
        if (this.mySdkType != null) {
            Element sdkType = new Element(ELEMENT_TYPE);
            sdkType.setAttribute(ATTRIBUTE_VALUE, this.mySdkType.getName());
            element.addContent(sdkType);
        }
        if (this.myVersionString != null) {
            Element version2 = new Element(ELEMENT_VERSION);
            version2.setAttribute(ATTRIBUTE_VALUE, this.myVersionString);
            element.addContent(version2);
        }
        Element home = new Element(ELEMENT_HOMEPATH);
        home.setAttribute(ATTRIBUTE_VALUE, this.myHomePath);
        element.addContent(home);
        Element roots = new Element(ELEMENT_ROOTS);
        this.myRoots.writeExternal(roots);
        element.addContent(roots);
        Element additional = new Element(ELEMENT_ADDITIONAL);
        if (this.myAdditionalData != null) {
            LOG.assertTrue(this.mySdkType != null);
            this.mySdkType.saveAdditionalData(this.myAdditionalData, additional);
        }
        element.addContent(additional);
    }

    public void setHomePath(String path) {
        boolean changes2 = this.myHomePath == null ? path != null : !this.myHomePath.equals(path);
        this.myHomePath = path;
        if (changes2) {
            this.resetVersionString();
        }
    }

    @NotNull
    public ProjectJdkImpl clone() {
        ProjectJdkImpl newJdk = new ProjectJdkImpl("", this.mySdkType);
        this.copyTo(newJdk);
        return newJdk;
    }

    @NotNull
    public RootProvider getRootProvider() {
        return this.myRootProvider;
    }

    void copyTo(@NotNull ProjectJdkImpl dest) {
        String name = this.getName();
        dest.setName(name);
        dest.setHomePath(this.getHomePath());
        dest.myVersionDefined = this.myVersionDefined;
        dest.myVersionString = this.myVersionString;
        dest.setSdkAdditionalData(this.getSdkAdditionalData());
        dest.myRoots.copyRootsFrom(this.myRoots);
        dest.myRootProvider.rootsChanged();
    }

    @NotNull
    public SdkModificator getSdkModificator() {
        ProjectJdkImpl sdk = this.clone();
        sdk.myOrigin = this;
        return sdk;
    }

    public void commitChanges() {
        LOG.assertTrue(this.isWritable());
        this.copyTo(this.myOrigin);
        this.myOrigin = null;
        Disposer.dispose((Disposable)this);
    }

    public SdkAdditionalData getSdkAdditionalData() {
        return this.myAdditionalData;
    }

    public void setSdkAdditionalData(SdkAdditionalData data) {
        this.myAdditionalData = data;
    }

    @NotNull
    public VirtualFile[] getRoots(@NotNull OrderRootType rootType) {
        return this.myRoots.getFiles(rootType);
    }

    @NotNull
    public String[] getUrls(@NotNull OrderRootType rootType) {
        return this.myRoots.getUrls(rootType);
    }

    public void addRoot(@NotNull VirtualFile root, @NotNull OrderRootType rootType) {
        this.myRoots.addRoot(root, rootType);
    }

    public void addRoot(@NotNull String url, @NotNull OrderRootType rootType) {
        this.myRoots.addRoot(url, rootType);
    }

    public void removeRoot(@NotNull VirtualFile root, @NotNull OrderRootType rootType) {
        this.myRoots.removeRoot(root, rootType);
    }

    public void removeRoot(@NotNull String url, @NotNull OrderRootType rootType) {
        this.myRoots.removeRoot(url, rootType);
    }

    public void removeRoots(@NotNull OrderRootType rootType) {
        this.myRoots.removeAllRoots(rootType);
    }

    public void removeAllRoots() {
        this.myRoots.removeAllRoots();
    }

    public boolean isWritable() {
        return this.myOrigin != null;
    }

    public String toString() {
        return this.myName + (this.myVersionDefined ? ": " + this.myVersionString : "") + " (" + this.myHomePath + ")";
    }

    private class MyRootProvider
    extends RootProviderBaseImpl
    implements ProjectRootListener {
        private MyRootProvider() {
        }

        @NotNull
        public String[] getUrls(@NotNull OrderRootType rootType) {
            return ProjectJdkImpl.this.myRoots.getUrls(rootType);
        }

        @NotNull
        public VirtualFile[] getFiles(@NotNull OrderRootType rootType) {
            return ProjectJdkImpl.this.myRoots.getFiles(rootType);
        }

        public void rootsChanged() {
            if (this.myDispatcher.hasListeners()) {
                ApplicationManager.getApplication().runWriteAction(this::fireRootSetChanged);
            }
        }
    }
}

