/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.projectRoots.impl;

import com.intellij.ide.highlighter.ArchiveFileType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.components.ExportableComponent;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.RoamingType;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.projectRoots.JavaSdkType;
import com.intellij.openapi.projectRoots.ProjectJdkTable;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkType;
import com.intellij.openapi.projectRoots.SdkTypeId;
import com.intellij.openapi.projectRoots.impl.ProjectJdkImpl;
import com.intellij.openapi.projectRoots.impl.UnknownSdkType;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.util.ThreeState;
import com.intellij.util.containers.SmartHashSet;
import com.intellij.util.messages.MessageBus;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.impl.MessageListenerList;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="ProjectJdkTable", storages={@Storage(value="jdk.table.xml", roamingType=RoamingType.DISABLED, useSaveThreshold=ThreeState.NO)})
public class ProjectJdkTableImpl
extends ProjectJdkTable
implements ExportableComponent,
PersistentStateComponent<Element> {
    private final List<Sdk> mySdks = new ArrayList<Sdk>();
    private final MessageListenerList<ProjectJdkTable.Listener> myListenerList;
    @NonNls
    private static final String ELEMENT_JDK = "jdk";
    private final Map<String, ProjectJdkImpl> myCachedProjectJdks = new HashMap<String, ProjectJdkImpl>();
    private final MessageBus myMessageBus = ApplicationManager.getApplication().getMessageBus();

    public ProjectJdkTableImpl() {
        this.myListenerList = new MessageListenerList(this.myMessageBus, JDK_TABLE_TOPIC);
        MessageBusConnection connection = ApplicationManager.getApplication().getMessageBus().connect();
        connection.subscribe(VirtualFileManager.VFS_CHANGES, (Object)new BulkFileListener(){
            private final FileTypeManager myFileTypeManager = FileTypeManager.getInstance();

            public void after(@NotNull List<? extends VFileEvent> events) {
                if (!events.isEmpty()) {
                    SmartHashSet affected = new SmartHashSet();
                    for (VFileEvent vFileEvent : events) {
                        this.addAffectedJavaSdk(vFileEvent, (Set<? super Sdk>)affected);
                    }
                    if (!affected.isEmpty()) {
                        for (Sdk sdk : affected) {
                            ((SdkType)sdk.getSdkType()).setupSdkPaths(sdk);
                        }
                    }
                }
            }

            private void addAffectedJavaSdk(VFileEvent event, Set<? super Sdk> affected) {
                VirtualFile file2 = event.getFile();
                CharSequence fileName2 = null;
                if (file2 != null && file2.isValid()) {
                    if (file2.isDirectory()) {
                        return;
                    }
                    fileName2 = file2.getNameSequence();
                }
                if (fileName2 == null) {
                    String eventPath = event.getPath();
                    fileName2 = VfsUtil.extractFileName((String)eventPath);
                }
                if (fileName2 != null && !ArchiveFileType.INSTANCE.equals(this.myFileTypeManager.getFileTypeByFileName(fileName2))) {
                    return;
                }
                for (Sdk sdk : ProjectJdkTableImpl.this.mySdks) {
                    if (!(sdk.getSdkType() instanceof JavaSdkType) || affected.contains(sdk)) continue;
                    String homePath = sdk.getHomePath();
                    String eventPath = event.getPath();
                    if (StringUtil.isEmpty((String)homePath) || !FileUtil.isAncestor((String)homePath, (String)eventPath, (boolean)true)) continue;
                    affected.add((Sdk)sdk);
                }
            }
        });
    }

    @NotNull
    public File[] getExportFiles() {
        return new File[]{PathManager.getOptionsFile((String)"jdk.table")};
    }

    @NotNull
    public String getPresentableName() {
        return ProjectBundle.message((String)"sdk.table.settings", (Object[])new Object[0]);
    }

    @Nullable
    public Sdk findJdk(@NotNull String name) {
        int len = this.mySdks.size();
        for (int i = 0; i < len; ++i) {
            Sdk jdk = this.mySdks.get(i);
            if (!Comparing.strEqual((String)name, (String)jdk.getName())) continue;
            return jdk;
        }
        return null;
    }

    @Nullable
    public Sdk findJdk(@NotNull String name, @NotNull String type) {
        SdkType[] sdkTypes;
        Sdk projectJdk = this.findJdk(name);
        if (projectJdk != null) {
            return projectJdk;
        }
        String uniqueName = type + "." + name;
        projectJdk = this.myCachedProjectJdks.get(uniqueName);
        if (projectJdk != null) {
            return projectJdk;
        }
        String jdkPrefix = "jdk.";
        String jdkPath = System.getProperty("jdk." + name);
        if (jdkPath == null) {
            return null;
        }
        for (SdkType sdkType : sdkTypes = SdkType.getAllTypes()) {
            if (!Comparing.strEqual((String)type, (String)sdkType.getName())) continue;
            if (!sdkType.isValidSdkHome(jdkPath)) break;
            ProjectJdkImpl projectJdkImpl = new ProjectJdkImpl(name, (SdkTypeId)sdkType);
            projectJdkImpl.setHomePath(jdkPath);
            sdkType.setupSdkPaths((Sdk)projectJdkImpl);
            this.myCachedProjectJdks.put(uniqueName, projectJdkImpl);
            return projectJdkImpl;
        }
        return null;
    }

    @NotNull
    public Sdk[] getAllJdks() {
        return this.mySdks.toArray(new Sdk[0]);
    }

    @NotNull
    public List<Sdk> getSdksOfType(@NotNull SdkTypeId type) {
        Sdk[] sdks;
        ArrayList<Sdk> result2 = new ArrayList<Sdk>();
        for (Sdk sdk : sdks = this.getAllJdks()) {
            if (sdk.getSdkType() != type) continue;
            result2.add(sdk);
        }
        return result2;
    }

    public void addJdk(@NotNull Sdk jdk) {
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        this.mySdks.add(jdk);
        ((ProjectJdkTable.Listener)this.myMessageBus.syncPublisher(JDK_TABLE_TOPIC)).jdkAdded(jdk);
    }

    public void removeJdk(@NotNull Sdk jdk) {
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        ((ProjectJdkTable.Listener)this.myMessageBus.syncPublisher(JDK_TABLE_TOPIC)).jdkRemoved(jdk);
        this.mySdks.remove(jdk);
        if (jdk instanceof Disposable) {
            Disposer.dispose((Disposable)((Disposable)jdk));
        }
    }

    public void updateJdk(@NotNull Sdk originalJdk, @NotNull Sdk modifiedJdk) {
        String previousName = originalJdk.getName();
        String newName = modifiedJdk.getName();
        ((ProjectJdkImpl)modifiedJdk).copyTo((ProjectJdkImpl)originalJdk);
        if (!previousName.equals(newName)) {
            ((ProjectJdkTable.Listener)this.myMessageBus.syncPublisher(JDK_TABLE_TOPIC)).jdkNameChanged(originalJdk, previousName);
        }
    }

    public void addListener(@NotNull ProjectJdkTable.Listener listener2) {
        this.myListenerList.add((Object)listener2);
    }

    public void removeListener(@NotNull ProjectJdkTable.Listener listener2) {
        this.myListenerList.remove((Object)listener2);
    }

    @NotNull
    public SdkTypeId getDefaultSdkType() {
        return UnknownSdkType.getInstance((String)"");
    }

    @NotNull
    public SdkTypeId getSdkTypeByName(@NotNull String sdkTypeName) {
        return ProjectJdkTableImpl.findSdkTypeByName(sdkTypeName);
    }

    @NotNull
    private static SdkTypeId findSdkTypeByName(@NotNull String sdkTypeName) {
        SdkType[] allSdkTypes;
        for (SdkType type : allSdkTypes = SdkType.getAllTypes()) {
            if (!type.getName().equals(sdkTypeName)) continue;
            return type;
        }
        return UnknownSdkType.getInstance((String)sdkTypeName);
    }

    @NotNull
    public Sdk createSdk(@NotNull String name, @NotNull SdkTypeId sdkType) {
        return new ProjectJdkImpl(name, sdkType);
    }

    public void loadState(@NotNull Element element) {
        this.mySdks.clear();
        for (Element child2 : element.getChildren(ELEMENT_JDK)) {
            ProjectJdkImpl jdk = new ProjectJdkImpl(null, null);
            jdk.readExternal(child2, this);
            this.mySdks.add(jdk);
        }
    }

    public Element getState() {
        Element element = new Element("state");
        for (Sdk jdk : this.mySdks) {
            Element e = new Element(ELEMENT_JDK);
            ((ProjectJdkImpl)jdk).writeExternal(e);
            element.addContent(e);
        }
        return element;
    }
}

