/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.projectRoots.impl;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.OrderEnumerator;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.PsiManagerImpl;
import com.intellij.psi.impl.file.impl.FileManager;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;

public class ProjectRootUtil {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.projectRoots.impl.ProjectRootUtil");

    private ProjectRootUtil() {
    }

    @NotNull
    private static PsiDirectory[] convertRoots(@NotNull Project project, @NotNull VirtualFile[] roots) {
        return ProjectRootUtil.convertRoots(((PsiManagerImpl)PsiManager.getInstance((Project)project)).getFileManager(), roots);
    }

    @NotNull
    private static PsiDirectory[] convertRoots(@NotNull FileManager fileManager, @NotNull VirtualFile[] roots) {
        ArrayList<PsiDirectory> dirs = new ArrayList<PsiDirectory>();
        for (VirtualFile root : roots) {
            PsiDirectory dir;
            if (!root.isValid()) {
                LOG.error("Root " + root + " is not valid!");
            }
            if ((dir = fileManager.findDirectory(root)) == null) continue;
            dirs.add(dir);
        }
        return dirs.toArray(PsiDirectory.EMPTY_ARRAY);
    }

    @NotNull
    public static PsiDirectory[] getSourceRootDirectories(@NotNull Project project) {
        VirtualFile[] files2 = OrderEnumerator.orderEntries((Project)project).sources().usingCache().getRoots();
        return ProjectRootUtil.convertRoots(project, files2);
    }

    @NotNull
    public static PsiDirectory[] getAllContentRoots(@NotNull Project project) {
        VirtualFile[] files2 = ProjectRootManager.getInstance((Project)project).getContentRootsFromAllModules();
        return ProjectRootUtil.convertRoots(project, files2);
    }
}

