/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.projectRoots.impl;

import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkType;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.SimpleTextAttributes;
import javax.swing.Icon;
import javax.swing.JList;
import org.jetbrains.annotations.NotNull;

public class SdkListCellRenderer
extends ColoredListCellRenderer<Sdk> {
    private final String myNullText;
    private final boolean myShowHomePath;

    public SdkListCellRenderer(@NotNull String nullText) {
        this(nullText, false);
    }

    public SdkListCellRenderer(@NotNull String nullText, boolean showHomePath) {
        this.myNullText = nullText;
        this.myShowHomePath = showHomePath;
    }

    protected void customizeCellRenderer(@NotNull JList<? extends Sdk> list2, Sdk sdk, int index, boolean selected, boolean hasFocus) {
        if (sdk != null) {
            this.setIcon(this.getSdkIcon(sdk));
            this.append(sdk.getName());
            if (this.myShowHomePath) {
                this.append(" (" + FileUtil.toSystemDependentName((String)StringUtil.notNullize((String)sdk.getHomePath())) + ")", selected ? SimpleTextAttributes.REGULAR_ATTRIBUTES : SimpleTextAttributes.GRAYED_ATTRIBUTES);
            }
        } else {
            this.append(this.myNullText);
        }
    }

    protected Icon getSdkIcon(Sdk sdk) {
        return ((SdkType)sdk.getSdkType()).getIcon();
    }
}

