/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.FilenameIndex;
import com.intellij.psi.search.GlobalSearchScope;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

public class ProjectRootUtil {
    @NotNull
    public static VirtualFile findSymlinkedFileInContent(@NotNull Project project, @NotNull VirtualFile forFile) {
        GlobalSearchScope scope = GlobalSearchScope.allScope((Project)project);
        if (scope.contains(forFile)) {
            return forFile;
        }
        VirtualFile canonicalForFile = forFile.getCanonicalFile();
        if (canonicalForFile == null) {
            canonicalForFile = forFile;
        }
        Collection<VirtualFile> projectFiles = FilenameIndex.getVirtualFilesByName(project, canonicalForFile.getName(), true, scope);
        for (VirtualFile eachContentFile : projectFiles) {
            if (!canonicalForFile.equals(eachContentFile.getCanonicalFile())) continue;
            return eachContentFile;
        }
        return forFile;
    }
}

