/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots;

import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.roots.ImmutableSyntheticLibrary;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Experimental
public abstract class SyntheticLibrary {
    @NotNull
    public abstract Collection<VirtualFile> getSourceRoots();

    @NotNull
    public Collection<VirtualFile> getBinaryRoots() {
        return Collections.emptyList();
    }

    @NotNull
    public Set<VirtualFile> getExcludedRoots() {
        return Collections.emptySet();
    }

    @Nullable
    public Condition<VirtualFile> getExcludeFileCondition() {
        return null;
    }

    public boolean isShowInExternalLibrariesNode() {
        return this instanceof ItemPresentation;
    }

    public abstract boolean equals(Object var1);

    public abstract int hashCode();

    @NotNull
    public static SyntheticLibrary newImmutableLibrary(@NotNull Collection<VirtualFile> sourceRoots) {
        return SyntheticLibrary.newImmutableLibrary(sourceRoots, Collections.emptySet(), null);
    }

    @NotNull
    public static SyntheticLibrary newImmutableLibrary(@NotNull Collection<VirtualFile> sourceRoots, @NotNull Set<VirtualFile> excludedRoots, @Nullable Condition<VirtualFile> excludeCondition) {
        return SyntheticLibrary.newImmutableLibrary(sourceRoots, Collections.emptySet(), excludedRoots, excludeCondition);
    }

    @NotNull
    public static SyntheticLibrary newImmutableLibrary(@NotNull Collection<VirtualFile> sourceRoots, @NotNull Collection<VirtualFile> binaryRoots, @NotNull Set<VirtualFile> excludedRoots, @Nullable Condition<VirtualFile> excludeCondition) {
        return new ImmutableSyntheticLibrary(sourceRoots, binaryRoots, excludedRoots, excludeCondition);
    }

    @NotNull
    public final Collection<VirtualFile> getAllRoots() {
        return this.getRoots(true, true);
    }

    @NotNull
    private Collection<VirtualFile> getRoots(boolean includeSources, boolean includeBinaries) {
        if (includeSources && includeBinaries) {
            Collection<VirtualFile> sourceRoots = this.getSourceRoots();
            Collection<VirtualFile> binaryRoots = this.getBinaryRoots();
            if (binaryRoots.isEmpty()) {
                return sourceRoots;
            }
            if (sourceRoots.isEmpty()) {
                return binaryRoots;
            }
            return ContainerUtil.union(sourceRoots, binaryRoots);
        }
        if (includeSources) {
            return this.getSourceRoots();
        }
        if (includeBinaries) {
            return this.getBinaryRoots();
        }
        return Collections.emptySet();
    }

    public final boolean contains(@NotNull VirtualFile file2, boolean includeSources, boolean includeBinaries) {
        Set<VirtualFile> roots = SyntheticLibrary.asSet(this.getRoots(includeSources, includeBinaries));
        return VfsUtilCore.isUnder((VirtualFile)file2, roots) && !VfsUtilCore.isUnder((VirtualFile)file2, this.getExcludedRoots());
    }

    public final boolean contains(@NotNull VirtualFile file2) {
        return this.contains(file2, true, true);
    }

    @NotNull
    private static <T extends VirtualFile> Set<T> asSet(@NotNull Collection<T> collection) {
        return collection instanceof Set ? (Set)collection : ContainerUtil.newTroveSet(collection);
    }
}

